/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.UnprotectedAttributes;

public class EncryptedData
implements DEREncodable {
    private CMSVersion version;
    private EncryptedContentInfo encryptedContentInfo;
    private UnprotectedAttributes unprotectedAttrs;

    public EncryptedData(CMSVersion cMSVersion, EncryptedContentInfo encryptedContentInfo, UnprotectedAttributes unprotectedAttributes) {
        this.setVersion(cMSVersion);
        this.setEncryptedContentInfo(encryptedContentInfo);
        this.setUnprotectedAttrs(unprotectedAttributes);
    }

    public EncryptedData(BERConstructedSequence bERConstructedSequence) {
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(0));
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(bERConstructedSequence.getObjectAt(1));
        if (bERConstructedSequence.getSize() > 2) {
            this.unprotectedAttrs = UnprotectedAttributes.getInstance(bERConstructedSequence.getObjectAt(2));
        }
    }

    public EncryptedData(EncryptedData encryptedData) {
        this.version = encryptedData.version;
        this.encryptedContentInfo = encryptedData.encryptedContentInfo;
        this.unprotectedAttrs = encryptedData.unprotectedAttrs;
    }

    public static EncryptedData getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedData) {
            return (EncryptedData)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new EncryptedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedData");
    }

    public static EncryptedData newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedData) {
            return new EncryptedData((EncryptedData)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new EncryptedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedData");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    private void setEncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.encryptedContentInfo = encryptedContentInfo;
    }

    public UnprotectedAttributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    private void setUnprotectedAttrs(UnprotectedAttributes unprotectedAttributes) {
        this.unprotectedAttrs = unprotectedAttributes;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unprotectedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

