/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class SignatureValue
implements DEREncodable {
    private DEROctetString value;

    public SignatureValue(byte[] byArray) {
        this.setValue(byArray);
    }

    public SignatureValue(DEROctetString dEROctetString) {
        this.value = dEROctetString;
    }

    public SignatureValue(SignatureValue signatureValue) {
        this.value = signatureValue.value;
    }

    public static SignatureValue getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignatureValue) {
            return (SignatureValue)object;
        }
        if (object instanceof DEROctetString) {
            return new SignatureValue((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignatureValue.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignatureValue");
    }

    public static SignatureValue newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignatureValue) {
            return new SignatureValue((SignatureValue)object);
        }
        if (object instanceof DEROctetString) {
            return new SignatureValue((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignatureValue.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignatureValue");
    }

    public byte[] getValue() {
        return this.value.getOctets();
    }

    private void setValue(byte[] byArray) {
        this.value = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.value;
    }
}

