/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.service.backup.MultipartDedupUploadCallable;
import com.parablu.epa.common.service.backup.MultipartUploadCallable;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.about.SystemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DelegateRunnable.class);
    private BlockingQueue<BackupTO> chunkFileQueue;
    private ExecutorService multiPartUploadService;
    private GatewayTO uploadGatewayTO;
    private BackupPolicyTO currentPolicy;
    private AtomicInteger uploadCount;
    private String batchIdForBackup;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;
    private AtomicInteger noOfBatches;
    private AtomicBoolean loopFinished;
    private CleanupInterface cleanupInterface;
    private String requestURL;
    private RateLimiter rateLimiter;
    private int threadPriority = Thread.currentThread().getPriority();
    private MultipartUploadCallable multipartUploadCallable;
    private MultipartDedupUploadCallable multipartDedupUploadCallable;
    private AtomicBoolean interupted;
    private boolean isFullBackup;
    private AtomicLong totalUploadSize;
    private String isBackupManual;
    private long maxSizeinBytesPerBatch = this.getMaxSizeinMbPerBatch();

    public DelegateRunnable(BlockingQueue<BackupTO> chunkFileQueue, ExecutorService multiPartUploadService, GatewayTO uploadGatewayTO, BackupPolicyTO currentPolicy, AtomicInteger uploadCount, String batchIdForBackup, BlockingQueue<Future<BackupTO>> finishedBatchesQueue, AtomicInteger noOfBatches, AtomicBoolean loopFinished, CleanupInterface cleanupInterface, String requestURL, RateLimiter rateLimiter, ExecutorService chunkService, AtomicBoolean interupted, boolean isFullBackup, AtomicLong totalUploadSize, String isBackupManual) {
        this.chunkFileQueue = chunkFileQueue;
        this.multiPartUploadService = multiPartUploadService;
        this.uploadGatewayTO = uploadGatewayTO;
        this.currentPolicy = currentPolicy;
        this.uploadCount = uploadCount;
        this.batchIdForBackup = batchIdForBackup;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.noOfBatches = noOfBatches;
        this.loopFinished = loopFinished;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = requestURL;
        this.rateLimiter = rateLimiter;
        this.interupted = interupted;
        this.isFullBackup = isFullBackup;
        this.totalUploadSize = totalUploadSize;
        this.isBackupManual = isBackupManual;
    }

    @Override
    public void run() {
        this.logger.debug("thread priority:" + Thread.currentThread().getPriority() + " adapter thread priority: " + this.threadPriority);
        int retries = 3;
        while (retries >= 0) {
            ArrayList backupTOs = new ArrayList(50);
            ArrayList<Object> backupTOSmallFileList = new ArrayList<BackupTO>();
            ArrayList<BackupTO> backupTObatchList = new ArrayList<BackupTO>();
            boolean clientDedupSet = false;
            try {
                Queues.drain(this.chunkFileQueue, backupTOs, (int)50, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                this.logger.debug("BACKUPTO  BATCH START SIZE > :" + backupTOs.size() + "$$$$$$$finishedBatchesQueue.size()>>>>$$$$$$" + this.finishedBatchesQueue.size());
                if (!backupTOs.isEmpty()) {
                    retries = 10;
                    this.logger.debug(backupTOs.size() + "backupTOs");
                    BackupPolicyTO policy = this.currentPolicy;
                    if (policy != null) {
                        clientDedupSet = policy.isClientDedupEnabled();
                    }
                    for (BackupTO backupTo : backupTOs) {
                        if (backupTo.getFileSize() >= this.maxSizeinBytesPerBatch) {
                            this.submitUploadJob(backupTOSmallFileList, false);
                            backupTOSmallFileList = new ArrayList();
                            backupTObatchList = new ArrayList();
                            backupTObatchList.add(backupTo);
                            this.submitUploadJob(backupTObatchList, clientDedupSet);
                            continue;
                        }
                        backupTOSmallFileList.add(backupTo);
                    }
                    this.submitUploadJob(backupTOSmallFileList, false);
                    continue;
                }
                if (!this.loopFinished.get()) continue;
                --retries;
            }
            catch (InterruptedException e) {
                this.logger.trace("" + e);
                this.logger.error("Interrupted Exception:" + e.getMessage());
                SettingHelper.setErrorOccuredDuringSync(true);
                this.interupted.set(true);
                this.chunkFileQueue.clear();
                this.logger.debug("Exception occured: " + e);
                if (this.multipartUploadCallable != null) {
                    this.logger.debug("THREAD BEEN NUDGED CANCELLING THE PROCESS");
                    this.finishedBatchesQueue.clear();
                    this.multipartUploadCallable.cancelUpload();
                }
                if (this.multipartDedupUploadCallable != null) {
                    this.logger.debug("THREAD BEEN NUDGED CANCELLING THE PROCESS");
                    this.finishedBatchesQueue.clear();
                    this.multipartDedupUploadCallable.cancelUpload();
                }
                this.loopFinished.set(true);
                break;
            }
        }
        try {
            BackupTO backupTO = new BackupTO();
            backupTO.setRestartId(-1L);
            this.finishedBatchesQueue.put((Future<BackupTO>)Futures.immediateFuture((Object)backupTO));
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
    }

    public void setThreadPriority() {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Iterator<Thread> i = threadSet.iterator();
        try {
            while (i.hasNext()) {
                String threadName = i.next().getName().toLowerCase();
                if (i.next() == null) continue;
                Thread thread = i.next();
                if (!threadName.startsWith("multipart")) continue;
                this.logger.debug("THREAD FOUND > " + threadName);
                if (thread.getPriority() == 1) continue;
                thread.setPriority(1);
                this.logger.debug("FOUND THREAD PRIORITY > " + thread.getPriority());
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error in setting the thread priority" + e.getMessage());
        }
    }

    public boolean isCpuThrottleReached() {
        boolean isReached = false;
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getCPUIdlePerc();
            this.logger.debug("CURRENT POLICY CPU UTILIZATION : " + this.currentPolicy.getCpuUtilization());
            double cpuUsedPerc = 100.0 - percentage;
            this.logger.debug("CPU USED PERCENTAGE IS : " + cpuUsedPerc);
            if ((double)this.currentPolicy.getCpuUtilization() >= cpuUsedPerc) {
                return isReached;
            }
            isReached = true;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("EXCEPTION IN ISCPUTHROTTLEREACHED : " + e.getMessage());
        }
        return isReached;
    }

    private void submitUploadJob(ArrayList<BackupTO> backupTOSmallFileList, boolean isDedupSet) throws InterruptedException {
        if (!backupTOSmallFileList.isEmpty()) {
            ArrayList<BackupTO> backupToList = backupTOSmallFileList;
            if (isDedupSet) {
                this.logger.debug(backupTOSmallFileList.size() + "backupTOSmallFileListsize inside dedup enabled set");
                this.multipartDedupUploadCallable = new MultipartDedupUploadCallable(backupToList, this.uploadGatewayTO, this.batchIdForBackup, this.uploadCount, this.currentPolicy, this.cleanupInterface, this.requestURL, this.rateLimiter, this.threadPriority, this.isFullBackup, this.totalUploadSize, this.isBackupManual, this.finishedBatchesQueue);
                Future<BackupTO> result = this.multiPartUploadService.submit(this.multipartDedupUploadCallable);
                this.finishedBatchesQueue.put(result);
            } else {
                this.logger.debug(backupTOSmallFileList.size() + "backupTOSmallFileList inside no dedup");
                this.multipartUploadCallable = new MultipartUploadCallable(backupToList, this.uploadGatewayTO, this.batchIdForBackup, this.uploadCount, this.currentPolicy, this.cleanupInterface, this.requestURL, this.rateLimiter, this.threadPriority, this.isFullBackup, this.totalUploadSize, this.isBackupManual, this.finishedBatchesQueue);
                Future<BackupTO> result = this.multiPartUploadService.submit(this.multipartUploadCallable);
                this.finishedBatchesQueue.put(result);
            }
            this.noOfBatches.incrementAndGet();
        }
    }

    private long getMaxSizeinMbPerBatch() {
        int maxSizeinMbPerBatch = 50;
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentPolicy();
        if (currentPolicy != null) {
            maxSizeinMbPerBatch = currentPolicy.getMaxFileSizeinMBBkpbatch();
        }
        this.logger.debug("max Size inMb PerBatch" + maxSizeinMbPerBatch);
        this.maxSizeinBytesPerBatch = maxSizeinMbPerBatch == 0 ? 0x3200000L : (long)(maxSizeinMbPerBatch * 1024 * 1024);
        this.logger.debug("max Size inBytes Per Batch" + this.maxSizeinBytesPerBatch);
        return this.maxSizeinBytesPerBatch;
    }
}

