/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class BasicConstraints
implements DEREncodable {
    DERBoolean cA = new DERBoolean(false);
    DERInteger pathLenConstraint = null;

    public BasicConstraints(DERConstructedSequence dERConstructedSequence) {
        if (dERConstructedSequence.getSize() != 0) {
            this.cA = (DERBoolean)dERConstructedSequence.getObjectAt(0);
            this.pathLenConstraint = (DERInteger)dERConstructedSequence.getObjectAt(1);
        }
    }

    public BasicConstraints(boolean bl, int n) {
        this.cA = new DERBoolean(bl);
        this.pathLenConstraint = new DERInteger(n);
    }

    public BasicConstraints(boolean bl) {
        this.cA = new DERBoolean(bl);
        this.pathLenConstraint = null;
    }

    public boolean isCA() {
        return this.cA.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue();
        }
        return null;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.cA);
        if (this.pathLenConstraint != null) {
            dERConstructedSequence.addObject(this.pathLenConstraint);
        }
        return dERConstructedSequence;
    }

    public String toString() {
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.pathLenConstraint.getValue();
    }
}

