/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class MessageAuthenticationCodeAlgorithm
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public MessageAuthenticationCodeAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public MessageAuthenticationCodeAlgorithm(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public MessageAuthenticationCodeAlgorithm(MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm) {
        this.alg = messageAuthenticationCodeAlgorithm.alg;
    }

    public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public MessageAuthenticationCodeAlgorithm(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static MessageAuthenticationCodeAlgorithm getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageAuthenticationCodeAlgorithm) {
            return (MessageAuthenticationCodeAlgorithm)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new MessageAuthenticationCodeAlgorithm((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new MessageAuthenticationCodeAlgorithm((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageAuthenticationCodeAlgorithm.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageAuthenticationCodeAlgorithm");
    }

    public static MessageAuthenticationCodeAlgorithm newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageAuthenticationCodeAlgorithm) {
            return new MessageAuthenticationCodeAlgorithm((MessageAuthenticationCodeAlgorithm)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new MessageAuthenticationCodeAlgorithm((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new MessageAuthenticationCodeAlgorithm((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageAuthenticationCodeAlgorithm.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageAuthenticationCodeAlgorithm");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

