/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceManagementService {
    private static Logger logger = LoggerFactory.getLogger(InterfaceManagementService.class);
    private static final String MESSAGE = "Inavlid option recieved";

    private InterfaceManagementService() {
    }

    public static void disableUISettings(String productType, List<String> uiPermissionsList) {
        block39: {
            block38: {
                if (!"BACKUP".equalsIgnoreCase(productType)) break block38;
                InterfaceManagementService.initialiseDefaultUISettings("BACKUP", true);
                for (String permission : uiPermissionsList) {
                    try {
                        switch (interfaceFeatures.valueOf(permission)) {
                            case EXIT: {
                                SettingHelper.setExitBackupInterfaceEnabled(false);
                                break;
                            }
                            case DECOUPLE: {
                                SettingHelper.setDecoupleBackupInterfaceEnabled(false);
                                break;
                            }
                            case SUPPORT: {
                                SettingHelper.setSupportBackupInterfaceEnabled(false);
                                break;
                            }
                            case INTIATE_BACKUP: {
                                SettingHelper.setInitiateBackupInterfaceEnabled(false);
                                break;
                            }
                            case RESTORE: {
                                SettingHelper.setRestoreInterfaceEnabled(false);
                                break;
                            }
                            case PAUSE_BACKUP: {
                                SettingHelper.setPauseBackupInterfaceEnabled(false);
                                break;
                            }
                            case STOP_BACKUP: {
                                SettingHelper.setStopBackupInterfaceEnabled(false);
                                break;
                            }
                            case BACKUP_SETTINGS: {
                                SettingHelper.setBackupSettingsInterfaceEnabled(false);
                                break;
                            }
                            case BACKUP_FILES: {
                                SettingHelper.setBackupFilesInterfaceEnabled(false);
                                break;
                            }
                            case REFRESH_BACKUP_POLICY: {
                                SettingHelper.setRefreshBackupPolicyInterfaceEnabled(false);
                                break;
                            }
                            case UPDATE_AGENT: {
                                SettingHelper.setUpdateAgentBackupInterfaceEnabled(false);
                                break;
                            }
                            case ABOUT: {
                                SettingHelper.setAboutBackupInterfaceEnabled(false);
                                break;
                            }
                            case BLOCK_NOTIFICATIONS: {
                                SettingHelper.setBackuptoolTipNotificationBlocked(false);
                                break;
                            }
                            case SYSTRAYICON: {
                                SettingHelper.setBackupSystrayIconEnabled(false);
                                break;
                            }
                            case NETWORK_SETTINGS: {
                                SettingHelper.setNetworkSettingsEnabled(false);
                                break;
                            }
                            default: {
                                logger.debug(MESSAGE + permission);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(MESSAGE + e);
                    }
                }
                break block39;
            }
            if (!"SYNC".equalsIgnoreCase(productType)) break block39;
            InterfaceManagementService.initialiseDefaultUISettings("SYNC", true);
            for (String permission : uiPermissionsList) {
                try {
                    switch (interfaceFeatures.valueOf(permission)) {
                        case INITIATE_SYNC: {
                            SettingHelper.setSyncNowInterfaceEnabled(false);
                            break;
                        }
                        case SYNC_SETTINGS: {
                            SettingHelper.setSyncSettingsInterfaceEnabled(false);
                            break;
                        }
                        case SYNC_FILES: {
                            SettingHelper.setSyncFilesInterfaceEnabled(false);
                            break;
                        }
                        case REFRESH_SYNC_POLICY: {
                            SettingHelper.setRefreshSyncPolicyInterfaceEnabled(false);
                            break;
                        }
                        case SEARCH: {
                            SettingHelper.setSearchInterfaceEnabled(false);
                            break;
                        }
                        case OPEN_SYNC_FOLDER: {
                            SettingHelper.setOpenSyncFolderInterfaceEnabled(false);
                            break;
                        }
                        case EXIT: {
                            SettingHelper.setExitSyncInterfaceEnabled(false);
                            break;
                        }
                        case DECOUPLE: {
                            SettingHelper.setDecoupleSyncInterfaceEnabled(false);
                            break;
                        }
                        case SUPPORT: {
                            SettingHelper.setSupportSyncInterfaceEnabled(false);
                            break;
                        }
                        case UPDATE_AGENT: {
                            SettingHelper.setUpdateAgentSyncInterfaceEnabled(false);
                            break;
                        }
                        case ABOUT: {
                            SettingHelper.setAboutSyncInterfaceEnabled(false);
                            break;
                        }
                        case BLOCK_NOTIFICATIONS: {
                            SettingHelper.setSynctoolTipNotificationBlocked(false);
                            break;
                        }
                        case SYSTRAYICON: {
                            SettingHelper.setSyncSystrayIconEnabled(false);
                            break;
                        }
                        default: {
                            logger.debug(MESSAGE + permission);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(MESSAGE + e);
                }
            }
        }
    }

    public static void initialiseDefaultUISettings(String productType, boolean defaultValue) {
        if ("BACKUP".equalsIgnoreCase(productType)) {
            SettingHelper.setExitBackupInterfaceEnabled(defaultValue);
            SettingHelper.setDecoupleBackupInterfaceEnabled(defaultValue);
            SettingHelper.setSupportBackupInterfaceEnabled(defaultValue);
            SettingHelper.setInitiateBackupInterfaceEnabled(defaultValue);
            SettingHelper.setRestoreInterfaceEnabled(defaultValue);
            SettingHelper.setPauseBackupInterfaceEnabled(defaultValue);
            SettingHelper.setStopBackupInterfaceEnabled(defaultValue);
            SettingHelper.setBackupSettingsInterfaceEnabled(defaultValue);
            SettingHelper.setBackupFilesInterfaceEnabled(defaultValue);
            SettingHelper.setRefreshBackupPolicyInterfaceEnabled(defaultValue);
            SettingHelper.setUpdateAgentBackupInterfaceEnabled(defaultValue);
            SettingHelper.setAboutBackupInterfaceEnabled(defaultValue);
            SettingHelper.setBackuptoolTipNotificationBlocked(defaultValue);
            SettingHelper.setBackupSystrayIconEnabled(defaultValue);
            SettingHelper.setNetworkSettingsEnabled(defaultValue);
        } else if ("SYNC".equalsIgnoreCase(productType)) {
            SettingHelper.setExitSyncInterfaceEnabled(defaultValue);
            SettingHelper.setDecoupleSyncInterfaceEnabled(defaultValue);
            SettingHelper.setSupportSyncInterfaceEnabled(defaultValue);
            SettingHelper.setSyncNowInterfaceEnabled(defaultValue);
            SettingHelper.setSyncSettingsInterfaceEnabled(defaultValue);
            SettingHelper.setSyncFilesInterfaceEnabled(defaultValue);
            SettingHelper.setRefreshSyncPolicyInterfaceEnabled(defaultValue);
            SettingHelper.setSearchInterfaceEnabled(defaultValue);
            SettingHelper.setOpenSyncFolderInterfaceEnabled(defaultValue);
            SettingHelper.setUpdateAgentSyncInterfaceEnabled(defaultValue);
            SettingHelper.setAboutSyncInterfaceEnabled(defaultValue);
            SettingHelper.setSynctoolTipNotificationBlocked(defaultValue);
            SettingHelper.setSyncSystrayIconEnabled(defaultValue);
        }
    }

    public static enum interfaceFeatures {
        EXIT,
        DECOUPLE,
        SUPPORT,
        INTIATE_BACKUP,
        RESTORE,
        PAUSE_BACKUP,
        STOP_BACKUP,
        BACKUP_SETTINGS,
        BACKUP_FILES,
        REFRESH_BACKUP_POLICY,
        INITIATE_SYNC,
        SYNC_SETTINGS,
        SYNC_FILES,
        REFRESH_SYNC_POLICY,
        SEARCH,
        OPEN_SYNC_FOLDER,
        BLOCK_NOTIFICATIONS,
        UPDATE_AGENT,
        ABOUT,
        SYSTRAYICON,
        NETWORK_SETTINGS;

    }
}

