/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.alarm;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.MacCheckBackupPolicy;
import com.parablu.epa.service.notifications.MacEventsManagement;
import com.parablu.epa.service.sync.MacCheckSyncPolicy;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MacPolicyRefreshHelper {
    private static Logger logger = LoggerFactory.getLogger(MacPolicyRefreshHelper.class);
    private static Timer backupPolicyRefreshTimer = null;
    private static Timer syncPolicyRefreshTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;
    private static MacEventsManagement macEventsManagement = new MacEventsManagement();

    private MacPolicyRefreshHelper() {
    }

    public static synchronized void initiateBackupPolicyTimer() {
        MacCheckBackupPolicy.resetTimers();
        logger.debug("Initiating policy refresh timer" + SettingHelper.getTempPolicyRefreshIntervalInMins());
        backupPolicyRefreshTimer = new Timer();
        try {
            backupPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    macEventsManagement.refreshPolicyTask();
                }
            }, 5000L, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error in policy refresh timer" + e.getMessage());
        }
    }

    public static synchronized void initiateBackupPolicyTimerAfterDelay() {
        logger.debug("Initiating policy refresh timer after delay");
        backupPolicyRefreshTimer = new Timer();
        try {
            backupPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    macEventsManagement.refreshPolicyTask();
                }
            }, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getTempPolicyRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in policy refresh timer" + e.getMessage());
        }
    }

    public static synchronized void resetBackupPolicyTimer() {
        if (backupPolicyRefreshTimer != null) {
            backupPolicyRefreshTimer.cancel();
        }
        MacPolicyRefreshHelper.initiateBackupPolicyTimerAfterDelay();
    }

    public static void cancelBackupPolicyTimer() {
        backupPolicyRefreshTimer.cancel();
    }

    public static synchronized void refreshPolicyAndResetTimer() {
        MacCheckSyncPolicy.pullSyncPolicy();
        BlusyncThreadHelper.resetSyncTimer();
        macEventsManagement.refreshPolicyTask();
    }

    public static void resetSyncPolicyTimer(int syncPolicyRefreshInterval) {
        if (syncPolicyRefreshTimer != null) {
            syncPolicyRefreshTimer.cancel();
        }
        MacPolicyRefreshHelper.initiateSyncPolicyTimerAfterDelay(syncPolicyRefreshInterval);
    }

    private static void initiateSyncPolicyTimerAfterDelay(int syncPolicyRefreshInterval) {
        syncPolicyRefreshTimer = new Timer();
        try {
            syncPolicyRefreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    MacCheckSyncPolicy.pullSyncPolicy();
                    BlusyncThreadHelper.resetSyncTimer();
                }
            }, (long)syncPolicyRefreshInterval * timeInMillisecondsConvertionFactorFromMinutes, (long)syncPolicyRefreshInterval * timeInMillisecondsConvertionFactorFromMinutes);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in initiating timer......" + e.getMessage());
        }
        logger.debug("Initiating policy refresh timer after delay ");
    }

    public static void cancelBSyncPolicyTimer() {
        syncPolicyRefreshTimer.cancel();
    }
}

