/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class ContentType
implements DEREncodable {
    private DERObjectIdentifier contentType;

    public ContentType(String string) {
        this.setContentType(string);
    }

    public ContentType(DERObjectIdentifier dERObjectIdentifier) {
        this.contentType = dERObjectIdentifier;
    }

    public ContentType(ContentType contentType) {
        this.contentType = contentType.contentType;
    }

    public static ContentType getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentType) {
            return (ContentType)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentType((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentType.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentType");
    }

    public static ContentType newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentType) {
            return new ContentType((ContentType)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentType((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return ContentType.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid ContentType");
    }

    public String getContentType() {
        return this.contentType.getId();
    }

    private void setContentType(String string) {
        this.contentType = new DERObjectIdentifier(string);
    }

    public DERObject getDERObject() {
        return this.contentType;
    }
}

