/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.Impl;

import com.parablu.epa.Impl.NoBackupSchedules;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.to.NoBkpScheduleTO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoBackupSchedulesImpl
implements NoBackupSchedules {
    private static Logger logger = LoggerFactory.getLogger(NoBackupSchedulesImpl.class);
    BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());

    @Override
    public boolean isNoBackupSchedule() {
        List<NoBkpScheduleTO> schedules = this.backupPolicyDAOImpl.getNoBKPSchedules();
        boolean isSkipBackup = false;
        logger.debug("error to parse schedules..." + schedules.size());
        for (NoBkpScheduleTO schedule : schedules) {
            logger.error("error to parse schedules..." + schedule.getScheduleName());
            logger.error("stringArrays..." + schedule.getDayArray());
            String[] stringArray = schedule.getDayArray().split(",");
            logger.error("stringArrays..." + stringArray);
            int[] dayArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dayArray[i] = Integer.parseInt(stringArray[i].trim());
            }
            try {
                isSkipBackup = NoBackupSchedulesImpl.isCurrentTimeInRange(schedule.getFromTime(), schedule.getToTime(), dayArray);
                if (!isSkipBackup) continue;
                break;
            }
            catch (ParseException e) {
                logger.error("error to parse schedules...");
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                logger.error("error to parse schedules...");
                e.printStackTrace();
                return false;
            }
        }
        logger.error("isSkipBackup..." + isSkipBackup);
        return isSkipBackup;
    }

    public static boolean isCurrentTimeInRange(String startTimeString, String endTimeString, int[] days) throws ParseException {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Date startTime = timeFormat.parse(startTimeString);
        Date endTime = timeFormat.parse(endTimeString);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(14, 0);
        int currentDay = now.get(7);
        boolean isDayInRange = false;
        for (int day : days) {
            if (day != currentDay) continue;
            isDayInRange = true;
            break;
        }
        if (!isDayInRange) {
            return false;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.set(11, startTime.getHours());
        startCal.set(12, startTime.getMinutes());
        startCal.set(13, 0);
        startCal.set(14, 0);
        Calendar endCal = Calendar.getInstance();
        endCal.set(11, endTime.getHours());
        endCal.set(12, endTime.getMinutes());
        endCal.set(13, 0);
        endCal.set(14, 0);
        if (!now.after(startCal) || now.before(endCal)) {
            // empty if block
        }
        return now.equals(startCal) || now.equals(endCal) || now.after(startCal) && now.before(endCal);
    }

    public static boolean isCurrentTimeInRange1(String startTimeString, String endTimeString, int[] days) throws ParseException {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Date startTime = timeFormat.parse(startTimeString);
        Date endTime = timeFormat.parse(endTimeString);
        Calendar now = Calendar.getInstance();
        now.set(13, 0);
        now.set(14, 0);
        int currentDay = now.get(7);
        boolean isDayInRange = false;
        for (int day : days) {
            if (day != currentDay) continue;
            isDayInRange = true;
            break;
        }
        if (!isDayInRange) {
            return false;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.set(11, startTime.getHours());
        startCal.set(12, startTime.getMinutes());
        startCal.set(13, 0);
        startCal.set(14, 0);
        Calendar endCal = Calendar.getInstance();
        endCal.set(11, endTime.getHours());
        endCal.set(12, endTime.getMinutes());
        endCal.set(13, 0);
        endCal.set(14, 0);
        if (!now.after(startCal) || now.before(endCal)) {
            // empty if block
        }
        return now.equals(startCal) || now.equals(endCal) || now.after(startCal) && now.before(endCal);
    }
}

