/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSettings
extends BaseView {
    public Shell shell = null;
    private static final int COLOR255 = 255;
    private Color whiteColor = new Color((Device)Display.getCurrent(), 255, 255, 255);
    FontsManager fontsManager;
    private ImageData shellImageData = null;
    private Image shellImage = null;
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    private Color uiBackgroundColor = new Color((Device)Display.getCurrent(), 240, 240, 240);
    private static final int COLOR240 = 240;
    private Group wifiSettingsPanel = null;
    private Button nwSettingsCheckBox = null;
    protected Composite centerWizardPanel = null;
    private Button okButton = null;
    private Button cancelButton = null;
    List<String> selctedNWList = new ArrayList<String>();
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Logger logger = LoggerFactory.getLogger(NetworkSettings.class);

    NetworkSettings() throws IOException {
        try {
            this.shell = new Shell(1216);
            int xAxisLocation = this.shell.getDisplay().getClientArea().width / 8 - 50;
            int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 190;
            this.shell.setLocation(xAxisLocation, yAxisLocation);
            this.shell.setBackground(this.whiteColor);
        }
        catch (Exception e) {
            logger.error("Exception in UIMain constructor: " + e.getMessage());
            logger.trace("" + e);
        }
    }

    public void openShell() {
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.numColumns = 1;
        shellGridLayout.marginRight = 0;
        this.shell.setLayout((Layout)new FillLayout(512));
        this.fontsManager = new FontsManager(this.shell.getDisplay());
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        this.shell.setFont(this.fontsManager.getMediumNormalFont());
        this.shell.setSize(400, 600);
        this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.shell.setImage(this.shellImage);
        this.generateUI();
        Listener listener = event -> {
            logger.debug("BluSync UI Close action called from UIMain");
            this.closeUi(true);
        };
        this.shell.addListener(21, listener);
        this.shell.open();
    }

    public void closeUi(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        this.setImageDataObjectsToNull();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
    }

    private void setImageDataObjectsToNull() {
        this.shellImageData = null;
    }

    public void generateUI() {
        try {
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 2816);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            this.wifiSettingsPanel = new Group((Composite)scrolledComposite, 8);
            GridLayout wifiSettingsPanelGridLayout = new GridLayout();
            GridData wifiSettingsPanelGridData = new GridData(768);
            wifiSettingsPanelGridLayout.makeColumnsEqualWidth = false;
            wifiSettingsPanelGridLayout.marginLeft = 10;
            wifiSettingsPanelGridLayout.marginRight = 10;
            wifiSettingsPanelGridLayout.horizontalSpacing = 7;
            wifiSettingsPanelGridLayout.verticalSpacing = 6;
            wifiSettingsPanelGridLayout.marginTop = 6;
            wifiSettingsPanelGridLayout.marginBottom = 5;
            wifiSettingsPanelGridLayout.numColumns = 1;
            this.wifiSettingsPanel.setLayout((Layout)wifiSettingsPanelGridLayout);
            wifiSettingsPanelGridData.grabExcessHorizontalSpace = true;
            this.wifiSettingsPanel.setText("Wi-Fi Settings");
            this.wifiSettingsPanel.setFont(this.fontsManager.getSmallNormalFont());
            this.wifiSettingsPanel.setLayoutData((Object)wifiSettingsPanelGridData);
            List<String> nwList = NetworkSettings.getWifiNetworksWindows();
            HashSet<String> uniqueSet = new HashSet<String>(nwList);
            String networkNames = backUpFolderDAOImpl.getAllNetworkSettings();
            logger.debug("inside validateNetworks" + networkNames);
            if (!StringUtils.isEmpty((String)networkNames)) {
                String[] networks;
                for (String networkName : networks = networkNames.split("\\s*,\\s*")) {
                    uniqueSet.add(networkName);
                }
            }
            for (String nw : uniqueSet) {
                if (StringUtils.isEmpty((String)nw)) {
                    nw = "Hidden Network";
                }
                boolean selected = false;
                if (StringUtils.isNotEmpty((String)networkNames) && networkNames.contains(nw)) {
                    this.selctedNWList.add(nw);
                    selected = true;
                }
                GridData proxtCheckBoxGridData = new GridData(768);
                this.setNetworklist(proxtCheckBoxGridData, nw, selected);
            }
            this.wifiSettingsPanel.setSize(this.wifiSettingsPanel.computeSize(-1, -1));
            logger.debug("inside validateNetworks" + this.wifiSettingsPanel.getSize());
            scrolledComposite.setContent((Control)this.wifiSettingsPanel);
            scrolledComposite.setMinSize(this.wifiSettingsPanel.computeSize(-1, -1));
            Composite cancelcomp = new Composite((Composite)this.shell, 4);
            GridLayout cancelcompPanelGridLayout1 = new GridLayout();
            cancelcompPanelGridLayout1.makeColumnsEqualWidth = false;
            cancelcompPanelGridLayout1.marginLeft = 5;
            cancelcompPanelGridLayout1.horizontalSpacing = 7;
            cancelcompPanelGridLayout1.verticalSpacing = 6;
            cancelcompPanelGridLayout1.marginTop = 10;
            cancelcompPanelGridLayout1.marginBottom = 10;
            cancelcompPanelGridLayout1.numColumns = 3;
            GridData cancelcompGridData1 = new GridData(768);
            cancelcompGridData1.grabExcessHorizontalSpace = true;
            cancelcompGridData1.grabExcessVerticalSpace = true;
            cancelcomp.setLayout((Layout)cancelcompPanelGridLayout1);
            cancelcomp.setLayoutData((Object)cancelcompGridData1);
            GridData saveGridData = new GridData();
            saveGridData.horizontalAlignment = 2;
            saveGridData.widthHint = 62;
            Label dummyLable = new Label(cancelcomp, 4);
            dummyLable.setText("                     ");
            dummyLable.setToolTipText("");
            dummyLable.setEnabled(false);
            this.okButton = new Button(cancelcomp, 8);
            this.okButton.setText(" Save ");
            this.okButton.setBounds(20, 300, 100, 30);
            this.okButton.setLayoutData((Object)saveGridData);
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        MessageBox msg = new MessageBox(NetworkSettings.this.shell, 40);
                        msg.setText("Metered Network");
                        msg.setMessage("Changes saved successfully");
                        msg.open();
                        String commaSeparatedString = String.join((CharSequence)", ", NetworkSettings.this.selctedNWList);
                        PropertyHelper.changeConfigProperty((String)"NWList", (String)commaSeparatedString, (int)1);
                        backUpFolderDAOImpl.dropNetworkSettingsTable();
                        backupPolicyDAOImpl.createNetworkSettingsTable();
                        backUpFolderDAOImpl.insertNetworkSettings(commaSeparatedString);
                        NetworkSettings.this.shell.close();
                    }
                    catch (Exception e1) {
                        logger.error("Error to save in nw settings in db .." + e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
            this.cancelButton = new Button(cancelcomp, 8);
            this.cancelButton.setText(" Cancel ");
            this.cancelButton.setBounds(20, 300, 100, 30);
            this.cancelButton.setLayoutData((Object)saveGridData);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    logger.debug("inside cancel...");
                    NetworkSettings.this.shell.close();
                }
            });
        }
        catch (Exception e) {
            logger.error("Error to create network settings ui.." + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setNetworklist(GridData checkBoxGridData, String nw, boolean selected) {
        this.nwSettingsCheckBox = new Button((Composite)this.wifiSettingsPanel, 32);
        checkBoxGridData.verticalSpan = 2;
        checkBoxGridData.horizontalSpan = 2;
        this.nwSettingsCheckBox.setLayoutData((Object)checkBoxGridData);
        this.nwSettingsCheckBox.setFont(this.fontsManager.getMediumNormalFont());
        this.nwSettingsCheckBox.setText(nw);
        this.nwSettingsCheckBox.setSelection(selected);
        this.nwSettingsCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (btn.getSelection()) {
                    NetworkSettings.this.selctedNWList.add(btn.getText());
                } else {
                    NetworkSettings.this.selctedNWList.remove(btn.getText());
                }
            }
        });
    }

    private static List<String> getWifiNetworksWindows() throws IOException {
        ArrayList<String> nwList = new ArrayList<String>();
        try {
            String line;
            String[] cmd = new String[]{"/System/Library/PrivateFrameworks/Apple80211.framework/Versions/Current/Resources/airport", "-s"};
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                logger.debug(line);
                String ssid = line.trim().split("\\s+")[0];
                nwList.add(ssid);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("Command exited with error code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return nwList;
    }
}

