/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.dao.UploadTableDAO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.RenamedTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTableImpl
extends BaseDAO
implements UploadTableDAO {
    private Logger logger = LoggerFactory.getLogger(UploadTableImpl.class);

    public UploadTableImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListToTable(List<FileTO> fileList) {
        StringBuilder sqlQuery = new StringBuilder().append("INSERT INTO ").append("UploadTable").append(" Values(?,?,?,?,?,?,?,?);");
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                int listsize = fileList.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    FileTO currentFilesTO = fileList.get(recordCount);
                    int tempValueFolder = currentFilesTO.isFolder() ? 1 : 0;
                    int tempValueExist = currentFilesTO.isExists() ? 1 : 0;
                    this.statement.setString(1, currentFilesTO.getFileName());
                    this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                    this.statement.setString(3, currentFilesTO.getMiniCloudId());
                    this.statement.setString(4, currentFilesTO.getMd5checksum());
                    this.statement.setString(5, currentFilesTO.getMetaData());
                    this.statement.setString(6, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                    this.statement.setInt(7, tempValueFolder);
                    this.statement.setInt(8, tempValueExist);
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.statement.close();
                this.conn.commit();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while insert List To upload Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    @Deprecated
    public void removeListFromTable(List<FileTO> fileList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTable(FileTO fileList) {
        String filePath = fileList.getAbstractFilePath();
        String filename = fileList.getFileName();
        StringBuilder sqlQuery = new StringBuilder().append("delete from ").append("UploadTable").append(" where ").append("filepath").append("=?").append(" and ").append("filename").append("= ?").append(";");
        this.statement = null;
        this.logger.debug("time before removing entry" + System.currentTimeMillis());
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                this.statement.setString(1, filePath);
                this.statement.setString(2, filename);
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing from Upload Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        this.logger.debug("time after removing entry" + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable() {
        this.statement = null;
        StringBuilder sqlQuery = new StringBuilder().append("delete from ").append("UploadTable");
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while clearing Upload Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    public boolean createUploadTable() {
        this.statement = null;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(createUploadTableSqlQuery.toString());
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while createing Upload Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return gotConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> selectListFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select * from ").append("UploadTable");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = new ArrayList<FileTO>();
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting List From Table", (Throwable)e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set selecting List From Table" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> selectSortedListFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select * from ").append("UploadTable").append(" Order By ").append("folder").append(" Desc,").append("(Length(").append("filepath").append(") - Length(REPLACE(").append("filepath").append(",\"\\\",\"\"))) Asc;");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = new ArrayList<FileTO>();
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting Sorted List From Upload Table", (Throwable)e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set select Sorted List From Upload Table" + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTable(List<RenamedTO> renTOList) {
        String sqlQueryStart = "UPDATE UploadTable SET filename=?";
        String sqlQueryMid = " Where filename=?";
        String sqlQueryEnd = " And filepath=?";
        StringBuilder sqlQuery = new StringBuilder().append(sqlQueryStart).append(sqlQueryMid).append(sqlQueryEnd);
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                for (RenamedTO renTo : renTOList) {
                    String tempPath = renTo.getAbstractFilePath();
                    String tempName = renTo.getOldFileName();
                    String tempNewName = renTo.getNewfileName();
                    this.statement.setString(1, tempNewName);
                    this.statement.setString(2, tempName);
                    this.statement.setString(3, tempPath);
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while update Table", (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileCountFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select count(*) from ").append("UploadTable").append(" where ").append("folder").append("=0").append(";");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        long countOfFileTOList = 0L;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                if (selectImageTableResult != null && selectImageTableResult.next()) {
                    countOfFileTOList = selectImageTableResult.getLong(1);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Row Count From Table", (Throwable)e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set geting Row Count From Table", (Throwable)e);
                    }
                }
                this.closeConnection();
            }
        }
        return countOfFileTOList;
    }
}

