/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class PBES2Parameters
implements PKCSObjectIdentifiers,
DEREncodable {
    private DERObjectIdentifier objectId;
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Parameters(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)enumeration.nextElement();
        this.func = dERConstructedSequence2.getObjectAt(0).equals(PKCSObjectIdentifiers.id_PBKDF2) ? new PBKDF2Params(dERConstructedSequence2) : new KeyDerivationFunc(dERConstructedSequence2);
        this.scheme = new EncryptionScheme((DERConstructedSequence)enumeration.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.func);
        dERConstructedSequence.addObject(this.scheme);
        return dERConstructedSequence;
    }
}

