/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.RestoreDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.restore.MultipartRestoreCallable;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.service.sync.interfaces.CleanupInterface;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.RestoreActivityTO;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RestoreRunnable.class);
    private ExecutorService multiPartRestoreService;
    private String gatewayIp;
    private AtomicInteger restoreCount;
    private AtomicLong restoredSize;
    private AtomicBoolean stopRestore;
    private RestoreElement restoreElement;
    private RestoreActivityTO activityTO;
    private MultipartRestoreCallable multipartRestoreCallable;
    private BlockingQueue<Future<Integer>> finishedBatchesQueue;
    private AtomicInteger noOfBatches;
    private boolean isSync = false;
    private List<FileTO> syncDownloadList;
    private CleanupInterface<FileTO> cleanupInterface;

    public RestoreRunnable(ExecutorService multiPartRestoreService, String gatewayIP, AtomicInteger restoreCount, AtomicLong restoredSize, AtomicBoolean stopRestore, RestoreElement restoreElement, RestoreActivityTO activityTO, BlockingQueue<Future<Integer>> finishedBatchesQueue, AtomicInteger noOfBatches, boolean isSync, List<FileTO> syncDownloadList, CleanupInterface<FileTO> cleanupInterface) {
        this.multiPartRestoreService = multiPartRestoreService;
        this.gatewayIp = gatewayIP;
        this.restoreCount = restoreCount;
        this.restoredSize = restoredSize;
        this.stopRestore = stopRestore;
        this.restoreElement = restoreElement;
        this.activityTO = activityTO;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.noOfBatches = noOfBatches;
        this.isSync = isSync;
        this.syncDownloadList = syncDownloadList;
        this.cleanupInterface = cleanupInterface;
    }

    @Override
    public void run() {
        this.logger.debug("thread priority:" + Thread.currentThread().getPriority());
        int restoredFolderCount = 0;
        RestoreDAOImpl restoreDAOImpl = new RestoreDAOImpl(SettingHelper.getRestoreDbUrl());
        List<RestoreElement> fileListFromDb = null;
        fileListFromDb = this.isSync && this.syncDownloadList != null && !this.syncDownloadList.isEmpty() ? this.convertToRestoreElement(this.syncDownloadList, this.restoreElement) : restoreDAOImpl.getRestoreFilepath();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        if (fileListFromDb != null) {
            block4: while (restoredFolderCount < fileListFromDb.size()) {
                this.logger.debug("restoredFolderCount:" + restoredFolderCount);
                try {
                    if (this.isSync) {
                        if (this.stopRestore.get()) {
                            this.logger.debug("REstore called for stop....");
                            break;
                        }
                        NotificationHelper.setRestoreStarted(true);
                        NotificationHelper.restoreFinished = false;
                        NotificationHelper.successfulRestore = 1;
                        List partitionedLists = Lists.partition(fileListFromDb, (int)100);
                        Iterator iterator = partitionedLists.iterator();
                        while (iterator.hasNext()) {
                            List subList = (List)iterator.next();
                            this.restoreElement.setRestoreCount(String.valueOf(subList.size()));
                            ArrayList<RestoreElement> elements = new ArrayList<RestoreElement>(subList);
                            this.multipartRestoreCallable = new MultipartRestoreCallable(elements, this.stopRestore, this.gatewayIp, this.restoreCount, this.restoredSize, this.restoreElement, this.noOfBatches, this.isSync, this.cleanupInterface);
                            Future<Integer> response = this.multiPartRestoreService.submit(this.multipartRestoreCallable);
                            this.finishedBatchesQueue.put(response);
                            this.logger.debug("response:" + response + " restoredFolder count:" + (restoredFolderCount += elements.size()));
                        }
                        continue;
                    }
                    for (RestoreElement element : fileListFromDb) {
                        if (this.stopRestore.get()) {
                            this.logger.debug("REstore called for stop....");
                            continue block4;
                        }
                        NotificationHelper.setRestoreStarted(true);
                        NotificationHelper.restoreFinished = false;
                        NotificationHelper.successfulRestore = 1;
                        element.setCloudName(this.restoreElement.getCloudName());
                        element.setDeleteRestoreEvent(this.restoreElement.isDeleteRestoreEvent());
                        element.setDeviceUUid(this.restoreElement.getDeviceUUid());
                        element.setFileBackupId(this.restoreElement.getFileBackupId());
                        element.setFileName(this.encodeUTFBase64(this.restoreElement.getFileName()));
                        element.setFileUserOwner(this.restoreElement.getFileUserOwner());
                        element.setRestoreAllVersions(this.restoreElement.isRestoreAllVersions());
                        element.setRestoreBatchId(this.restoreElement.getRestoreBatchId());
                        element.setRestoreCount(this.restoreElement.getRestoreCount());
                        element.setRestoredFolder(this.restoreElement.getRestoredFolder());
                        element.setRestoreInterrupted(this.restoreElement.isRestoreInterrupted());
                        element.setRestoreTillDate(this.restoreElement.getRestoreTillDate());
                        element.setRestoreDeletedFiles(this.restoreElement.isRestoreDeletedFiles());
                        element.setOverwriteNewerFiles(this.restoreElement.isOverwriteNewerFiles());
                        element.setRestoreToOnedrive(this.restoreElement.isRestoreToOnedrive());
                        element.setRestoreStartTime(this.restoreElement.getRestoreStartTime());
                        element.setTotalRestoredSize(this.restoreElement.getTotalRestoredSize());
                        this.updateRestoreEvent(this.activityTO, restoreActivityHistoryDAOImpl);
                        this.logger.debug(this.multiPartRestoreService + " before calling restore:" + element.getSelectedDevicePath() + " restoreCount:" + this.restoreCount.get() + " restoredSize:" + this.restoredSize.get());
                        element.setDevicePath(this.encodeUTFBase64(element.getDevicePath().replace("\\", "/")));
                        ArrayList<RestoreElement> restoreElements = new ArrayList<RestoreElement>();
                        restoreElements.add(element);
                        this.multipartRestoreCallable = new MultipartRestoreCallable(restoreElements, this.stopRestore, this.gatewayIp, this.restoreCount, this.restoredSize, this.restoreElement, this.noOfBatches, this.isSync, this.cleanupInterface);
                        Future<Integer> response = this.multiPartRestoreService.submit(this.multipartRestoreCallable);
                        this.logger.debug("REstore element:" + element.getDevicePath());
                        this.finishedBatchesQueue.put(response);
                        this.logger.debug("response:" + response + " restoredFolder count:" + ++restoredFolderCount);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.finishedBatchesQueue.put((Future<Integer>)Futures.immediateFuture((Object)-1));
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
    }

    private List<RestoreElement> convertToRestoreElement(List<FileTO> syncDownloadList, RestoreElement restoreElement) {
        ArrayList<RestoreElement> syncRestoreElements = new ArrayList<RestoreElement>();
        for (FileTO fileTO : syncDownloadList) {
            RestoreElement syncRestoreElement = new RestoreElement();
            syncRestoreElement.setCloudName(restoreElement.getCloudName());
            syncRestoreElement.setDeviceUUid(restoreElement.getDeviceUUid());
            syncRestoreElement.setRestoreBatchId(restoreElement.getRestoreBatchId());
            syncRestoreElement.setRestoreAllVersions(restoreElement.isRestoreAllVersions());
            syncRestoreElement.setFileBackupId(fileTO.getFileRevisionId());
            syncRestoreElement.setFileName(this.encodeUTFBase64(fileTO.getFileName()));
            syncRestoreElement.setDevicePath(this.encodeUTFBase64(fileTO.getAbstractFilePath().replace("\\", "/")));
            syncRestoreElements.add(syncRestoreElement);
        }
        return syncRestoreElements;
    }

    private String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    private void updateRestoreEvent(RestoreActivityTO restoreActivityTo, RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        restoreActivityTo.setTotalRestoreCount("" + this.restoreCount.get());
        restoreActivityTo.setTotalRestoredSize(this.restoredSize.get());
        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
        this.logger.debug("Resore count:" + restoreActivityTo.getTotalRestoreCount() + "Resore size:" + restoreActivityTo.getTotalRestoredSize());
    }
}

