/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.ExtIOFilter;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtility {
    private static Logger logger = LoggerFactory.getLogger(FileSystemUtility.class);
    private int lengthOfParablu = "ParaBlu".length();
    private static final String PARENT_DIR = "The parent directory is :";
    private static final String CHUNK = "CHUNK";
    private static final String DOT_PBS = ".pbsdn.tmp";
    private int lastSuccessfulCrawledTime = 0;
    private int count = 1;

    public List<FileTO> crawlFolder(String folderPath, String devicePath, long lastSuccessfulCrawlTimeStamp, String miniCloudId) {
        ArrayList<FileTO> crawledfilesTOList = null;
        File currentFolder = new File(folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        logger.debug("Count of sub directories and files in the parent directory (crawlFolder) :" + childFileAndFolderNames.length);
        logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<FileTO> fileTOList;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            Object completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + (String)completePath;
            String fileName = currentProcessingFile.getName();
            completePath = ((String)completePath).substring(0, ((String)completePath).length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : String.valueOf(currentProcessingFile.lastModified());
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, (String)completePath, fileName);
            if (!isFileADirectory || (fileTOList = this.crawlFolder(currentProcessingFile.getAbsolutePath(), devicePath, lastSuccessfulCrawlTimeStamp, miniCloudId)) == null) continue;
            crawledfilesTOList.addAll(fileTOList);
        }
        return crawledfilesTOList;
    }

    public List<FileTO> crawlFolderEfficient(String folderPath, String devicePath, Map<String, FileTO> fileHashMap, String miniCloudId, Map<String, String> extensionsMap, int allowedSize, List<String> minicloudNameList) {
        ArrayList<FileTO> crawledfilesTOList = null;
        Boolean checkList = true;
        File currentFolder = new File(folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        logger.debug("The number of sub directories and files in the parent directory (crawlFolderEfficient) :" + childFileAndFolderNames.length);
        logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            List<FileTO> curFileTOList;
            boolean isFileADirectory;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().contains(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (isfileHidden || !(isFileADirectory = currentProcessingFile.isDirectory()) && !FileSystemUtility.checkExtensions(extensionsMap, currentProcessingFile)) continue;
            if (currentProcessingFile.getName().toLowerCase().startsWith("_mc_")) {
                logger.debug("folder name is with _mc_");
                continue;
            }
            if (this.checkFileSize(currentProcessingFile, allowedSize)) {
                logger.debug(">>>>> File skiped as Max size exceeded " + currentProcessingFile.getName());
                continue;
            }
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory) {
                Long previousModifiedValue;
                Long prevModifiedValue = null;
                FileTO fileTo = fileHashMap.get(absPath);
                Boolean isexists = null;
                if (fileTo != null) {
                    prevModifiedValue = fileTo.getLastModifiedTimestamp();
                    isexists = fileTo.isExists();
                }
                if (prevModifiedValue != null && (previousModifiedValue = Long.valueOf(prevModifiedValue / 1000L)).equals(currentProcessingFile.lastModified() / 1000L) && isexists.booleanValue()) continue;
            }
            Object completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + (String)completePath;
            String fileName = currentProcessingFile.getName();
            completePath = ((String)completePath).substring(0, ((String)completePath).length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : String.valueOf(currentProcessingFile.lastModified());
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, (String)completePath, fileName);
            if (!isFileADirectory || (curFileTOList = this.crawlFolderEfficient(currentProcessingFile.getAbsolutePath(), devicePath, fileHashMap, miniCloudId, extensionsMap, allowedSize, minicloudNameList)) == null) continue;
            crawledfilesTOList.addAll(curFileTOList);
        }
        return crawledfilesTOList;
    }

    public List<FileTO> crawlFolderEfficientExcludingMiniClouds(String folderPath, String devicePath, Map<String, FileTO> fileHashMap, String miniCloudId, List<String> minicloudNameList, Map<String, String> extensionsMap, int allowedSize) {
        ArrayList<FileTO> crawledfilesTOList = null;
        Boolean checkList = true;
        File currentFolder = new File(folderPath);
        logger.debug("filePath :::::::: " + folderPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        logger.debug("The number of sub directories and files in the parent directory :" + childFileAndFolderNames.length);
        logger.debug(PARENT_DIR + currentFolder.getName());
        crawledfilesTOList = new ArrayList<FileTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().contains(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (!isFileADirectory && !FileSystemUtility.checkExtensions(extensionsMap, currentProcessingFile)) {
                logger.debug("skiping as ext not included >>>>>>>>> " + currentProcessingFile.getName());
                continue;
            }
            if (minicloudNameList.contains(currentProcessingFile.getName())) {
                logger.debug(">>>>> File skiped as in prev list " + currentProcessingFile.getName());
                continue;
            }
            if (currentProcessingFile.getName().toLowerCase().startsWith("_mc_")) {
                logger.debug("folder name is with _mc_");
                continue;
            }
            if (this.checkFileSize(currentProcessingFile, allowedSize)) {
                logger.debug(">>>>> File skiped as Max size exceeded " + currentProcessingFile.getName());
                continue;
            }
            if (checkList.booleanValue() && !isFileADirectory) {
                Long previousModifiedValue;
                FileTO fileTo = fileHashMap.get(absPath);
                Long prevModifiedValue = null;
                Boolean fileExists = null;
                if (fileTo != null) {
                    prevModifiedValue = fileTo.getLastModifiedTimestamp();
                    fileExists = fileTo.isExists();
                }
                if (prevModifiedValue != null && (previousModifiedValue = Long.valueOf(prevModifiedValue / 1000L)).equals(currentProcessingFile.lastModified() / 1000L) && fileExists.booleanValue()) continue;
            }
            String fileName = currentProcessingFile.getName();
            Object completePath = absPath.substring(devicePath.length() + 1 + this.lengthOfParablu, absPath.length());
            completePath = "ParaBlu" + (String)completePath;
            completePath = ((String)completePath).substring(0, ((String)completePath).length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : String.valueOf(currentProcessingFile.lastModified());
            this.createFileToAndAddDetailsToList(miniCloudId, crawledfilesTOList, md5Value, currentProcessingFile, isFileADirectory, (String)completePath, fileName);
            if (!isFileADirectory) continue;
            logger.debug(">>>>>>>> recursive crawl : " + currentProcessingFile.getAbsolutePath());
            List<FileTO> curFileTOList = this.crawlFolderEfficient(currentProcessingFile.getAbsolutePath(), devicePath, fileHashMap, miniCloudId, extensionsMap, allowedSize, minicloudNameList);
            if (curFileTOList == null) continue;
            crawledfilesTOList.addAll(curFileTOList);
        }
        return crawledfilesTOList;
    }

    private FileTO createFileToAndAddDetailsToList(String miniCloudId, List<FileTO> crawledfilesTOList, String md5Value, File currentProcessingFile, boolean isFileADirectory, String completePath, String fileName) {
        FileTO tempFileTO = new FileTO();
        tempFileTO.setExists(true);
        tempFileTO.setAbstractFilePath(completePath);
        tempFileTO.setFileName(fileName);
        tempFileTO.setFolder(isFileADirectory);
        tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
        tempFileTO.setMetaData("null");
        tempFileTO.setMiniCloudId(miniCloudId);
        crawledfilesTOList.add(tempFileTO);
        return tempFileTO;
    }

    public List<MediaTO> crawlFolderEfficientStoringFullPathsForMedia(String completeParentPath, Map<String, Long> fileHashMap, String[] extensions, String mediaType) {
        ArrayList<MediaTO> crawledfilesTOList = new ArrayList<MediaTO>();
        logger.debug("Extensions: " + extensions);
        logger.debug("Complete Parent Path: " + completeParentPath);
        File currentFolder = new File(completeParentPath);
        Boolean checkList = true;
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        ExtIOFilter extIOFilter = new ExtIOFilter(extensions);
        Iterator itr = FileUtils.iterateFiles((File)currentFolder, (IOFileFilter)extIOFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (itr.hasNext()) {
            Long prevModifiedValue;
            boolean isfileHidden;
            File currentProcessingFile = (File)itr.next();
            logger.debug("Current processing file for media: " + currentProcessingFile + " ");
            if (currentProcessingFile.getName().contains(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (isfileHidden) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) {
                logger.debug("Skipping file " + absPath);
                continue;
            }
            String completePath = absPath;
            String fileName = currentProcessingFile.getName();
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : "parablu";
            MediaTO tempFileTO = new MediaTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(completePath);
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
            tempFileTO.setMd5checksum(String.valueOf(currentProcessingFile.lastModified()));
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            tempFileTO.setExtension(FilenameUtils.getExtension((String)currentProcessingFile.getAbsolutePath()));
            tempFileTO.setMediaType(mediaType);
            crawledfilesTOList.add(tempFileTO);
        }
        return crawledfilesTOList;
    }

    public List<BackupTO> crawlFolderEfficientStoringFullPaths(String completeParentPath, Map<String, Long> fileHashMap) {
        ArrayList<BackupTO> crawledfilesTOList = null;
        Boolean checkList = true;
        boolean fileToBeSkipped = false;
        File currentFolder = new File(completeParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return crawledfilesTOList;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        int noOfChildFilesAndFolders = childFileAndFolderNames.length;
        crawledfilesTOList = new ArrayList<BackupTO>();
        for (int i = 0; i < noOfChildFilesAndFolders; ++i) {
            Long prevModifiedValue;
            boolean isfileHidden;
            File currentProcessingFile = childFileAndFolderNames[i];
            if (currentProcessingFile.getName().contains(DOT_PBS)) {
                currentProcessingFile.delete();
                continue;
            }
            boolean bl = isfileHidden = currentProcessingFile.getName().equals(CHUNK) || currentProcessingFile.isHidden();
            if (currentProcessingFile.getName().startsWith("pbchnkz") || currentProcessingFile.getName().startsWith(".pbchnkz")) {
                if (currentProcessingFile.isDirectory()) {
                    String[] children = currentProcessingFile.list();
                    for (int j = 0; j < children.length; ++j) {
                        new File(currentProcessingFile, children[j]).delete();
                    }
                }
                currentProcessingFile.delete();
                continue;
            }
            if (currentProcessingFile.isDirectory()) {
                fileToBeSkipped = this.fileSkip(currentProcessingFile.getName());
            }
            if (isfileHidden || fileToBeSkipped) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            String completePath = absPath;
            String fileName = currentProcessingFile.getName().replaceAll("[*!@^&{}<>|]", "~");
            completePath = completePath.substring(0, completePath.length() - (fileName.length() + 1));
            String md5Value = isFileADirectory ? "null" : "parablu";
            BackupTO tempFileTO = new BackupTO();
            tempFileTO.setExists(true);
            tempFileTO.setAbstractFilePath(completePath);
            tempFileTO.setFileName(fileName);
            tempFileTO.setFolder(isFileADirectory);
            tempFileTO.setLastModifiedTimestamp(currentProcessingFile.lastModified());
            tempFileTO.setMd5checksum(String.valueOf(currentProcessingFile.lastModified()));
            tempFileTO.setMetaData("null");
            tempFileTO.setClientData(absPath);
            tempFileTO.setBaseFolder(false);
            crawledfilesTOList.add(tempFileTO);
            if (!isFileADirectory) continue;
            List<BackupTO> curFileTOList = this.crawlFolderEfficientStoringFullPaths(currentProcessingFile.getAbsolutePath(), fileHashMap);
            if (curFileTOList != null) {
                crawledfilesTOList.addAll(curFileTOList);
            }
            if (crawledfilesTOList.size() <= 5) continue;
            logger.debug("BACKUPLIST >5000 so write in new file");
            crawledfilesTOList = new ArrayList();
            ++this.count;
        }
        return crawledfilesTOList;
    }

    private boolean fileSkip(String fileName) {
        if (ParabluFileSystemUtils.getOsType().toLowerCase().contains("win")) {
            for (BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.values()) {
                if (!beSkipped.value().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith(BackupFoldersToBeSkipped.WindowsBackupFoldersToBeSkipped.PROGRAM_FILES.value())) continue;
                logger.debug("LIST OF FILES FROM ENUM SKIPPING FILE " + fileName);
                return true;
            }
        } else {
            for (BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped.values()) {
                if (!beSkipped.value().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith(BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped.LIBRARY.value())) continue;
                logger.debug("LIST OF FILES FROM ENUM SKIPPING FILE " + fileName);
                return true;
            }
        }
        return false;
    }

    public List<FileTO> showFolderContent(String folderName) {
        List<FileTO> fileToList = null;
        logger.debug("FolderName in show folder content:" + folderName);
        return fileToList;
    }

    public int getLastSuccessfulCrawledTime() {
        return this.lastSuccessfulCrawledTime;
    }

    public static boolean checkExtensions(Map<String, String> extensionsMap, File file) {
        String[] tmpExtensionCheck = null;
        String extensions = extensionsMap.get("extensionName");
        String filterType = extensionsMap.get("filterType");
        boolean isExtAllowed = true;
        if (!StringUtils.isEmpty((String)extensions)) {
            String delimiter = ",";
            tmpExtensionCheck = extensions.split(delimiter);
        }
        if (!StringUtils.isEmpty((String)extensions)) {
            isExtAllowed = StringUtils.isEmpty((String)filterType) || filterType.equalsIgnoreCase("inclusion") ? FileSystemUtility.isExtensionAllowedForBackup(tmpExtensionCheck, file) : FileSystemUtility.isExtensionRestricted(tmpExtensionCheck, file);
        }
        return isExtAllowed;
    }

    private static boolean isExtensionAllowedForBackup(String[] tmpExtensionCheck, File file) {
        String fileext = FilenameUtils.getExtension((String)file.getName());
        boolean fileAllowedForBackup = false;
        for (String ext : tmpExtensionCheck) {
            if ("ALL".equalsIgnoreCase(ext = ext.trim())) {
                fileAllowedForBackup = true;
                break;
            }
            if (!ext.equalsIgnoreCase(fileext)) continue;
            fileAllowedForBackup = true;
            break;
        }
        return fileAllowedForBackup;
    }

    private boolean checkFileSize(File file, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = file.length();
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    private static boolean isExtensionRestricted(String[] tmpExtensionCheck, File file) {
        boolean isFileAllowed = true;
        String fileext = FilenameUtils.getExtension((String)file.getName());
        for (String ext : tmpExtensionCheck) {
            if (!(ext = ext.trim()).equalsIgnoreCase(fileext)) continue;
            isFileAllowed = false;
            break;
        }
        return isFileAllowed;
    }

    public static String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    public static long getFileAccessTime(File proccessingFile) {
        Path filePath = Paths.get(proccessingFile.getAbsolutePath(), new String[0]);
        BasicFileAttributes fileAttributes = null;
        long fileAccessTime = 0L;
        try {
            fileAttributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            fileAccessTime = fileAttributes.lastAccessTime().toMillis();
        }
        catch (IOException e) {
            logger.error("Exception while getting file access time : " + e.getMessage());
            logger.trace("" + e);
        }
        return fileAccessTime;
    }

    public static void setFileAccessTime(File proccessingFile, long lastAccessTime) {
        try {
            Path filePath = Paths.get(proccessingFile.getAbsolutePath(), new String[0]);
            FileTime fileTime = FileTime.fromMillis(lastAccessTime);
            Files.setAttribute(filePath, "basic:lastAccessTime", fileTime, new LinkOption[0]);
        }
        catch (IOException e) {
            logger.error("Exception while getting file access time : " + e.getMessage());
            logger.trace("" + e);
        }
    }

    public static void setFileLastModifiedTime(File proccessingFile, long lastModifiedTime) {
        try {
            Path filePath = Paths.get(proccessingFile.getAbsolutePath(), new String[0]);
            FileTime fileTime = FileTime.fromMillis(lastModifiedTime);
            Files.setAttribute(filePath, "basic:lastModifiedTime", fileTime, new LinkOption[0]);
        }
        catch (IOException e) {
            logger.error("Exception while getting file lastmodified time : " + e.getMessage());
            logger.trace("" + e);
        }
    }

    public static long getFileCreatedTime(File proccessingFile) {
        Path filePath = Paths.get(proccessingFile.getAbsolutePath(), new String[0]);
        BasicFileAttributes fileAttributes = null;
        long fileCreatedTime = 0L;
        try {
            fileAttributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            fileCreatedTime = fileAttributes.creationTime().toMillis();
        }
        catch (IOException e) {
            logger.error("Exception while getting file created time : " + e.getMessage());
            logger.trace("" + e);
        }
        return fileCreatedTime;
    }

    public static void setFileCreationTime(File proccessingFile, long creationTime) {
        try {
            Path filePath = Paths.get(proccessingFile.getAbsolutePath(), new String[0]);
            FileTime fileTime = FileTime.fromMillis(creationTime);
            Files.setAttribute(filePath, "basic:creationTime", fileTime, new LinkOption[0]);
        }
        catch (IOException e) {
            logger.error("Exception while getting file access time : " + e.getMessage());
            logger.trace("" + e);
        }
    }
}

