/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class EncryptedContent
implements DEREncodable {
    private DEROctetString content;

    public EncryptedContent(byte[] byArray) {
        this.setContent(byArray);
    }

    public EncryptedContent(DEROctetString dEROctetString) {
        this.content = dEROctetString;
    }

    public EncryptedContent(EncryptedContent encryptedContent) {
        this.content = encryptedContent.content;
    }

    public static EncryptedContent getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedContent) {
            return (EncryptedContent)object;
        }
        if (object instanceof DEROctetString) {
            return new EncryptedContent((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedContent.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedContent");
    }

    public static EncryptedContent newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedContent) {
            return new EncryptedContent((EncryptedContent)object);
        }
        if (object instanceof DEROctetString) {
            return new EncryptedContent((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedContent.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedContent");
    }

    public byte[] getContent() {
        return this.content.getOctets();
    }

    private void setContent(byte[] byArray) {
        this.content = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.content;
    }
}

