/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RestoreBackup;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestoreUI {
    Logger logger = LoggerFactory.getLogger(RestoreUI.class);
    FontsManager fontsManager;
    protected Composite centerWizardPanel = null;
    private static boolean uilock = false;
    public Shell shell = null;
    private static final int COLOR255 = 255;
    private static final int COLOR240 = 240;
    private Color uiBackgroundColor = new Color((Device)Display.getCurrent(), 240, 240, 240);
    private Color whiteColor = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private Image shellImage = null;
    public RestoreBackup restorebackup = null;
    private Timer restoreUITimer = null;

    RestoreUI() throws IOException {
        try {
            this.restoreUITimer = new Timer();
            this.restoreUITimer.schedule((TimerTask)new RestoreUICloseTask(), 500L, 2000L);
            GridLayout shellGridLayout = new GridLayout();
            this.shell = new Shell(64);
            int xAxisLocation = this.shell.getDisplay().getClientArea().width / 2 - 200;
            int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 300;
            this.shell.setLocation(xAxisLocation, yAxisLocation);
            this.shell.setBackground(this.whiteColor);
            this.shell.setMinimumSize(200, 430);
            shellGridLayout.marginWidth = 0;
            shellGridLayout.marginHeight = 0;
            shellGridLayout.marginBottom = 0;
            shellGridLayout.verticalSpacing = 0;
            shellGridLayout.horizontalSpacing = 0;
            shellGridLayout.numColumns = 1;
            shellGridLayout.marginRight = 0;
            this.shell.setLayout((Layout)shellGridLayout);
            this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
            Listener listener = event -> {
                this.logger.debug("BluSync UI Close action called from UIMain");
                this.close();
            };
            this.shell.addListener(21, listener);
            this.shell.pack();
            this.shell.setVisible(false);
            this.restorebackup = new RestoreBackup(this.shell);
            this.restorebackup.setText("Restore Backup");
            this.restorebackup.startRestoreBackup();
            this.restorebackup.openShell();
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" exception:" + e.getMessage());
            uilock = false;
        }
    }

    public void restoreBatchUpdateBeforeExit() {
        if (this.restorebackup != null) {
            this.restorebackup.restoreBatchUpdateBeforeExit();
        }
    }

    public void close() {
        if (this.shell == null) {
            return;
        }
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        this.closeRestoreDisplay();
        this.logger.debug("Disposed all fields");
        uilock = false;
    }

    public static synchronized boolean isUilock() {
        return uilock;
    }

    public static synchronized void setUilock(boolean uilock) {
        RestoreUI.uilock = uilock;
    }

    public void closeRestoreDisplay() {
        if (this.restorebackup != null) {
            this.restorebackup.closeRestoreBackup();
        }
    }

    public void cancelRestoreDisplayTimer() {
        this.restorebackup.cancelRestoreDisplayTimer();
    }

    public void closeRestoreWindow() {
        this.restorebackup.closeRestoreWindow();
    }

    class RestoreUICloseTask
    extends TimerTask {
        RestoreUICloseTask() {
        }

        @Override
        public void run() {
            if (RestoreUI.this.shell == null || RestoreUI.this.shell.isDisposed()) {
                return;
            }
            try {
                Runnable runnable = () -> {
                    if (RestoreUI.this.restorebackup.isDisposed()) {
                        RestoreUI.this.close();
                    }
                };
                RestoreUI.this.shell.getDisplay().asyncExec(runnable);
            }
            catch (Exception e) {
                RestoreUI.this.logger.trace("" + e);
                RestoreUI.this.logger.error(" exception in restore ui close task..." + e.getMessage());
            }
        }
    }
}

