/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CertificateRevocationLists;
import org.bouncycastle.asn1.cms.CertificateSet;

public class OriginatorInfo
implements DEREncodable {
    private CertificateSet certs;
    private CertificateRevocationLists crls;

    public OriginatorInfo(CertificateSet certificateSet, CertificateRevocationLists certificateRevocationLists) {
        this.setCertificates(certificateSet);
        this.setCrls(certificateRevocationLists);
    }

    public OriginatorInfo(BERConstructedSequence bERConstructedSequence) {
        block0 : switch (bERConstructedSequence.getSize()) {
            case 0: {
                break;
            }
            case 1: {
                BERTaggedObject bERTaggedObject = (BERTaggedObject)bERConstructedSequence.getObjectAt(0);
                switch (bERTaggedObject.getTagNo()) {
                    case 0: {
                        this.certs = CertificateSet.getInstance(bERTaggedObject);
                        break block0;
                    }
                    case 1: {
                        this.crls = CertificateRevocationLists.getInstance(bERTaggedObject);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid OriginatorInfo");
            }
            case 2: {
                this.certs = CertificateSet.getInstance(bERConstructedSequence.getObjectAt(0));
                this.crls = CertificateRevocationLists.getInstance(bERConstructedSequence.getObjectAt(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OriginatorInfo");
            }
        }
    }

    public OriginatorInfo(OriginatorInfo originatorInfo) {
        this.certs = originatorInfo.certs;
        this.crls = originatorInfo.crls;
    }

    public static OriginatorInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorInfo) {
            return (OriginatorInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new OriginatorInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorInfo");
    }

    public static OriginatorInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorInfo) {
            return new OriginatorInfo((OriginatorInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new OriginatorInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorInfo");
    }

    public CertificateSet getCertificates() {
        return this.certs;
    }

    private void setCertificates(CertificateSet certificateSet) {
        this.certs = certificateSet;
    }

    public CertificateRevocationLists getCrls() {
        return this.crls;
    }

    private void setCrls(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        if (this.certs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.certs.getDERObject()));
        }
        if (this.crls != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.crls.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

