/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;

public class UnauthAttributes
implements DEREncodable {
    private DERConstructedSet attributes;

    public UnauthAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public UnauthAttributes(DERConstructedSet dERConstructedSet) {
        this.attributes = dERConstructedSet;
    }

    public UnauthAttributes(UnauthAttributes unauthAttributes) {
        this.attributes = unauthAttributes.attributes;
    }

    public static UnauthAttributes getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof UnauthAttributes) {
            return (UnauthAttributes)object;
        }
        if (object instanceof DERConstructedSet) {
            return new UnauthAttributes((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return UnauthAttributes.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid UnauthAttributes");
    }

    public static UnauthAttributes newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof UnauthAttributes) {
            return new UnauthAttributes((UnauthAttributes)object);
        }
        if (object instanceof DERConstructedSet) {
            return new UnauthAttributes((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return UnauthAttributes.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid UnauthAttributes");
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.attributes;
    }
}

