/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.BERInputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;

public class DERInputStream
extends FilterInputStream
implements DERTags {
    public DERInputStream(InputStream inputStream) {
        super(inputStream);
    }

    protected int readLength() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.read();
                if (n4 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n4;
                ++n3;
            }
        }
        return n;
    }

    protected void readFully(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n == 0) {
            return;
        }
        while ((n -= this.read(byArray, byArray.length - n, n)) != 0) {
        }
    }

    protected DERObject buildObject(int n, byte[] byArray) throws IOException {
        switch (n) {
            case 5: {
                return null;
            }
            case 48: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
                DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
                try {
                    while (true) {
                        DERObject dERObject = bERInputStream.readObject();
                        dERConstructedSequence.addObject(dERObject);
                    }
                }
                catch (EOFException eOFException) {
                    return dERConstructedSequence;
                }
            }
            case 49: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
                DERSet dERSet = new DERSet();
                try {
                    while (true) {
                        DERObject dERObject = bERInputStream.readObject();
                        dERSet.addObject(dERObject);
                    }
                }
                catch (EOFException eOFException) {
                    return dERSet;
                }
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n & 0xA0) != 0) {
            if (byArray.length == 0) {
                return new DERTaggedObject(n & 0xF);
            }
            if ((n & 0x20) == 0) {
                return new DERTaggedObject(false, n & 0xF, new DEROctetString(byArray));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BERInputStream bERInputStream = new BERInputStream(byteArrayInputStream);
            DERObject dERObject = bERInputStream.readObject();
            if (bERInputStream.available() == 0) {
                return new DERTaggedObject(n & 0xF, dERObject);
            }
            DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
            dERConstructedSequence.addObject(dERObject);
            try {
                while (true) {
                    dERObject = bERInputStream.readObject();
                    dERConstructedSequence.addObject(dERObject);
                }
            }
            catch (EOFException eOFException) {
                return new DERTaggedObject(false, n & 0xF, dERConstructedSequence);
            }
        }
        return new DERUnknownTag(n, byArray);
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = this.readLength();
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return this.buildObject(n, byArray);
    }
}

