/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTableUI
extends TableUI {
    private static final StringBuilder BASELINE_COMPONENT_KEY = new StringBuilder("Table.baselineComponent");
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private Handler handler;
    private boolean isFileList = false;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();

    private boolean pointOutsidePrefSize(int n, int n2, Point point) {
        if (!this.isFileList) {
            return false;
        }
        return SwingUtilities2.pointOutsidePrefSize(this.table, n, n2, point);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return this.getHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installDefaults2();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        LookAndFeel.installProperty(this.table, "opaque", Boolean.TRUE);
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            color3 = UIManager.getColor("Table.selectionBackground");
            this.table.setSelectionBackground(color3 != null ? color3 : UIManager.getColor("textHighlight"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            color2 = UIManager.getColor("Table.selectionForeground");
            this.table.setSelectionForeground(color2 != null ? color2 : UIManager.getColor("textHighlightText"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            color = UIManager.getColor("Table.gridColor");
            this.table.setGridColor(color != null ? color : Color.GRAY);
        }
        if ((container = SwingUtilities.getUnwrappedParent(this.table)) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
        this.isFileList = Boolean.TRUE.equals(this.table.getClientProperty("Table.isFileList"));
    }

    private void installDefaults2() {
        TransferHandler transferHandler = this.table.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
            if (this.table.getDropTarget() instanceof UIResource) {
                this.table.setDropTarget(null);
            }
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.getHandler());
        if (this.isFileList) {
            this.table.getSelectionModel().addListSelectionListener(this.getHandler());
        }
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.table, BasicTableUI.class, "Table.actionMap");
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.table, this, "Table.ancestorInputMap");
            if (this.table.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.table, this, "Table.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectNextColumn", 1, 0, false, false));
        lazyActionMap.put(new Actions("selectNextColumnChangeLead", 1, 0, false, false));
        lazyActionMap.put(new Actions("selectPreviousColumn", -1, 0, false, false));
        lazyActionMap.put(new Actions("selectPreviousColumnChangeLead", -1, 0, false, false));
        lazyActionMap.put(new Actions("selectNextRow", 0, 1, false, false));
        lazyActionMap.put(new Actions("selectNextRowChangeLead", 0, 1, false, false));
        lazyActionMap.put(new Actions("selectPreviousRow", 0, -1, false, false));
        lazyActionMap.put(new Actions("selectPreviousRowChangeLead", 0, -1, false, false));
        lazyActionMap.put(new Actions("selectNextColumnExtendSelection", 1, 0, true, false));
        lazyActionMap.put(new Actions("selectPreviousColumnExtendSelection", -1, 0, true, false));
        lazyActionMap.put(new Actions("selectNextRowExtendSelection", 0, 1, true, false));
        lazyActionMap.put(new Actions("selectPreviousRowExtendSelection", 0, -1, true, false));
        lazyActionMap.put(new Actions("scrollUpChangeSelection", false, false, true, false));
        lazyActionMap.put(new Actions("scrollDownChangeSelection", false, true, true, false));
        lazyActionMap.put(new Actions("selectFirstColumn", false, false, false, true));
        lazyActionMap.put(new Actions("selectLastColumn", false, true, false, true));
        lazyActionMap.put(new Actions("scrollUpExtendSelection", true, false, true, false));
        lazyActionMap.put(new Actions("scrollDownExtendSelection", true, true, true, false));
        lazyActionMap.put(new Actions("selectFirstColumnExtendSelection", true, false, false, true));
        lazyActionMap.put(new Actions("selectLastColumnExtendSelection", true, true, false, true));
        lazyActionMap.put(new Actions("selectFirstRow", false, false, true, true));
        lazyActionMap.put(new Actions("selectLastRow", false, true, true, true));
        lazyActionMap.put(new Actions("selectFirstRowExtendSelection", true, false, true, true));
        lazyActionMap.put(new Actions("selectLastRowExtendSelection", true, true, true, true));
        lazyActionMap.put(new Actions("selectNextColumnCell", 1, 0, false, true));
        lazyActionMap.put(new Actions("selectPreviousColumnCell", -1, 0, false, true));
        lazyActionMap.put(new Actions("selectNextRowCell", 0, 1, false, true));
        lazyActionMap.put(new Actions("selectPreviousRowCell", 0, -1, false, true));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("startEditing"));
        lazyActionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        lazyActionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        lazyActionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        lazyActionMap.put(new Actions("scrollLeftChangeSelection", false, false, false, false));
        lazyActionMap.put(new Actions("scrollRightChangeSelection", false, true, false, false));
        lazyActionMap.put(new Actions("scrollLeftExtendSelection", true, false, false, false));
        lazyActionMap.put(new Actions("scrollRightExtendSelection", true, true, false, false));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
        lazyActionMap.put(new Actions("focusHeader"));
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.getHandler());
        if (this.isFileList) {
            this.table.getSelectionModel().removeListSelectionListener(this.getHandler());
        }
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Component component = (Component)uIDefaults.get(BASELINE_COMPONENT_KEY);
        if (component == null) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            component = defaultTableCellRenderer.getTableCellRendererComponent(this.table, "a", false, false, -1, -1);
            uIDefaults.put(BASELINE_COMPONENT_KEY, component);
        }
        component.setFont(this.table.getFont());
        int n3 = this.table.getRowMargin();
        return component.getBaseline(Integer.MAX_VALUE, this.table.getRowHeight() - n3) + n3 / 2;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    private Dimension createTableSize(long l) {
        long l2;
        int n = 0;
        int n2 = this.table.getRowCount();
        if (n2 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        if ((l2 = Math.abs(l)) > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            this.paintDropLines(graphics);
            return;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint(bl ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintCells(graphics, n, n2, n3, n4);
        this.paintDropLines(graphics);
    }

    private void paintDropLines(Graphics graphics) {
        int n;
        int n2;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n2, rectangle.y, n, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n2 = rectangle.y;
            n = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n2, rectangle.width, n);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n = dropLocation.getRow();
        int n2 = dropLocation.getColumn();
        if (n2 >= this.table.getColumnCount()) {
            --n2;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (n >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n, true);
        if (n >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        block6: {
            int n5;
            int n6;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle = this.table.getCellRect(n, n3, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            if (this.table.getShowHorizontalLines()) {
                int n7 = rectangle3.x + rectangle3.width;
                n6 = rectangle3.y;
                for (n5 = n; n5 <= n2; ++n5) {
                    graphics.drawLine(rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block6;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle3.x;
                for (int i = n3; i <= n4; ++i) {
                    int n8 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 += n8) - 1, 0, n5 - 1, n6 - 1);
                }
            } else {
                n5 = rectangle3.x;
                for (int i = n4; i >= n3; --i) {
                    int n9 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 += n9) - 1, 0, n5 - 1, n6 - 1);
                }
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                for (int j = n3; j <= n4; ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    rectangle.width = n6 - n5;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i, j);
                    }
                    rectangle.x += n6;
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                int n7;
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
                if (tableColumn3 != tableColumn) {
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    this.paintCell(graphics, rectangle, i, n3);
                }
                for (int j = n3 + 1; j <= n4; ++j) {
                    tableColumn3 = tableColumnModel.getColumn(j);
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    rectangle.x -= n7;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i, j);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    private static int getAdjustedLead(JTable jTable, boolean bl, ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getLeadSelectionIndex();
        int n2 = bl ? jTable.getRowCount() : jTable.getColumnCount();
        return n < n2 ? n : -1;
    }

    private static int getAdjustedLead(JTable jTable, boolean bl) {
        return bl ? BasicTableUI.getAdjustedLead(jTable, bl, jTable.getSelectionModel()) : BasicTableUI.getAdjustedLead(jTable, bl, jTable.getColumnModel().getSelectionModel());
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int[] nArray;
                int n;
                int[] nArray2;
                int n2;
                JTable jTable = (JTable)jComponent;
                if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!jTable.getRowSelectionAllowed()) {
                    n2 = jTable.getRowCount();
                    nArray2 = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        nArray2[n] = n;
                    }
                } else {
                    nArray2 = jTable.getSelectedRows();
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    n2 = jTable.getColumnCount();
                    nArray = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        nArray[n] = n;
                    }
                } else {
                    nArray = jTable.getSelectedColumns();
                }
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                for (int i = 0; i < nArray2.length; ++i) {
                    stringBuffer2.append("<tr>\n");
                    for (int j = 0; j < nArray.length; ++j) {
                        Object object = jTable.getValueAt(nArray2[i], nArray[j]);
                        String string = object == null ? "" : object.toString();
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    private class Handler
    implements FocusListener,
    MouseInputListener,
    PropertyChangeListener,
    ListSelectionListener,
    ActionListener,
    DragRecognitionSupport.BeforeDrag {
        private Component dispatchComponent;
        private int pressedRow;
        private int pressedCol;
        private MouseEvent pressedEvent;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private boolean shouldStartTimer;
        private boolean outsidePrefSize;
        private Timer timer = null;

        private Handler() {
        }

        private void repaintLeadCell() {
            int n = BasicTableUI.getAdjustedLead(BasicTableUI.this.table, true);
            int n2 = BasicTableUI.getAdjustedLead(BasicTableUI.this.table, false);
            if (n < 0 || n2 < 0) {
                return;
            }
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n, n2, false);
            BasicTableUI.this.table.repaint(rectangle);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintLeadCell();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = BasicTableUI.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = BasicTableUI.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n = BasicTableUI.getAdjustedLead(BasicTableUI.this.table, true);
            int n2 = BasicTableUI.getAdjustedLead(BasicTableUI.this.table, false);
            if (n != -1 && n2 != -1 && !BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.editCellAt(n, n2)) {
                return;
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = BasicTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
            SwingUtilities2.setSkipClickCount(this.dispatchComponent, mouseEvent.getClickCount() - 1);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !BasicTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }

        private boolean canStartDrag() {
            if (this.pressedRow == -1 || this.pressedCol == -1) {
                return false;
            }
            if (BasicTableUI.this.isFileList) {
                return !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getSelectionModel().getSelectionMode() == 0 && BasicTableUI.this.table.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                return true;
            }
            return BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.isEditing() && !BasicTableUI.this.table.getCellEditor().stopCellEditing()) {
                Component component = BasicTableUI.this.table.getEditorComponent();
                if (component != null && !component.hasFocus()) {
                    SwingUtilities2.compositeRequestFocus(component);
                }
                return;
            }
            Point point = mouseEvent.getPoint();
            this.pressedRow = BasicTableUI.this.table.rowAtPoint(point);
            this.pressedCol = BasicTableUI.this.table.columnAtPoint(point);
            this.outsidePrefSize = BasicTableUI.this.pointOutsidePrefSize(this.pressedRow, this.pressedCol, point);
            if (BasicTableUI.this.isFileList) {
                boolean bl = this.shouldStartTimer = BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol) && !mouseEvent.isShiftDown() && !BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent) && !this.outsidePrefSize;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mousePressedDND(mouseEvent);
            } else {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!BasicTableUI.this.isFileList) {
                    this.setValueIsAdjusting(true);
                }
                this.adjustSelection(mouseEvent);
            }
        }

        private void mousePressedDND(MouseEvent mouseEvent) {
            this.pressedEvent = mouseEvent;
            boolean bl = true;
            this.dragStarted = false;
            if (this.canStartDrag() && DragRecognitionSupport.mousePressed(mouseEvent)) {
                this.dragPressDidSelection = false;
                if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent) && BasicTableUI.this.isFileList) {
                    return;
                }
                if (!mouseEvent.isShiftDown() && BasicTableUI.this.table.isCellSelected(this.pressedRow, this.pressedCol)) {
                    BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
                    return;
                }
                this.dragPressDidSelection = true;
                bl = false;
            } else if (!BasicTableUI.this.isFileList) {
                this.setValueIsAdjusting(true);
            }
            if (bl) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
            }
            this.adjustSelection(mouseEvent);
        }

        private void adjustSelection(MouseEvent mouseEvent) {
            if (this.outsidePrefSize) {
                if (!(mouseEvent.getID() != 501 || mouseEvent.isShiftDown() && BasicTableUI.this.table.getSelectionModel().getSelectionMode() != 0)) {
                    BasicTableUI.this.table.clearSelection();
                    TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.stopCellEditing();
                    }
                }
                return;
            }
            if (this.pressedCol == -1 || this.pressedRow == -1) {
                return;
            }
            boolean bl = BasicTableUI.this.table.getDragEnabled();
            if (!bl && !BasicTableUI.this.isFileList && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            }
            TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
            if (bl || tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                BasicTableUI.this.table.changeSelection(this.pressedRow, this.pressedCol, BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent), mouseEvent.isShiftDown());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, null);
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (component != null && !component.hasFocus()) {
                SwingUtilities2.compositeRequestFocus(component);
            }
        }

        private void maybeStartTimer() {
            if (!this.shouldStartTimer) {
                return;
            }
            if (this.timer == null) {
                this.timer = new Timer(1200, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled()) {
                this.mouseReleasedDND(mouseEvent);
            } else if (BasicTableUI.this.isFileList) {
                this.maybeStartTimer();
            }
            this.pressedEvent = null;
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        private void mouseReleasedDND(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = DragRecognitionSupport.mouseReleased(mouseEvent);
            if (mouseEvent2 != null) {
                SwingUtilities2.adjustFocus(BasicTableUI.this.table);
                if (!this.dragPressDidSelection) {
                    this.adjustSelection(mouseEvent2);
                }
            }
            if (!this.dragStarted) {
                if (BasicTableUI.this.isFileList) {
                    this.maybeStartTimer();
                    return;
                }
                Point point = mouseEvent.getPoint();
                if (this.pressedEvent != null && BasicTableUI.this.table.rowAtPoint(point) == this.pressedRow && BasicTableUI.this.table.columnAtPoint(point) == this.pressedCol && BasicTableUI.this.table.editCellAt(this.pressedRow, this.pressedCol, this.pressedEvent)) {
                    this.setDispatchComponent(this.pressedEvent);
                    this.repostEvent(this.pressedEvent);
                    TableCellEditor tableCellEditor = BasicTableUI.this.table.getCellEditor();
                    if (tableCellEditor != null) {
                        tableCellEditor.shouldSelectCell(this.pressedEvent);
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void dragStarting(MouseEvent mouseEvent) {
            this.dragStarted = true;
            if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent) && BasicTableUI.this.isFileList) {
                BasicTableUI.this.table.getSelectionModel().addSelectionInterval(this.pressedRow, this.pressedRow);
                BasicTableUI.this.table.getColumnModel().getSelectionModel().addSelectionInterval(this.pressedCol, this.pressedCol);
            }
            this.pressedEvent = null;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTableUI.this.table)) {
                return;
            }
            if (BasicTableUI.this.table.getDragEnabled() && (DragRecognitionSupport.mouseDragged(mouseEvent, this) || this.dragStarted)) {
                return;
            }
            this.repostEvent(mouseEvent);
            if (BasicTableUI.this.isFileList || BasicTableUI.this.table.isEditing()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            BasicTableUI.this.table.changeSelection(n, n2, BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent), true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("componentOrientation" == string) {
                InputMap inputMap = BasicTableUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(BasicTableUI.this.table, 1, inputMap);
                JTableHeader jTableHeader = BasicTableUI.this.table.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                }
            } else if ("dropLocation" == string) {
                JTable.DropLocation dropLocation = (JTable.DropLocation)propertyChangeEvent.getOldValue();
                this.repaintDropLocation(dropLocation);
                this.repaintDropLocation(BasicTableUI.this.table.getDropLocation());
            } else if ("Table.isFileList" == string) {
                BasicTableUI.this.isFileList = Boolean.TRUE.equals(BasicTableUI.this.table.getClientProperty("Table.isFileList"));
                BasicTableUI.this.table.revalidate();
                BasicTableUI.this.table.repaint();
                if (BasicTableUI.this.isFileList) {
                    BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getHandler());
                } else {
                    BasicTableUI.this.table.getSelectionModel().removeListSelectionListener(BasicTableUI.this.getHandler());
                    this.timer = null;
                }
            } else if ("selectionModel" == string && BasicTableUI.this.isFileList) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                listSelectionModel.removeListSelectionListener(BasicTableUI.this.getHandler());
                BasicTableUI.this.table.getSelectionModel().addListSelectionListener(BasicTableUI.this.getHandler());
            }
        }

        private void repaintDropLocation(JTable.DropLocation dropLocation) {
            Rectangle rectangle;
            if (dropLocation == null) {
                return;
            }
            if (!dropLocation.isInsertRow() && !dropLocation.isInsertColumn()) {
                Rectangle rectangle2 = BasicTableUI.this.table.getCellRect(dropLocation.getRow(), dropLocation.getColumn(), false);
                if (rectangle2 != null) {
                    BasicTableUI.this.table.repaint(rectangle2);
                }
                return;
            }
            if (dropLocation.isInsertRow() && (rectangle = BasicTableUI.this.extendRect(BasicTableUI.this.getHDropLineRect(dropLocation), true)) != null) {
                BasicTableUI.this.table.repaint(rectangle);
            }
            if (dropLocation.isInsertColumn() && (rectangle = BasicTableUI.this.extendRect(BasicTableUI.this.getVDropLineRect(dropLocation), false)) != null) {
                BasicTableUI.this.table.repaint(rectangle);
            }
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseReleased(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseExited(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseMoved(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicTableUI.this.getHandler().mouseDragged(mouseEvent);
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicTableUI.this.getHandler().focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicTableUI.this.getHandler().focusLost(focusEvent);
        }
    }

    public class KeyHandler
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyPressed(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyReleased(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            BasicTableUI.this.getHandler().keyTyped(keyEvent);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CANCEL_EDITING = "cancel";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String START_EDITING = "startEditing";
        private static final String NEXT_ROW = "selectNextRow";
        private static final String NEXT_ROW_CELL = "selectNextRowCell";
        private static final String NEXT_ROW_EXTEND_SELECTION = "selectNextRowExtendSelection";
        private static final String NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String PREVIOUS_ROW = "selectPreviousRow";
        private static final String PREVIOUS_ROW_CELL = "selectPreviousRowCell";
        private static final String PREVIOUS_ROW_EXTEND_SELECTION = "selectPreviousRowExtendSelection";
        private static final String PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String NEXT_COLUMN = "selectNextColumn";
        private static final String NEXT_COLUMN_CELL = "selectNextColumnCell";
        private static final String NEXT_COLUMN_EXTEND_SELECTION = "selectNextColumnExtendSelection";
        private static final String NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String PREVIOUS_COLUMN_CELL = "selectPreviousColumnCell";
        private static final String PREVIOUS_COLUMN_EXTEND_SELECTION = "selectPreviousColumnExtendSelection";
        private static final String PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SCROLL_LEFT_CHANGE_SELECTION = "scrollLeftChangeSelection";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_SELECTION = "scrollRightChangeSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String FIRST_COLUMN = "selectFirstColumn";
        private static final String FIRST_COLUMN_EXTEND_SELECTION = "selectFirstColumnExtendSelection";
        private static final String LAST_COLUMN = "selectLastColumn";
        private static final String LAST_COLUMN_EXTEND_SELECTION = "selectLastColumnExtendSelection";
        private static final String FIRST_ROW = "selectFirstRow";
        private static final String FIRST_ROW_EXTEND_SELECTION = "selectFirstRowExtendSelection";
        private static final String LAST_ROW = "selectLastRow";
        private static final String LAST_ROW_EXTEND_SELECTION = "selectLastRowExtendSelection";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";
        private static final String FOCUS_HEADER = "focusHeader";
        protected int dx;
        protected int dy;
        protected boolean extend;
        protected boolean inSelection;
        protected boolean forwards;
        protected boolean vertically;
        protected boolean toLimit;
        protected int leadRow;
        protected int leadColumn;

        Actions(String string) {
            super(string);
        }

        Actions(String string, int n, int n2, boolean bl, boolean bl2) {
            super(string);
            if (bl2) {
                this.inSelection = true;
                n = Actions.sign(n);
                n2 = Actions.sign(n2);
                assert (!(n != 0 && n2 != 0 || n == 0 && n2 == 0));
            }
            this.dx = n;
            this.dy = n2;
            this.extend = bl;
        }

        Actions(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(string, 0, 0, bl, false);
            this.forwards = bl2;
            this.vertically = bl3;
            this.toLimit = bl4;
        }

        private static int clipToRange(int n, int n2, int n3) {
            return Math.min(Math.max(n, n2), n3 - 1);
        }

        private void moveWithinTableRange(JTable jTable, int n, int n2) {
            this.leadRow = Actions.clipToRange(this.leadRow + n2, 0, jTable.getRowCount());
            this.leadColumn = Actions.clipToRange(this.leadColumn + n, 0, jTable.getColumnCount());
        }

        private static int sign(int n) {
            return n < 0 ? -1 : (n == 0 ? 0 : 1);
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n, int n2, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
            boolean bl;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            boolean bl2 = jTable.getRowSelectionAllowed();
            boolean bl3 = jTable.getColumnSelectionAllowed();
            if (bl2 && bl3) {
                n7 = jTable.getSelectedRowCount() * jTable.getSelectedColumnCount();
                n6 = listSelectionModel2.getMinSelectionIndex();
                n5 = listSelectionModel2.getMaxSelectionIndex();
                n4 = listSelectionModel.getMinSelectionIndex();
                n3 = listSelectionModel.getMaxSelectionIndex();
            } else if (bl2) {
                n7 = jTable.getSelectedRowCount();
                n6 = 0;
                n5 = jTable.getColumnCount() - 1;
                n4 = listSelectionModel.getMinSelectionIndex();
                n3 = listSelectionModel.getMaxSelectionIndex();
            } else if (bl3) {
                n7 = jTable.getSelectedColumnCount();
                n6 = listSelectionModel2.getMinSelectionIndex();
                n5 = listSelectionModel2.getMaxSelectionIndex();
                n4 = 0;
                n3 = jTable.getRowCount() - 1;
            } else {
                n7 = 0;
                n3 = 0;
                n4 = 0;
                n5 = 0;
                n6 = 0;
            }
            if (n7 == 0 || n7 == 1 && jTable.isCellSelected(this.leadRow, this.leadColumn)) {
                bl = false;
                n5 = jTable.getColumnCount() - 1;
                n3 = jTable.getRowCount() - 1;
                n6 = Math.min(0, n5);
                n4 = Math.min(0, n3);
            } else {
                bl = true;
            }
            if (n2 == 1 && this.leadColumn == -1) {
                this.leadColumn = n6;
                this.leadRow = -1;
            } else if (n == 1 && this.leadRow == -1) {
                this.leadRow = n4;
                this.leadColumn = -1;
            } else if (n2 == -1 && this.leadColumn == -1) {
                this.leadColumn = n5;
                this.leadRow = n3 + 1;
            } else if (n == -1 && this.leadRow == -1) {
                this.leadRow = n3;
                this.leadColumn = n5 + 1;
            }
            this.leadRow = Math.min(Math.max(this.leadRow, n4 - 1), n3 + 1);
            this.leadColumn = Math.min(Math.max(this.leadColumn, n6 - 1), n5 + 1);
            do {
                this.calcNextPos(n, n6, n5, n2, n4, n3);
            } while (bl && !jTable.isCellSelected(this.leadRow, this.leadColumn));
            return bl;
        }

        private void calcNextPos(int n, int n2, int n3, int n4, int n5, int n6) {
            if (n != 0) {
                this.leadColumn += n;
                if (this.leadColumn > n3) {
                    this.leadColumn = n2;
                    ++this.leadRow;
                    if (this.leadRow > n6) {
                        this.leadRow = n5;
                    }
                } else if (this.leadColumn < n2) {
                    this.leadColumn = n3;
                    --this.leadRow;
                    if (this.leadRow < n5) {
                        this.leadRow = n6;
                    }
                }
            } else {
                this.leadRow += n4;
                if (this.leadRow > n6) {
                    this.leadRow = n5;
                    ++this.leadColumn;
                    if (this.leadColumn > n3) {
                        this.leadColumn = n2;
                    }
                } else if (this.leadRow < n5) {
                    this.leadRow = n6;
                    --this.leadColumn;
                    if (this.leadColumn < n2) {
                        this.leadColumn = n3;
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTableHeader jTableHeader;
            Rectangle rectangle;
            String string = this.getName();
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.leadRow = BasicTableUI.getAdjustedLead(jTable, true, listSelectionModel);
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.leadColumn = BasicTableUI.getAdjustedLead(jTable, false, listSelectionModel2);
            if (string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == SCROLL_UP_CHANGE_SELECTION || string == SCROLL_UP_EXTEND_SELECTION || string == SCROLL_DOWN_CHANGE_SELECTION || string == SCROLL_DOWN_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == FIRST_ROW || string == FIRST_ROW_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == LAST_ROW || string == LAST_ROW_EXTEND_SELECTION) {
                if (this.toLimit) {
                    if (this.vertically) {
                        int n = jTable.getRowCount();
                        this.dx = 0;
                        this.dy = this.forwards ? n : -n;
                    } else {
                        int n = jTable.getColumnCount();
                        this.dx = this.forwards ? n : -n;
                        this.dy = 0;
                    }
                } else {
                    int n;
                    if (!(SwingUtilities.getUnwrappedParent(jTable).getParent() instanceof JScrollPane)) {
                        return;
                    }
                    Dimension dimension = jTable.getParent().getSize();
                    if (this.vertically) {
                        rectangle = jTable.getCellRect(this.leadRow, 0, true);
                        rectangle.y = this.forwards ? (rectangle.y += Math.max(dimension.height, rectangle.height)) : (rectangle.y -= dimension.height);
                        this.dx = 0;
                        n = jTable.rowAtPoint(rectangle.getLocation());
                        if (n == -1 && this.forwards) {
                            n = jTable.getRowCount();
                        }
                        this.dy = n - this.leadRow;
                    } else {
                        rectangle = jTable.getCellRect(0, this.leadColumn, true);
                        rectangle.x = this.forwards ? (rectangle.x += Math.max(dimension.width, rectangle.width)) : (rectangle.x -= dimension.width);
                        n = jTable.columnAtPoint(rectangle.getLocation());
                        if (n == -1) {
                            boolean bl = jTable.getComponentOrientation().isLeftToRight();
                            n = this.forwards ? (bl ? jTable.getColumnCount() : 0) : (bl ? 0 : jTable.getColumnCount());
                        }
                        this.dx = n - this.leadColumn;
                        this.dy = 0;
                    }
                }
            }
            if (string == NEXT_ROW || string == NEXT_ROW_CELL || string == NEXT_ROW_EXTEND_SELECTION || string == NEXT_ROW_CHANGE_LEAD || string == NEXT_COLUMN || string == NEXT_COLUMN_CELL || string == NEXT_COLUMN_EXTEND_SELECTION || string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_ROW || string == PREVIOUS_ROW_CELL || string == PREVIOUS_ROW_EXTEND_SELECTION || string == PREVIOUS_ROW_CHANGE_LEAD || string == PREVIOUS_COLUMN || string == PREVIOUS_COLUMN_CELL || string == PREVIOUS_COLUMN_EXTEND_SELECTION || string == PREVIOUS_COLUMN_CHANGE_LEAD || string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == SCROLL_UP_CHANGE_SELECTION || string == SCROLL_UP_EXTEND_SELECTION || string == SCROLL_DOWN_CHANGE_SELECTION || string == SCROLL_DOWN_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == FIRST_ROW || string == FIRST_ROW_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == LAST_ROW || string == LAST_ROW_EXTEND_SELECTION) {
                if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                    return;
                }
                boolean bl = false;
                if (string == NEXT_ROW_CHANGE_LEAD || string == PREVIOUS_ROW_CHANGE_LEAD) {
                    bl = listSelectionModel.getSelectionMode() == 2;
                } else if (string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN_CHANGE_LEAD) {
                    boolean bl2 = bl = listSelectionModel2.getSelectionMode() == 2;
                }
                if (bl) {
                    this.moveWithinTableRange(jTable, this.dx, this.dy);
                    if (this.dy != 0) {
                        ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(this.leadRow);
                        if (BasicTableUI.getAdjustedLead(jTable, false, listSelectionModel2) == -1 && jTable.getColumnCount() > 0) {
                            ((DefaultListSelectionModel)listSelectionModel2).moveLeadSelectionIndex(0);
                        }
                    } else {
                        ((DefaultListSelectionModel)listSelectionModel2).moveLeadSelectionIndex(this.leadColumn);
                        if (BasicTableUI.getAdjustedLead(jTable, true, listSelectionModel) == -1 && jTable.getRowCount() > 0) {
                            ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(0);
                        }
                    }
                    if ((rectangle = jTable.getCellRect(this.leadRow, this.leadColumn, false)) != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                } else if (!this.inSelection) {
                    this.moveWithinTableRange(jTable, this.dx, this.dy);
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                } else {
                    if (jTable.getRowCount() <= 0 || jTable.getColumnCount() <= 0) {
                        return;
                    }
                    if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, listSelectionModel, listSelectionModel2)) {
                        if (listSelectionModel.isSelectedIndex(this.leadRow)) {
                            listSelectionModel.addSelectionInterval(this.leadRow, this.leadRow);
                        } else {
                            listSelectionModel.removeSelectionInterval(this.leadRow, this.leadRow);
                        }
                        if (listSelectionModel2.isSelectedIndex(this.leadColumn)) {
                            listSelectionModel2.addSelectionInterval(this.leadColumn, this.leadColumn);
                        } else {
                            listSelectionModel2.removeSelectionInterval(this.leadColumn, this.leadColumn);
                        }
                        rectangle = jTable.getCellRect(this.leadRow, this.leadColumn, false);
                        if (rectangle != null) {
                            jTable.scrollRectToVisible(rectangle);
                        }
                    } else {
                        jTable.changeSelection(this.leadRow, this.leadColumn, false, false);
                    }
                }
            } else if (string == CANCEL_EDITING) {
                jTable.removeEditor();
            } else if (string == SELECT_ALL) {
                jTable.selectAll();
            } else if (string == CLEAR_SELECTION) {
                jTable.clearSelection();
            } else if (string == START_EDITING) {
                if (!jTable.hasFocus()) {
                    TableCellEditor tableCellEditor = jTable.getCellEditor();
                    if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                        return;
                    }
                    jTable.requestFocus();
                    return;
                }
                jTable.editCellAt(this.leadRow, this.leadColumn, actionEvent);
                Component component = jTable.getEditorComponent();
                if (component != null) {
                    component.requestFocus();
                }
            } else if (string == ADD_TO_SELECTION) {
                if (!jTable.isCellSelected(this.leadRow, this.leadColumn)) {
                    int n = listSelectionModel.getAnchorSelectionIndex();
                    int n2 = listSelectionModel2.getAnchorSelectionIndex();
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel2.setValueIsAdjusting(true);
                    jTable.changeSelection(this.leadRow, this.leadColumn, true, false);
                    listSelectionModel.setAnchorSelectionIndex(n);
                    listSelectionModel2.setAnchorSelectionIndex(n2);
                    listSelectionModel.setValueIsAdjusting(false);
                    listSelectionModel2.setValueIsAdjusting(false);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                jTable.changeSelection(this.leadRow, this.leadColumn, true, false);
            } else if (string == EXTEND_TO) {
                jTable.changeSelection(this.leadRow, this.leadColumn, false, true);
            } else if (string == MOVE_SELECTION_TO) {
                jTable.changeSelection(this.leadRow, this.leadColumn, false, false);
            } else if (string == FOCUS_HEADER && (jTableHeader = jTable.getTableHeader()) != null) {
                TableHeaderUI tableHeaderUI;
                int n = jTable.getSelectedColumn();
                if (n >= 0 && (tableHeaderUI = jTableHeader.getUI()) instanceof BasicTableHeaderUI) {
                    ((BasicTableHeaderUI)tableHeaderUI).selectColumn(n);
                }
                jTableHeader.requestFocusInWindow();
            }
        }

        public boolean isEnabled(Object object) {
            String string = this.getName();
            if (object instanceof JTable && Boolean.TRUE.equals(((JTable)object).getClientProperty("Table.isFileList")) && (string == NEXT_COLUMN || string == NEXT_COLUMN_CELL || string == NEXT_COLUMN_EXTEND_SELECTION || string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN || string == PREVIOUS_COLUMN_CELL || string == PREVIOUS_COLUMN_EXTEND_SELECTION || string == PREVIOUS_COLUMN_CHANGE_LEAD || string == SCROLL_LEFT_CHANGE_SELECTION || string == SCROLL_LEFT_EXTEND_SELECTION || string == SCROLL_RIGHT_CHANGE_SELECTION || string == SCROLL_RIGHT_EXTEND_SELECTION || string == FIRST_COLUMN || string == FIRST_COLUMN_EXTEND_SELECTION || string == LAST_COLUMN || string == LAST_COLUMN_EXTEND_SELECTION || string == NEXT_ROW_CELL || string == PREVIOUS_ROW_CELL)) {
                return false;
            }
            if (string == CANCEL_EDITING && object instanceof JTable) {
                return ((JTable)object).isEditing();
            }
            if (string == NEXT_ROW_CHANGE_LEAD || string == PREVIOUS_ROW_CHANGE_LEAD) {
                return object != null && ((JTable)object).getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (string == NEXT_COLUMN_CHANGE_LEAD || string == PREVIOUS_COLUMN_CHANGE_LEAD) {
                return object != null && ((JTable)object).getColumnModel().getSelectionModel() instanceof DefaultListSelectionModel;
            }
            if (string == ADD_TO_SELECTION && object instanceof JTable) {
                JTable jTable = (JTable)object;
                int n = BasicTableUI.getAdjustedLead(jTable, true);
                int n2 = BasicTableUI.getAdjustedLead(jTable, false);
                return !jTable.isEditing() && !jTable.isCellSelected(n, n2);
            }
            if (string == FOCUS_HEADER && object instanceof JTable) {
                JTable jTable = (JTable)object;
                return jTable.getTableHeader() != null;
            }
            return true;
        }
    }
}

