/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutionException;
import sun.nio.fs.Cancellable;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsSecurity;

class WindowsFileCopy {
    private WindowsFileCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copy(final WindowsPath windowsPath, final WindowsPath windowsPath2, CopyOption ... copyOptionArray) throws IOException {
        boolean bl2;
        block52: {
            String string;
            boolean bl4 = false;
            boolean bl3 = false;
            bl2 = true;
            boolean bl = false;
            for (CopyOption copyOption : copyOptionArray) {
                if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                    bl4 = true;
                    continue;
                }
                if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                    bl2 = false;
                    continue;
                }
                if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                    bl3 = true;
                    continue;
                }
                if (copyOption != ExtendedCopyOption.INTERRUPTIBLE) {
                    if (copyOption != null) throw new UnsupportedOperationException("Unsupported copy option");
                    throw new NullPointerException();
                }
                bl = true;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                windowsPath.checkRead();
                windowsPath2.checkWrite();
            }
            WindowsFileAttributes windowsFileAttributes2 = null;
            WindowsFileAttributes windowsFileAttributes = null;
            long l = 0L;
            try {
                l = windowsPath.openForReadAttributeAccess(bl2);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath);
            }
            try {
                try {
                    windowsFileAttributes2 = WindowsFileAttributes.readAttributes((long)l);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath);
                }
                long l2 = 0L;
                try {
                    block48: {
                        l2 = windowsPath2.openForReadAttributeAccess(false);
                        windowsFileAttributes = WindowsFileAttributes.readAttributes((long)l2);
                        if (!WindowsFileAttributes.isSameFile((WindowsFileAttributes)windowsFileAttributes2, (WindowsFileAttributes)windowsFileAttributes)) break block48;
                        WindowsNativeDispatcher.CloseHandle((long)l2);
                        return;
                    }
                    try {
                        if (!bl4) {
                            throw new FileAlreadyExistsException(windowsPath2.getPathForExceptionMessage());
                        }
                    }
                    finally {
                        WindowsNativeDispatcher.CloseHandle((long)l2);
                    }
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
            finally {
                WindowsNativeDispatcher.CloseHandle((long)l);
            }
            if (securityManager != null && windowsFileAttributes2.isSymbolicLink()) {
                securityManager.checkPermission(new LinkPermission("symbolic"));
            }
            final String string2 = WindowsFileCopy.asWin32Path(windowsPath);
            final String string3 = WindowsFileCopy.asWin32Path(windowsPath2);
            if (windowsFileAttributes != null) {
                try {
                    if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                        WindowsNativeDispatcher.RemoveDirectory((String)string3);
                    } else {
                        WindowsNativeDispatcher.DeleteFile((String)string3);
                    }
                }
                catch (WindowsException windowsException) {
                    if (windowsFileAttributes.isDirectory()) {
                        if (windowsException.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                        if (windowsException.lastError() == 183) {
                            throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                        }
                    }
                    windowsException.rethrowAsIOException(windowsPath2);
                }
            }
            if (!windowsFileAttributes2.isDirectory() && !windowsFileAttributes2.isDirectoryLink()) {
                int n;
                int n2 = n = windowsPath.getFileSystem().supportsLinks() && !bl2 ? 2048 : 0;
                if (bl) {
                    Cancellable cancellable = new Cancellable(){

                        @Override
                        public int cancelValue() {
                            return 1;
                        }

                        @Override
                        public void implRun() throws IOException {
                            try {
                                WindowsNativeDispatcher.CopyFileEx((String)string2, (String)string3, (int)n, (long)this.addressToPollForCancel());
                            }
                            catch (WindowsException windowsException) {
                                windowsException.rethrowAsIOException(windowsPath, windowsPath2);
                            }
                        }
                    };
                    try {
                        Cancellable.runInterruptibly(cancellable);
                    }
                    catch (ExecutionException executionException) {
                        Throwable throwable = executionException.getCause();
                        if (!(throwable instanceof IOException)) throw new IOException(throwable);
                        throw (IOException)throwable;
                    }
                }
                try {
                    WindowsNativeDispatcher.CopyFileEx((String)string2, (String)string3, (int)n, (long)0L);
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath, windowsPath2);
                }
                if (!bl3) return;
                try {
                    WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, bl2);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            try {
                if (windowsFileAttributes2.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory((String)string3, (long)0L);
                } else {
                    string = WindowsLinkSupport.readLink((WindowsPath)windowsPath);
                    int n = 1;
                    WindowsNativeDispatcher.CreateSymbolicLink((String)string3, (String)WindowsPath.addPrefixIfNeeded((String)string), (int)n);
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(windowsPath2);
            }
            if (!bl3) return;
            string = WindowsFileAttributeViews.createDosView((WindowsPath)windowsPath2, (boolean)false);
            try {
                string.setAttributes(windowsFileAttributes2);
            }
            catch (IOException iOException) {
                if (!windowsFileAttributes2.isDirectory()) break block52;
                try {
                    WindowsNativeDispatcher.RemoveDirectory((String)string3);
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
        }
        try {
            WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, bl2);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void move(WindowsPath windowsPath, WindowsPath windowsPath2, CopyOption ... copyOptionArray) throws IOException {
        CopyOption windowsException222;
        boolean bl = false;
        boolean bl2 = false;
        for (CopyOption windowsException222 : copyOptionArray) {
            if (windowsException222 == StandardCopyOption.ATOMIC_MOVE) {
                bl = true;
                continue;
            }
            if (windowsException222 == StandardCopyOption.REPLACE_EXISTING) {
                bl2 = true;
                continue;
            }
            if (windowsException222 == LinkOption.NOFOLLOW_LINKS) continue;
            if (windowsException222 != null) throw new UnsupportedOperationException("Unsupported copy option");
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            windowsPath.checkWrite();
            windowsPath2.checkWrite();
        }
        String string2 = WindowsFileCopy.asWin32Path(windowsPath);
        String string = WindowsFileCopy.asWin32Path(windowsPath2);
        if (bl) {
            try {
                WindowsNativeDispatcher.MoveFileEx((String)string2, (String)string, (int)1);
                return;
            }
            catch (WindowsException windowsException3) {
                if (windowsException3.lastError() == 17) {
                    throw new AtomicMoveNotSupportedException(windowsPath.getPathForExceptionMessage(), windowsPath2.getPathForExceptionMessage(), windowsException3.errorString());
                }
                windowsException3.rethrowAsIOException(windowsPath, windowsPath2);
            }
            return;
        }
        windowsException222 = null;
        WindowsFileAttributes windowsFileAttributes = null;
        long l = 0L;
        try {
            l = windowsPath.openForReadAttributeAccess(false);
        }
        catch (WindowsException windowsException7) {
            windowsException7.rethrowAsIOException(windowsPath);
        }
        try {
            try {
                windowsException222 = WindowsFileAttributes.readAttributes((long)l);
            }
            catch (WindowsException windowsException5) {
                windowsException5.rethrowAsIOException(windowsPath);
            }
            long windowsException4 = 0L;
            try {
                block55: {
                    windowsException4 = windowsPath2.openForReadAttributeAccess(false);
                    windowsFileAttributes = WindowsFileAttributes.readAttributes((long)windowsException4);
                    if (!WindowsFileAttributes.isSameFile((WindowsFileAttributes)windowsException222, (WindowsFileAttributes)windowsFileAttributes)) break block55;
                    WindowsNativeDispatcher.CloseHandle((long)windowsException4);
                    return;
                }
                try {
                    if (!bl2) {
                        throw new FileAlreadyExistsException(windowsPath2.getPathForExceptionMessage());
                    }
                }
                finally {
                    WindowsNativeDispatcher.CloseHandle((long)windowsException4);
                }
            }
            catch (WindowsException windowsException42) {
                // empty catch block
            }
        }
        finally {
            WindowsNativeDispatcher.CloseHandle((long)l);
        }
        if (windowsFileAttributes != null) {
            try {
                if (windowsFileAttributes.isDirectory() || windowsFileAttributes.isDirectoryLink()) {
                    WindowsNativeDispatcher.RemoveDirectory((String)string);
                } else {
                    WindowsNativeDispatcher.DeleteFile((String)string);
                }
            }
            catch (WindowsException windowsException7) {
                if (windowsFileAttributes.isDirectory()) {
                    if (windowsException7.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                    if (windowsException7.lastError() == 183) {
                        throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                    }
                }
                windowsException7.rethrowAsIOException(windowsPath2);
            }
        }
        try {
            WindowsNativeDispatcher.MoveFileEx((String)string2, (String)string, (int)0);
            return;
        }
        catch (WindowsException windowsException2) {
            String windowsException3;
            if (windowsException2.lastError() != 17) {
                windowsException2.rethrowAsIOException(windowsPath, windowsPath2);
            }
            if (!windowsException222.isDirectory() && !windowsException222.isDirectoryLink()) {
                try {
                    WindowsNativeDispatcher.MoveFileEx((String)string2, (String)string, (int)2);
                }
                catch (WindowsException iOException) {
                    iOException.rethrowAsIOException(windowsPath, windowsPath2);
                }
                try {
                    WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, false);
                    return;
                }
                catch (IOException string3) {
                    // empty catch block
                }
                return;
            }
            assert (windowsException222.isDirectory() || windowsException222.isDirectoryLink());
            try {
                if (windowsException222.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory((String)string, (long)0L);
                } else {
                    windowsException3 = WindowsLinkSupport.readLink((WindowsPath)windowsPath);
                    WindowsNativeDispatcher.CreateSymbolicLink((String)string, (String)WindowsPath.addPrefixIfNeeded((String)windowsException3), (int)1);
                }
            }
            catch (WindowsException windowsException8) {
                windowsException8.rethrowAsIOException(windowsPath2);
            }
            windowsException3 = WindowsFileAttributeViews.createDosView((WindowsPath)windowsPath2, (boolean)false);
            try {
                windowsException3.setAttributes((WindowsFileAttributes)windowsException222);
            }
            catch (IOException iOException) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory((String)string);
                    throw iOException;
                }
                catch (WindowsException windowsException6) {
                    // empty catch block
                }
                throw iOException;
            }
            try {
                WindowsFileCopy.copySecurityAttributes(windowsPath, windowsPath2, false);
            }
            catch (IOException windowsException5) {
                // empty catch block
            }
            try {
                WindowsNativeDispatcher.RemoveDirectory((String)string2);
                return;
            }
            catch (WindowsException windowsException9) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory((String)string);
                }
                catch (WindowsException windowsException10) {
                    // empty catch block
                }
                if (windowsException9.lastError() == 145) throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                if (windowsException9.lastError() == 183) {
                    throw new DirectoryNotEmptyException(windowsPath2.getPathForExceptionMessage());
                }
                windowsException9.rethrowAsIOException(windowsPath);
            }
            return;
        }
    }

    private static String asWin32Path(WindowsPath windowsPath) throws IOException {
        try {
            return windowsPath.getPathForWin32Calls();
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySecurityAttributes(WindowsPath windowsPath, WindowsPath windowsPath2, boolean bl) throws IOException {
        String string = WindowsLinkSupport.getFinalPath((WindowsPath)windowsPath, (boolean)bl);
        WindowsSecurity.Privilege privilege = WindowsSecurity.enablePrivilege((String)"SeRestorePrivilege");
        try {
            int n = 7;
            NativeBuffer nativeBuffer = WindowsAclFileAttributeView.getFileSecurity((String)string, (int)n);
            try {
                try {
                    WindowsNativeDispatcher.SetFileSecurity((String)windowsPath2.getPathForWin32Calls(), (int)n, (long)nativeBuffer.address());
                }
                catch (WindowsException windowsException) {
                    windowsException.rethrowAsIOException(windowsPath2);
                }
            }
            finally {
                nativeBuffer.release();
            }
        }
        finally {
            privilege.drop();
        }
    }
}

