/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import com.sun.tracing.Provider;
import com.sun.tracing.ProviderName;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import sun.tracing.ProbeSkeleton;

public abstract class ProviderSkeleton
implements InvocationHandler,
Provider {
    protected boolean active = false;
    protected Class<? extends Provider> providerType;
    protected HashMap<Method, ProbeSkeleton> probes;

    protected abstract ProbeSkeleton createProbe(Method var1);

    protected ProviderSkeleton(Class<? extends Provider> clazz) {
        this.providerType = clazz;
        this.probes = new HashMap();
    }

    public void init() {
        Method[] methodArray;
        for (Method method : methodArray = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return ProviderSkeleton.this.providerType.getDeclaredMethods();
            }
        })) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Return value of method is not void");
            }
            this.probes.put(method, this.createProbe(method));
        }
        this.active = true;
    }

    public <T extends Provider> T newProxyInstance() {
        final ProviderSkeleton providerSkeleton = this;
        return (T)((Provider)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return (Provider)Proxy.newProxyInstance(ProviderSkeleton.this.providerType.getClassLoader(), new Class[]{ProviderSkeleton.this.providerType}, providerSkeleton);
            }
        }));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        block7: {
            Class<?> clazz = method.getDeclaringClass();
            if (clazz != this.providerType) {
                try {
                    if (clazz == Provider.class || clazz == Object.class) {
                        return method.invoke((Object)this, objectArray);
                    }
                    throw new SecurityException();
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                    break block7;
                }
                catch (InvocationTargetException invocationTargetException) {
                    assert (false);
                    break block7;
                }
            }
            this.triggerProbe(method, objectArray);
        }
        return null;
    }

    @Override
    public Probe getProbe(Method method) {
        return this.active ? (Probe)this.probes.get(method) : null;
    }

    @Override
    public void dispose() {
        this.active = false;
        this.probes.clear();
    }

    protected String getProviderName() {
        return ProviderSkeleton.getAnnotationString(this.providerType, ProviderName.class, this.providerType.getSimpleName());
    }

    protected static String getAnnotationString(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz, String string) {
        String string2 = (String)ProviderSkeleton.getAnnotationValue(annotatedElement, clazz, "value", string);
        return string2.isEmpty() ? string : string2;
    }

    protected static Object getAnnotationValue(AnnotatedElement annotatedElement, Class<? extends Annotation> clazz, String string, Object object) {
        Object object2;
        block8: {
            object2 = object;
            try {
                Method method = clazz.getMethod(string, new Class[0]);
                Annotation annotation = annotatedElement.getAnnotation(clazz);
                object2 = method.invoke((Object)annotation, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                assert (false);
            }
            catch (NullPointerException nullPointerException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return object2;
    }

    protected void triggerProbe(Method method, Object[] objectArray) {
        ProbeSkeleton probeSkeleton;
        if (this.active && (probeSkeleton = this.probes.get(method)) != null) {
            probeSkeleton.uncheckedTrigger(objectArray);
        }
    }
}

