/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.events;

import com.sun.xml.internal.stream.events.DummyEvent;
import com.sun.xml.internal.stream.util.ReadOnlyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class StartElementEvent
extends DummyEvent
implements StartElement {
    private Map fAttributes;
    private List fNamespaces;
    private NamespaceContext fNamespaceContext = null;
    private QName fQName;

    public StartElementEvent(String prefix, String uri, String localpart) {
        this(new QName(uri, localpart, prefix));
    }

    public StartElementEvent(QName qname) {
        this.fQName = qname;
        this.init();
    }

    public StartElementEvent(StartElement startelement) {
        this(startelement.getName());
        this.addAttributes(startelement.getAttributes());
        this.addNamespaceAttributes(startelement.getNamespaces());
    }

    protected void init() {
        this.setEventType(1);
        this.fAttributes = new HashMap();
        this.fNamespaces = new ArrayList();
    }

    @Override
    public QName getName() {
        return this.fQName;
    }

    public void setName(QName qname) {
        this.fQName = qname;
    }

    public Iterator getAttributes() {
        if (this.fAttributes != null) {
            Collection coll = this.fAttributes.values();
            return new ReadOnlyIterator(coll.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Iterator getNamespaces() {
        if (this.fNamespaces != null) {
            return new ReadOnlyIterator(this.fNamespaces.iterator());
        }
        return new ReadOnlyIterator();
    }

    @Override
    public Attribute getAttributeByName(QName qname) {
        if (qname == null) {
            return null;
        }
        return (Attribute)this.fAttributes.get(qname);
    }

    public String getNamespace() {
        return this.fQName.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.getNamespace() != null && this.fQName.getPrefix().equals(prefix)) {
            return this.getNamespace();
        }
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getNamespaceURI(prefix);
        }
        return null;
    }

    public String toString() {
        Attribute attr;
        Iterator it;
        StringBuffer startElement = new StringBuffer();
        startElement.append("<");
        startElement.append(this.nameAsString());
        if (this.fAttributes != null) {
            it = this.getAttributes();
            attr = null;
            while (it.hasNext()) {
                attr = (Attribute)it.next();
                startElement.append(" ");
                startElement.append(attr.toString());
            }
        }
        if (this.fNamespaces != null) {
            it = this.fNamespaces.iterator();
            attr = null;
            while (it.hasNext()) {
                attr = (Namespace)it.next();
                startElement.append(" ");
                startElement.append(attr.toString());
            }
        }
        startElement.append(">");
        return startElement.toString();
    }

    public String nameAsString() {
        if ("".equals(this.fQName.getNamespaceURI())) {
            return this.fQName.getLocalPart();
        }
        if (this.fQName.getPrefix() != null) {
            return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getPrefix() + ":" + this.fQName.getLocalPart();
        }
        return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getLocalPart();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext nc) {
        this.fNamespaceContext = nc;
    }

    @Override
    protected void writeAsEncodedUnicodeEx(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    void addAttribute(Attribute attr) {
        if (attr.isNamespace()) {
            this.fNamespaces.add(attr);
        } else {
            this.fAttributes.put(attr.getName(), attr);
        }
    }

    void addAttributes(Iterator attrs) {
        if (attrs == null) {
            return;
        }
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            this.fAttributes.put(attr.getName(), attr);
        }
    }

    void addNamespaceAttribute(Namespace attr) {
        if (attr == null) {
            return;
        }
        this.fNamespaces.add(attr);
    }

    void addNamespaceAttributes(Iterator attrs) {
        if (attrs == null) {
            return;
        }
        while (attrs.hasNext()) {
            Namespace attr = (Namespace)attrs.next();
            this.fNamespaces.add(attr);
        }
    }
}

