/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

final class MBeanServerDelegateImpl
extends MBeanServerDelegate
implements DynamicMBean,
MBeanRegistration {
    private static final String[] attributeNames = new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"};
    private static final MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MBeanServerId", "java.lang.String", "The MBean server agent identification", true, false, false), new MBeanAttributeInfo("SpecificationName", "java.lang.String", "The full name of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVersion", "java.lang.String", "The version of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("SpecificationVendor", "java.lang.String", "The vendor of the JMX specification implemented by this product.", true, false, false), new MBeanAttributeInfo("ImplementationName", "java.lang.String", "The JMX implementation name (the name of this product)", true, false, false), new MBeanAttributeInfo("ImplementationVersion", "java.lang.String", "The JMX implementation version (the version of this product).", true, false, false), new MBeanAttributeInfo("ImplementationVendor", "java.lang.String", "the JMX implementation vendor (the vendor of this product).", true, false, false)};
    private final MBeanInfo delegateInfo = new MBeanInfo("javax.management.MBeanServerDelegate", "Represents  the MBean server from the management point of view.", attributeInfos, null, null, this.getNotificationInfo());

    @Override
    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            return DELEGATE_NAME;
        }
        return objectName;
    }

    @Override
    public final void postRegister(Boolean bl) {
    }

    @Override
    public final void preDeregister() throws Exception {
        throw new IllegalArgumentException("The MBeanServerDelegate MBean cannot be unregistered");
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            if (string == null) {
                throw new AttributeNotFoundException("null");
            }
            if (string.equals("MBeanServerId")) {
                return this.getMBeanServerId();
            }
            if (string.equals("SpecificationName")) {
                return this.getSpecificationName();
            }
            if (string.equals("SpecificationVersion")) {
                return this.getSpecificationVersion();
            }
            if (string.equals("SpecificationVendor")) {
                return this.getSpecificationVendor();
            }
            if (string.equals("ImplementationName")) {
                return this.getImplementationName();
            }
            if (string.equals("ImplementationVersion")) {
                return this.getImplementationVersion();
            }
            if (string.equals("ImplementationVendor")) {
                return this.getImplementationVendor();
            }
            throw new AttributeNotFoundException("null");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (JMRuntimeException jMRuntimeException) {
            throw jMRuntimeException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new MBeanException(exception, "Failed to get " + string);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String string;
        String string2 = string = attribute == null ? null : attribute.getName();
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to invoke the setter on the MBean");
        }
        Object object = this.getAttribute(string);
        throw new AttributeNotFoundException(string + " not accessible");
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        String[] stringArray2 = stringArray == null ? attributeNames : stringArray;
        int n = stringArray2.length;
        AttributeList attributeList = new AttributeList(n);
        for (int i = 0; i < n; ++i) {
            try {
                Attribute attribute = new Attribute(stringArray2[i], this.getAttribute(stringArray2[i]));
                attributeList.add(attribute);
                continue;
            }
            catch (Exception exception) {
                if (!((Logger)((Object)JmxProperties.MBEANSERVER_LOGGER)).isLoggable(Level.FINEST)) continue;
                ((Logger)((Object)JmxProperties.MBEANSERVER_LOGGER)).logp(Level.FINEST, MBeanServerDelegateImpl.class.getName(), "getAttributes", "Attribute " + stringArray2[i] + " not found");
            }
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList(0);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred trying to invoke the operation on the MBean");
        }
        throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.delegateInfo;
    }
}

