/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.idesupport;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.Messages;
import java.io.Closeable;
import java.io.InputStream;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

final class JobFileWrite
extends Job {
    private final MCFile file;
    private final InputStream stream;
    private final boolean append;

    JobFileWrite(String jobName, MCFile file, InputStream stream, boolean append) {
        super(jobName);
        this.file = file;
        this.stream = stream;
        this.append = append;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.file.writeStream(this.stream, monitor, this.append);
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not write the specified file!", e);
                Status status = new Status(4, "com.jrockit.mc.core", NLS.bind((String)Messages.JobFileWrite_ERROR_FILE_WRITE_FAILED, (Object)this.file.getPath()), (Throwable)e);
                IOToolkit.closeSilently((Closeable)this.stream);
                return status;
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)this.stream);
        }
        return new Status(0, "com.jrockit.mc.core", NLS.bind((String)Messages.JobFileWrite_MESSAGE_FILE_WRITE_SUCCESS, (Object)this.file.getPath()));
    }
}

