/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public class Path
extends Resource {
    public NSBezierPath handle;
    boolean closed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = NSBezierPath.bezierPath();
            if (this.handle == null) {
                SWT.error(2);
            }
            this.handle.retain();
            this.handle.moveToPoint(new NSPoint());
            this.init();
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device, Path path, float f) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (path == null) {
                SWT.error(4);
            }
            if (path.isDisposed()) {
                SWT.error(5);
            }
            if ((f = Math.max(0.0f, f)) == 0.0f) {
                this.handle = new NSBezierPath(path.handle.copy().id);
            } else {
                double d = NSBezierPath.defaultFlatness();
                NSBezierPath.setDefaultFlatness(f);
                this.handle = path.handle.bezierPathByFlatteningPath();
                this.handle.retain();
                NSBezierPath.setDefaultFlatness(d);
            }
            if (this.handle == null) {
                SWT.error(2);
            }
            this.init();
            Object var8_6 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path(Device device, PathData pathData) {
        this(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (pathData == null) {
                SWT.error(4);
            }
            this.init(pathData);
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(f + f3 / 2.0f, f2 + f4 / 2.0f);
            nSAffineTransform.scaleXBy(f3 / 2.0f, f4 / 2.0f);
            NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
            NSPoint nSPoint = new NSPoint();
            float f7 = -f5;
            float f8 = -(f5 + f6);
            nSBezierPath.appendBezierPathWithArcWithCenter(nSPoint, 1.0, f7, f8, f6 > 0.0f);
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            this.appendBezierPath(nSBezierPath);
            this.closed = Math.abs(f6) >= 360.0f;
            if (this.closed) {
                this.handle.closePath();
            }
            Object var14_13 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    void appendBezierPath(NSBezierPath nSBezierPath) {
        int n = (int)nSBezierPath.elementCount();
        long l = OS.malloc(3 * NSPoint.sizeof);
        if (l == 0L) {
            SWT.error(2);
        }
        NSPoint nSPoint = new NSPoint();
        NSPoint nSPoint2 = new NSPoint();
        NSPoint nSPoint3 = new NSPoint();
        block6: for (int i = 0; i < n; ++i) {
            int n2 = (int)nSBezierPath.elementAtIndex(i, l);
            switch (n2) {
                case 0: {
                    OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                    if (this.closed) {
                        this.handle.moveToPoint(nSPoint);
                        continue block6;
                    }
                    this.handle.lineToPoint(nSPoint);
                    continue block6;
                }
                case 1: {
                    OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                    this.handle.lineToPoint(nSPoint);
                    this.closed = false;
                    continue block6;
                }
                case 2: {
                    OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                    OS.memmove(nSPoint2, l + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                    OS.memmove(nSPoint3, l + (long)NSPoint.sizeof + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                    this.handle.curveToPoint(nSPoint3, nSPoint, nSPoint2);
                    this.closed = false;
                    continue block6;
                }
                case 3: {
                    this.handle.closePath();
                    this.closed = true;
                }
            }
        }
        OS.free(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPath(path.handle);
            this.closed = path.closed;
            Object var4_3 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRectangle(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSRect nSRect = new NSRect();
        nSRect.x = f;
        nSRect.y = f2;
        nSRect.width = f3;
        nSRect.height = f4;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPathWithRect(nSRect);
            this.closed = true;
            Object var8_7 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addString(String string, float f, float f2, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.closed = true;
            NSString nSString = NSString.stringWith(string);
            NSTextStorage nSTextStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            NSLayoutManager nSLayoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer nSTextContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize nSSize = new NSSize();
            nSSize.width = 5000000.0;
            nSSize.height = 5000000.0;
            nSTextContainer.initWithContainerSize(nSSize);
            nSTextContainer.setLineFragmentPadding(0.0);
            nSTextStorage.addLayoutManager(nSLayoutManager);
            nSLayoutManager.addTextContainer(nSTextContainer);
            NSRange nSRange = new NSRange();
            nSRange.length = nSString.length();
            NSMutableAttributedString nSMutableAttributedString = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
            nSMutableAttributedString.id = nSMutableAttributedString.initWithString((NSString)nSString).id;
            nSMutableAttributedString.beginEditing();
            nSMutableAttributedString.addAttribute(OS.NSFontAttributeName, font.handle, nSRange);
            font.addTraits(nSMutableAttributedString, nSRange);
            nSMutableAttributedString.endEditing();
            nSTextStorage.setAttributedString(nSMutableAttributedString);
            nSMutableAttributedString.release();
            nSRange = nSLayoutManager.glyphRangeForTextContainer(nSTextContainer);
            if (nSRange.length != 0L) {
                long l = OS.malloc((nSRange.length + 1L) * 4L);
                long l2 = nSLayoutManager.getGlyphs(l, nSRange);
                NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
                int n = 0;
                while ((long)n < l2) {
                    NSPoint nSPoint = nSLayoutManager.locationForGlyphAtIndex(n);
                    NSRect nSRect = nSLayoutManager.lineFragmentUsedRectForGlyphAtIndex(n, 0L);
                    NSFont nSFont = new NSFont(nSTextStorage.attribute(OS.NSFontAttributeName, nSLayoutManager.characterIndexForGlyphAtIndex(n), 0L));
                    nSPoint.x = nSPoint.x + (double)f + nSRect.x;
                    nSPoint.y = -nSPoint.y - (double)f2 - nSRect.y;
                    nSBezierPath.moveToPoint(nSPoint);
                    nSBezierPath.appendBezierPathWithGlyphs(l + (long)(n * 4), 1L, nSFont);
                    ++n;
                }
                OS.free(l);
                NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
                nSAffineTransform.scaleXBy(1.0, -1.0);
                nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
                this.handle.appendBezierPath(nSBezierPath);
            }
            nSTextContainer.release();
            nSLayoutManager.release();
            nSTextStorage.release();
            Object var23_21 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var23_22 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.closePath();
            this.closed = true;
            Object var3_2 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(float f, float f2, GC gC, boolean bl) {
        boolean bl2;
        block21: {
            NSAutoreleasePool nSAutoreleasePool;
            block19: {
                boolean bl3;
                block20: {
                    if (this.isDisposed()) {
                        SWT.error(44);
                    }
                    if (gC == null) {
                        SWT.error(4);
                    }
                    if (gC.isDisposed()) {
                        SWT.error(5);
                    }
                    nSAutoreleasePool = null;
                    if (!NSThread.isMainThread()) {
                        nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        if (!bl) break block19;
                        long l = OS.malloc(4L);
                        if (l == 0L) {
                            SWT.error(2);
                        }
                        int[] nArray = new int[]{-1};
                        OS.memmove(l, nArray, 4L);
                        long l2 = OS.CGColorSpaceCreateDeviceRGB();
                        long l3 = OS.CGBitmapContextCreate(l, 1L, 1L, 8L, 4L, l2, 6);
                        OS.CGColorSpaceRelease(l2);
                        if (l3 == 0L) {
                            OS.free(l);
                            SWT.error(2);
                        }
                        GCData gCData = gC.data;
                        int n = 0;
                        switch (gCData.lineCap) {
                            case 2: {
                                n = 1;
                                break;
                            }
                            case 1: {
                                n = 0;
                                break;
                            }
                            case 3: {
                                n = 2;
                            }
                        }
                        OS.CGContextSetLineCap(l3, n);
                        int n2 = 0;
                        switch (gCData.lineJoin) {
                            case 1: {
                                n2 = 0;
                                break;
                            }
                            case 2: {
                                n2 = 1;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                            }
                        }
                        OS.CGContextSetLineJoin(l3, n2);
                        OS.CGContextSetLineWidth(l3, gCData.lineWidth);
                        OS.CGContextTranslateCTM(l3, -f + 0.5f, -f2 + 0.5f);
                        long l4 = GC.createCGPathRef(this.handle);
                        OS.CGContextAddPath(l3, l4);
                        OS.CGPathRelease(l4);
                        OS.CGContextStrokePath(l3);
                        OS.CGContextRelease(l3);
                        OS.memmove(nArray, l, 4L);
                        OS.free(l);
                        bl3 = nArray[0] != -1;
                        Object var20_16 = null;
                        if (nSAutoreleasePool == null) break block20;
                    }
                    catch (Throwable throwable) {
                        block22: {
                            Object var20_18 = null;
                            if (nSAutoreleasePool == null) break block22;
                            nSAutoreleasePool.release();
                        }
                        throw throwable;
                    }
                    nSAutoreleasePool.release();
                }
                return bl3;
            }
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f;
            nSPoint.y = f2;
            bl2 = this.handle.containsPoint(nSPoint);
            Object var20_17 = null;
            if (nSAutoreleasePool == null) break block21;
            nSAutoreleasePool.release();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f5;
            nSPoint.y = f6;
            NSPoint nSPoint2 = new NSPoint();
            nSPoint2.x = f;
            nSPoint2.y = f2;
            NSPoint nSPoint3 = new NSPoint();
            nSPoint3.x = f3;
            nSPoint3.y = f4;
            this.handle.curveToPoint(nSPoint, nSPoint2, nSPoint3);
            this.closed = false;
            Object var12_11 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSRect nSRect = this.handle.controlPointBounds();
            fArray[0] = (float)nSRect.x;
            fArray[1] = (float)nSRect.y;
            fArray[2] = (float)nSRect.width;
            fArray[3] = (float)nSRect.height;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = this.handle.currentPoint();
            fArray[0] = (float)nSPoint.x;
            fArray[1] = (float)nSPoint.y;
            Object var5_4 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathData getPathData() {
        PathData pathData;
        block13: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool nSAutoreleasePool = null;
            if (!NSThread.isMainThread()) {
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                int n = (int)this.handle.elementCount();
                int n2 = 0;
                int n3 = 0;
                byte[] byArray = new byte[n];
                float[] fArray = new float[n * 6];
                long l = OS.malloc(3 * NSPoint.sizeof);
                if (l == 0L) {
                    SWT.error(2);
                }
                NSPoint nSPoint = new NSPoint();
                block8: for (int i = 0; i < n; ++i) {
                    int n4 = (int)this.handle.elementAtIndex(i, l);
                    switch (n4) {
                        case 0: {
                            byArray[n3++] = 1;
                            OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                            fArray[n2++] = (float)nSPoint.x;
                            fArray[n2++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 1: {
                            byArray[n3++] = 2;
                            OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                            fArray[n2++] = (float)nSPoint.x;
                            fArray[n2++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 2: {
                            byArray[n3++] = 4;
                            OS.memmove(nSPoint, l, (long)NSPoint.sizeof);
                            fArray[n2++] = (float)nSPoint.x;
                            fArray[n2++] = (float)nSPoint.y;
                            OS.memmove(nSPoint, l + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                            fArray[n2++] = (float)nSPoint.x;
                            fArray[n2++] = (float)nSPoint.y;
                            OS.memmove(nSPoint, l + (long)NSPoint.sizeof + (long)NSPoint.sizeof, (long)NSPoint.sizeof);
                            fArray[n2++] = (float)nSPoint.x;
                            fArray[n2++] = (float)nSPoint.y;
                            continue block8;
                        }
                        case 3: {
                            byArray[n3++] = 5;
                        }
                    }
                }
                OS.free(l);
                if (n2 != fArray.length) {
                    float[] fArray2 = new float[n2];
                    System.arraycopy(fArray, 0, fArray2, 0, n2);
                    fArray = fArray2;
                }
                PathData pathData2 = new PathData();
                pathData2.types = byArray;
                pathData2.points = fArray;
                pathData = pathData2;
                Object var13_14 = null;
                if (nSAutoreleasePool == null) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var13_15 = null;
                    if (nSAutoreleasePool == null) break block14;
                    nSAutoreleasePool.release();
                }
                throw throwable;
            }
            nSAutoreleasePool.release();
        }
        return pathData;
    }

    void init(PathData pathData) {
        byte[] byArray = pathData.types;
        float[] fArray = pathData.points;
        int n = 0;
        block7: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 1: {
                    this.moveTo(fArray[n++], fArray[n++]);
                    continue block7;
                }
                case 2: {
                    this.lineTo(fArray[n++], fArray[n++]);
                    continue block7;
                }
                case 4: {
                    this.cubicTo(fArray[n++], fArray[n++], fArray[n++], fArray[n++], fArray[n++], fArray[n++]);
                    continue block7;
                }
                case 3: {
                    this.quadTo(fArray[n++], fArray[n++], fArray[n++], fArray[n++]);
                    continue block7;
                }
                case 5: {
                    this.close();
                    continue block7;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lineTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f;
            nSPoint.y = f2;
            this.handle.lineToPoint(nSPoint);
            this.closed = false;
            Object var6_5 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveTo(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = f;
            nSPoint.y = f2;
            this.handle.moveToPoint(nSPoint);
            this.closed = true;
            Object var6_5 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void quadTo(float f, float f2, float f3, float f4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint nSPoint = this.handle.isEmpty() ? new NSPoint() : this.handle.currentPoint();
            NSPoint nSPoint2 = new NSPoint();
            nSPoint2.x = nSPoint.x + 2.0 * ((double)f - nSPoint.x) / 3.0;
            nSPoint2.y = nSPoint.y + 2.0 * ((double)f2 - nSPoint.y) / 3.0;
            NSPoint nSPoint3 = new NSPoint();
            nSPoint3.x = nSPoint2.x + ((double)f3 - nSPoint.x) / 3.0;
            nSPoint3.y = nSPoint2.y + ((double)f4 - nSPoint.y) / 3.0;
            NSPoint nSPoint4 = new NSPoint();
            nSPoint4.x = f3;
            nSPoint4.y = f4;
            this.handle.curveToPoint(nSPoint4, nSPoint2, nSPoint3);
            this.closed = false;
            Object var11_10 = null;
            if (nSAutoreleasePool == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (nSAutoreleasePool == null) throw throwable;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

