/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.rcp.application.p2.AddRepositoriesJob;
import com.jrockit.mc.rcp.application.p2.JMCPolicy;
import com.jrockit.mc.rcp.logging.LoggingToolkit;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ApplicationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.rcp.application";
    private static final String VERSION_PROPERTIES = "/about.mappings";
    private static final String UNKNOWN_VERSION = "unknown";
    private static ApplicationPlugin plugin;
    public static final String VERSION;
    public static final String FULL_VERSION;
    public static final String ICON_UPDATE_SEARCH = "/icons/usearch_obj.gif";
    public static final String ICON_ERROR_MARKER = "/icons/error_marker.gif";
    public static final String ICON_INSTRUCTION_POINTER = "/icons/inst_ptr_top.gif";

    static {
        String fullVersion;
        String version;
        block5: {
            version = UNKNOWN_VERSION;
            fullVersion = UNKNOWN_VERSION;
            Properties props = new Properties();
            InputStream is = null;
            try {
                try {
                    is = ApplicationPlugin.class.getResourceAsStream(VERSION_PROPERTIES);
                    props.load(is);
                    version = props.getProperty("0");
                    fullVersion = props.getProperty("4");
                }
                catch (Exception exception) {
                    IOToolkit.closeSilently((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
        VERSION = version;
        FULL_VERSION = fullVersion;
    }

    public ApplicationPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDebug();
        LoggingToolkit.initializeLogging();
        this.registerP2Policy(context);
        new AddRepositoriesJob(context).schedule();
    }

    private void registerP2Policy(BundleContext context) {
        context.registerService(Policy.class.getName(), (Object)new JMCPolicy(), null);
    }

    private void initializeDebug() {
        if (System.getProperty("osgi.debug") != null) {
            System.setProperty("com.jrockit.mc.debug", "true");
            ApplicationPlugin.getLogger().log(Level.INFO, "JMC debug mode enabled");
        }
    }

    public static Logger getLogger() {
        return LoggingToolkit.getLogger();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(ICON_ERROR_MARKER, ApplicationPlugin.getImageDescriptor(ICON_ERROR_MARKER));
        reg.put(ICON_INSTRUCTION_POINTER, ApplicationPlugin.getImageDescriptor(ICON_INSTRUCTION_POINTER));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ApplicationPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ApplicationPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

