/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.CloudAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.exception.EndpointGeneralException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.PolicyTo;
import com.parablu.epa.helper.utils.PBCountDownTimer;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.notifications.MacEventsManagement;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.service.sync.MacCheckSyncPolicy;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.ConsolidatedView;
import com.parablu.epa.view.ProxySettingsView;
import com.parablu.epa.view.RestoreManager;
import com.parablu.epa.view.RestoreUI;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayUI {
    private static Logger logger = LoggerFactory.getLogger(SystemTrayUI.class);
    private Shell systrayShell;
    private TrayItem systrayItem;
    private ConsolidatedView instance = null;
    private boolean forcestop = true;
    private ImageData systrayImageData = null;
    private Image systrayImage = null;
    private Tray tray = null;
    private Display display = null;
    private Menu menu = null;
    private MenuItem systemStartCrawlMenuItem = null;
    private MenuItem searchMenuItem = null;
    private Timer systrayTimer = null;
    private static String port;
    private static CloudAdapter cloudAdapter;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR;
    public static final String PARABLU_LICENSE_EXPIRED_IMAGE;
    private MenuItem systemStartBackupMenuItem = null;
    private MenuItem systemPolicyRefreshMenuItem = null;
    private RestoreUI restoreInstance = null;
    private int uiVersion = -1;
    private Menu subMenuForSync = null;
    private Menu subMenuForBackup = null;
    private Menu subMenuForSupport = null;
    private MenuItem restoreMenuItem = null;
    private MenuItem pauseBackup = null;
    private MenuItem stopBackup = null;
    private static final String PORTAL_AUTH = "/portal/auth?c=";
    private static final String HTTPS_URL = "https://";
    private static final String PARAM = "&param=";
    private static final String URL_STR = "&url=";
    private MenuItem systemSyncPolicyRefreshMenuItem = null;
    private static final String ENCODE_UTF_8 = "UTF-8";
    private static final String FILES_STR = "files";
    private static boolean isStopBackupPressed;
    private static boolean isPauseBackupPressed;
    private MacEventsManagement macEventsManagement = new MacEventsManagement();
    private String backupTooltip = "";
    private String syncTooltip = "";
    private static SystemTrayUI systemTrayUI;
    private ProxySettingsView ProxySettinginstance = null;
    String password;
    boolean result = false;

    public static SystemTrayUI getSystemtrayInstance() {
        if (systemTrayUI == null) {
            systemTrayUI = new SystemTrayUI();
        }
        return systemTrayUI;
    }

    public void relaunchSystemTray() {
        try {
            SystemTrayUI.unlockFileUI();
            if (this.restoreInstance != null) {
                this.restoreInstance.cancelRestoreDisplayTimer();
            }
            if (this.systrayItem != null) {
                logger.debug("systrayItem is not null....");
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("systrayItem is enabled  null......");
                        SystemTrayUI.this.loadSystemTray(false);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("error..", (Object)e.getMessage());
        }
    }

    public void loadSystemTray(boolean showtoolTip) {
        Listener listener2;
        Listener listener;
        Listener listener3;
        this.macEventsManagement = new MacEventsManagement();
        if (SettingHelper.isLicenseActive()) {
            this.systrayTimer = new Timer();
            this.systrayTimer.schedule((TimerTask)new SystrayNotificationTask(), 500L, 2000L);
        }
        if (Display.getCurrent() != null && !Display.getCurrent().isDisposed()) {
            try {
                Display.getCurrent().dispose();
            }
            catch (Exception e) {
                logger.error("Exception", e);
            }
        }
        this.display = new Display();
        this.tray = this.display.getSystemTray();
        if (this.tray == null) {
            return;
        }
        logger.info("Loading systray");
        if (SettingHelper.getUiVersion() != -1) {
            this.uiVersion = SettingHelper.getUiVersion();
            logger.debug("UI version in systray" + this.uiVersion);
        }
        this.systrayImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.SYNCING_IMAGE);
        ImageData systrayLicenseExpiredImageData = new ImageData(PARABLU_LICENSE_EXPIRED_IMAGE);
        this.systrayShell = new Shell(this.display);
        ToolTip toolTip = new ToolTip(this.systrayShell, 4098);
        if (SettingHelper.isLicenseActive()) {
            this.systrayImage = new Image((Device)this.display, this.systrayImageData.scaledTo(24, 24));
            toolTip.setText(PropertyHelper.SYSTRAY_BALLOONTIP_LABEL);
            toolTip.setMessage(PropertyHelper.SYSTRAY_BALLOONTIP_BELOW_LABEL);
        } else {
            this.systrayImage = new Image((Device)this.display, systrayLicenseExpiredImageData.scaledTo(24, 24));
            toolTip.setText("Server License Expired");
            toolTip.setMessage("Server License Expired");
        }
        this.systrayItem = new TrayItem(this.tray, 0);
        this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
        this.systrayItem.setImage(this.systrayImage);
        if ("true".equals(SettingHelper.getSyncLicenced())) {
            listener3 = event -> {
                Runnable runnable = () -> {
                    logger.debug("Parablu folder clicked is selected.");
                    Program.launch(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu");
                };
                new Thread(runnable).start();
            };
            this.systrayItem.addListener(14, listener3);
        }
        if (!this.isCommonFeatureEnabled(SettingHelper.isBackuptoolTipNotificationBlocked(), SettingHelper.isSynctoolTipNotificationBlocked())) {
            this.systrayItem.setToolTip(toolTip);
            toolTip.setAutoHide(true);
            toolTip.setVisible(showtoolTip);
        }
        this.menu = new Menu(this.systrayShell, 8);
        if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true") && SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            MenuItem syncMenuItem = new MenuItem(this.menu, 64);
            syncMenuItem.setText("&Sync and Share");
            this.subMenuForSync = new Menu(this.menu);
            syncMenuItem.setMenu(this.subMenuForSync);
            MenuItem backupMenuItem = new MenuItem(this.menu, 64);
            backupMenuItem.setText("&Backup");
            this.subMenuForBackup = new Menu(this.menu);
            backupMenuItem.setMenu(this.subMenuForBackup);
            if (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled())) {
                MenuItem supportMenuItem = new MenuItem(this.menu, 64);
                supportMenuItem.setText("&Support");
                this.subMenuForSupport = new Menu(this.menu);
                supportMenuItem.setMenu(this.subMenuForSupport);
            }
        } else {
            this.subMenuForSupport = this.menu;
            if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                this.subMenuForBackup = this.menu;
            } else if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
                this.subMenuForSync = this.menu;
            }
        }
        if ("true".equals(SettingHelper.getSyncLicenced())) {
            if (SettingHelper.isOpenSyncFolderInterfaceEnabled()) {
                MenuItem parabluMenuItem = new MenuItem(this.subMenuForSync, 8);
                parabluMenuItem.setText(PropertyHelper.SYSTRAY_OPEN_SHORTCUT_FOLDER_LABEL);
                listener = event -> {
                    Runnable runnable = () -> {
                        logger.debug("Parablu folder clicked is selected.");
                        Program.launch(SettingHelper.getParabluSyncFolder() + StringLiterals.FILE_SEPARATOR + "ParaBlu");
                    };
                    new Thread(runnable).start();
                };
                parabluMenuItem.addListener(13, listener);
            }
            if (SettingHelper.isSyncNowInterfaceEnabled()) {
                this.systemStartCrawlMenuItem = new MenuItem(this.subMenuForSync, 8);
                if (SettingHelper.isLicenseActive()) {
                    logger.debug("isLicenseActive: " + SettingHelper.isLicenseActive());
                    this.systemStartCrawlMenuItem.setText("Sync Now");
                    if (SettingHelper.getSyncLicenced().contentEquals("false")) {
                        this.systemStartCrawlMenuItem.setEnabled(false);
                    }
                } else {
                    this.systemStartCrawlMenuItem.setText("License Expired");
                    this.systemStartCrawlMenuItem.setEnabled(false);
                }
                listener2 = event -> {
                    ManualSyncHelper.startManualSync();
                    this.systemStartCrawlMenuItem.setEnabled(false);
                    this.systemStartCrawlMenuItem.setText("");
                    this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                    UIHelper.displaySyncingGif();
                };
                this.systemStartCrawlMenuItem.addListener(13, listener2);
            }
        }
        if ("true".equalsIgnoreCase(SettingHelper.getBackupLicenced()) && SettingHelper.isBackupFilesInterfaceEnabled()) {
            MenuItem backupFilesMenuItem = new MenuItem(this.subMenuForBackup, 8);
            backupFilesMenuItem.setText("My Backup Files");
            listener = event -> new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Launch Portalmy backup Now");
                    try {
                        this.getUserAuthenticationTokenAndLaunchPortal();
                    }
                    catch (Exception e) {
                        logger.debug("Exception occurred while getting new tokens", e);
                    }
                }

                private void getUserAuthenticationTokenAndLaunchPortal() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
                    String url;
                    String iP = SettingHelper.getCurrentCloudIpAddress();
                    port = SettingHelper.getCurrentHttpsPort();
                    String token = SettingHelper.readTokenFromFile();
                    String cloudName = SettingHelper.getCloudName();
                    String userName = SettingHelper.getUserName();
                    cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
                    if (port == null) {
                        String[] resArr = cloudAdapter.getAuthenticationToken(iP, null, token, userName);
                        String proxyToken = resArr[0];
                        cloudName = resArr[1];
                        url = SystemTrayUI.HTTPS_URL + iP + SystemTrayUI.PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.URL_STR + "mydevices" + SystemTrayUI.PARAM;
                    } else {
                        String[] resArr = cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
                        String proxyToken = resArr[0];
                        cloudName = resArr[1];
                        url = SystemTrayUI.HTTPS_URL + iP + ":" + port + SystemTrayUI.PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.URL_STR + "mydevices" + SystemTrayUI.PARAM;
                    }
                    Program.launch(url);
                }
            }).start();
            backupFilesMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.isRestoreInterfaceEnabled()) {
            this.restoreMenuItem = new MenuItem(this.subMenuForBackup, 8);
            this.restoreMenuItem.setText("Restore");
            listener2 = event -> {
                logger.debug("Settings / Preferences is selected.");
                this.loadRestoreUI();
            };
            this.restoreMenuItem.addListener(13, listener2);
        }
        if ("true".equalsIgnoreCase(SettingHelper.getSyncLicenced()) && SettingHelper.isSyncFilesInterfaceEnabled()) {
            MenuItem portalMenuItem = new MenuItem(this.subMenuForSync, 8);
            portalMenuItem.setText("My Files");
            listener = event -> new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Launch Portal Now");
                    try {
                        this.getUserAuthenticationTokenAndLaunchPortal();
                    }
                    catch (Exception e) {
                        logger.debug("Exception occurred while getting new tokens", e);
                    }
                }

                private void getUserAuthenticationTokenAndLaunchPortal() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
                    String url;
                    String iP = SettingHelper.getCurrentCloudIpAddress();
                    port = SettingHelper.getCurrentHttpsPort();
                    String token = SettingHelper.readTokenFromFile();
                    String cloudName = SettingHelper.getCloudName();
                    String userName = SettingHelper.getUserName();
                    cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
                    if (port == null) {
                        String[] resArr = cloudAdapter.getAuthenticationToken(iP, null, token, userName);
                        String proxyToken = resArr[0];
                        cloudName = resArr[1];
                        url = SystemTrayUI.HTTPS_URL + iP + SystemTrayUI.PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.URL_STR + SystemTrayUI.FILES_STR + SystemTrayUI.PARAM;
                    } else {
                        String[] resArr = cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
                        String proxyToken = resArr[0];
                        cloudName = resArr[1];
                        url = SystemTrayUI.HTTPS_URL + iP + ":" + port + SystemTrayUI.PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + SystemTrayUI.URL_STR + SystemTrayUI.FILES_STR + SystemTrayUI.PARAM;
                    }
                    Program.launch(url);
                }
            }).start();
            portalMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && (SettingHelper.isBackupSettingsInterfaceEnabled() || SettingHelper.isRefreshBackupPolicyInterfaceEnabled())) {
            new MenuItem(this.subMenuForBackup, 2);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.isBackupSettingsInterfaceEnabled()) {
            MenuItem newSettingsMenuItem = new MenuItem(this.subMenuForBackup, 8);
            newSettingsMenuItem.setText("Backup Settings");
            listener = event -> {
                if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && this.uiVersion == 1) {
                    Runnable runnable = () -> {
                        logger.debug("Launch New Settings");
                        String iP = SettingHelper.getCurrentCloudIpAddress();
                        String token = null;
                        try {
                            token = SettingHelper.readTokenFromFile();
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error(" exception in reading token from file..." + e.getMessage());
                        }
                        String cloudName = SettingHelper.getCloudName();
                        String userName = SettingHelper.getUserName();
                        String[] resArr = null;
                        cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
                        try {
                            String url;
                            if (port == null) {
                                resArr = cloudAdapter.getAuthenticationToken(iP, null, token, userName);
                                String proxyToken = resArr[0];
                                cloudName = resArr[1];
                                userName = URLEncoder.encode(userName, ENCODE_UTF_8);
                                String deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), ENCODE_UTF_8);
                                url = HTTPS_URL + iP + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "mybackup" + PARAM + "&v=" + PropertyHelper.BLUSYNC_VERSION_LABEL + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + deviceName;
                            } else {
                                resArr = cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
                                String proxyToken = resArr[0];
                                cloudName = resArr[1];
                                userName = URLEncoder.encode(userName, ENCODE_UTF_8);
                                String deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), ENCODE_UTF_8);
                                url = HTTPS_URL + iP + ":" + port + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "mybackup" + PARAM + "&v=" + PropertyHelper.BLUSYNC_VERSION_LABEL + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + deviceName;
                            }
                            Program.launch(url);
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error(" exception " + e.getMessage());
                        }
                    };
                    new Thread(runnable).start();
                } else {
                    logger.error("Policy is disabled for the user....");
                    Shell shell = new Shell(this.display);
                    MessageBox infoBox = new MessageBox(shell, 2);
                    infoBox.setMessage("Backup Settings");
                    infoBox.setText("Policy is disabled for the user");
                    infoBox.open();
                }
            };
            newSettingsMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isRefreshBackupPolicyInterfaceEnabled()) {
            this.systemPolicyRefreshMenuItem = new MenuItem(this.subMenuForBackup, 8);
            this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
            listener2 = event -> {
                Runnable runnable = () -> {
                    this.macEventsManagement.refreshPolicyTask();
                    String toolTipMessage = "Policy Refresh";
                    String toolTipmessage1 = "Policy update finished";
                    UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
                };
                new Thread(runnable).start();
            };
            this.systemPolicyRefreshMenuItem.addListener(13, listener2);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && (SettingHelper.isInitiateBackupInterfaceEnabled() || SettingHelper.isPauseBackupInterfaceEnabled() || SettingHelper.isStopBackupInterfaceEnabled())) {
            new MenuItem(this.subMenuForBackup, 2);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.isInitiateBackupInterfaceEnabled()) {
            this.systemStartBackupMenuItem = new MenuItem(this.subMenuForBackup, 8);
            if (SettingHelper.isLicenseActive()) {
                logger.debug("isLicenseActive:inside praveen backup: " + SettingHelper.isLicenseActive());
                this.systemStartBackupMenuItem.setText("Initiate Backup");
            } else {
                this.systemStartBackupMenuItem.setText("License Expired");
                this.systemStartBackupMenuItem.setEnabled(false);
            }
            listener3 = event -> {
                ManualSyncHelper.startManualBackup();
                this.systemStartBackupMenuItem.setEnabled(false);
                this.systemStartBackupMenuItem.setText("");
                this.systemStartBackupMenuItem.setText("Backup in progress");
                UIHelper.displaySyncingGif();
            };
            this.systemStartBackupMenuItem.addListener(13, listener3);
        }
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isPauseBackupInterfaceEnabled()) {
            this.pauseBackup = new MenuItem(this.subMenuForBackup, 8);
            this.pauseBackup.setText("Pause Backup");
            this.pauseBackup.setEnabled(false);
            listener2 = event -> {
                if (NotificationHelper.isBackUpStarted()) {
                    logger.debug("Calling pause backup.");
                    isPauseBackupPressed = true;
                    if (this.stopBackup != null && !this.stopBackup.isDisposed()) {
                        this.stopBackup.setEnabled(false);
                    }
                    this.pauseBackup.setText("Pausing Backup...");
                    BlusyncThreadHelper.cancelCurrentBackupProcess(true, false, false);
                }
            };
            this.pauseBackup.addListener(13, listener2);
        }
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") && SettingHelper.isStopBackupInterfaceEnabled()) {
            this.stopBackup = new MenuItem(this.subMenuForBackup, 8);
            this.stopBackup.setText("Stop Backup");
            listener2 = event -> {
                Shell shell = new Shell(this.display);
                MessageBox dialog = new MessageBox(shell, 200);
                dialog.setText("Stop Backup");
                dialog.setMessage("You have chosen to stop the current backup\nAre you sure?");
                int result = dialog.open();
                if (result == 64) {
                    this.stopBackup.setEnabled(false);
                    if (NotificationHelper.isBackUpStarted()) {
                        logger.debug("Calling stop backup.");
                        isStopBackupPressed = true;
                        if (this.pauseBackup != null && !this.pauseBackup.isDisposed()) {
                            this.pauseBackup.setEnabled(false);
                        }
                        this.stopBackup.setText("Stopping Backup...");
                        BlusyncThreadHelper.cancelCurrentBackupProcess(true, true, false);
                    }
                }
            };
            this.stopBackup.addListener(13, listener2);
        }
        if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.isSyncSettingsInterfaceEnabled()) {
            MenuItem syncSettingsMenuItem = new MenuItem(this.subMenuForSync, 8);
            syncSettingsMenuItem.setText("Sync Settings");
            listener = event -> {
                logger.debug("Settings or Preferences is selected.");
                this.loadParaBluClient();
            };
            syncSettingsMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.isSearchInterfaceEnabled()) {
            this.searchMenuItem = new MenuItem(this.subMenuForSync, 8);
            this.searchMenuItem.setText("Search ");
            if (!SettingHelper.isLicenseActive()) {
                this.searchMenuItem.setEnabled(false);
            }
            listener2 = event -> {
                Runnable runnable = () -> {
                    logger.debug("Launch Search");
                    String iP = SettingHelper.getCurrentCloudIpAddress();
                    String token = null;
                    try {
                        token = SettingHelper.readTokenFromFile();
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(" exception in search " + e.getMessage());
                    }
                    String cloudName = SettingHelper.getCloudName();
                    String userName = SettingHelper.getUserName();
                    String[] resArr = null;
                    cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
                    try {
                        String url;
                        if (port == null) {
                            resArr = cloudAdapter.getAuthenticationToken(iP, null, token, userName);
                            String proxyToken = resArr[0];
                            cloudName = resArr[1];
                            url = HTTPS_URL + iP + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "search" + PARAM + URLEncoder.encode("ParaBlu", ENCODE_UTF_8);
                        } else {
                            resArr = cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
                            String proxyToken = resArr[0];
                            cloudName = resArr[1];
                            url = HTTPS_URL + iP + ":" + port + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "search" + PARAM + URLEncoder.encode("ParaBlu", ENCODE_UTF_8);
                        }
                        Program.launch(url);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("" + e);
                        logger.error(" UnsupportedEncodingException " + e.getMessage());
                    }
                };
                new Thread(runnable).start();
            };
            this.searchMenuItem.addListener(13, listener2);
        }
        if (SettingHelper.getSyncLicenced().equals("true") && SettingHelper.isRefreshSyncPolicyInterfaceEnabled()) {
            this.systemSyncPolicyRefreshMenuItem = new MenuItem(this.subMenuForSync, 8);
            this.systemSyncPolicyRefreshMenuItem.setText("Refresh Sync Policy");
            Listener lstner = event -> {
                Runnable runnable = () -> {
                    MacCheckSyncPolicy.pullSyncPolicy();
                    BlusyncThreadHelper.resetSyncTimer();
                    this.macEventsManagement.refreshPolicyTask();
                    String toolTipMessage = "Policy Refresh";
                    String toolTipmessage1 = "Policy update finished";
                    UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
                };
                new Thread(runnable).start();
            };
            this.systemSyncPolicyRefreshMenuItem.addListener(13, lstner);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.getSyncLicenced().contentEquals("false") && (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled()) || this.isCommonFeatureEnabled(SettingHelper.isDecoupleBackupInterfaceEnabled(), SettingHelper.isDecoupleSyncInterfaceEnabled()))) {
            new MenuItem(this.subMenuForBackup, 2);
        }
        if (this.isCommonFeatureEnabled(SettingHelper.isSupportBackupInterfaceEnabled(), SettingHelper.isSupportSyncInterfaceEnabled())) {
            MenuItem supportLogMenuItem = new MenuItem(this.subMenuForSupport, 8);
            supportLogMenuItem.setText("Support Request");
            Listener listener22 = event -> {
                Shell shell = new Shell(this.display);
                MessageBox supportLogAttachMsgBox = new MessageBox(shell, 196);
                supportLogAttachMsgBox.setMessage("Do you want to add end point logs with request?");
                supportLogAttachMsgBox.setText("Support request");
                int response = supportLogAttachMsgBox.open();
                if (response == 64) {
                    if (SupportHelper.isSupportRequestInitiated()) {
                        logger.debug("isSupportRequestInitiated: " + SupportHelper.isSupportRequestInitiated());
                        return;
                    }
                    int logsSent = SupportHelper.sendNewSupportLogs(SettingHelper.getCloudName(), SettingHelper.getUserName(), SettingHelper.getDeviceName(), true, false, false, false, "PULL_AGENTLOGS");
                    if (logsSent == 2) {
                        Clipboard clipboard = new Clipboard(Display.getCurrent());
                        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
                        clipboard.setContents(new Object[]{SupportHelper.getSupportRequestId()}, transfers);
                        clipboard.dispose();
                        MessageBox messageBox = new MessageBox(shell, 34);
                        messageBox.setText("Support Request Raised Successfully");
                        messageBox.setMessage("Logs have been sent Successfully to our server.\nLog id will be attached in your request mail.");
                        messageBox.open();
                    } else if (logsSent == 1) {
                        MessageBox messageBox = new MessageBox(shell, 40);
                        messageBox.setMessage("Failed to send logs.\n\nLog id will be attached in your request mail.");
                        messageBox.setText("Request Failed");
                        messageBox.open();
                    }
                }
                logger.debug("Clicked on Help Hyperlink");
                String mailto = PropertyHelper.HELP_LINK_SEND_MAIL + "?subject=" + SystemTrayUI.encode(SupportHelper.getSupportRequestId());
                Program.launch(mailto);
                SupportHelper.setSupportRequestId(null);
            };
            supportLogMenuItem.addListener(13, listener22);
        }
        if (this.isCommonFeatureEnabled(SettingHelper.isDecoupleBackupInterfaceEnabled(), SettingHelper.isDecoupleSyncInterfaceEnabled())) {
            MenuItem decoupleMenuItem = new MenuItem(this.menu, 8);
            decoupleMenuItem.setText("Decouple Device");
            decoupleMenuItem.addListener(13, new Listener(){

                @Override
                public void handleEvent(Event event) {
                    boolean decoupleAgent = SystemTrayUI.this.validateWithPassword();
                    if (decoupleAgent) {
                        logger.debug("Settings decouple is selected.");
                        Shell shell = new Shell(SystemTrayUI.this.display);
                        MessageBox dialog = new MessageBox(shell, 200);
                        dialog.setText("Decouple Device");
                        dialog.setMessage("This action will de-couple the device from Parablu server and will trigger a full backup if you choose to re-couple it again later.\nAre you sure you want to proceed?");
                        int result = dialog.open();
                        if (result == 64) {
                            logger.debug("Clicked on disconnect button");
                            int response = this.sendDecoupleRequest();
                            if (response == 200) {
                                if (NotificationHelper.isBackUpStarted()) {
                                    PolicyManagementServerHelper.updateFailCodeToActivityHistory(913);
                                    PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit("STOPPED", false);
                                }
                                if (SystemTrayUI.this.restoreInstance != null && NotificationHelper.restoreStarted) {
                                    SystemTrayUI.this.restoreInstance.restoreBatchUpdateBeforeExit();
                                    SystemTrayUI.this.restoreInstance.close();
                                } else if (SystemTrayUI.this.restoreInstance != null && ((SystemTrayUI)SystemTrayUI.this).restoreInstance.shell != null) {
                                    SystemTrayUI.this.restoreInstance.close();
                                }
                                BluSyncLauncher.changeAccount();
                            } else {
                                MessageBox msg = new MessageBox(shell, 34);
                                msg.setText("Cannot Decouple");
                                msg.setMessage("Could not connect to server. User will not be decoupled from the device.");
                                msg.open();
                            }
                        }
                    }
                }

                private int sendDecoupleRequest() {
                    BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                    int response = 0;
                    if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                        try {
                            response = backupAdapter.getDecoupleResponse(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile());
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error(" exception in send decouple request " + e.getMessage());
                        }
                        return response;
                    }
                    return 200;
                }
            });
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && this.isCommonFeatureEnabled(SettingHelper.isAboutBackupInterfaceEnabled(), SettingHelper.isAboutSyncInterfaceEnabled())) {
            new MenuItem(this.subMenuForBackup, 2);
        }
        if (this.isCommonFeatureEnabled(SettingHelper.isAboutBackupInterfaceEnabled(), SettingHelper.isAboutSyncInterfaceEnabled())) {
            MenuItem SettingsMenuItem = new MenuItem(this.menu, 8);
            SettingsMenuItem.setText("About");
            listener = event -> {
                logger.debug("about page  is selected.");
                this.loadParaBluAbout();
            };
            SettingsMenuItem.addListener(13, listener);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true") && SettingHelper.getSyncLicenced().contentEquals("false") && this.isCommonFeatureEnabled(SettingHelper.isExitBackupInterfaceEnabled(), SettingHelper.isExitSyncInterfaceEnabled())) {
            new MenuItem(this.subMenuForBackup, 2);
        }
        if (this.isCommonFeatureEnabled(SettingHelper.isExitBackupInterfaceEnabled(), SettingHelper.isExitSyncInterfaceEnabled())) {
            MenuItem systemTrayExit = new MenuItem(this.menu, 8);
            systemTrayExit.setText("Exit");
            Listener listener32 = event -> {
                boolean exitAgent = this.validateWithPassword();
                if (exitAgent) {
                    logger.debug("Exiting Client Application");
                    if (NotificationHelper.isBackUpStarted()) {
                        PolicyManagementServerHelper.updateFailCodeToActivityHistory(911);
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit("STOPPED", false);
                    }
                    if (this.restoreInstance != null) {
                        if (NotificationHelper.restoreStarted) {
                            this.restoreInstance.restoreBatchUpdateBeforeExit();
                        }
                        this.restoreInstance.cancelRestoreDisplayTimer();
                    } else if (this.restoreInstance == null && NotificationHelper.restoreStarted) {
                        RestoreManager.restoreBatchUpdateBeforeExit();
                    }
                    this.stopTimer();
                    SystemTrayUI.unlockFileUI();
                    this.closeUIInstances();
                    this.systrayItem.dispose();
                    this.systrayShell.getDisplay().dispose();
                    this.systrayShell.dispose();
                    this.checkCrawlStatusAndUpdateTable();
                    if (SettingHelper.process != null) {
                        SettingHelper.process.destroy();
                    }
                    SettingHelper.deleteParaBluFolderPathTempFile();
                    SettingHelper.deleteUserValidityFilePath();
                    SettingHelper.deleteNotSyncedFile();
                    System.exit(0);
                }
            };
            systemTrayExit.addListener(13, listener32);
        }
        Listener listener4 = event -> {
            logger.debug("System Tray - Menu Detection Listener");
            this.menu.setVisible(true);
            if (SettingHelper.getUiVersion() != -1) {
                this.uiVersion = SettingHelper.getUiVersion();
                logger.debug("UI version in systray" + this.uiVersion);
            }
        };
        this.systrayItem.addListener(35, listener4);
        logger.debug("Systray loading and listeners attached");
        UIHelper.setSystemTrayUI(this, this.display);
        while (this.systrayShell != null && !this.systrayShell.isDisposed() && this.forcestop) {
            if (this.display.isDisposed() || this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.closeUIInstances();
        this.stopTimer();
        if (this.systrayImage != null && !this.systrayImage.isDisposed()) {
            this.systrayImage.dispose();
        }
        if (this.systrayItem != null && !this.systrayItem.isDisposed()) {
            this.systrayItem.dispose();
        }
        if (this.systrayShell != null && !this.systrayShell.isDisposed()) {
            this.systrayShell.dispose();
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.dispose();
        }
        this.systrayItem = null;
        this.systrayImage = null;
        this.display = null;
        this.systrayShell = null;
    }

    private boolean validateWithPassword() {
        this.result = false;
        this.password = null;
        logger.debug("Exiting Client Application");
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        PolicyTo currentPolicy = null;
        if (currentDetails != null && (currentPolicy = currentDetails.get(0)).getAgentPassword() != null) {
            this.password = currentPolicy.getAgentPassword();
        }
        if (currentPolicy.isSwitchAgentPassword()) {
            if (!StringUtils.isEmpty(this.password)) {
                this.password = SystemTrayUI.decodeBase64UTFString(this.password);
                System.out.println(".................." + this.password);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        final Shell shell = new Shell(SystemTrayUI.this.display);
                        shell.setLayout(new GridLayout());
                        shell.setText("Password");
                        shell.setLayoutData(new GridData());
                        SystemTrayUI.this.systrayImage = new Image((Device)SystemTrayUI.this.display, SystemTrayUI.this.systrayImageData.scaledTo(24, 24));
                        shell.setImage(SystemTrayUI.this.systrayImage);
                        Composite shellComposite = new Composite(shell, 0);
                        GridLayout shellGroupGridLayout = new GridLayout();
                        shellGroupGridLayout.numColumns = 1;
                        shellGroupGridLayout.makeColumnsEqualWidth = false;
                        shellGroupGridLayout.verticalSpacing = 5;
                        shellComposite.setLayout(shellGroupGridLayout);
                        shellComposite.setLayoutData(new GridData(768));
                        Composite textComposite = new Composite(shellComposite, 0x1000000);
                        GridLayout textGroupGridLayout = new GridLayout();
                        textGroupGridLayout.numColumns = 1;
                        textGroupGridLayout.makeColumnsEqualWidth = false;
                        textGroupGridLayout.verticalSpacing = 5;
                        textComposite.setLayout(textGroupGridLayout);
                        textComposite.setLayoutData(new GridData(768));
                        Label lbel = new Label(textComposite, 0);
                        lbel.setText("Enter the password to exit/decouple the agent");
                        lbel.setLayoutData(new GridData(768));
                        final Text pswdtext = new Text(textComposite, 2048);
                        pswdtext.setEchoChar('*');
                        pswdtext.setLayoutData(new GridData(768));
                        Composite buttonComposite = new Composite(shellComposite, 0x1000000);
                        GridLayout groupGridLayout = new GridLayout();
                        groupGridLayout.numColumns = 4;
                        groupGridLayout.makeColumnsEqualWidth = false;
                        groupGridLayout.marginTop = 10;
                        groupGridLayout.verticalSpacing = 5;
                        buttonComposite.setLayout(groupGridLayout);
                        buttonComposite.setLayoutData(new GridData(768));
                        GridData saveGridData = new GridData();
                        saveGridData.horizontalAlignment = 2;
                        saveGridData.widthHint = 75;
                        Button dummybutton = new Button(buttonComposite, 8);
                        dummybutton.setText("Okkkkkk");
                        dummybutton.setVisible(false);
                        Button buttonForOk = new Button(buttonComposite, 8);
                        buttonForOk.setText("OK");
                        buttonForOk.setLayoutData(saveGridData);
                        buttonForOk.setAlignment(0x1000000);
                        Button dummybutton1 = new Button(buttonComposite, 8);
                        dummybutton1.setText("OK");
                        dummybutton1.setVisible(false);
                        buttonForOk.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent event) {
                                String pswd = pswdtext.getText().trim();
                                if (pswd.contentEquals(SystemTrayUI.this.password)) {
                                    SystemTrayUI.this.result = true;
                                    shell.close();
                                } else {
                                    MessageBox msg = new MessageBox(shell, 33);
                                    msg.setText("Password");
                                    msg.setMessage(" Incorrect Password    ");
                                    msg.open();
                                    SystemTrayUI.this.result = false;
                                    shell.close();
                                }
                            }
                        });
                        Button buttonForCancel = new Button(buttonComposite, 8);
                        buttonForCancel.setText(" Cancel ");
                        buttonForCancel.setLayoutData(saveGridData);
                        buttonForCancel.setAlignment(0x1000000);
                        buttonForCancel.addSelectionListener(new SelectionAdapter(){

                            @Override
                            public void widgetSelected(SelectionEvent event) {
                                shell.close();
                            }
                        });
                        shell.setSize(350, 160);
                        shell.open();
                        while (!shell.isDisposed()) {
                            if (SystemTrayUI.this.display.readAndDispatch()) continue;
                            SystemTrayUI.this.display.sleep();
                        }
                    }
                });
            } else {
                this.result = true;
            }
        } else {
            this.result = true;
        }
        logger.debug("result...." + this.result);
        return this.result;
    }

    static String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64(encodedString), ENCODE_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException" + e);
        }
        return decodedString;
    }

    public void loadProxySettings() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUIforProxySetting();
            this.createProxyViewInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void acquireLockForNewUIforProxySetting() {
        SystemTrayUI systemTrayUI = this;
        if (systemTrayUI.ProxySettinginstance.isUilock()) {
            if (this.ProxySettinginstance != null && this.ProxySettinginstance.shell != null) {
                logger.debug("Trying to maximise");
                this.ProxySettinginstance.shell.open();
            }
            throw new EndpointGeneralException("Instance already running. Unable to acquire lock. Terminate application.");
        }
        ProxySettingsView.setUilock(true);
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void createProxyViewInstance() {
        Runnable runnable = () -> {
            try {
                this.ProxySettinginstance = null;
                this.ProxySettinginstance = new ProxySettingsView();
                this.ProxySettinginstance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    private void closeUIInstances() {
        if (this.instance != null) {
            this.instance.close(true);
            this.instance = null;
        }
        if (this.restoreInstance != null) {
            this.restoreInstance.close();
            this.restoreInstance = null;
        }
    }

    protected void checkCrawlStatusAndUpdateTable() {
        if (NotificationHelper.getMainStatus() != 101 || NotificationHelper.getCurrentActivityState() != 8) {
            return;
        }
        ActivityHistoryImpl activityHistoryHandle = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        ActivityTO activity = new ActivityTO();
        Date crawlDate = new Date(Long.valueOf(NotificationHelper.getCurrentCrawlTimeStamp()));
        activity.setActivityTimeStamp(crawlDate);
        activity.setActivityName(CrawlLifecycle.EXITED.name());
        activity.setUploadCount(NotificationHelper.getUploadCount());
        activity.setDownloadCount(NotificationHelper.getDowloadCount());
        activity.setActivityID(NotificationHelper.getCurrentActivityId());
        activityHistoryHandle.updateEventToActivityHistoryTable(activity);
    }

    public synchronized void stopTimer() {
        if (this.systrayTimer != null) {
            this.systrayTimer.cancel();
            this.systrayTimer = null;
        }
    }

    public void loadRestoreUI() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewRestoreUI();
            this.createRestoreInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createRestoreInstance() {
        Runnable runnable = () -> {
            try {
                logger.debug("inside restore IUI start");
                this.restoreInstance = new RestoreUI();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void loadParaBluClient() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUI();
            this.createConsInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createConsInstance() {
        Runnable runnable = () -> {
            try {
                this.instance = null;
                this.instance = new ConsolidatedView();
                this.instance.openShell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    void acquireLockForNewUI() throws EndpointGeneralException {
        if (ConsolidatedView.isUilock()) {
            if (this.instance != null && this.instance.shell != null) {
                logger.debug("Trying to maximise");
                this.instance.shell.open();
            }
            throw new EndpointGeneralException("Instance already running. Unable to acquire lock. Terminate application.");
        }
        ConsolidatedView.setUilock(true);
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void acquireLockForNewRestoreUI() throws EndpointGeneralException {
        if (RestoreUI.isUilock()) {
            if (this.restoreInstance != null && this.restoreInstance.shell != null) {
                logger.debug("Trying to maximise");
            }
            throw new EndpointGeneralException("Instance already running. Unable to acquire lock. Terminate application.");
        }
        RestoreUI.setUilock(true);
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private void acquireLockForNewUIforAbout() throws EndpointGeneralException {
        if (ConsolidatedView.isUilock()) {
            if (this.instance != null && this.instance.shell != null) {
                logger.debug("Trying to maximise");
                this.instance.shell.open();
            }
            throw new EndpointGeneralException("Instance already running. Unable to acquire lock. Terminate application.");
        }
        ConsolidatedView.setUilock(true);
        ShutdownHookUI shutdownHook = new ShutdownHookUI();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static synchronized void unlockFileUI() {
        ConsolidatedView.setUilock(false);
        RestoreUI.setUilock(false);
    }

    public synchronized void disposeSystrayUIShells() {
        this.stopTimer();
        if (this.instance != null) {
            this.instance.close(false);
            SystemTrayUI.unlockFileUI();
        }
        try {
            this.menu.dispose();
            this.systrayImage.dispose();
            this.systrayItem.dispose();
            this.systrayShell.dispose();
            this.tray.dispose();
            this.display.dispose();
        }
        catch (Exception e) {
            logger.error("error in disposing fields.", e);
        }
    }

    private static String encode(String strData) {
        String data = strData;
        if (data == null) {
            data = "";
        }
        try {
            return URLEncoder.encode(data, ENCODE_UTF_8).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.debug("UnsupportedEncodingException:" + e.getMessage());
            return data;
        }
    }

    public boolean isCommonFeatureEnabled(boolean backupFeatureEnabled, boolean syncFeatureEnabled) {
        boolean interfaceFetureEnabled = false;
        if ("true".equalsIgnoreCase(SettingHelper.getBackupLicenced()) && backupFeatureEnabled && ("true".equalsIgnoreCase(SettingHelper.getSyncLicenced()) && syncFeatureEnabled || !"true".equalsIgnoreCase(SettingHelper.getSyncLicenced())) || this.isSyncCommonFeatureEnabled(syncFeatureEnabled)) {
            interfaceFetureEnabled = true;
        }
        return interfaceFetureEnabled;
    }

    private boolean isSyncCommonFeatureEnabled(boolean syncFeatureEnabled) {
        return !"true".equalsIgnoreCase(SettingHelper.getBackupLicenced()) && "true".equalsIgnoreCase(SettingHelper.getSyncLicenced()) && syncFeatureEnabled;
    }

    public MenuItem getSystemStartCrawl() {
        return this.systemStartCrawlMenuItem;
    }

    public MenuItem getSearchMenuItem() {
        return this.searchMenuItem;
    }

    public Shell getSystrayShell() {
        return this.systrayShell;
    }

    public void setSystrayShell(Shell systrayShell) {
        this.systrayShell = systrayShell;
    }

    public TrayItem getSystrayItem() {
        return this.systrayItem;
    }

    public void setSystrayItem(TrayItem systrayItem) {
        this.systrayItem = systrayItem;
    }

    public ConsolidatedView getInstance() {
        return this.instance;
    }

    public MenuItem systemStartBackupMenuItem() {
        return this.systemStartBackupMenuItem;
    }

    public void loadParaBluAbout() {
        try {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.acquireLockForNewUIforAbout();
            this.createAboutViewInstance();
        }
        catch (Exception e) {
            logger.error("Exception while creating BluSync GUI" + e);
        }
    }

    private void createAboutViewInstance() {
        Runnable runnable = () -> {
            try {
                this.instance = null;
                this.instance = new ConsolidatedView();
                this.instance.openAboutshell();
            }
            catch (Exception e) {
                logger.error("Exception during instantiation of UI" + e);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void closeRestoreWindow() {
        this.restoreInstance.closeRestoreWindow();
    }

    static void getUserAuthenticationTokenandLaunchInfectedFilesList() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        String url;
        String iP = SettingHelper.getCurrentCloudIpAddress();
        port = SettingHelper.getCurrentHttpsPort();
        String token = SettingHelper.readTokenFromFile();
        String cloudName = SettingHelper.getCloudName();
        String userName = SettingHelper.getUserName();
        String deviceName = null;
        cloudAdapter = new CloudAdapter(cloudName, SettingHelper.getKeystorePath());
        if (port == null) {
            String[] resArr = cloudAdapter.getAuthenticationToken(iP, null, token, userName);
            String proxyToken = resArr[0];
            cloudName = resArr[1];
            try {
                userName = URLEncoder.encode(userName, ENCODE_UTF_8);
                deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), ENCODE_UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Exception :", (Object)e.getMessage());
            }
            url = HTTPS_URL + iP + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "failedFiles" + PARAM + "&v=" + PropertyHelper.BLUSYNC_VERSION_LABEL + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + deviceName;
        } else {
            String[] resArr = cloudAdapter.getAuthenticationToken(iP, Integer.valueOf(port), token, userName);
            String proxyToken = resArr[0];
            cloudName = resArr[1];
            try {
                userName = URLEncoder.encode(userName, ENCODE_UTF_8);
                deviceName = URLEncoder.encode(SettingHelper.getDeviceName(), ENCODE_UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Exception :", (Object)e.getMessage());
            }
            url = HTTPS_URL + iP + ":" + port + PORTAL_AUTH + cloudName + "&u=" + userName + "&t=" + proxyToken + URL_STR + "failedFiles" + PARAM + "&v=" + PropertyHelper.BLUSYNC_VERSION_LABEL + "&id=" + SettingHelper.getDeviceUUId() + "&action=" + deviceName;
        }
        Program.launch(url);
    }

    static {
        cloudAdapter = null;
        FILE_SEPARATOR = System.getProperty("file.separator");
        PARABLU_LICENSE_EXPIRED_IMAGE = MacSettingsHelper.baseResourceFolder + RESOURCE + FILE_SEPARATOR + IMG + FILE_SEPARATOR + "ParaBlu_2.png";
        systemTrayUI = null;
    }

    class SystrayNotificationTask
    extends TimerTask {
        SystrayNotificationTask() {
        }

        @Override
        public void run() {
            if (SystemTrayUI.this.display == null) {
                return;
            }
            Runnable runnable = () -> {
                try {
                    if (NotificationHelper.getMainStatus() == 100 && !NotificationHelper.isBackUpStarted() && SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                        SystemTrayUI.this.systrayItem.setToolTipText(PropertyHelper.SYSTRAY_TOOLTIP_LABEL);
                        SystemTrayUI.this.syncTooltip = "";
                        SystemTrayUI.this.backupTooltip = PropertyHelper.SYSTRAY_TOOLTIP_LABEL;
                    }
                    if (SettingHelper.getSyncLicenced().equalsIgnoreCase("true")) {
                        this.handleSyncPolicyRefreshButton();
                    }
                    if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                        if (NotificationHelper.restoreStarted && SystemTrayUI.this.restoreMenuItem != null && !SystemTrayUI.this.restoreMenuItem.isDisposed()) {
                            SystemTrayUI.this.restoreMenuItem.setEnabled(false);
                        }
                        if (!NotificationHelper.restoreStarted && SystemTrayUI.this.restoreMenuItem != null && !SystemTrayUI.this.restoreMenuItem.isDisposed()) {
                            SystemTrayUI.this.restoreMenuItem.setEnabled(true);
                        }
                    }
                    if (NotificationHelper.getMainStatus() == 100) {
                        if (SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                            SystemTrayUI.this.syncTooltip = "";
                        }
                        if (!(SystemTrayUI.this.systemStartCrawlMenuItem == null || SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() || SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled() || SettingHelper.getSyncLicenced().contentEquals("false"))) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(true);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Sync Now");
                        }
                        return;
                    }
                    if (NotificationHelper.getCurrentActivityState() != 9) {
                        SystemTrayUI.this.syncTooltip = "\nSync Download-" + NotificationHelper.getDowloadCount() + " file(s)\nSync Upload-" + NotificationHelper.getUploadCount() + " file(s)";
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                        if (SystemTrayUI.this.systemStartCrawlMenuItem != null && !SystemTrayUI.this.systemStartCrawlMenuItem.isDisposed() && SystemTrayUI.this.systemStartCrawlMenuItem.getEnabled()) {
                            SystemTrayUI.this.systemStartCrawlMenuItem.setEnabled(false);
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("");
                            SystemTrayUI.this.systemStartCrawlMenuItem.setText("Currently Syncing...");
                            UIHelper.displaySyncingGif();
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Exception during the crawl process ", e);
                }
            };
            SystemTrayUI.this.display.asyncExec(runnable);
            SystemTrayUI.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                            if (NotificationHelper.policyRefreshStarted) {
                                if (SystemTrayUI.this.systemPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemPolicyRefreshMenuItem.isDisposed() && SystemTrayUI.this.systemPolicyRefreshMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(false);
                                    if (NotificationHelper.isChangeTextOfBackupPolicyMenu()) {
                                        SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                        SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refreshing Policy");
                                    }
                                }
                            } else if (SystemTrayUI.this.systemPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemPolicyRefreshMenuItem.isDisposed()) {
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setEnabled(true);
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("");
                                SystemTrayUI.this.systemPolicyRefreshMenuItem.setText("Refresh Policy");
                            }
                        }
                        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                            if (NotificationHelper.backUpStarted) {
                                this.updateBackupProgressTooltip();
                                if (isStopBackupPressed) {
                                    SystemTrayUI.this.stopBackup.setEnabled(false);
                                }
                                if (isPauseBackupPressed) {
                                    SystemTrayUI.this.pauseBackup.setEnabled(false);
                                }
                                if (!(SystemTrayUI.this.pauseBackup == null || SystemTrayUI.this.pauseBackup.isDisposed() || isPauseBackupPressed || isStopBackupPressed)) {
                                    if (NotificationHelper.getBackupStatus() == 2) {
                                        SystemTrayUI.this.pauseBackup.setEnabled(false);
                                    } else {
                                        SystemTrayUI.this.pauseBackup.setEnabled(true);
                                    }
                                }
                                if (!(SystemTrayUI.this.stopBackup == null || SystemTrayUI.this.stopBackup.isDisposed() || isPauseBackupPressed || isStopBackupPressed)) {
                                    SystemTrayUI.this.stopBackup.setEnabled(true);
                                }
                                if (SystemTrayUI.this.systemStartBackupMenuItem != null && !SystemTrayUI.this.systemStartBackupMenuItem.isDisposed() && SystemTrayUI.this.systemStartBackupMenuItem.getEnabled()) {
                                    SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(false);
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                                    SystemTrayUI.this.systemStartBackupMenuItem.setText("Backup in progress");
                                    UIHelper.displaySyncingGif();
                                }
                                return;
                            }
                            if (SystemTrayUI.this.systrayItem != null && !SystemTrayUI.this.systrayItem.isDisposed()) {
                                SystemTrayUI.this.backupTooltip = PropertyHelper.SYSTRAY_TOOLTIP_LABEL;
                            }
                            if (SystemTrayUI.this.systemStartBackupMenuItem != null && !SystemTrayUI.this.systemStartBackupMenuItem.isDisposed()) {
                                SystemTrayUI.this.systemStartBackupMenuItem.setText("");
                                SystemTrayUI.this.systemStartBackupMenuItem.setText("Initiate Backup");
                                if (NotificationHelper.restoreStarted) {
                                    if (NotificationHelper.isSuspendBackup) {
                                        SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(false);
                                    }
                                } else {
                                    SystemTrayUI.this.systemStartBackupMenuItem.setEnabled(true);
                                }
                            }
                            if (SystemTrayUI.this.pauseBackup != null && !SystemTrayUI.this.pauseBackup.isDisposed()) {
                                SystemTrayUI.this.pauseBackup.setText("Pause Backup");
                                SystemTrayUI.this.pauseBackup.setEnabled(false);
                                isPauseBackupPressed = false;
                            }
                            if (SystemTrayUI.this.stopBackup != null && !SystemTrayUI.this.stopBackup.isDisposed()) {
                                SystemTrayUI.this.stopBackup.setText("Stop Backup");
                                SystemTrayUI.this.stopBackup.setEnabled(false);
                                isStopBackupPressed = false;
                            }
                            if (NotificationHelper.getMainStatus() == 100) {
                                UIHelper.updateSystrayImageAccordingToStage(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_IMAGE);
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception during the crawl process " + e);
                    }
                }

                private void updateBackupProgressTooltip() {
                    if (NotificationHelper.getBackupStatus() != 4) {
                        if (NotificationHelper.getBackupStatus() == 6) {
                            SystemTrayUI.this.backupTooltip = NotificationHelper.getCurrentBackupStatus() + PBCountDownTimer.getCountDownTimer() + "(mm:ss)";
                        } else {
                            SystemTrayUI.this.backupTooltip = NotificationHelper.getCurrentBackupStatus();
                        }
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                    } else if (NotificationHelper.getBackupStatus() == 4) {
                        String filesCount = NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp();
                        String toolTipText1 = NotificationHelper.getCurrentBackupStatus() + filesCount + SystemTrayUI.FILES_STR;
                        String toolTipText2 = !NotificationHelper.getBackupChunkFileDetails().isEmpty() ? NotificationHelper.getBackupChunkFileDetails() : NotificationHelper.getBackupFileChunkingStatus();
                        SystemTrayUI.this.backupTooltip = "";
                        SystemTrayUI.this.backupTooltip = toolTipText1 + toolTipText2;
                        SystemTrayUI.this.systrayItem.setToolTipText(SystemTrayUI.this.backupTooltip + SystemTrayUI.this.syncTooltip);
                    }
                }
            });
        }

        private void handleSyncPolicyRefreshButton() {
            if (NotificationHelper.syncPolicyRefreshStarted) {
                if (SystemTrayUI.this.systemSyncPolicyRefreshMenuItem != null && !SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.isDisposed() && SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.getEnabled()) {
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setEnabled(false);
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("");
                    SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("Refreshing Policy");
                }
            } else if (SystemTrayUI.this.systemSyncPolicyRefreshMenuItem != null) {
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setEnabled(true);
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("");
                SystemTrayUI.this.systemSyncPolicyRefreshMenuItem.setText("Refresh Sync Policy");
            }
        }
    }

    static class ShutdownHookUI
    extends Thread {
        ShutdownHookUI() {
        }

        @Override
        public void run() {
            SystemTrayUI.unlockFileUI();
        }
    }
}

