/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SearchDialog {
    Shell shell;
    Text searchText;
    Combo searchArea;
    Label searchAreaLabel;
    Button matchCase;
    Button matchWord;
    Button findButton;
    Button down;
    FindListener findHandler;

    public SearchDialog(Shell parent) {
        this.shell = new Shell(parent, 2144);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout(layout);
        this.shell.setText("Search");
        this.shell.addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent e) {
                e.doit = false;
                SearchDialog.this.shell.setVisible(false);
            }
        });
        Label label = new Label(this.shell, 16384);
        label.setText("Find");
        this.searchText = new Text(this.shell, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchText.setLayoutData(gridData);
        this.searchText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                boolean enableFind = SearchDialog.this.searchText.getCharCount() != 0;
                SearchDialog.this.findButton.setEnabled(enableFind);
            }
        });
        this.searchAreaLabel = new Label(this.shell, 16384);
        this.searchArea = new Combo(this.shell, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchArea.setLayoutData(gridData);
        Group options = new Group(this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        options.setLayoutData(gridData);
        options.setLayout(new FillLayout());
        options.setText("Options");
        this.matchCase = new Button(options, 32);
        this.matchCase.setText("Case sensitive");
        this.matchWord = new Button(options, 32);
        this.matchWord.setText("Whole word");
        Group direction = new Group(this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        direction.setLayoutData(gridData);
        direction.setLayout(new FillLayout());
        direction.setText("Direction");
        Button up = new Button(direction, 16);
        up.setText("Up");
        up.setSelection(false);
        this.down = new Button(direction, 16);
        this.down.setText("Down");
        this.down.setSelection(true);
        Composite composite = new Composite(this.shell, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout(layout);
        this.findButton = new Button(composite, 8);
        this.findButton.setText("Find");
        this.findButton.setLayoutData(new GridData(128));
        this.findButton.setEnabled(false);
        this.findButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!SearchDialog.this.findHandler.find()) {
                    MessageBox box = new MessageBox(SearchDialog.this.shell, 32802);
                    box.setText(SearchDialog.this.shell.getText());
                    box.setMessage("Cannot find\"" + SearchDialog.this.searchText.getText() + "\"");
                    box.open();
                }
            }
        });
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText("Cancel");
        cancelButton.setLayoutData(new GridData(32));
        cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.shell.setVisible(false);
            }
        });
        this.shell.pack();
    }

    public String getSearchAreaLabel(String label) {
        return this.searchAreaLabel.getText();
    }

    public String[] getsearchAreaNames() {
        return this.searchArea.getItems();
    }

    public boolean getMatchCase() {
        return this.matchCase.getSelection();
    }

    public boolean getMatchWord() {
        return this.matchWord.getSelection();
    }

    public String getSearchString() {
        return this.searchText.getText();
    }

    public boolean getSearchDown() {
        return this.down.getSelection();
    }

    public int getSelectedSearchArea() {
        return this.searchArea.getSelectionIndex();
    }

    public void open() {
        if (this.shell.isVisible()) {
            this.shell.setFocus();
        } else {
            this.shell.open();
        }
        this.searchText.setFocus();
    }

    public void setSearchAreaNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.searchArea.add(names[i]);
        }
        this.searchArea.select(0);
    }

    public void setSearchAreaLabel(String label) {
        this.searchAreaLabel.setText(label);
    }

    public void setMatchCase(boolean match) {
        this.matchCase.setSelection(match);
    }

    public void setMatchWord(boolean match) {
        this.matchWord.setSelection(match);
    }

    public void setSearchDown(boolean searchDown) {
        this.down.setSelection(searchDown);
    }

    public void setSearchString(String searchString) {
        this.searchText.setText(searchString);
    }

    public void setSelectedSearchArea(int index) {
        this.searchArea.select(index);
    }

    public void addFindListener(FindListener listener) {
        this.findHandler = listener;
    }

    public void removeFindListener(FindListener listener) {
        this.findHandler = null;
    }

    static interface FindListener {
        public boolean find();
    }
}

