/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.AccountManagementView;
import com.parablu.epa.view.BackUpPreferenceView;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.LicenseExpiredView;
import com.parablu.epa.view.MediaManagementView;
import com.parablu.epa.view.NotificationView;
import com.parablu.epa.view.PreferencesView;
import java.io.IOException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsolidatedView {
    private static Logger logger = LoggerFactory.getLogger(ConsolidatedView.class);
    private static boolean uilock = false;
    public Shell shell = null;
    private ToolBar toolBar = null;
    private ToolItem settingsToolItem = null;
    private ToolItem notificationToolItem = null;
    private ToolItem backupToolItem = null;
    private ToolItem accountToolItem = null;
    private ToolItem mediaToolItem = null;
    private PreferencesView preferencesPage = null;
    private BackUpPreferenceView backUpFolderView = null;
    private AccountManagementView accountManagementPage = null;
    private NotificationView notificationPage = null;
    private LicenseExpiredView licenseExpiredViewPage = null;
    private MediaManagementView mediaManagementPage = null;
    protected Composite centerWizardPanel = null;
    private StackLayout centerWizardLayout = null;
    private static final int MENU_SETTINGS = 0;
    private static final int MENU_BACKUP = 1;
    private static final int MENU_ACCOUNT = 2;
    private static final int MENU_MEDIA = 3;
    private static final int MENU_LICENSE = 5;
    private static final int MENU_NOTIFICATION = 4;
    private static final int COLOR255 = 255;
    private static final int COLOR240 = 240;
    private static final int MENU_ABOUT = 6;
    private Color uiBackgroundColor = new Color(Display.getCurrent(), 240, 240, 240);
    private Color whiteColor = new Color(Display.getCurrent(), 255, 255, 255);
    private FontsManager fontsManager;
    private ImageData shellImageData = null;
    private Image shellImage = null;
    private ImageData notificationHotImageData = null;
    private ImageData accountImageData = null;
    private ImageData accountHotImageData = null;
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String BLUSYNC_SETTINGS_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "settings.png";
    public static final String BLUSYNC_SYNC_NOW_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "sync_folder.png";
    public static final String BLUSYNC_HELP_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "help.png";
    public static final String BLUSYNC_ACTIVITY_HISTORY_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "log.png";
    public static final String BLUSYNC_ACCOUNT_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "account.png";
    public static final String BLUSYNC_MEDIA_ICON_PATH = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "media.png";
    private ToolItem aboutToolItem = null;

    ConsolidatedView() throws IOException {
        try {
            this.shell = new Shell(2272);
            int xAxisLocation = this.shell.getDisplay().getClientArea().width / 2 - 150;
            int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 170;
            this.shell.setLocation(xAxisLocation, yAxisLocation);
            this.shell.setBackground(this.whiteColor);
            this.shell.setMinimumSize(400, 400);
        }
        catch (Exception e) {
            logger.error("Exception in UIMain constructor: ", e);
            uilock = false;
        }
    }

    public void generateUI() {
        logger.debug("Structuring BluSync Settings/Preferences User Interface");
        int imageAccountHorizontalSize = 32;
        int imageAccountVerticalSize = 32;
        Display display = this.shell.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.toolBar = new ToolBar(this.shell, 0x1000000);
        GridLayout toolBarGridLayout = new GridLayout();
        toolBarGridLayout.marginLeft = 0;
        toolBarGridLayout.marginTop = 0;
        toolBarGridLayout.marginBottom = 0;
        toolBarGridLayout.marginWidth = 0;
        toolBarGridLayout.marginHeight = 0;
        this.toolBar.setLayout(toolBarGridLayout);
        GridData toolbarData = new GridData(768);
        toolbarData.horizontalAlignment = 16384;
        this.toolBar.setLayoutData(toolbarData);
        this.toolBar.setBackground(this.whiteColor);
        this.toolBar.setFont(this.fontsManager.getMediumNormalFont());
        this.notificationToolItem = new ToolItem(this.toolBar, 16);
        this.notificationToolItem.setText("  Notifications  ");
        this.notificationToolItem.setToolTipText("Notifications");
        this.notificationHotImageData = new ImageData(BLUSYNC_SYNC_NOW_ICON_PATH);
        this.notificationToolItem.setImage(new Image((Device)Display.getCurrent(), this.notificationHotImageData));
        this.notificationToolItem.setSelection(true);
        this.notificationToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ConsolidatedView.this.setDataForCentralArea(4);
            }
        });
        this.accountToolItem = new ToolItem(this.toolBar, 16);
        this.accountToolItem.setText("  Account  ");
        this.accountToolItem.setToolTipText("Account");
        this.accountImageData = new ImageData(BLUSYNC_ACCOUNT_ICON_PATH);
        this.accountToolItem.setImage(new Image((Device)Display.getCurrent(), this.accountImageData.scaledTo(32, 32)));
        this.accountHotImageData = new ImageData(BLUSYNC_ACCOUNT_ICON_PATH);
        this.accountToolItem.setHotImage(new Image((Device)Display.getCurrent(), this.accountHotImageData.scaledTo(32, 32)));
        this.accountToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ConsolidatedView.this.setDataForCentralArea(2);
            }
        });
        if (SettingHelper.isLicenseActive()) {
            this.setDataForCentralArea(2);
            this.setDataForCentralArea(3);
            this.setDataForCentralArea(1);
            this.setDataForCentralArea(0);
            this.setDataForCentralArea(4);
        } else {
            this.setDataForCentralArea(5);
        }
    }

    public void setDataForCentralArea(int menuOption) {
        logger.debug("Repainting the central area " + menuOption);
        if (this.centerWizardPanel == null) {
            this.centerWizardLayout = new StackLayout();
            this.centerWizardLayout.marginWidth = 0;
            this.centerWizardLayout.marginHeight = 0;
            this.centerWizardPanel = new Composite(this.shell, 2052);
            GridData gridData = new GridData(1808);
            this.centerWizardPanel.setLayoutData(gridData);
            this.centerWizardPanel.setLayout(this.centerWizardLayout);
        }
        switch (menuOption) {
            case 0: {
                this.menuSettings();
                break;
            }
            case 1: {
                this.menuBackup();
                break;
            }
            case 2: {
                this.menuAccount();
                break;
            }
            case 3: {
                this.menuMedia();
                break;
            }
            case 4: {
                this.menuNotification();
                break;
            }
            case 5: {
                this.menuLicensce();
                break;
            }
            case 6: {
                this.menuAbout();
                break;
            }
        }
    }

    private void menuSettings() {
        logger.debug("menu option =MENU_SYNC ");
        if (this.preferencesPage == null) {
            this.preferencesPage = new PreferencesView(this.centerWizardPanel);
        }
        this.preferencesPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.preferencesPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuBackup() {
        logger.debug("menu option = MENU_ACTIVITY_HISTORY ");
        if (this.backUpFolderView == null) {
            this.backUpFolderView = new BackUpPreferenceView(this.centerWizardPanel);
        }
        this.backUpFolderView.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.backUpFolderView.getBaseGroup();
        this.centerWizardPanel.layout();
        this.backUpFolderView.startBackupTimer();
    }

    private void menuAccount() {
        logger.debug("menu option = MENU_ACCOUNT ");
        if (this.accountManagementPage == null) {
            this.accountManagementPage = new AccountManagementView(this.centerWizardPanel);
            this.accountManagementPage.generateUI();
            this.accountManagementPage.generateUISupportdata();
        }
        this.accountManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.accountManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuMedia() {
        logger.debug("menu option = MENU_MEDIA ");
        if (this.mediaManagementPage == null) {
            this.mediaManagementPage = new MediaManagementView(this.centerWizardPanel);
        }
        this.mediaManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.mediaManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    private void menuNotification() {
        logger.debug("menu option = MENU_NOTIFICATION ");
        if (this.notificationPage == null) {
            this.notificationPage = new NotificationView(this.centerWizardPanel);
        }
        this.notificationPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.notificationPage.getBaseGroup();
        this.centerWizardPanel.layout();
        this.notificationPage.startNotificationTimerTask();
    }

    private void menuLicensce() {
        logger.debug("menu option = MENU_LICENSE ");
        this.disposeAllStackedCompositePagesOnShell();
        if (this.licenseExpiredViewPage == null) {
            this.licenseExpiredViewPage = new LicenseExpiredView(this.centerWizardPanel);
        }
        this.licenseExpiredViewPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.licenseExpiredViewPage.getBaseGroup();
        this.centerWizardPanel.layout();
        this.toolBar.setEnabled(false);
        this.toolBar.layout();
        this.toolBar.getShell().layout();
    }

    private void menuAbout() {
        logger.debug("menu option = MENU_ABOUT ");
        if (this.accountManagementPage == null) {
            this.accountManagementPage = new AccountManagementView(this.centerWizardPanel);
            this.accountManagementPage.generateAboutUI();
            this.accountManagementPage.generateAboutUISupportdata();
        }
        this.accountManagementPage.getBaseGroup().setParent(this.centerWizardPanel);
        this.centerWizardLayout.topControl = this.accountManagementPage.getBaseGroup();
        this.centerWizardPanel.layout();
    }

    public void close(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        if (showApplyMessageForSettings) {
            this.askWhetherSettingsChangesAreToBeApplied();
        }
        this.setImageDataObjectsToNull();
        this.disposeAllToolBarWidgets();
        this.disposeAllStackedCompositePagesOnShell();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
        uilock = false;
    }

    private void disposeAllStackedCompositePagesOnShell() {
        if (this.preferencesPage != null && this.preferencesPage.mainParentComposite != null) {
            this.preferencesPage.disposeAllSettings();
            this.preferencesPage = null;
        }
        if (this.backUpFolderView != null && this.backUpFolderView.mainParentComposite != null) {
            this.backUpFolderView.disoposeAllWidgets();
            this.backUpFolderView = null;
        }
        if (this.accountManagementPage != null && this.accountManagementPage.mainParentComposite != null) {
            this.accountManagementPage.disposeAllAccountWidgets();
            this.accountManagementPage = null;
        }
        if (this.mediaManagementPage != null && this.mediaManagementPage.mainParentComposite != null) {
            this.mediaManagementPage.disposeAllMediaWidgets();
            this.mediaManagementPage = null;
        }
        if (this.notificationPage != null && this.notificationPage.mainParentComposite != null) {
            this.notificationPage.disposeAllNotification();
            this.notificationPage = null;
        }
        if (this.licenseExpiredViewPage != null && this.licenseExpiredViewPage.mainParentComposite != null) {
            this.licenseExpiredViewPage.disposeAllLicenseViewFields();
            this.licenseExpiredViewPage = null;
        }
    }

    private void disposeAllToolBarWidgets() {
        this.fontsManager.disposeFonts();
        if (this.settingsToolItem != null) {
            if (this.settingsToolItem.getImage() != null) {
                this.settingsToolItem.getImage().dispose();
            }
            if (this.settingsToolItem.getHotImage() != null) {
                this.settingsToolItem.getHotImage().dispose();
            }
            this.settingsToolItem.dispose();
        }
        if (this.backupToolItem != null) {
            if (this.backupToolItem.getImage() != null) {
                this.backupToolItem.getImage().dispose();
            }
            if (this.backupToolItem.getHotImage() != null) {
                this.backupToolItem.getHotImage().dispose();
            }
            this.backupToolItem.dispose();
        }
        if (this.accountToolItem != null) {
            if (this.accountToolItem.getImage() != null) {
                this.accountToolItem.getImage().dispose();
            }
            if (this.accountToolItem.getHotImage() != null) {
                this.accountToolItem.getHotImage().dispose();
            }
            this.accountToolItem.dispose();
        }
        if (this.mediaToolItem != null) {
            if (this.mediaToolItem.getImage() != null) {
                this.mediaToolItem.getImage().dispose();
            }
            if (this.mediaToolItem.getHotImage() != null) {
                this.mediaToolItem.getHotImage().dispose();
            }
            this.mediaToolItem.dispose();
        }
        if (this.notificationToolItem != null) {
            if (this.notificationToolItem.getImage() != null) {
                this.notificationToolItem.getImage().dispose();
            }
            if (this.notificationToolItem.getHotImage() != null) {
                this.notificationToolItem.getHotImage().dispose();
            }
            this.notificationToolItem.dispose();
        }
        this.toolBar.dispose();
    }

    private void setImageDataObjectsToNull() {
        this.shellImageData = null;
        this.notificationHotImageData = null;
        this.accountImageData = null;
        this.accountHotImageData = null;
    }

    private void askWhetherSettingsChangesAreToBeApplied() {
        int backupFrequencyMinutes;
        int backupFrequencyHours;
        int backupFrequencyDays;
        int syncFrequencyMinutes;
        int syncFrequencyHours;
        int backupFrequency;
        boolean backupFreqeuncyChanged = false;
        boolean syncFreqeuncyChanged = false;
        int syncFrequency = SettingHelper.getCheckParacloudForUpdateTimerInMins();
        int newbackupFrequency = backupFrequency = SettingHelper.getBackUpIntervalInMins();
        int newSyncFrequency = syncFrequency;
        if (this.preferencesPage.syncFrequencyMinutesCombo != null && this.preferencesPage.syncFrequencyHoursCombo != null && this.preferencesPage.syncFrequencyMinutesCombo.isEnabled() && (newSyncFrequency = (syncFrequencyHours = Integer.parseInt(this.preferencesPage.syncFrequencyHoursCombo.getItem(this.preferencesPage.syncFrequencyHoursCombo.getSelectionIndex())) * 60) + (syncFrequencyMinutes = Integer.parseInt(this.preferencesPage.syncFrequencyMinutesCombo.getItem(this.preferencesPage.syncFrequencyMinutesCombo.getSelectionIndex())))) != syncFrequency) {
            syncFreqeuncyChanged = true;
        }
        if (this.backUpFolderView.backupFrequencyHoursCombo != null && this.backUpFolderView.backupFrequencyMinutesCombo != null && this.backUpFolderView.backupFrequencyDaysCombo != null && this.backUpFolderView.backupFrequencyHoursCombo.isEnabled() && backupFrequency != (newbackupFrequency = (backupFrequencyDays = Integer.parseInt(this.backUpFolderView.backupFrequencyDaysCombo.getItem(this.backUpFolderView.backupFrequencyDaysCombo.getSelectionIndex())) * 24 * 60) + (backupFrequencyHours = Integer.parseInt(this.backUpFolderView.backupFrequencyHoursCombo.getItem(this.backUpFolderView.backupFrequencyHoursCombo.getSelectionIndex())) * 60) + (backupFrequencyMinutes = Integer.parseInt(this.backUpFolderView.backupFrequencyMinutesCombo.getItem(this.backUpFolderView.backupFrequencyMinutesCombo.getSelectionIndex()))))) {
            backupFreqeuncyChanged = true;
        }
        if (backupFreqeuncyChanged || syncFreqeuncyChanged) {
            MessageBox msg = new MessageBox(this.shell, 196);
            msg.setMessage("Do you want to save your changes?");
            int confirmationValue = msg.open();
            if (confirmationValue == 64) {
                SettingHelper.setTempCheckParacloudForUpdateTimerInMins(newSyncFrequency);
                SettingHelper.setTempBackUpIntervalInMins(newbackupFrequency);
                SettingHelper.applyChangesToSharedPreferences(true);
                logger.debug("Settings applied");
            } else {
                SettingHelper.refresh();
            }
        }
    }

    public static synchronized boolean isUilock() {
        return uilock;
    }

    public static synchronized void setUilock(boolean uilock) {
        ConsolidatedView.uilock = uilock;
    }

    public void openShell() {
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.numColumns = 1;
        shellGridLayout.marginRight = 0;
        this.shell.setLayout(shellGridLayout);
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.shell.setImage(this.shellImage);
        this.generateUI();
        Listener listener = event -> {
            logger.debug("BluSync UI Close action called from UIMain");
            this.close(true);
        };
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
    }

    public void openAboutshell() {
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.numColumns = 1;
        shellGridLayout.marginRight = 0;
        this.shell.setLayout(shellGridLayout);
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.shell.setImage(this.shellImage);
        this.generateAboutUI();
        Listener listener = event -> {
            logger.debug("BluSync UI Close action called from UIMain");
            this.closeUi(true);
        };
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
    }

    private void generateAboutUI() {
        logger.debug("Structuring BluSync Settings/Preferences User Interface");
        int imageAccountHorizontalSize = 32;
        int imageAccountVerticalSize = 32;
        Display display = this.shell.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.toolBar = new ToolBar(this.shell, 0x1000000);
        GridLayout toolBarGridLayout = new GridLayout();
        toolBarGridLayout.marginLeft = 0;
        toolBarGridLayout.marginTop = 0;
        toolBarGridLayout.marginBottom = 0;
        toolBarGridLayout.marginWidth = 0;
        toolBarGridLayout.marginHeight = 0;
        this.toolBar.setLayout(toolBarGridLayout);
        GridData toolbarData = new GridData(768);
        toolbarData.horizontalAlignment = 16384;
        this.toolBar.setLayoutData(toolbarData);
        this.toolBar.setBackground(this.whiteColor);
        this.toolBar.setFont(this.fontsManager.getMediumNormalFont());
        this.aboutToolItem = new ToolItem(this.toolBar, 16);
        this.aboutToolItem.setText("");
        this.aboutToolItem.setToolTipText("Account");
        if (SettingHelper.isLicenseActive()) {
            this.setDataForCentralArea(6);
        } else {
            this.setDataForCentralArea(5);
        }
    }

    public void closeUi(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        this.setImageDataObjectsToNull();
        this.disposeAboutToolBarWidgets();
        this.disposeAboutStackedCompositePagesOnShell();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
        uilock = false;
    }

    private void disposeAboutStackedCompositePagesOnShell() {
        if (this.accountManagementPage != null && this.accountManagementPage.mainParentComposite != null) {
            this.accountManagementPage.disposeAllAccountWidgets();
            this.accountManagementPage = null;
        }
        if (this.licenseExpiredViewPage != null && this.licenseExpiredViewPage.mainParentComposite != null) {
            this.licenseExpiredViewPage.disposeAllLicenseViewFields();
            this.licenseExpiredViewPage = null;
        }
    }

    private void disposeAboutToolBarWidgets() {
        this.fontsManager.disposeFonts();
        if (this.aboutToolItem != null) {
            if (this.aboutToolItem.getImage() != null) {
                this.aboutToolItem.getImage().dispose();
            }
            if (this.aboutToolItem.getHotImage() != null) {
                this.aboutToolItem.getHotImage().dispose();
            }
            this.aboutToolItem.dispose();
        }
    }
}

