/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackupCheckTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManagerView
extends Shell {
    private static final String LABEL_ROOT = "root";
    String token = null;
    File currentParentFile = null;
    Text lblNewLabel = null;
    org.eclipse.swt.widgets.List list1 = null;
    private Table table;
    private Image shellImage = null;
    private ImageData shellImageData = null;
    private Image img = null;
    private Image imageLeft = null;
    private Image imageRight = null;
    private Image imageBack = null;
    private FontsManager fontsManager;
    private BackupAdapter backupAdapter;
    private static final String RESOURCE = "resource";
    private static String rightImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + StringLiterals.FILE_SEPARATOR + "img" + StringLiterals.FILE_SEPARATOR + "glyphicons_223_chevron-right.png";
    private static String leftImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + StringLiterals.FILE_SEPARATOR + "img" + StringLiterals.FILE_SEPARATOR + "glyphicons_224_chevron-left.png";
    private static String backImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + StringLiterals.FILE_SEPARATOR + "img" + StringLiterals.FILE_SEPARATOR + "glyphicons_221_unshare.png";
    private Set<BackupFolderTO> backupFolderTOsExistingFolderPaths;
    private Set<String> rootFilesList;
    private List<File> filesAddedToBackup;
    private List<BackupFolderTO> filesToRemove;
    private final BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    private Logger logger = LoggerFactory.getLogger(BackupManagerView.class);
    private Button btnNewButton;
    private static final String DEVICE_CREDENTIALS_WARNING = "Device credentials expired, please re-login to your cloud.";
    private static final String AUTHORIZTION_FAILED = "Authoriztion failed";
    protected static final String MAC = "Macintosh";
    private Button btnCancelButton;

    public BackupManagerView(Shell shell) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        super(shell, 65632);
        this.filesAddedToBackup = new ArrayList<File>();
        this.filesToRemove = new ArrayList<BackupFolderTO>();
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        this.fontsManager = new FontsManager(this.getDisplay());
        this.readExistingBackupFiles();
        this.logger.info("after reading Existing Backup Files");
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 10;
        this.setLayout(gridLayout);
        this.setLocation(shell.getLocation());
        this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.img = new Image((Device)shell.getDisplay(), new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_FOLDER_ICON).scaledTo(16, 16));
        this.imageLeft = new Image((Device)shell.getDisplay(), new ImageData(leftImageLocation).scaledTo(16, 16));
        this.imageRight = new Image((Device)shell.getDisplay(), new ImageData(rightImageLocation).scaledTo(16, 16));
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(16, 12));
        Listener listener = arg0 -> this.disposeImagesAndFonts();
        this.addListener(21, listener);
        Label lblNewLabel3 = new Label(this, 64);
        GridData gdLblNewLabel3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblNewLabel3.widthHint = 425;
        gdLblNewLabel3.heightHint = 30;
        lblNewLabel3.setLayoutData(gdLblNewLabel3);
        lblNewLabel3.setText("Select a folder and click add to include the folder for backup. Double click any folder to view its subfolders.");
        lblNewLabel3.setFont(this.fontsManager.getMediumNormalFont());
        Composite composite = new Composite(this, 0);
        GridLayout glComposite = new GridLayout(3, false);
        glComposite.horizontalSpacing = 0;
        glComposite.marginHeight = 0;
        glComposite.marginWidth = 0;
        composite.setLayout(glComposite);
        GridData gdComposite = new GridData(4, 4, false, false, 1, 1);
        gdComposite.widthHint = 430;
        gdComposite.heightHint = 225;
        composite.setLayoutData(gdComposite);
        Composite composite1 = new Composite(composite, 0);
        GridLayout glComposite1 = new GridLayout(1, false);
        glComposite1.verticalSpacing = 0;
        glComposite1.marginWidth = 0;
        glComposite1.marginHeight = 0;
        composite1.setLayout(glComposite1);
        GridData gdComposite1 = new GridData(4, 4, false, true, 1, 1);
        gdComposite1.widthHint = 177;
        gdComposite1.heightHint = 223;
        composite1.setLayoutData(gdComposite1);
        Composite composite5 = new Composite(composite1, 2048);
        GridLayout glComposite5 = new GridLayout(3, false);
        glComposite5.horizontalSpacing = 1;
        glComposite5.marginWidth = 0;
        glComposite5.marginHeight = 0;
        composite5.setLayout(glComposite5);
        GridData gdComposite5 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdComposite5.widthHint = 173;
        gdComposite5.heightHint = 27;
        composite5.setLayoutData(gdComposite5);
        Button btnNewButton3 = new Button(composite5, 0);
        btnNewButton3.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (BackupManagerView.this.currentParentFile == null) {
                    BackupManagerView.this.logger.debug("currentParentFile is null");
                    return;
                }
                BackupManagerView.this.currentParentFile = BackupManagerView.this.currentParentFile.getParentFile();
                if (BackupManagerView.this.currentParentFile == null) {
                    BackupManagerView.this.table.removeAll();
                    BackupManagerView.this.addDefaultItemsToTable();
                    BackupManagerView.this.lblNewLabel.setText(BackupManagerView.LABEL_ROOT);
                    BackupManagerView.this.lblNewLabel.getParent().layout();
                } else {
                    BackupManagerView.this.lblNewLabel.setText(BackupManagerView.this.currentParentFile.getAbsolutePath());
                    File[] allFilesInSubFolder = BackupManagerView.this.currentParentFile.listFiles();
                    BackupManagerView.this.table.removeAll();
                    if (allFilesInSubFolder == null) {
                        return;
                    }
                    for (File file : allFilesInSubFolder) {
                        if (!file.isDirectory()) continue;
                        TableItem tableItem = new TableItem(BackupManagerView.this.table, 0);
                        tableItem.setData(file);
                        tableItem.setImage(BackupManagerView.this.img);
                        tableItem.setText(file.getName());
                    }
                }
            }
        });
        GridData gdBtnNewButton3 = new GridData(4, 4, false, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 40;
        btnNewButton3.setLayoutData(gdBtnNewButton3);
        btnNewButton3.setText("");
        btnNewButton3.setFont(this.fontsManager.getMediumNormalFont());
        btnNewButton3.setImage(this.imageBack);
        Label lblNewLabel2 = new Label(composite5, 2);
        lblNewLabel2.setLayoutData(new GridData(16384, 128, false, true, 1, 2));
        this.lblNewLabel = new Text(composite5, 2056);
        GridData gdLblNewLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        gdLblNewLabel.heightHint = 17;
        gdLblNewLabel.widthHint = 120;
        this.lblNewLabel.setLayoutData(gdLblNewLabel);
        if (this.currentParentFile == null) {
            this.lblNewLabel.setText(LABEL_ROOT);
        } else {
            this.lblNewLabel.setText(this.currentParentFile.getAbsolutePath());
        }
        this.lblNewLabel.setFont(this.fontsManager.getMediumNormalFont());
        new Label(composite5, 0);
        new Label(composite5, 0);
        this.table = new Table(composite1, 67584);
        this.table.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.table.setLinesVisible(false);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent arg0) {
            }

            @Override
            public void mouseDown(MouseEvent arg0) {
            }

            @Override
            public void mouseDoubleClick(MouseEvent event) {
                TableItem[] items = BackupManagerView.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                BackupManagerView.this.currentParentFile = (File)items[0].getData();
                BackupManagerView.this.lblNewLabel.setText(BackupManagerView.this.currentParentFile.getAbsolutePath());
                BackupManagerView.this.lblNewLabel.setFont(BackupManagerView.this.fontsManager.getMediumNormalFont());
                BackupManagerView.this.lblNewLabel.getParent().layout();
                File[] files = BackupManagerView.this.currentParentFile.listFiles();
                BackupManagerView.this.table.removeAll();
                if (files == null) {
                    return;
                }
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    TableItem tableItem = new TableItem(BackupManagerView.this.table, 0);
                    tableItem.setData(file);
                    tableItem.setImage(BackupManagerView.this.img);
                    tableItem.setText(file.getName());
                }
            }
        });
        TableColumn tblclmnNewColumn = new TableColumn(this.table, 0);
        tblclmnNewColumn.setImage(null);
        tblclmnNewColumn.setWidth(173);
        tblclmnNewColumn.setText("New Column");
        this.addDefaultItemsToTable();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout(1, false);
        composite2.setLayout(gridLayout2);
        GridData gdComposite2 = new GridData(4, 4, false, true, 1, 1);
        gdComposite2.widthHint = 80;
        composite2.setLayoutData(gdComposite2);
        new Label(composite2, 0);
        new Label(composite2, 0);
        new Label(composite2, 0);
        Button btnNewButton1 = new Button(composite2, 0);
        btnNewButton1.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] tableItems = BackupManagerView.this.table.getSelection();
                if (tableItems == null || tableItems.length == 0) {
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Please select a folder and try again");
                    messageBox.setText("No folder selected");
                    messageBox.open();
                    return;
                }
                File selectedItem = (File)tableItems[0].getData();
                if (BackupManagerView.this.rootFilesList.contains(selectedItem.getAbsolutePath())) {
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("Root folders are not allowed for backup.");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                for (BackupFolderTO backupFolderTO : BackupManagerView.this.backupFolderTOsExistingFolderPaths) {
                    boolean isParentFolder = backupFolderTO.getFolderPath().contains(BackupManagerView.MAC + selectedItem.getAbsolutePath() + StringLiterals.FILE_SEPARATOR);
                    boolean isSameFolder = backupFolderTO.getFolderPath().equals(BackupManagerView.MAC + selectedItem.getAbsolutePath());
                    boolean isChildFolder = (BackupManagerView.MAC + selectedItem.getAbsolutePath()).equals(backupFolderTO.getFolderPath());
                    boolean isChildFolder2 = (BackupManagerView.MAC + selectedItem.getAbsolutePath()).contains(backupFolderTO.getFolderPath() + StringLiterals.FILE_SEPARATOR);
                    if (isParentFolder && !isSameFolder) {
                        MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                        messageBox.setMessage("Sub-folder of " + selectedItem.getName() + " already exists, remove the folder(" + new File(backupFolderTO.getFolderPath()).getName() + ") first.");
                        messageBox.setText("Invalid selection");
                        messageBox.open();
                        return;
                    }
                    if (isSameFolder) {
                        MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                        messageBox.setMessage("Folder already added for Backup");
                        messageBox.setText("Folder already exists");
                        messageBox.open();
                        return;
                    }
                    if (!isChildFolder && !isChildFolder2) continue;
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("The current folder or one of its parent folders seems to have already been selected for backup.");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                BackupManagerView.this.filesAddedToBackup.add(selectedItem);
                BackupFolderTO backupFolderTO = new BackupFolderTO();
                backupFolderTO.setFolderPath(BackupManagerView.MAC + selectedItem.getAbsolutePath());
                BackupManagerView.this.logger.debug(BackupManagerView.MAC + selectedItem.getAbsolutePath());
                backupFolderTO.setLastSyncTime(0L);
                BackupManagerView.this.backupFolderTOsExistingFolderPaths.add(backupFolderTO);
                BackupManagerView.this.list1.add(BackupManagerView.MAC + selectedItem.getAbsolutePath());
                BackupManagerView.this.list1.getParent().layout();
            }
        });
        GridData gdBtnNewButton1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnNewButton1.heightHint = 23;
        gdBtnNewButton1.widthHint = 69;
        btnNewButton1.setLayoutData(gdBtnNewButton1);
        btnNewButton1.setText("ADD");
        btnNewButton1.setFont(this.fontsManager.getMediumNormalFont());
        new Label(composite2, 0);
        Button btnNewButton2 = new Button(composite2, 0);
        btnNewButton2.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                String[] strings = BackupManagerView.this.list1.getSelection();
                if (strings == null || strings.length == 0) {
                    BackupManagerView.this.logger.debug("list of selected folders is empty");
                    return;
                }
                BackupFolderTO file = new BackupFolderTO();
                file.setFolderPath(strings[0]);
                for (BackupFolderTO backupFolderTO : BackupManagerView.this.backupFolderTOsExistingFolderPaths) {
                    if (backupFolderTO.getCreateBy() == null || !"IA".equalsIgnoreCase(backupFolderTO.getCreateBy()) || !backupFolderTO.getFolderPath().equalsIgnoreCase(file.getFolderPath())) continue;
                    BackupManagerView.this.logger.debug("Admin Added Folder From Policy can't remove");
                    MessageBox messageBox = new MessageBox(BackupManagerView.this.getShell(), 32);
                    messageBox.setMessage("This is a default folder added by your Administrator and cannot be removed.");
                    messageBox.setText("Invalid selection");
                    messageBox.open();
                    return;
                }
                BackupManagerView.this.logger.debug(file.getFolderPath());
                BackupManagerView.this.list1.remove(strings[0]);
                BackupManagerView.this.backupFolderTOsExistingFolderPaths.remove(file);
                BackupManagerView.this.filesAddedToBackup.remove(new File(file.getFolderPath()));
                BackupManagerView.this.filesToRemove.add(file);
            }
        });
        GridData gdBtnNewButton2 = new GridData(0x1000000, 4, false, false, 1, 1);
        gdBtnNewButton2.heightHint = 26;
        gdBtnNewButton2.widthHint = 80;
        btnNewButton2.setLayoutData(gdBtnNewButton2);
        btnNewButton2.setText("REMOVE");
        Composite composite3 = new Composite(composite, 0);
        GridLayout glComposite3 = new GridLayout(1, false);
        glComposite3.marginHeight = 0;
        glComposite3.marginWidth = 0;
        glComposite3.verticalSpacing = 0;
        composite3.setLayout(glComposite3);
        GridData gdComposite3 = new GridData(4, 4, false, true, 1, 1);
        gdComposite3.widthHint = 170;
        composite3.setLayoutData(gdComposite3);
        Composite composite6 = new Composite(composite3, 2048);
        GridLayout glComposite6 = new GridLayout(1, false);
        glComposite6.marginLeft = 5;
        composite6.setLayout(glComposite6);
        GridData gdComposite6 = new GridData(4, 4, true, false, 1, 1);
        gdComposite6.widthHint = 151;
        gdComposite6.heightHint = 27;
        composite6.setLayoutData(gdComposite6);
        Label lblNewLabel1 = new Label(composite6, 0);
        lblNewLabel1.setToolTipText("The list of folders selected for Backup");
        GridData gdLblNewLabel1 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdLblNewLabel1.heightHint = 16;
        gdLblNewLabel1.widthHint = 121;
        lblNewLabel1.setLayoutData(gdLblNewLabel1);
        lblNewLabel1.setText("Selected Folders");
        lblNewLabel1.setFont(this.fontsManager.getMediumNormalFont());
        this.list1 = new org.eclipse.swt.widgets.List(composite3, 2816);
        GridData gdList1 = new GridData(4, 4, false, true, 1, 1);
        gdList1.widthHint = 150;
        gdList1.heightHint = 101;
        this.list1.setLayoutData(gdList1);
        this.list1.setFont(this.fontsManager.getMediumNormalFont());
        this.addDefaultItemsToList();
        Composite composite4 = new Composite(this, 0);
        composite4.setLayout(null);
        GridData gdComposite4 = new GridData(4, 4, false, false, 1, 1);
        gdComposite4.heightHint = 49;
        composite4.setLayoutData(gdComposite4);
        this.btnNewButton = new Button(composite4, 0);
        this.btnNewButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                BackupManagerView.this.saveSettings();
            }
        });
        this.btnNewButton.setBounds(270, 10, 70, 25);
        this.btnNewButton.setText(" Save ");
        this.btnNewButton.setFont(this.fontsManager.getMediumNormalFont());
        this.btnCancelButton = new Button(composite4, 0);
        this.btnCancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                BackupManagerView.this.cancelSettings();
            }
        });
        this.btnCancelButton.setBounds(340, 10, 70, 25);
        this.btnCancelButton.setText(" Cancel ");
        this.btnCancelButton.setFont(this.fontsManager.getMediumNormalFont());
        this.createContents();
    }

    private void addDefaultItemsToList() {
        this.list1.removeAll();
        for (BackupFolderTO backupFolderTO : this.backupFolderTOsExistingFolderPaths) {
            this.list1.add(backupFolderTO.getFolderPath());
        }
    }

    private void readExistingBackupFiles() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.token = SettingHelper.readTokenFromFile();
        this.backupFolderTOsExistingFolderPaths = new HashSet<BackupFolderTO>();
        List<BackupFolderTO> backupFolderList = this.backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        if (backupFolderList == null || backupFolderList.isEmpty()) {
            this.logger.debug("backupFolderList is empty");
            return;
        }
        for (BackupFolderTO backupFolderTO : backupFolderList) {
            this.backupFolderTOsExistingFolderPaths.add(backupFolderTO);
        }
    }

    private void addDefaultItemsToTable() {
        if (this.rootFilesList != null) {
            this.rootFilesList.clear();
        } else {
            this.rootFilesList = new HashSet<String>();
        }
        File[] files = File.listRoots();
        this.currentParentFile = null;
        for (File file : files) {
            this.rootFilesList.add(file.getAbsolutePath());
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setData(file);
            tableItem.setImage(this.img);
            tableItem.setText(file.getAbsolutePath());
        }
    }

    private BackupElement createBackupElement(File file) {
        this.logger.info("creating BackupElement: " + file.getName());
        BackupElement backupElement = new BackupElement();
        backupElement.setBaseFolder(true);
        backupElement.setClientData(file.getAbsolutePath());
        backupElement.setFileName(file.getName());
        backupElement.setFileCompletePath(MAC + file.getParentFile().getAbsolutePath());
        backupElement.setExists(true);
        backupElement.setFolder(true);
        backupElement.setLastModifiedTimestamp(file.lastModified());
        backupElement.setMd5checksum("null");
        backupElement.setSize("0");
        return backupElement;
    }

    protected void saveSettings() {
        this.btnNewButton.setText("Saving..");
        this.btnNewButton.setEnabled(false);
        Runnable runnable = () -> {
            this.removeAllFoldersNotToBeBackedup();
            this.addSelectedBackedupFolder();
            Runnable runbl = () -> this.getShell().close();
            this.getDisplay().asyncExec(runbl);
        };
        new Thread(runnable).start();
    }

    private void showMessage(String text, String message) {
        if (this.getDisplay() == null || this.getDisplay().isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            MessageBox messageBox = new MessageBox(this.getShell(), 8);
            messageBox.setText(text);
            messageBox.setMessage(message);
            messageBox.open();
        };
        this.getDisplay().syncExec(runnable);
    }

    private void removeAllFoldersNotToBeBackedup() {
        for (BackupFolderTO file : this.filesToRemove) {
            if (this.backUpFolderDAOImpl.removeAParentFolder(file)) {
                this.logger.debug("removed parent folder");
                continue;
            }
            this.logger.debug("remove parent folder failed");
        }
    }

    private BackupCheckTO saveBackupConfigurationSettings(File selectedItem) {
        BackupElement backupElement = this.createBackupElement(selectedItem);
        BackupCheckTO backupCheckTO = null;
        try {
            backupCheckTO = this.backupAdapter.addFolderToBackup(SettingHelper.getCurrentCloudIpAddress(), null, CreateXmlObject.createBackupElementXml(backupElement), this.token);
            if (SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && backupCheckTO == null && SettingHelper.getHttpsPort() != null) {
                backupCheckTO = this.backupAdapter.addFolderToBackup(SettingHelper.getCurrentCloudIpAddress(), Integer.valueOf(SettingHelper.getHttpsPort()), CreateXmlObject.createBackupElementXml(backupElement), this.token);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in addFolderToBackup, backupAdapter: ", e);
        }
        return backupCheckTO;
    }

    private void addSelectedBackedupFolder() {
        ArrayList<String> partialFolderUploadFailure = new ArrayList<String>();
        boolean status = true;
        for (File file : this.filesAddedToBackup) {
            BackupCheckTO backupCheckTO = this.saveBackupConfigurationSettings(file);
            if (backupCheckTO == null) {
                this.showMessage("Failed to add folders", "Cannot connect to the server. Please check the network connection and try again. If the problem persists, please contact your Administrator.");
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 417) {
                this.showMessage("User Limit Exceeded", "The storage space limit for backup has been reached");
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 421) {
                this.showMessage(AUTHORIZTION_FAILED, DEVICE_CREDENTIALS_WARNING);
                status = false;
                break;
            }
            if (backupCheckTO.getResponseCode() == 401) {
                this.showMessage(AUTHORIZTION_FAILED, DEVICE_CREDENTIALS_WARNING);
                status = false;
                break;
            }
            if (backupCheckTO.isConflict()) {
                BackupElement backupElement2 = Xmlparser.parseBackupElementResponse(backupCheckTO.getBackupElementXml());
                partialFolderUploadFailure.add(backupElement2.getFileName());
                continue;
            }
            BackupFolderTO backupFolderTO = new BackupFolderTO();
            backupFolderTO.setFolderPath(MAC + file.getAbsolutePath());
            this.logger.debug(MAC + file.getAbsolutePath());
            backupFolderTO.setLastSyncTime(0L);
            if (this.backUpFolderDAOImpl.insertAParentFolder(backupFolderTO)) continue;
            this.logger.debug("couldnt insertAParentFolder");
        }
        if (status && !partialFolderUploadFailure.isEmpty()) {
            this.showMessage("Conflict detected", "A folder name conflict has been detected while adding the selected folders.\nPlease ensure that the selected folder names are unique.");
        }
    }

    protected void createContents() {
        this.setText("Backup Manager");
        this.setImage(this.shellImage);
        this.pack();
    }

    protected void disposeImagesAndFonts() {
        if (this.img != null) {
            this.img.dispose();
            this.img = null;
        }
        if (this.imageLeft != null) {
            this.imageLeft.dispose();
            this.imageLeft = null;
        }
        if (this.imageRight != null) {
            this.imageRight.dispose();
            this.imageRight = null;
        }
        if (this.imageBack != null) {
            this.imageBack.dispose();
            this.imageBack = null;
        }
        if (this.shellImage != null) {
            this.shellImage.dispose();
            this.shellImage = null;
        }
        this.fontsManager.disposeFonts();
    }

    @Override
    protected void checkSubclass() {
    }

    protected void cancelSettings() {
        this.btnCancelButton.setEnabled(false);
        Runnable runnable = () -> {
            Runnable runner = () -> this.getShell().close();
            this.getDisplay().asyncExec(runner);
        };
        new Thread(runnable).start();
    }
}

