/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.sync;

import com.parablu.epa.common.dao.ImageTableHistoryImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.sync.MultiThreadSyncUploadJob;
import com.parablu.epa.common.service.sync.SyncDownloadJob;
import com.parablu.epa.common.service.sync.SyncJob;
import com.parablu.epa.common.service.sync.SyncMediaUploadJob;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.dao.MacImageHistoryDaoImpl;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.service.sync.MacSyncDownloadJob;
import com.parablu.epa.service.sync.MacSyncMediaUploadJob;
import com.parablu.epa.service.sync.MacSyncUploadJob;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacSyncJob
extends SyncJob {
    private SyncDownloadJob dt;
    private MultiThreadSyncUploadJob ut;
    private SyncMediaUploadJob mt = null;
    private Logger logger = LoggerFactory.getLogger(MacSyncJob.class);

    @Override
    protected void crawlFinPostProcessor(String uploadCount, String downloadcount) {
        MacImageHistoryDaoImpl imageTableListDao = new MacImageHistoryDaoImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        String oldestImageTableName = imageTableListDao.getOldestImageTableName();
        this.logger.debug("deleteing oldest image table" + oldestImageTableName);
        if (oldestImageTableName != null && !oldestImageTableName.equals(this.currentImageTableName)) {
            this.logger.debug("Deleting the oldest image table");
            ActivityTO activityTO = new ActivityTO();
            activityTO.setActivityID(this.acitivityId);
            activityTO.setActivityName(CrawlLifecycle.FINISHED.name());
            activityTO.setUploadCount(uploadCount);
            activityTO.setDownloadCount(downloadcount);
            activityTO.setActivityTimeStamp(new Date(Long.parseLong(this.crawlTimeStamp)));
            ((ImageTableHistoryImpl)imageTableListDao).deleteImageTable(oldestImageTableName, activityTO);
            File delTable = new File(this.baseURlForImageTables + StringLiterals.FILE_SEPARATOR + oldestImageTableName);
            if (delTable.exists()) {
                delTable.delete();
            }
        } else {
            this.addOrUpdateToActivityHistory(this.acitivityId, CrawlLifecycle.FINISHED.name(), uploadCount, downloadcount, true);
        }
    }

    @Override
    protected void getAndDeleteCurrentImageTable(ActivityTO activityto) {
        MacImageHistoryDaoImpl imageTableListDao = new MacImageHistoryDaoImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        String curImageTableName = imageTableListDao.getCurrentImageTableName();
        if (curImageTableName != null) {
            this.logger.debug("Deleting the current image table");
            ((ImageTableHistoryImpl)imageTableListDao).deleteImageTable(curImageTableName, activityto);
            File delTable = new File(this.baseURlForImageTables + StringLiterals.FILE_SEPARATOR + curImageTableName);
            if (delTable.exists()) {
                delTable.delete();
            }
        }
    }

    @Override
    protected ImageTableHistoryImpl createCurrentImageTable() throws DatabaseException {
        this.logger.debug("creating CurrentImageTable");
        MacImageHistoryDaoImpl imageTableListDao = new MacImageHistoryDaoImpl(this.imageTableHistoryDBURL, this.crawlTimeStamp, this.baseURlForImageTables);
        this.createImageTableAndUpdateActivity(imageTableListDao);
        this.previousImageTableName = imageTableListDao.getPreviousImageTableName();
        this.lastSuccessfulCrawlTimeStamp = this.getLastSuccessfullCrawlTimestamp(this.previousImageTableName);
        this.logger.debug("The previous image table name is :" + this.previousImageTableName);
        this.logger.debug("The current image table name is:" + this.currentImageTableName);
        return imageTableListDao;
    }

    @Override
    public void startUploadDownload() throws InterruptedException {
        this.logger.debug("Starting Upload Download Threads");
        String cloudIP = SettingHelper.getCurrentCloudIpAddress();
        GatewayTO gatewayTo = SettingHelper.getSyncUploadIpAddress();
        this.logger.debug("-------------------------------");
        this.logger.debug("IP " + cloudIP + "    cloudNAme " + SettingHelper.getCloudName());
        this.logger.debug("SettingService.getRegristrationID() " + SettingHelper.getRegristrationID());
        this.logger.debug("GATEWAY  NAME: " + gatewayTo.getGatewayName());
        this.logger.debug("Setiin Helper Gateway : " + SettingHelper.getSyncUploadIpAddress());
        this.logger.debug("-------------------------------");
        String currentImageTablePath = new StringBuffer().append(this.baseURlForImageTables).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(this.currentImageTableName).toString();
        this.dt = new MacSyncDownloadJob(cloudIP, this.currentPort, SettingHelper.getCloudName(), this.downloadTableURL, this.deviceUserPath, currentImageTablePath, this.crawlTimeStamp, this.baseURlForImageTables, this.currentImageTableName, this.token, SettingHelper.getKeystorePath(), gatewayTo.getGatewayName());
        this.ut = new MacSyncUploadJob(cloudIP, this.currentPort, SettingHelper.getCloudName(), this.uploadTableURL, this.deviceUserPath, currentImageTablePath, this.baseURlForImageTables, this.currentImageTableName, this.token, SettingHelper.getKeystorePath(), gatewayTo);
        this.ut.setName("Upload thread");
        this.dt.setName("Download thread");
        this.dt.start();
        this.ut.start();
        this.dt.join();
        this.ut.join();
    }

    @Override
    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (!NotificationHelper.isBackUpStarted()) {
            UIHelper.updateSystrayImageAccordingToStage(MacSettingsHelper.baseResourceFolder + syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    @Override
    public void updateSystrayToolTipNotification(String string, String string2) {
        UIHelper.updateSystrayToolTipNotification(string, string2);
    }

    @Override
    public void abortUploadAndDownloadProcess() {
        this.logger.debug("aborting Upload And Download Process");
        if (this.dt != null) {
            this.dt.isTerminated = true;
            this.dt.abortDownloadProcesses();
            if (this.dt.isAlive()) {
                this.dt.interrupt();
            }
        }
        if (this.ut != null) {
            this.ut.isTerminated = true;
            this.ut.abortUploadProcesses();
            if (this.ut.isAlive()) {
                this.ut.interrupt();
            }
        }
    }

    @Override
    public void startMediaUpload(List<MediaTO> mediaBackUpList) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.mt = new MacSyncMediaUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), mediaBackUpList, SettingHelper.getMediaDbUrl());
        this.mt.setName("Media Upload");
        this.mt.start();
        this.mt.join();
    }

    @Override
    protected void remapNetworkDrive(ResponseTO arg0, String arg1) {
        if (arg0 != null && SettingHelper.isMediaHubEnabled()) {
            MacSettingsHelper.disconnectWebDAVasNetworkDrive();
            MacSettingsHelper.mapWebDAVasNetworkDrive(SettingHelper.getMediaUserName(), SettingHelper.getMediaPassword());
        }
    }

    @Override
    protected void refreshExplorer() {
    }

    @Override
    public void pauseSync(SyncJob syncUpload) {
        try {
            this.logger.debug("inside pause1111111111 ...");
            if (this.ut != null && this.ut.isAlive()) {
                this.logger.debug("stopping the thread");
                this.ut.interrupt();
                this.logger.debug("Interrupted backup thread");
                this.ut.join(10000L);
                this.ut.interrupt();
            }
            if (syncUpload != null) {
                this.logger.debug("interrupt the thread syncUpload1");
                syncUpload.interrupt();
            }
            if (syncUpload.isAlive()) {
                this.logger.debug("stopping the thread syncUpload1");
                syncUpload.stop();
            }
            this.logger.debug("stopping the thread syncUpload1" + syncUpload.isAlive());
            this.logger.debug("After updating the error code as sync intrupted.............");
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception" + e.getMessage());
        }
    }
}

