/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.backup;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.MultiThreadBackupUpload;
import com.parablu.epa.common.service.backup.NewBackUpJob;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.BackupCrawlUtility;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.backup.MacBackupUploadJob;
import com.parablu.epa.service.backup.MacCheckBackupPolicy;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacBackupJob
extends NewBackUpJob {
    private static Logger logger = LoggerFactory.getLogger(MacBackupJob.class);
    private MultiThreadBackupUpload backUpUpload = null;

    public MacBackupJob(boolean manualVal, boolean isFullBackup) {
        super(manualVal, isFullBackup);
    }

    @Override
    public void startBackUpThread(Set<DedupTO> dedupTOs, boolean restart, long restartId, String backupType) throws InterruptedException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.backUpUpload = new MacBackupUploadJob(SettingHelper.getCurrentCloudIpAddress(), this.currentPort, SettingHelper.getCloudName(), SettingHelper.readTokenFromFile(), SettingHelper.getBackUpDbUrl(), dedupTOs, restart, restartId, backupType);
        this.backUpUpload.setName("BackUpUpload");
        this.backUpUpload.start();
        this.backUpUpload.join();
    }

    @Override
    public void updateSystrayToolTipNotification(String toolTipMessage, String toolTipmessage1) {
        UIHelper.updateSystrayToolTipNotification(toolTipMessage, toolTipmessage1);
    }

    @Override
    protected void scanFileSystemByType(BackupFolderTO backupFolderTO) {
        BackupCrawlUtility backupCrawlUtility = new BackupCrawlUtility();
        backupCrawlUtility.crawlFolderEfficientStoringFullPaths(backupFolderTO.getFolderPath(), null);
    }

    @Override
    public void updateSystrayImageAccordingToStage(String syncingImage) {
        if (NotificationHelper.getMainStatus() == 100) {
            UIHelper.updateSystrayImageAccordingToStage(MacSettingsHelper.baseResourceFolder + syncingImage);
        } else {
            UIHelper.displaySyncingGif();
        }
    }

    @Override
    public void pauseBackup(boolean isManualStop, boolean hardStop, NewBackUpJob newBackUpJob, boolean isActionFromPortal) {
        try {
            BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
            BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
            if (backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString()) && this.backUpUpload != null && this.backUpUpload.isAlive()) {
                logger.debug("stopping the thread");
                this.backUpUpload.interrupt();
                logger.debug("Interrupted backup thread");
                this.backUpUpload.join(10000L);
                this.backUpUpload.interrupt();
            }
            logger.debug("Interrupted backup thread again ismanual stop:" + isManualStop + "is hardStop: " + hardStop);
            if (backupActivityTO.getBatchStatus().equals(BackupLifeCycle.SCANNING.toString()) && newBackUpJob != null) {
                newBackUpJob.interrupt();
            }
            logger.debug("Interrupted backup thread again ismanual stop:" + isManualStop + "is hardStop: " + hardStop + "fromPortal" + isActionFromPortal);
            if (isManualStop && !hardStop && !isActionFromPortal) {
                logger.debug("updating error code as user stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(1992);
            } else if (isManualStop && hardStop && !isActionFromPortal) {
                logger.debug("updating error code as user hard stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(1207);
            } else if (isManualStop && !hardStop && isActionFromPortal) {
                logger.debug("updating error code as user stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(1208);
            } else if (isManualStop && hardStop && isActionFromPortal) {
                logger.debug("updating error code as user hard stopped backup");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(1209);
            }
            logger.debug("After updating the error code as user stopped backup");
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception" + e.getMessage());
        }
    }

    @Override
    public boolean createVsnapshot(List<BackupFolderTO> arg0) {
        return false;
    }

    @Override
    public void deleteVsnapshot(List<BackupFolderTO> arg0) {
    }

    @Override
    public boolean runScripts(String arg0, boolean arg1) {
        return true;
    }

    @Override
    public void startBackupPolicyRefresh() {
        MacCheckBackupPolicy.checkGroupPolicy();
        BlusyncThreadHelper.resetBackupTimer();
    }

    @Override
    public void updateSystrayToolTipNotification() {
        UIHelper.updateSystrayToolTipNotification("Parablu Blusync", "You have no folders configured for backup");
    }

    @Override
    public boolean runCommandUsingService(String arg0, String arg1) {
        return false;
    }
}

