/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.dao;

import com.parablu.epa.common.dao.ImageTableHistoryImpl;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.CrawlDbTo;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacImageHistoryDaoImpl
extends ImageTableHistoryImpl {
    private Logger logger = LoggerFactory.getLogger(MacImageHistoryDaoImpl.class);

    public MacImageHistoryDaoImpl(String connectionURL, String timeStamp, String folderURLOfDB) {
        super(connectionURL, timeStamp, folderURLOfDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrawlDbTo createImageTable(ActivityTO activity) {
        MacImageHistoryDaoImpl macImageHistoryDaoImpl = this;
        synchronized (macImageHistoryDaoImpl) {
            String tableName = null;
            long columnId = 0L;
            String tempActivityName = activity.getActivityName();
            String tempActivityTimeStamp = String.valueOf(activity.getActivityTimeStamp().getTime());
            String tempActivityUpload = activity.getUploadCount();
            String tempActivitydownload = activity.getDownloadCount();
            String batchId = activity.getBatchId();
            CrawlDbTo crawlDbTo = null;
            String sqlQuery = BluSyncSQLConstants.createImageTable(this.tableTimeStamp);
            this.statement = null;
            StringBuilder sb = new StringBuilder().append(this.baseURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ImageTable").append(this.tableTimeStamp);
            String sqlQueryForActivityTable = new StringBuffer().append("INSERT INTO ").append("ActivityTable").append(".").append("ActivityHistory").append(" (").append("timestamp").append(",").append("currentactivity").append(",").append("uploadcount").append(",").append("batchID").append(",").append("downloadcount").append(")").append(" Values(?,?,?,?,?);").toString();
            String sqlQueryForInsertingIntoImageTableHistory = "insert into ImageTableHistory.ImageTableHistory values(?);";
            boolean gotConnection = this.getConnectionForCreatingDatabase(sb.toString());
            if (gotConnection) {
                try {
                    this.attachImageTableDataInCurrentTable("ActivityTable");
                    this.attachImageTableDataInCurrentTable("ImageTableHistory");
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.execute();
                    this.statement.close();
                    tableName = "ImageTable" + this.tableTimeStamp;
                    this.statement = this.conn.prepareStatement(sqlQueryForActivityTable, 1);
                    this.statement.setString(1, tempActivityTimeStamp);
                    this.statement.setString(2, tempActivityName);
                    this.statement.setString(3, tempActivityUpload);
                    this.statement.setString(4, batchId);
                    this.statement.setString(5, tempActivitydownload);
                    this.statement.execute();
                    ResultSet result = this.statement.getGeneratedKeys();
                    if (result != null && result.next()) {
                        columnId = result.getLong(1);
                        result.close();
                    }
                    this.statement.close();
                    this.statement = this.conn.prepareStatement("insert into ImageTableHistory.ImageTableHistory values(?);");
                    this.statement.setString(1, tableName);
                    this.statement.execute();
                    this.statement.close();
                    this.detachImageTableDataInCurrentTable("ActivityTable");
                    this.detachImageTableDataInCurrentTable("ImageTableHistory");
                    crawlDbTo = new CrawlDbTo();
                    crawlDbTo.setActivityId(columnId);
                    crawlDbTo.setImageTableName(tableName);
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while createImageTable", e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            this.logger.debug("The Created table name is:" + tableName);
            return crawlDbTo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteImageTable(String imageTableName, ActivityTO activity) {
        MacImageHistoryDaoImpl macImageHistoryDaoImpl = this;
        synchronized (macImageHistoryDaoImpl) {
            this.statement = null;
            long activityId = activity.getActivityID();
            String tempActivityUpload = activity.getUploadCount();
            String tempActivitydownload = activity.getDownloadCount();
            String activityName = activity.getActivityName();
            String dropTableQuery = "Drop Table ";
            String sqlQueryToUpdateActivityTable = "Update ActivityTable.ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;";
            StringBuilder sb = new StringBuilder().append(this.baseURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(imageTableName);
            boolean gotConnection = this.getConnection(sb.toString());
            if (gotConnection) {
                try {
                    if (imageTableName != null) {
                        this.attachImageTableDataInCurrentTable("ActivityTable");
                        this.statement = this.conn.prepareStatement(dropTableQuery + imageTableName);
                        this.statement.execute();
                        this.statement.close();
                        this.statement = this.conn.prepareStatement("Update ActivityTable.ActivityHistory set uploadcount=?,downloadcount=?,currentactivity=? where id=?;");
                        this.statement.setString(1, tempActivityUpload);
                        this.statement.setString(2, tempActivitydownload);
                        this.statement.setString(3, activityName);
                        this.statement.setLong(4, activityId);
                        this.statement.execute();
                        this.statement.close();
                        this.detachImageTableDataInCurrentTable("ActivityTable");
                    }
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while deleteImageTable", e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            boolean success = this.removeFromImageTableHistory(imageTableName);
            return success;
        }
    }
}

