/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.RestoreDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.RestoreEvenListElement;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.RestoreHelper;
import com.parablu.epa.core.to.DisplayTo;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.view.RestoreBackup;
import com.parablu.epa.view.SystemTrayUI;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreManager {
    private Logger logger = LoggerFactory.getLogger(RestoreManager.class);
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static RestoreBackup restoreInstance = null;
    private static String missingDrive = "";
    private List<DisplayTo> listOfDrives = null;
    private Set<String> selectedDrives = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRestoreElementfromServer() {
        RestoreEvenListElement restoreEvenListElement = null;
        RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        String destinationFolder = null;
        boolean isDestPathChanged = false;
        try {
            this.acquireLockForNewUI();
            restoreEvenListElement = this.backUpAdapter.getRestoreDetailsFromServer(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName());
            if (restoreEvenListElement == null) {
                this.logger.debug("restoreEvenListElement is null so return");
                return;
            }
            String deviceUUID = restoreEvenListElement.getActionOnDeviceUUID();
            String status = BackupLifeCycle.STARTED.toString();
            destinationFolder = restoreEvenListElement.getDestinationPath();
            String deviceType = restoreEvenListElement.getActionOnDeviceType();
            String sourcePathForRestore = restoreEvenListElement.getFileElement().getFileCompletePath();
            boolean overwriteNewerFiles = restoreEvenListElement.isOverwriteNewerFiles();
            boolean restoreDeletedFiles = restoreEvenListElement.isRestoreDeletedFiles();
            RestoreHelper restoreHelper = new RestoreHelper();
            this.logger.debug("isDestPathChanged..." + isDestPathChanged);
            String deviceId = restoreEvenListElement.getDeviceId();
            this.logger.debug(deviceId + "deviceId....");
            boolean isSuspendBackup = restoreEvenListElement.isSuspendBackup();
            this.logger.debug("isSuspendBackup..." + isSuspendBackup);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    restoreInstance = null;
                    restoreInstance = new RestoreBackup();
                }
            });
            NotificationHelper.setSuspendBackup((boolean)isSuspendBackup);
            NotificationHelper.setRestoreStarted((boolean)true);
            NotificationHelper.restoreFinished = false;
            RestoreManager.restoreInstance.restoreElement.setDeleteRestoreEvent(true);
            if (sourcePathForRestore == null) {
                RestoreManager.restoreInstance.restoreElement.setRestoredFolder("All drives");
            } else {
                RestoreManager.restoreInstance.restoreElement.setRestoredFolder(sourcePathForRestore);
            }
            this.logger.debug("restoreInstance.restoreElement" + RestoreManager.restoreInstance.restoreElement + "..." + RestoreManager.restoreInstance.restoreElement.getDestinationPath());
            if (restoreEvenListElement.getRestoreDataBefore() != 0L) {
                RestoreManager.restoreInstance.restoreElement.setRestoreTillDate(String.valueOf(restoreEvenListElement.getRestoreDataBefore()));
            }
            FileElement fileElement = null;
            FileListElement listFolderFiles = new FileListElement();
            String selectedPathForRestore = destinationFolder;
            RestoreManager.restoreInstance.restoreElement.setDeleteRestoreEvent(true);
            RestoreManager.restoreInstance.restoreElement.setSelectedDevicePath("");
            RestoreManager.restoreInstance.restoreElement.setDevicePath("");
            RestoreManager.restoreInstance.restoreElement.setFileUserOwner("");
            RestoreManager.restoreInstance.restoreElement.setFileName("");
            RestoreManager.restoreInstance.restoreElement.setFileBackupId("");
            RestoreManager.restoreInstance.restoreElement.setDeleteRestoreEvent(true);
            if (sourcePathForRestore != null) {
                File file = new File(sourcePathForRestore);
                FileElement filePathElement = restoreEvenListElement.getFileElement();
                if (filePathElement.isFolder()) {
                    this.logger.debug("inside folder......" + file.getAbsoluteFile() + sourcePathForRestore);
                    selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + file.getAbsoluteFile().getName().replace(":", "_DRIVE");
                    if (sourcePathForRestore.endsWith(":")) {
                        selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + sourcePathForRestore.replace(":", "_DRIVE");
                    }
                    this.logger.debug("inside folder......" + file.getAbsoluteFile() + sourcePathForRestore);
                    fileElement = ObjectUtils.convertToRestoreEventTOFileElement((RestoreEvenListElement)restoreEvenListElement);
                    fileElement.setFileName("");
                    RestoreManager.restoreInstance.restoreElement.setSelectedDevicePath(fileElement.getFileCompletePath());
                    RestoreManager.restoreInstance.restoreElement.setDevicePath(fileElement.getFileCompletePath());
                    RestoreManager.restoreInstance.restoreElement.setFileUserOwner("");
                    listFolderFiles.getFileElementList().add(fileElement);
                } else if (!filePathElement.isFolder()) {
                    this.logger.debug("inside file");
                    RestoreManager.restoreInstance.restoreElement.setSelectedDevicePath(sourcePathForRestore);
                    List<String> folderPathArray = Arrays.asList(sourcePathForRestore.split("/"));
                    String fileName = folderPathArray.get(folderPathArray.size() - 1);
                    String path = sourcePathForRestore.substring(0, sourcePathForRestore.length() - fileName.length() - 1);
                    this.logger.debug("..");
                    RestoreManager.restoreInstance.restoreElement.setDevicePath(path);
                    RestoreManager.restoreInstance.restoreElement.setFileName(fileName);
                    RestoreManager.restoreInstance.restoreElement.setFileUserOwner("");
                    this.logger.debug("...." + path + " " + fileName);
                    if (!restoreEvenListElement.isRestoreAllVersions()) {
                        this.logger.debug("all versions not selected so set backup id>>>>>>" + filePathElement.getBackupId());
                        RestoreManager.restoreInstance.restoreElement.setFileBackupId(filePathElement.getBackupId());
                    }
                }
            } else {
                this.logger.debug("inside device");
                RestoreManager.restoreInstance.restoreElement.setFileUserOwner(SettingHelper.getUserName());
                fileElement = new FileElement();
            }
            RestoreManager.restoreInstance.restoreElement.setCloudName(SettingHelper.getCloudName());
            RestoreManager.restoreInstance.restoreElement.setRestoreBatchId(RestoreManager.restoreInstance.batchId);
            if (restoreEvenListElement.isInPlaceRestore()) {
                RestoreManager.restoreInstance.restoreElement.setDestinationPath(null);
            } else {
                RestoreManager.restoreInstance.restoreElement.setDestinationPath(selectedPathForRestore);
            }
            RestoreManager.restoreInstance.restoreElement.setDeviceUUid(restoreEvenListElement.getActionOnDeviceUUID());
            RestoreManager.restoreInstance.restoreElement.setRestoreAllVersions(restoreEvenListElement.isRestoreAllVersions());
            RestoreManager.restoreInstance.deviceuid = restoreEvenListElement.getActionOnDeviceUUID();
            RestoreManager.restoreInstance.restoreElement.setSelectedDestinationPath(destinationFolder);
            RestoreManager.restoreInstance.selectedDestinationPath = destinationFolder;
            RestoreManager.restoreInstance.threadsCountToUse = String.valueOf(restoreEvenListElement.getNoOfThreads());
            RestoreManager.restoreInstance.isDestPathChanged = isDestPathChanged;
            RestoreManager.restoreInstance.restoreElement.setOverwriteNewerFiles(overwriteNewerFiles);
            RestoreManager.restoreInstance.restoreElement.setRestoreDeletedFiles(restoreDeletedFiles);
            RestoreDAOImpl restoreDAOImpl = new RestoreDAOImpl(SettingHelper.getRestoreDbUrl());
            restoreDAOImpl.clearEntireRestoreTable();
            if (!restoreEvenListElement.isInPlaceRestore() && !restoreHelper.checkForDriveExist(destinationFolder, isDestPathChanged)) {
                this.logger.debug(" restore failed...");
                NotificationHelper.successfulRestore = 10;
                return;
            }
            if (!this.checkPreconditionForInplacerestore(restoreEvenListElement, deviceType, sourcePathForRestore)) {
                RestoreManager.restoreInstance.selectedDestinationPath = RestoreManager.restoreInstance.restoreElement.getRestoredFolder();
                destinationFolder = RestoreManager.restoreInstance.restoreElement.getRestoredFolder();
                this.logger.debug("Inplace restore failed..." + RestoreManager.restoreInstance.restoreElement.getRestoredFolder());
                NotificationHelper.successfulRestore = 10;
                return;
            }
            if (restoreEvenListElement.isInPlaceRestore()) {
                destinationFolder = RestoreManager.restoreInstance.restoreElement.getRestoredFolder();
                RestoreManager.restoreInstance.selectedDestinationPath = RestoreManager.restoreInstance.restoreElement.getRestoredFolder();
            }
            RestoreManager.restoreInstance.batchId = restoreInstance.restoreBatchInitiated(status, "", "0/0", 0L, deviceUUID, true, 0, SettingHelper.getDeviceUUId(), RestoreManager.restoreInstance.restoreElement.getRestoredFolder(), destinationFolder);
            if (!RestoreManager.restoreInstance.batchId.equals("") && !"-1".equals(RestoreManager.restoreInstance.batchId)) {
                restoreInstance.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl, true);
                this.logger.debug("Inserting into restore table");
                restoreActivityTo.setRestoreBatchStatus(status);
                restoreActivityTo.setRestoreBatchId(RestoreManager.restoreInstance.batchId);
                restoreActivityTo.setTotalRestoreCount("0");
                restoreActivityTo.setRestoreType("Portal");
                restoreActivityTo.setDeviceuid(SettingHelper.getDeviceUUId());
                restoreActivityTo.setRestoreDeviceUUID(RestoreManager.restoreInstance.deviceuid);
                restoreActivityTo.setRestoredFolder(RestoreManager.restoreInstance.restoreElement.getRestoredFolder());
                restoreActivityTo.setSelectedDestinationPath(destinationFolder);
                restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
            }
            NotificationHelper.successfulRestore = 1;
            restoreInstance.downloadFiles(restoreActivityTo, restoreActivityHistoryDAOImpl, fileElement, listFolderFiles, true);
        }
        catch (Exception e1) {
            NotificationHelper.successfulRestore = 0;
            this.logger.trace("" + e1);
            e1.printStackTrace();
            this.logger.error("unsuccessfulRestore, Exception e1: ", (Object)e1.getMessage());
        }
        finally {
            restoreInstance.saveandSendRestoreResponse(restoreActivityTo, restoreActivityHistoryDAOImpl, false, restoreEvenListElement.getActionOnDeviceUUID(), true, RestoreManager.restoreInstance.restoreElement.getRestoredFolder());
        }
    }

    private void acquireLockForNewUI() {
        SystemTrayUI systemTrayUI = SystemTrayUI.getSystemtrayInstance();
        try {
            systemTrayUI.acquireLockForNewUI();
            systemTrayUI.unlockFileUI();
        }
        catch (Exception e) {
            this.logger.error("..................", (Object)e.getMessage());
            systemTrayUI.closeRestoreWindow();
        }
    }

    public static void restoreBatchUpdateBeforeExit() {
        restoreInstance.restoreBatchUpdateBeforeExit();
    }

    private boolean checkPreconditionForInplacerestore(RestoreEvenListElement restoreEvenListElement, String deviceType, String sourcePathForRestore) {
        try {
            if (restoreEvenListElement.isInPlaceRestore() && !deviceType.toLowerCase().startsWith("mac")) {
                this.logger.debug("Inplace restore incompatibility...");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.debug("error", (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

