/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.adapter.pcb.MediaAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.MediaFolderTO;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.to.NetworkDriveTo;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.PreferencesView;
import java.io.File;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaManagementView
extends BaseView {
    private static final String MEDIA_HUB_STATUS = "Media Hub Status  : ";
    private static final String HUB_SCANNING = "SCANNING";
    private static final String HUB_ENABLED = "ENABLED";
    private static final String HUB_DISABLED = "DISABLED";
    private static Logger logger = LoggerFactory.getLogger(PreferencesView.class);
    FontsManager fontsManager;
    public boolean enableBlusyncToggle;
    public int syncFrequency = 5;
    private Composite settingsPanel = null;
    private Group syncPanelSubGroup = null;
    private Group mediaPanelSubGroup = null;
    private Label syncEnableDisableLabel = null;
    private Label mediaEnableDisableLabel = null;
    private Label syncEnableDisableInfoLabel = null;
    private Label backupEnableDisableLabel = null;
    public Button syncEnableButton = null;
    public Button mediaEnableButton = null;
    public Button mediaPicturesCheckBox = null;
    public Button mediaVideosCheckBox = null;
    public Button mediaMusicCheckBox = null;
    public Text mediaMusicLabel = null;
    public Text mediaPicturesLabel = null;
    public Text mediaVideosLabel = null;
    public Button mediaPicturesConfigButton = null;
    public Button mediaMusicConfigButton = null;
    public Button mediaVideosConfigButton = null;
    public Button backupEnableButton = null;
    private Label backuEnableDisableInfoLabel = null;
    private Label syncFrequencyLbl = null;
    public CCombo syncFrequencyHoursCombo = null;
    private Label syncFrequencyHoursLabel = null;
    public CCombo syncFrequencyMinutesCombo = null;
    private Label syncFrequencyMinutesLabel = null;
    private Link mediaWebDAVenabled;
    private Button mediaWebDavButton;
    private Composite applyButtonToolBar = null;
    private Button syncFrequencyApplyButton = null;
    MediaFolderDAOImpl mediaFolderDAOImpl = new MediaFolderDAOImpl(SettingHelper.getMediaDbUrl());
    private String currentMediaHubStatus = "SCANNING";
    private Label webDavStatus;

    public MediaManagementView(Composite composite) {
        this.mainParentComposite = composite;
        if ("true".equals(SettingHelper.getSyncLicenced())) {
            this.generateUI();
        } else {
            this.generateDefaultSyncPreferencesUI();
        }
    }

    private void generateDefaultSyncPreferencesUI() {
        Display display = Display.getCurrent();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout baseGroupGridLayout = new GridLayout();
        baseGroupGridLayout.marginWidth = 5;
        baseGroupGridLayout.marginHeight = 10;
        baseGroupGridLayout.marginTop = 10;
        baseGroupGridLayout.marginLeft = 10;
        baseGroupGridLayout.marginRight = 10;
        baseGroupGridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.baseGroup.setLayout((Layout)baseGroupGridLayout);
        this.baseGroup.setLayoutData((Object)gridData);
        Composite syncNotificationsComposite = new Composite(this.baseGroup, 2048);
        GridLayout syncNotificationsCompositeLayout = new GridLayout();
        syncNotificationsCompositeLayout.marginWidth = 5;
        syncNotificationsCompositeLayout.marginTop = 5;
        syncNotificationsCompositeLayout.marginLeft = 5;
        syncNotificationsCompositeLayout.marginRight = 5;
        syncNotificationsCompositeLayout.marginBottom = 5;
        syncNotificationsCompositeLayout.numColumns = 1;
        syncNotificationsComposite.setLayout((Layout)syncNotificationsCompositeLayout);
        syncNotificationsComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(syncNotificationsComposite, 64);
        label.setText("Media upload is not enabled for this user.\nPlease contact your cloud administrator.");
        label.setFont(this.fontsManager.getMediumNormalFont());
        GridData gridData1 = new GridData(1808);
        gridData1.widthHint = 300;
        label.setLayoutData((Object)gridData1);
    }

    private void generateUI() {
        GridData gridData = new GridData(4, 4, false, true);
        this.enableBlusyncToggle = SettingHelper.isEnableBlusync();
        this.syncFrequency = SettingHelper.getCheckParacloudForUpdateTimerInMins();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        GridLayout settingGroupLayout = new GridLayout();
        settingGroupLayout.verticalSpacing = 6;
        this.baseGroup.setLayout((Layout)settingGroupLayout);
        this.baseGroup.setLayoutData((Object)gridData);
        GridLayout settingsPanelCompositeLayout = new GridLayout();
        settingsPanelCompositeLayout.numColumns = 2;
        settingsPanelCompositeLayout.marginWidth = 5;
        settingsPanelCompositeLayout.marginRight = 5;
        settingsPanelCompositeLayout.marginLeft = 5;
        settingsPanelCompositeLayout.marginTop = 15;
        settingsPanelCompositeLayout.marginHeight = 0;
        settingsPanelCompositeLayout.makeColumnsEqualWidth = false;
        settingsPanelCompositeLayout.horizontalSpacing = 20;
        GridData settingsPanelCompositeData = new GridData(1808);
        settingsPanelCompositeData.grabExcessHorizontalSpace = true;
        this.settingsPanel = new Composite(this.baseGroup, 4);
        this.settingsPanel.setLayout((Layout)settingsPanelCompositeLayout);
        this.settingsPanel.setLayoutData((Object)settingsPanelCompositeData);
        this.mediaPanelSubGroup = new Group(this.settingsPanel, 0);
        GridLayout settingsPanelMediaGridLayout = new GridLayout();
        settingsPanelMediaGridLayout.makeColumnsEqualWidth = true;
        settingsPanelMediaGridLayout.numColumns = 1;
        settingsPanelMediaGridLayout.horizontalSpacing = 20;
        settingsPanelMediaGridLayout.marginWidth = 0;
        settingsPanelMediaGridLayout.marginRight = 0;
        settingsPanelMediaGridLayout.marginLeft = 5;
        settingsPanelMediaGridLayout.verticalSpacing = 4;
        settingsPanelMediaGridLayout.marginBottom = 0;
        this.mediaPanelSubGroup.setLayout((Layout)settingsPanelMediaGridLayout);
        GridData mediaPanelSubGroupGridData = new GridData(768);
        mediaPanelSubGroupGridData.horizontalSpan = 2;
        this.mediaPanelSubGroup.setLayoutData((Object)mediaPanelSubGroupGridData);
        this.mediaPanelSubGroup.setFont(this.fontsManager.getSmallNormalFont());
        this.mediaPanelSubGroup.setText("Media Settings");
        this.mediaEnableDisableLabel = new Label((Composite)this.mediaPanelSubGroup, 0);
        this.mediaEnableDisableLabel.setText("Automatic Media Upload");
        this.mediaEnableDisableLabel.setFont(this.fontsManager.getMediumBoldFont());
        Composite mediaSelectioncomposite = new Composite((Composite)this.mediaPanelSubGroup, 0);
        GridLayout selectionMediaGridLayout = new GridLayout();
        selectionMediaGridLayout.makeColumnsEqualWidth = false;
        selectionMediaGridLayout.numColumns = 3;
        selectionMediaGridLayout.horizontalSpacing = 10;
        selectionMediaGridLayout.marginWidth = 0;
        selectionMediaGridLayout.marginRight = 0;
        selectionMediaGridLayout.marginLeft = 5;
        selectionMediaGridLayout.verticalSpacing = 8;
        selectionMediaGridLayout.marginBottom = 0;
        mediaSelectioncomposite.setLayout((Layout)selectionMediaGridLayout);
        mediaSelectioncomposite.setLayoutData((Object)new GridData(1808));
        this.mediaMusicCheckBox = new Button(mediaSelectioncomposite, 32);
        this.mediaMusicCheckBox.setText("Music");
        this.mediaMusicCheckBox.setSelection(SettingHelper.isTempEnableMusicMediaSync());
        this.mediaMusicLabel = new Text(mediaSelectioncomposite, 0);
        this.mediaMusicLabel.setEditable(false);
        this.mediaMusicLabel.setEnabled(this.mediaMusicCheckBox.getSelection());
        this.mediaMusicLabel.setText("");
        String folderPathMusic = this.getSyncFolderForMedia("Music");
        this.mediaMusicLabel.setToolTipText(folderPathMusic);
        folderPathMusic = this.checkForPathOverflow(folderPathMusic);
        this.mediaMusicLabel.setText(folderPathMusic);
        this.mediaMusicLabel.setSize(5, 10);
        GridData gridData21 = new GridData();
        gridData21.widthHint = 130;
        this.mediaMusicLabel.setLayoutData((Object)gridData21);
        this.mediaMusicConfigButton = new Button(mediaSelectioncomposite, 8);
        this.mediaMusicConfigButton.setText("Configure");
        this.mediaMusicConfigButton.setEnabled(this.mediaMusicCheckBox.getSelection());
        this.mediaMusicCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MediaManagementView.this.mediaMusicCheckBox.getSelection()) {
                    MediaManagementView.this.mediaMusicConfigButton.setEnabled(true);
                    MediaManagementView.this.mediaMusicLabel.setEnabled(true);
                    SettingHelper.setTempEnableMusicMediaSync((boolean)true);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                } else {
                    MediaManagementView.this.mediaMusicConfigButton.setEnabled(false);
                    SettingHelper.setTempEnableMusicMediaSync((boolean)false);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                    MediaManagementView.this.mediaMusicLabel.setEnabled(false);
                }
            }
        });
        this.mediaMusicConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(MediaManagementView.this.mainParentComposite.getShell());
                directoryDialog.setMessage("Please select a folder");
                directoryDialog.setText("Folder Selection");
                String folderSelection = directoryDialog.open();
                if (folderSelection != null) {
                    String selctionMusic = new File(folderSelection).getAbsolutePath();
                    MediaManagementView.this.mediaMusicLabel.setToolTipText(selctionMusic);
                    MediaManagementView.this.mediaMusicLabel.setText(MediaManagementView.this.checkForPathOverflow(selctionMusic));
                    MediaManagementView.this.addToMediaFolderTable(folderSelection, "Music");
                }
            }
        });
        this.mediaPicturesCheckBox = new Button(mediaSelectioncomposite, 32);
        this.mediaPicturesCheckBox.setText("Picture");
        this.mediaPicturesCheckBox.setSelection(SettingHelper.isTempEnablePicturesMediaSync());
        this.mediaPicturesLabel = new Text(mediaSelectioncomposite, 0);
        this.mediaPicturesLabel.setEditable(false);
        this.mediaPicturesLabel.setEnabled(this.mediaPicturesCheckBox.getSelection());
        this.mediaPicturesLabel.setText("");
        String folderPathPicture = this.getSyncFolderForMedia("Picture");
        this.mediaPicturesLabel.setToolTipText(folderPathPicture);
        folderPathPicture = this.checkForPathOverflow(folderPathPicture);
        this.mediaPicturesLabel.setText(folderPathPicture);
        this.mediaPicturesLabel.setSize(5, 10);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 130;
        this.mediaPicturesLabel.setLayoutData((Object)gridData3);
        this.mediaPicturesConfigButton = new Button(mediaSelectioncomposite, 8);
        this.mediaPicturesConfigButton.setText("Configure");
        this.mediaPicturesConfigButton.setEnabled(this.mediaPicturesCheckBox.getSelection());
        this.mediaPicturesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MediaManagementView.this.mediaPicturesCheckBox.getSelection()) {
                    MediaManagementView.this.mediaPicturesConfigButton.setEnabled(true);
                    MediaManagementView.this.mediaPicturesLabel.setEnabled(true);
                    SettingHelper.setTempEnablePicturesMediaSync((boolean)true);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                } else {
                    MediaManagementView.this.mediaPicturesConfigButton.setEnabled(false);
                    MediaManagementView.this.mediaPicturesLabel.setEnabled(false);
                    SettingHelper.setTempEnablePicturesMediaSync((boolean)false);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                }
            }
        });
        this.mediaPicturesConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(MediaManagementView.this.mainParentComposite.getShell());
                directoryDialog.setMessage("Please select a folder");
                directoryDialog.setText("Folder Selection");
                String folderSelection = directoryDialog.open();
                if (folderSelection != null) {
                    String selctionPicture = new File(folderSelection).getAbsolutePath();
                    MediaManagementView.this.mediaPicturesLabel.setToolTipText(selctionPicture);
                    MediaManagementView.this.mediaPicturesLabel.setText(MediaManagementView.this.checkForPathOverflow(selctionPicture));
                    MediaManagementView.this.addToMediaFolderTable(folderSelection, "Picture");
                }
            }
        });
        this.mediaVideosCheckBox = new Button(mediaSelectioncomposite, 32);
        this.mediaVideosCheckBox.setText("Video");
        this.mediaVideosCheckBox.setSelection(SettingHelper.isTempEnableVideosMediaSync());
        this.mediaVideosLabel = new Text(mediaSelectioncomposite, 0);
        this.mediaVideosLabel.setEditable(false);
        this.mediaVideosLabel.setEnabled(this.mediaVideosCheckBox.getSelection());
        String folderPathVideo = this.getSyncFolderForMedia("Video");
        this.mediaVideosLabel.setToolTipText(folderPathVideo);
        folderPathVideo = this.checkForPathOverflow(folderPathVideo);
        this.mediaVideosLabel.setText(folderPathVideo);
        this.mediaVideosLabel.setSize(5, 10);
        GridData gridData4 = new GridData();
        gridData4.widthHint = 130;
        this.mediaVideosLabel.setLayoutData((Object)gridData4);
        this.mediaVideosConfigButton = new Button(mediaSelectioncomposite, 8);
        this.mediaVideosConfigButton.setText("Configure");
        this.mediaVideosConfigButton.setEnabled(this.mediaVideosCheckBox.getSelection());
        this.mediaVideosCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MediaManagementView.this.mediaVideosCheckBox.getSelection()) {
                    MediaManagementView.this.mediaVideosConfigButton.setEnabled(true);
                    MediaManagementView.this.mediaVideosLabel.setEnabled(true);
                    SettingHelper.setTempEnableVideosMediaSync((boolean)true);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                } else {
                    MediaManagementView.this.mediaVideosConfigButton.setEnabled(false);
                    MediaManagementView.this.mediaVideosLabel.setEnabled(false);
                    SettingHelper.setTempEnableVideosMediaSync((boolean)false);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                }
            }
        });
        this.mediaVideosConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(MediaManagementView.this.mainParentComposite.getShell());
                directoryDialog.setMessage("Please select a folder");
                directoryDialog.setText("Folder Selection");
                String folderSelection = directoryDialog.open();
                if (folderSelection != null) {
                    String selection = new File(folderSelection).getAbsolutePath();
                    MediaManagementView.this.mediaVideosLabel.setToolTipText(selection);
                    MediaManagementView.this.mediaVideosLabel.setText(MediaManagementView.this.checkForPathOverflow(selection));
                    MediaManagementView.this.addToMediaFolderTable(folderSelection, "Video");
                }
            }
        });
        this.webDavStatus = new Label(mediaSelectioncomposite, 16384);
        GridData webDavStatusGridData = new GridData(1808);
        webDavStatusGridData.horizontalSpan = 3;
        this.webDavStatus.setLayoutData((Object)webDavStatusGridData);
        this.webDavStatus.setText(MEDIA_HUB_STATUS + this.currentMediaHubStatus);
        this.mediaWebDAVenabled = new Link(mediaSelectioncomposite, 16448);
        GridData mediaWebDAVenabledGridData = new GridData(1808);
        mediaWebDAVenabledGridData.horizontalSpan = 2;
        this.mediaWebDAVenabled.setLayoutData((Object)mediaWebDAVenabledGridData);
        this.mediaWebDavButton = new Button(mediaSelectioncomposite, 8);
        GridData mediaWebDavButtonGridData = new GridData(1808);
        mediaWebDavButtonGridData.horizontalSpan = 1;
        mediaWebDavButtonGridData.widthHint = 80;
        this.mediaWebDavButton.setLayoutData((Object)mediaWebDavButtonGridData);
        this.mediaWebDavButton.setVisible(false);
        this.mediaWebDavButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MediaManagementView.this.currentMediaHubStatus.equals(MediaManagementView.HUB_DISABLED)) {
                    MessageBox messageBox = new MessageBox(MediaManagementView.this.mainParentComposite.getShell(), 40);
                    messageBox.setText("Media Hub not configured");
                    messageBox.setMessage("Media hub is not enabled, please contact your cloud administrator");
                    messageBox.open();
                    return;
                }
                NetworkDriveTo networkDriveTo = MacSettingsHelper.mapWebDAVasNetworkDrive(null, null);
                if (networkDriveTo.isStatus()) {
                    MediaManagementView.this.mediaWebDavButton.setVisible(true);
                    MediaManagementView.this.mediaWebDAVenabled.setText("<a>Media Hub</a> has been successfully mapped.");
                    MediaManagementView.this.mediaWebDavButton.setText("Remap");
                    MediaManagementView.this.mediaWebDAVenabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Program.launch((String)SettingHelper.getWebdevDrive());
                        }
                    });
                }
            }
        });
        this.checkIFMediaHubISEnabled();
    }

    protected String getSyncFolderForMedia(String mediaType) {
        return this.mediaFolderDAOImpl.getSyncPath(mediaType);
    }

    protected synchronized void diableOtherSyncOptions(boolean enableBlusyncToggle2) {
        if (!this.syncFrequencyHoursLabel.isDisposed() && !this.syncFrequencyHoursLabel.getParent().isDisposed()) {
            this.syncFrequencyHoursLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyMinutesLabel.isDisposed() && !this.syncFrequencyMinutesLabel.getParent().isDisposed()) {
            this.syncFrequencyMinutesLabel.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyHoursCombo.isDisposed() && !this.syncFrequencyHoursCombo.getParent().isDisposed()) {
            this.syncFrequencyHoursCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyMinutesCombo.isDisposed() && !this.syncFrequencyMinutesCombo.getParent().isDisposed()) {
            this.syncFrequencyMinutesCombo.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyLbl.isDisposed() && !this.syncFrequencyLbl.getParent().isDisposed()) {
            this.syncFrequencyLbl.setEnabled(enableBlusyncToggle2);
        }
        if (!this.syncFrequencyApplyButton.isDisposed() && !this.syncFrequencyApplyButton.getParent().isDisposed()) {
            this.syncFrequencyApplyButton.setEnabled(enableBlusyncToggle2);
        }
    }

    protected void addToMediaFolderTable(String selectedFolder, String mediaType) {
        MediaFolderTO mediaFolderTO = new MediaFolderTO();
        File selectedItem = new File(selectedFolder);
        mediaFolderTO.setFolderPath(selectedItem.getAbsolutePath());
        mediaFolderTO.setLastSyncTime(0L);
        mediaFolderTO.setMediaType(mediaType);
        this.mediaFolderDAOImpl.removeAParentFolder(mediaFolderTO);
        this.mediaFolderDAOImpl.insertAParentFolder(mediaFolderTO);
    }

    private void checkIFMediaHubISEnabled() {
        Runnable runnable = () -> this.scanAndUpdateMediaHubStatus();
        new Thread(runnable).start();
    }

    private String checkForPathOverflow(String path) {
        String pathVariable = path;
        if (path.length() > 22) {
            pathVariable = new StringBuffer().append(path.substring(0, 22)).append("...").toString();
        }
        return pathVariable;
    }

    private void scanAndUpdateMediaHubStatus() {
        Runnable runnable;
        boolean status = false;
        MediaAdapter mediaAdapter = new MediaAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        try {
            status = mediaAdapter.checkIfMediaHubIsEnabled(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
            if (!status && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                status = mediaAdapter.checkIfMediaHubIsEnabled(SettingHelper.getCurrentCloudIpAddress(), Integer.valueOf(SettingHelper.getHttpsPort()), SettingHelper.readTokenFromFile());
            }
        }
        catch (CrawlAdapterException e) {
            logger.debug("CrawlAdapterException", (Throwable)e);
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
        if (status) {
            runnable = () -> {
                this.currentMediaHubStatus = HUB_ENABLED;
                this.webDavStatus.setText(MEDIA_HUB_STATUS + this.currentMediaHubStatus);
                this.webDavStatus.getParent().getShell().layout();
                if (SettingHelper.isMediaHubEnabled() && MacSettingsHelper.checkIfDriveIsMounted()) {
                    this.mediaWebDavButton.setVisible(true);
                    this.mediaWebDAVenabled.setText("<a>Media Hub</a> has been successfully mapped.");
                    this.mediaWebDavButton.setText("Remap");
                    this.mediaWebDAVenabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Program.launch((String)SettingHelper.getWebdevDrive());
                        }
                    });
                } else {
                    SettingHelper.setMediaHubEnabled((boolean)false);
                    this.mediaWebDavButton.setVisible(true);
                    this.mediaWebDAVenabled.setText("Click here to map the network drive");
                    this.mediaWebDavButton.setText("Map Drive");
                }
            };
            this.mainParentComposite.getDisplay().asyncExec(runnable);
        } else {
            SettingHelper.setMediaHubEnabled((boolean)false);
            runnable = () -> {
                this.mediaWebDavButton.setVisible(true);
                this.currentMediaHubStatus = HUB_DISABLED;
                this.webDavStatus.setText(MEDIA_HUB_STATUS + this.currentMediaHubStatus);
                this.webDavStatus.getParent().getShell().layout();
                this.mediaWebDAVenabled.setText("Click here to map the network drive");
                this.mediaWebDavButton.setText("Map Drive");
                this.mediaWebDavButton.setVisible(true);
            };
            this.mainParentComposite.getDisplay().asyncExec(runnable);
        }
    }

    protected synchronized void applySyncSettingChanges(int syncFrequency, boolean syncEnableBlusyncToggle2) {
        SettingHelper.setTempCheckParacloudForUpdateTimerInMins((int)syncFrequency);
        SettingHelper.setTempEnableBlusync((boolean)syncEnableBlusyncToggle2);
        boolean appliedSuccessfully = SettingHelper.applyChangesToSharedPreferences((boolean)true);
        if (appliedSuccessfully) {
            MediaManagementView.updateUIBasedOnChoice(syncEnableBlusyncToggle2);
            BlusyncThreadHelper.resetSyncTimer();
        }
        if (this.mainParentComposite.getShell() == null) {
            return;
        }
        MessageBox msg = new MessageBox(this.mainParentComposite.getShell(), 34);
        msg.setText("Settings Saved");
        msg.setMessage("Sync settings updated");
        msg.open();
    }

    public static void updateUIBasedOnChoice(boolean enableBlusyncToggle2) {
        if (enableBlusyncToggle2 && NotificationHelper.getMainStatus() == 100) {
            NotificationHelper.setCurrentActivityState((int)12);
        }
    }

    public void enableAutomaticSync() {
        this.changeImageAndTextOfEnableBluSyncButton(true);
        this.enableBlusyncToggle = true;
        SettingHelper.setTempEnableBlusync((boolean)true);
        this.diableOtherSyncOptions(this.enableBlusyncToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.syncEnableDisableLabel.setText("Automatic Sync is Enabled");
        this.syncEnableDisableLabel.getParent().layout();
    }

    public void disabeAutomaticSync() {
        this.changeImageAndTextOfEnableBluSyncButton(false);
        this.enableBlusyncToggle = false;
        SettingHelper.setTempEnableBlusync((boolean)false);
        this.diableOtherSyncOptions(this.enableBlusyncToggle);
        SettingHelper.applyChangesToSharedPreferences((boolean)true);
        this.syncEnableDisableLabel.setText("Automatic Sync is Disabled");
        this.syncEnableDisableLabel.getParent().layout();
    }

    public void changeImageAndTextOfEnableBluSyncButton(boolean state) {
        if (state) {
            this.syncEnableButton.setText("Disable");
        } else {
            this.syncEnableButton.setText("Enable");
        }
        this.syncEnableButton.getParent().layout();
    }

    public void changeImageAndTextOfEnableBackupButton(boolean state) {
        if (state) {
            this.backupEnableButton.setText("Disable");
        } else {
            this.backupEnableButton.setText("Enable");
        }
        this.backupEnableButton.getParent().layout();
    }

    public void disposeAllMediaWidgets() {
        this.fontsManager.disposeFonts();
        this.disposeEnableBlusyncButtonsAndLabels();
        this.disposeSyncFrequencyButtonsAndLabels();
        if (this.syncPanelSubGroup != null && !this.syncPanelSubGroup.isDisposed()) {
            this.syncPanelSubGroup.dispose();
        }
        if (this.settingsPanel != null && !this.settingsPanel.isDisposed()) {
            this.settingsPanel.dispose();
        }
    }

    private void disposeEnableBlusyncButtonsAndLabels() {
        if (this.syncEnableDisableLabel != null) {
            this.syncEnableDisableLabel.dispose();
        }
        if (this.syncEnableDisableInfoLabel != null) {
            this.syncEnableDisableInfoLabel.dispose();
        }
        if (this.syncEnableButton != null) {
            if (this.syncEnableButton.getImage() != null && !this.syncEnableButton.getImage().isDisposed()) {
                this.syncEnableButton.getImage().dispose();
            }
            this.syncEnableButton.dispose();
        }
        if (this.backupEnableDisableLabel != null) {
            this.backupEnableDisableLabel.dispose();
        }
        if (this.backuEnableDisableInfoLabel != null) {
            this.backuEnableDisableInfoLabel.dispose();
        }
        if (this.backupEnableButton != null) {
            if (this.backupEnableButton.getImage() != null && !this.backupEnableButton.getImage().isDisposed()) {
                this.backupEnableButton.getImage().dispose();
            }
            this.backupEnableButton.dispose();
        }
    }

    private void disposeSyncFrequencyButtonsAndLabels() {
        if (this.syncFrequencyLbl != null) {
            this.syncFrequencyLbl.dispose();
        }
        if (this.syncFrequencyMinutesLabel != null) {
            this.syncFrequencyMinutesLabel.dispose();
        }
        if (this.syncFrequencyHoursLabel != null) {
            this.syncFrequencyHoursLabel.dispose();
        }
        if (this.syncFrequencyMinutesCombo != null) {
            this.syncFrequencyMinutesCombo.dispose();
        }
        if (this.syncFrequencyHoursCombo != null) {
            this.syncFrequencyHoursCombo.dispose();
        }
        if (this.syncFrequencyApplyButton != null) {
            if (this.syncFrequencyApplyButton.getImage() != null && !this.syncFrequencyApplyButton.getImage().isDisposed()) {
                this.syncFrequencyApplyButton.getImage().dispose();
            }
            this.syncFrequencyApplyButton.dispose();
        }
        if (this.applyButtonToolBar != null) {
            this.applyButtonToolBar.dispose();
        }
    }
}

