/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.sync;

import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.element.SyncPolicyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.service.alarm.MacPolicyRefreshHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacCheckSyncPolicy {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    private static Logger logger = LoggerFactory.getLogger(MacCheckSyncPolicy.class);
    private static SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
    public static SyncAdapter syncAdapter = new SyncAdapter(cloudName, keyStorePath);
    public static BackupAdapter backupAdapter = new BackupAdapter(cloudName, keyStorePath);
    static int syncPolicyRefreshIntervalInHrs = -1;

    private MacCheckSyncPolicy() {
    }

    public static void pullSyncPolicy() {
        if (NotificationHelper.syncPolicyRefreshStarted) {
            syncPolicyRefreshIntervalInHrs = MacCheckSyncPolicy.getCurrentSyncPolicyRefereshInterval();
            logger.debug("Sync policy interval :" + syncPolicyRefreshIntervalInHrs);
            if (syncPolicyRefreshIntervalInHrs != -1 && syncPolicyRefreshIntervalInHrs != 0) {
                MacPolicyRefreshHelper.resetSyncPolicyTimer(syncPolicyRefreshIntervalInHrs);
            } else {
                MacPolicyRefreshHelper.resetSyncPolicyTimer(60);
            }
            return;
        }
        NotificationHelper.syncPolicyRefreshStarted = true;
        List syncPolicyTos = syncPolicyDAOImpl.getSyncPolicyDetails();
        SyncPolicyTo currentPolicy = null;
        if (syncPolicyTos != null && !syncPolicyTos.isEmpty()) {
            currentPolicy = (SyncPolicyTo)syncPolicyTos.get(0);
        }
        if (currentPolicy != null) {
            SettingHelper.setPolicySyncInterval((int)currentPolicy.getSyncInterval());
            SyncPolicyTo syncPolicyTo = new SyncPolicyTo();
            SyncPolicyElement syncPolicyElement = null;
            try {
                syncAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                syncPolicyElement = syncAdapter.getSyncPolicyElement(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
                if (syncPolicyElement == null) {
                    syncPolicyElement = MacCheckSyncPolicy.retryUsingUpdatedIp();
                }
            }
            catch (CrawlAdapterException protocolException) {
                logger.error("Client protocol exception...." + (Object)((Object)protocolException));
                syncPolicyElement = MacCheckSyncPolicy.retryUsingUpdatedIp();
            }
            catch (Exception e) {
                logger.error("Error in get latest policy:" + e);
            }
            if (syncPolicyElement != null) {
                if (syncPolicyElement.getStatus() == 416) {
                    SettingHelper.setLicenseActive((boolean)false);
                } else {
                    SettingHelper.setLicenseActive((boolean)true);
                    try {
                        PolicyManagementServerHelper.createSyncPolicyAndChildDetails((SyncPolicyDAOImpl)syncPolicyDAOImpl, (SyncPolicyTo)syncPolicyTo, (SyncPolicyElement)syncPolicyElement);
                    }
                    catch (Exception e) {
                        logger.error("Error in create group  policy:" + e);
                    }
                }
            }
        } else {
            logger.debug("Due to some connection error previous policy may null so get latest policy");
            PolicyManagementServerHelper.loadSyncPolicyElement((String)SettingHelper.getDeviceName());
        }
        syncPolicyRefreshIntervalInHrs = MacCheckSyncPolicy.getCurrentSyncPolicyRefereshInterval();
        if (syncPolicyRefreshIntervalInHrs != -1 && syncPolicyRefreshIntervalInHrs != 0) {
            MacPolicyRefreshHelper.resetSyncPolicyTimer(syncPolicyRefreshIntervalInHrs);
        } else {
            MacPolicyRefreshHelper.resetSyncPolicyTimer(60);
        }
        NotificationHelper.syncPolicyRefreshStarted = false;
    }

    private static int getCurrentSyncPolicyRefereshInterval() {
        int policyInterval = -1;
        SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
        List policyTos = syncPolicyDAOImpl.getSyncPolicyDetails();
        if (policyTos != null && !policyTos.isEmpty()) {
            SyncPolicyTo currentPolicy = (SyncPolicyTo)policyTos.get(0);
            policyInterval = currentPolicy.getPolicyRefreshInterval();
        }
        return policyInterval;
    }

    private static SyncPolicyElement retryUsingUpdatedIp() {
        logger.debug("Retrying to get policy information.");
        SettingHelper.checkAndUpdateIpAddress();
        String currentIP = SettingHelper.getPublicIpAddress();
        SyncPolicyElement syncPolicyElement = null;
        try {
            syncAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            syncPolicyElement = syncAdapter.getSyncPolicyElement(currentIP, null, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
        }
        catch (CrawlAdapterException protocolException) {
            logger.error("client protocol exception...." + (Object)((Object)protocolException));
            currentIP = SettingHelper.getGaeLocalIpAddress();
            syncPolicyElement = MacCheckSyncPolicy.checkWithGaeLocalIp(currentIP);
        }
        catch (Exception e) {
            logger.error("Error in retrying  to get policy:" + e);
        }
        if (syncPolicyElement != null) {
            SettingHelper.setCurrentCloudIpAddress((String)currentIP);
            ProxyElement.setIp((String)currentIP);
            SettingHelper.applyChangesToSharedPreferences((boolean)false);
            return syncPolicyElement;
        }
        return null;
    }

    private static SyncPolicyElement checkWithGaeLocalIp(String currentIP) {
        SyncPolicyElement syncPolicyElement = null;
        try {
            syncPolicyElement = syncAdapter.getSyncPolicyElement(currentIP, null, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
        }
        catch (Exception exception) {
            logger.error("exception while get policy....." + exception);
        }
        if (syncPolicyElement != null) {
            return syncPolicyElement;
        }
        return null;
    }
}

