/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import com.apple.eio.FileManager;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.settings.InterfaceManagementService;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.settings.MountDriveTO;
import com.parablu.epa.to.NetworkDriveTo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacSettingsHelper {
    private static final String MEDIAHUB_CONNECTION_ERROR_MESSAGE = "Connection to mediahub failed. Please check your connection status and try again.";
    private static final String SYSTEM_ERROR_NETWORK_UNREACHABLE = "User canceled. (-128)";
    private static final String HTTP_PROTOCOL = "http";
    private static final String MEDIA_HUB_URL_PARAM = "mediahub";
    private static Logger logger = LoggerFactory.getLogger(MacSettingsHelper.class);
    public static String baseResourceFolder;
    private static final String REMOVING_EXISTING_DRIVES = "removing existing drives";
    private static final String ERROR_WHILE_CONNECTINGTO_WEBDAV = "Error while connecting to WebDav";
    private static final String OSASCRIPT = "osascript";
    private static final String MOUNT = "mount";
    private static final String MOUNT_VOLUME = "mount volume \"";

    private MacSettingsHelper() {
    }

    public static boolean initiateSettings() {
        boolean success = true;
        try {
            logger.debug("Initiating settings");
            SettingHelper.setUserHome((String)System.getProperty("user.home"));
            String appDataDir = SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu";
            StringBuilder sb = new StringBuilder();
            SettingHelper.setOsName((String)MacSettingsHelper.getOSType());
            SettingHelper.setOsVersion((String)MacSettingsHelper.getOSVersion());
            SettingHelper.setUserAppdataDir((String)appDataDir);
            sb.append(appDataDir).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ParaBlu").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Blusync");
            SettingHelper.setParabluBaseAppDataFolderUrl((String)(appDataDir + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu"));
            SettingHelper.setParabluBlusyncAppDataFolderUrl((String)sb.toString());
            SettingHelper.setParabluTempUploadFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("TempUploadFolder").toString());
            SettingHelper.setParabluTempDownloadFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("tempDownloadFolder").toString());
            SettingHelper.setCrawlGzipFolder((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("requestdata").toString());
            logger.debug("User Home:" + SettingHelper.getUserHome());
            SettingHelper.setBaseDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").toString());
            SettingHelper.setActivityDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ActivityTable").toString());
            SettingHelper.setFolderDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("FolderSync").toString());
            SettingHelper.setSyncedFilesDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("SyncedFiles").toString());
            SettingHelper.setImageTableHistoryDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ImageTableHistory").toString());
            SettingHelper.setDownloadTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("DownloadTable").toString());
            SettingHelper.setBackUpDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("BackupDB").toString());
            SettingHelper.setUploadTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("UploadTable").toString());
            SettingHelper.setDodTableDBUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("DodTable").toString());
            SettingHelper.setSharedPreferencesUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("usersettings").toString());
            SettingHelper.setIpSettingsUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("ipsettings").toString());
            SettingHelper.setMediaDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("MediaDB").toString());
            SettingHelper.setRestoreDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("RestoreDB").toString());
            SettingHelper.setTokenFileUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("settings").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("token.pbs").toString());
            SettingHelper.setUpdateDownloadURL((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("updates").toString());
            SettingHelper.setUiLockUrl((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("RingOnRequestUI.lock").toString());
            SettingHelper.setMainLockUrl((String)new StringBuffer().append(SettingHelper.getParabluBlusyncAppDataFolderUrl()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("RingOnRequestMain.lock").toString());
            SettingHelper.setIconPath((String)(SettingHelper.getParabluBaseAppDataFolderUrl() + StringLiterals.FILE_SEPARATOR + SyncConstants.FOLDER_ICON_NAME));
            SettingHelper.setSyncDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("SycnDB").toString());
            baseResourceFolder = FileManager.getPathToApplicationBundle() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Contents" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Java" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu" + StringLiterals.CONSTANTS_FILE_SEPARATOR;
            ParabluFileSystemUtils.setInstallationDir((String)baseResourceFolder);
            SettingHelper.setKeystorePath((String)(baseResourceFolder + "resource" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "keystore.jks"));
            logger.debug("creating chunk folder&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&*******");
            SettingHelper.setBaseChunkFolderUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Upload").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("Chunk").toString());
            SettingHelper.setBackUpCrawlDbUrl((String)new StringBuffer().append(sb.toString()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("databases").append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("BackupCrawlDB").toString());
            MacSettingsHelper.copyPlistFile();
            success = SettingHelper.createFolders();
            logger.debug("success:" + success);
            logger.debug("System info and paths initialisation : " + success);
        }
        catch (Exception e) {
            logger.error("Exception while geting user name,appdata name" + e.getMessage());
            logger.trace("" + e);
            logger.debug("Exception here");
            success = false;
        }
        if (success) {
            success = SettingHelper.readFromSharedPreferences();
            if (!success) {
                logger.debug("Exception here success");
                success = SettingHelper.resetSharedPreferences();
            }
            if (success) {
                if ("true".equalsIgnoreCase(SettingHelper.getBackupLicenced())) {
                    if (StringUtils.isNotEmpty((String)SettingHelper.getEndpointBackupUiDisabledDetails())) {
                        String[] disabledUiList = SettingHelper.getEndpointBackupUiDisabledDetails().split(",");
                        InterfaceManagementService.disableUISettings((String)"BACKUP", Arrays.asList(disabledUiList));
                    } else {
                        InterfaceManagementService.initialiseDefaultUISettings((String)"BACKUP", (boolean)true);
                    }
                }
                if ("true".equalsIgnoreCase(SettingHelper.getSyncLicenced())) {
                    if (StringUtils.isNotEmpty((String)SettingHelper.getEndpointSyncUiDisabledDetails())) {
                        String[] syncDisabledUiDetails = SettingHelper.getEndpointSyncUiDisabledDetails().split(",");
                        InterfaceManagementService.disableUISettings((String)"SYNC", Arrays.asList(syncDisabledUiDetails));
                    } else {
                        InterfaceManagementService.initialiseDefaultUISettings((String)"SYNC", (boolean)true);
                    }
                }
            }
            ProxyElement.setIp((String)PropertyHelper.MAIN_EBMS_DOMAIN);
            logger.debug("Url" + ProxyElement.getIp());
            logger.debug("Settings initialisation  : " + success);
        }
        SettingHelper.setProductVersion((String)PropertyHelper.BLUSYNC_VERSION_LABEL);
        return success;
    }

    private static void copyPlistFile() {
        try {
            String plistFileLocation = baseResourceFolder + "resource" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "com.parablu.autoLogin.plist";
            String destLocation = SettingHelper.getUserHome() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Library" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "LaunchAgents";
            File sourceFile = new File(plistFileLocation);
            File destFile = new File(destLocation);
            File checkFileExists = new File(destLocation + StringLiterals.FILE_SEPARATOR + "com.parablu.autoLogin.plist");
            String appLauncherPath = FileManager.getPathToApplicationBundle() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Contents" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "MacOS" + StringLiterals.CONSTANTS_FILE_SEPARATOR + "JavaAppLauncher";
            MacSettingsHelper.updateplist(plistFileLocation, appLauncherPath);
            if (!checkFileExists.exists()) {
                logger.debug("File does not exists so copy plist file to directory");
                FileUtils.copyFileToDirectory((File)sourceFile, (File)destFile);
            } else {
                logger.debug("File exists so delete and copy plist file to directory");
                checkFileExists.delete();
                FileUtils.copyFileToDirectory((File)sourceFile, (File)destFile);
            }
        }
        catch (Exception e) {
            logger.error("Exception while copying plist file:", (Object)e.getMessage());
            logger.trace("", (Throwable)e);
        }
    }

    public static void updateplist(String plistFileLoc, String updateString) throws TransformerFactoryConfigurationError {
        try {
            logger.debug("plist file location:" + plistFileLoc + " Update string:" + updateString);
            File file = new File(plistFileLoc);
            NSDictionary rootDict = (NSDictionary)PropertyListParser.parse((File)file);
            NSObject[] parameters = ((NSArray)rootDict.objectForKey("ProgramArguments")).getArray();
            NSString psDict = (NSString)parameters[0];
            psDict.setContent(updateString);
            PropertyListParser.saveAsXML((NSObject)rootDict, (File)new File(plistFileLoc));
        }
        catch (Exception ex) {
            logger.debug("exception when updating the plist file:", (Throwable)ex);
        }
    }

    private static String getOSType() {
        String osType = System.getProperty("os.name");
        if (!osType.toLowerCase().contains("win")) {
            return osType;
        }
        return osType + "mac";
    }

    static String getOSVersion() {
        String architecture = "";
        try {
            String osVersion = System.getProperty("os.version");
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            architecture = arch != null && arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "(64 bit)" : "(32 bit)";
            return osVersion + architecture;
        }
        catch (Exception e) {
            logger.error("ERROR WHILE GETTING OS VERSION" + e.getMessage());
            logger.trace("" + e);
            return architecture;
        }
    }

    public static NetworkDriveTo mapWebDAVasNetworkDrive(String userName, String password) {
        Integer port = null;
        logger.debug("Trying to map network drive to media hub");
        if (SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpPort() != null) {
            port = Integer.valueOf(SettingHelper.getHttpPort());
        }
        MacSettingsHelper.detectAndRemoveExistingNetworkDrives(port);
        if (userName == null) {
            return MacSettingsHelper.mapNetworkDrive(port);
        }
        return MacSettingsHelper.mapNetworkDrive(userName, password, port);
    }

    public static boolean checkIfDriveIsMounted() {
        logger.debug(REMOVING_EXISTING_DRIVES);
        boolean mounted = false;
        try {
            String[] x = new String[]{MOUNT};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0) {
                return mounted;
            }
            mounted = MacSettingsHelper.readProcessInput(process);
        }
        catch (IOException | InterruptedException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
        return mounted;
    }

    private static boolean readProcessInput(Process process) throws IOException {
        boolean isMounted = false;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String cmdLine;
            while ((cmdLine = bufferedReader.readLine()) != null) {
                logger.debug(" : " + cmdLine);
                if (!cmdLine.contains(SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM)) continue;
                isMounted = true;
                break;
            }
        }
        return isMounted;
    }

    private static MountDriveTO getMountedDriveDetails() {
        logger.debug(REMOVING_EXISTING_DRIVES);
        MountDriveTO driveTO = null;
        try {
            String[] x = new String[]{MOUNT};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0) {
                return new MountDriveTO(false, null);
            }
            driveTO = MacSettingsHelper.getInputWhileMountingDrive(process);
        }
        catch (IOException | InterruptedException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
        return driveTO;
    }

    private static MountDriveTO getInputWhileMountingDrive(Process process) throws IOException {
        MountDriveTO mountedDriveTO = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String cmdLine;
            while ((cmdLine = bufferedReader.readLine()) != null) {
                String[] tempDrives;
                logger.debug(" : " + cmdLine);
                if (!cmdLine.contains(SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM)) continue;
                String driveToUnmap = null;
                String[] driveName = cmdLine.split(" on ");
                if (driveName.length > 1 && (tempDrives = driveName[1].split(" ")).length > 0) {
                    driveToUnmap = tempDrives[0].trim();
                }
                mountedDriveTO = new MountDriveTO(true, driveToUnmap);
                break;
            }
        }
        return mountedDriveTO;
    }

    private static NetworkDriveTo mapNetworkDrive(Integer port) {
        logger.debug("mapping drive");
        String consoleMessage = "";
        try {
            String[] x = new String[]{OSASCRIPT, "-e", "mount volume \"http://" + SettingHelper.getCurrentCloudIpAddress() + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "\" "};
            logger.debug(x[0] + " " + x[1] + " " + x[2]);
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            logger.debug("status 1:" + status);
            if (status != 0 && port != null) {
                String[] x1 = new String[]{OSASCRIPT, "-e", "mount volume \"http://" + SettingHelper.getCurrentCloudIpAddress() + ":" + port + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "\" "};
                process = Runtime.getRuntime().exec(x1);
                status = process.waitFor();
                logger.debug("status 2:" + status);
            }
            MacSettingsHelper.readInputStreamAndDetermineDriveName(null, null, status);
            consoleMessage = MacSettingsHelper.readErrorStream(process);
            SettingHelper.applyChangesToSharedPreferences((boolean)true);
        }
        catch (IOException | InterruptedException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
        return new NetworkDriveTo(consoleMessage, SettingHelper.isMediaHubEnabled());
    }

    private static NetworkDriveTo mapNetworkDrive(String userName, String password, Integer port) {
        logger.debug("mapping drive");
        String consoleMessage = "";
        try {
            String[] x = new String[]{OSASCRIPT, "-e", "mount volume \"http://" + userName + ":" + password + "@" + SettingHelper.getCurrentCloudIpAddress() + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "\" "};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0 && port != null) {
                String[] x1 = new String[]{OSASCRIPT, "-e", "mount volume \"http://" + userName + ":" + password + "@" + SettingHelper.getCurrentCloudIpAddress() + ":" + port + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "\" "};
                process = Runtime.getRuntime().exec(x1);
                status = process.waitFor();
            }
            MacSettingsHelper.readInputStreamAndDetermineDriveName(userName, password, status);
            consoleMessage = MacSettingsHelper.readErrorStream(process);
            SettingHelper.applyChangesToSharedPreferences((boolean)true);
        }
        catch (IOException | InterruptedException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
        return new NetworkDriveTo(consoleMessage, SettingHelper.isMediaHubEnabled());
    }

    private static String readErrorStream(Process process) throws IOException {
        StringBuilder consoleMessage = new StringBuilder();
        try (BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String errorStreamMessage;
            while ((errorStreamMessage = errorBufferedReader.readLine()) != null) {
                if (errorStreamMessage.isEmpty()) continue;
                if (errorStreamMessage.contains(SYSTEM_ERROR_NETWORK_UNREACHABLE)) {
                    consoleMessage = new StringBuilder().append(MEDIAHUB_CONNECTION_ERROR_MESSAGE);
                    break;
                }
                consoleMessage.append(errorStreamMessage).append("\n");
            }
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
        return consoleMessage.toString();
    }

    private static void readInputStreamAndDetermineDriveName(String userName, String password, int status) throws IOException {
        if (status == 0) {
            SettingHelper.setMediaHubEnabled((boolean)true);
            SettingHelper.setMediaUserName((String)userName);
            SettingHelper.setMediaPassword((String)password);
            MountDriveTO driveTO = MacSettingsHelper.getMountedDriveDetails();
            if (driveTO == null || !driveTO.isStatus()) {
                SettingHelper.setWebdevDrive((String)("http://" + SettingHelper.getCurrentCloudIpAddress() + "/" + SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM + "/"));
            } else {
                SettingHelper.setWebdevDrive((String)driveTO.getDriveMounted());
            }
            logger.debug("mediaHub successfully Enabled");
        }
    }

    private static void detectAndRemoveExistingNetworkDrives(Integer port) {
        logger.debug(REMOVING_EXISTING_DRIVES);
        try {
            String[] x = new String[]{MOUNT};
            Process process = Runtime.getRuntime().exec(x);
            int status = process.waitFor();
            if (status != 0 && port != null) {
                String[] x1 = new String[]{MOUNT};
                process = Runtime.getRuntime().exec(x1);
                status = process.waitFor();
            }
            if (status != 0) {
                return;
            }
            MacSettingsHelper.processInputRemovingDrive(process);
        }
        catch (IOException | InterruptedException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
    }

    private static void processInputRemovingDrive(Process process) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String cmdLine;
            while ((cmdLine = bufferedReader.readLine()) != null) {
                logger.debug(" : " + cmdLine);
                if (!cmdLine.contains(SettingHelper.getCloudName() + "/" + MEDIA_HUB_URL_PARAM)) continue;
                String[] driveName = cmdLine.split("on");
                String driveToUnmap = driveName[0].trim();
                MacSettingsHelper.dsconnectManuallyMappedNetworkDrive(driveToUnmap);
            }
        }
    }

    public static void disconnectWebDAVasNetworkDrive() {
        try {
            logger.debug("Trying to disconnect from network drive");
            String x = "umount " + SettingHelper.getWebdevDrive();
            Runtime.getRuntime().exec(x);
            logger.debug("MediaHub disconnect exec statement: " + x);
            SettingHelper.setWebdevDrive(null);
            SettingHelper.setMediaHubEnabled((boolean)false);
            SettingHelper.applyChangesToSharedPreferences((boolean)true);
        }
        catch (IOException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
    }

    private static void dsconnectManuallyMappedNetworkDrive(String driveName) {
        try {
            logger.debug("Trying to disconnect from network drive");
            String x = "umount " + driveName;
            Runtime.getRuntime().exec(x);
            logger.debug("MediaHub disconnect exec statement: " + x);
        }
        catch (IOException e) {
            logger.debug(ERROR_WHILE_CONNECTINGTO_WEBDAV + e);
        }
    }
}

