/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMDNSAdapter {
    private Logger logger = LoggerFactory.getLogger(JMDNSAdapter.class);
    public String ipaddressFromJmdns = null;
    public static final String REMOTE_TYPE = "_paracloud._tcp.local.";
    private Map<String, String> cloudInfo = null;
    public String cloudName = null;

    private void serviceResolved(String foundCloudName, String address) {
        this.ipaddressFromJmdns = foundCloudName;
        if (!this.cloudInfo.containsKey(foundCloudName)) {
            this.cloudInfo.put(foundCloudName, address);
        }
    }

    public String getIpAddress(String cloudName) {
        this.cloudName = cloudName;
        this.logger.debug("Colud Name entered is " + this.cloudName);
        this.cloudInfo = null;
        this.cloudInfo = new HashMap<String, String>();
        this.enumerateNetworkAdaptersAndPerformJmdns();
        String value = null;
        if (!this.cloudInfo.isEmpty()) {
            value = this.cloudInfo.get(cloudName);
        } else if (this.ipaddressFromJmdns != null) {
            value = this.ipaddressFromJmdns;
        }
        return value;
    }

    private void enumerateNetworkAdaptersAndPerformJmdns() {
        ArrayList<Thread> listOfThreads = new ArrayList<Thread>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            this.logger.debug("Enumerating Network interfaces ");
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                List<InterfaceAddress> addresses = networkInterface.getInterfaceAddresses();
                this.enumerateAddressOfNetworkInterfaceAndRunJmdns(listOfThreads, networkInterface, addresses);
            }
            for (Thread jmDnsThread : listOfThreads) {
                jmDnsThread.join();
            }
        }
        catch (SocketException e) {
            this.logger.error("SocketException " + e);
        }
        catch (RuntimeException e) {
            this.logger.error("RuntimeException " + e);
        }
        catch (Exception e) {
            this.logger.error("Exception " + e);
        }
    }

    private void enumerateAddressOfNetworkInterfaceAndRunJmdns(List<Thread> listOfThreads, NetworkInterface networkInterface, List<InterfaceAddress> addresses) throws SocketException {
        int sizeOfAddressList = addresses.size();
        if (sizeOfAddressList == 2) {
            InterfaceAddress address = addresses.get(sizeOfAddressList - 1);
            this.logger.debug("Discovering over " + networkInterface.getName() + " " + networkInterface.getDisplayName());
            this.logger.debug("Supports multicast : " + networkInterface.supportsMulticast());
            CloudDiscoveryThread cloudSearchEngine = new CloudDiscoveryThread(address.getAddress());
            cloudSearchEngine.start();
            listOfThreads.add(cloudSearchEngine);
        } else {
            for (InterfaceAddress address : addresses) {
                this.logger.debug("Discovering over " + networkInterface.getName() + " " + networkInterface.getDisplayName());
                this.logger.debug("Supports multicast : " + networkInterface.supportsMulticast());
                CloudDiscoveryThread cloudSearchEngine = new CloudDiscoveryThread(address.getAddress());
                cloudSearchEngine.start();
                listOfThreads.add(cloudSearchEngine);
            }
        }
    }

    class SampleListener
    implements ServiceListener {
        JmDNS jmdns;

        public SampleListener(JmDNS jm) {
            this.jmdns = jm;
        }

        public void serviceAdded(ServiceEvent event) {
            JMDNSAdapter.this.logger.debug("Service added   : " + event.getName() + " TYPE : " + event.getType());
            this.jmdns.requestServiceInfo(event.getType(), event.getName(), 1L);
        }

        public void serviceRemoved(ServiceEvent event) {
            JMDNSAdapter.this.logger.debug("Service removed   : " + event.getName() + " TYPE : " + event.getType());
        }

        public void serviceResolved(ServiceEvent event) {
            String foundCloudName = event.getInfo().getQualifiedName();
            foundCloudName = foundCloudName.substring(0, foundCloudName.indexOf(46));
            String[] addresses = event.getInfo().getHostAddresses();
            String ip4Address = addresses[0];
            JMDNSAdapter.this.logger.debug("Service Resolved   : " + foundCloudName + " ip : : " + ip4Address);
            JMDNSAdapter.this.logger.debug("Cloud Name Entered is " + JMDNSAdapter.this.cloudName);
            if (foundCloudName != null && foundCloudName.equalsIgnoreCase(JMDNSAdapter.this.cloudName) || ip4Address != null && ip4Address.equals(JMDNSAdapter.this.cloudName)) {
                JMDNSAdapter.this.serviceResolved(foundCloudName, ip4Address);
            }
        }
    }

    class CloudDiscoveryThread
    extends Thread {
        InetAddress inetAddress;

        public CloudDiscoveryThread(InetAddress inetAddressForRunnable) {
            this.inetAddress = inetAddressForRunnable;
        }

        @Override
        public void run() {
            this.discoverOverInterface(this.inetAddress);
        }

        private void discoverOverInterface(InetAddress inetAddress) {
            try {
                ServiceInfo[] serviceInfo;
                JMDNSAdapter.this.logger.debug("JmDNS Ip : " + inetAddress.getHostAddress());
                JmDNS jmdns = JmDNS.create((InetAddress)InetAddress.getByName(inetAddress.getHostAddress()));
                jmdns.addServiceListener(JMDNSAdapter.REMOTE_TYPE, (ServiceListener)new SampleListener(jmdns));
                for (ServiceInfo info : serviceInfo = jmdns.list(JMDNSAdapter.REMOTE_TYPE, 40000L)) {
                    JMDNSAdapter.this.logger.debug("## Service Resolved : " + info.getName());
                    String foundCloudName = info.getQualifiedName();
                    foundCloudName = foundCloudName.substring(0, foundCloudName.indexOf(46));
                    String[] addresses = info.getHostAddresses();
                    String ip4Address = addresses[0];
                    JMDNSAdapter.this.logger.debug("Service Resolved   : " + foundCloudName + " ip : : " + ip4Address);
                    if (JMDNSAdapter.this.cloudName == null || StringUtils.isEmpty((String)JMDNSAdapter.this.cloudName)) {
                        JMDNSAdapter.this.serviceResolved(foundCloudName, ip4Address);
                        continue;
                    }
                    if ((foundCloudName == null || !foundCloudName.equalsIgnoreCase(JMDNSAdapter.this.cloudName)) && (ip4Address == null || !ip4Address.equals(JMDNSAdapter.this.cloudName))) continue;
                    JMDNSAdapter.this.serviceResolved(foundCloudName, ip4Address);
                }
                jmdns.close();
            }
            catch (IOException e) {
                JMDNSAdapter.this.logger.error("JmDns exception ", (Throwable)e);
            }
        }
    }
}

