/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBCountDownTimer {
    private static Logger logger = LoggerFactory.getLogger(PBCountDownTimer.class);
    private static Timer timer;
    private static String countDownTimer;

    public void startCountDownTimer(final int minutes) {
        if (timer != null) {
            timer.cancel();
        }
        System.out.println("minutes:" + minutes);
        int timerDelay = 1000;
        int period = 1000;
        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            int timet;
            long delay;
            DecimalFormat df;
            {
                this.timet = minutes * 60;
                this.delay = (long)this.timet * 1000L;
                this.df = new DecimalFormat("00");
            }

            @Override
            public void run() {
                int minutes2 = this.timet / 60;
                int seconds = this.timet % 60;
                PBCountDownTimer.setCountDownTimer(this.df.format(minutes2) + ":" + this.df.format(seconds));
                countDownTimer = this.df.format(minutes2) + ":" + this.df.format(seconds);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.trace("Interrupted Exception : " + e);
                    logger.error("Interrupted Exception : " + e.getMessage());
                }
                --this.timet;
                this.delay -= 1000L;
                if (this.delay == 0L) {
                    timer.cancel();
                }
            }
        }, timerDelay, (long)period);
        System.out.println("exiting the timer");
    }

    public static String getCountDownTimer() {
        return countDownTimer;
    }

    public static void setCountDownTimer(String countDownTimer) {
        PBCountDownTimer.countDownTimer = countDownTimer;
    }
}

