/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        ECPoint eCPoint = (ECPoint)object;
        return this.x.equals(eCPoint.x) && this.y.equals(eCPoint.y);
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint multiply(BigInteger var1);

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        public byte[] getEncoded() {
            int n = this.getY().toBigInteger().testBit(0) ? 2 : 3;
            byte[] byArray = this.getX().toBigInteger().toByteArray();
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = n;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            return byArray2;
        }

        public ECPoint add(ECPoint eCPoint) {
            ECFieldElement eCFieldElement = eCPoint.y.subtract(this.y).divide(eCPoint.x.subtract(this.x));
            ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCFieldElement).subtract(this.x).subtract(eCPoint.x);
            ECFieldElement eCFieldElement3 = eCFieldElement.multiply(this.x.subtract(eCFieldElement2)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement2, eCFieldElement3);
        }

        public ECPoint twice() {
            ECFieldElement eCFieldElement = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement eCFieldElement2 = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement eCFieldElement3 = this.x.multiply(this.x).multiply(eCFieldElement2).add(this.curve.a).divide(this.y.multiply(eCFieldElement));
            ECFieldElement eCFieldElement4 = eCFieldElement3.multiply(eCFieldElement3).subtract(this.x.multiply(eCFieldElement));
            ECFieldElement eCFieldElement5 = eCFieldElement3.multiply(this.x.subtract(eCFieldElement4)).subtract(this.y);
            return new Fp(this.curve, eCFieldElement4, eCFieldElement5);
        }

        public ECPoint subtract(ECPoint eCPoint) {
            return this.add(new Fp(this.curve, eCPoint.x, eCPoint.y.negate()));
        }

        public ECPoint multiply(BigInteger bigInteger) {
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = bigInteger2.multiply(BigInteger.valueOf(3L));
            ECPoint eCPoint = this;
            int n = bigInteger3.bitLength() - 2;
            while (n > 0) {
                eCPoint = eCPoint.twice();
                if (bigInteger3.testBit(n) && !bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.add(this);
                } else if (!bigInteger3.testBit(n) && bigInteger2.testBit(n)) {
                    eCPoint = eCPoint.subtract(this);
                }
                --n;
            }
            return eCPoint;
        }
    }
}

