/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.settings.CheckBackupPolicy;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.helper.ParabluStringUtils;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.ScheduleTO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashChecker {
    private static Logger logger = LoggerFactory.getLogger(HashChecker.class);
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());

    public static boolean isHashMatchForBackupPolicy(BackupPolicyTO policyTO) {
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedStringForPolicyTO((StringBuilder)stringBuilder, (BackupPolicyTO)policyTO);
        logger.debug("stringBuilder......get poilyc string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("BACKUP_POLICY");
        logger.debug("Hash value for policyTo" + hashValue + " Hash from saved table:" + hashValueFromTable);
        return StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue);
    }

    public static List<BackupFolderTO> getAllFolderToBackUpFiles() {
        List<BackupFolderTO> listOfFolderFromPolicy = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedStringForBackupFolderToList((StringBuilder)stringBuilder, listOfFolderFromPolicy);
        logger.debug("stringBuilder......get poilyc string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("BKFT");
        logger.debug("Hash value for policyTo" + hashValue + " Hash from saved table:" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return listOfFolderFromPolicy;
        }
        logger.debug("CALLING CHECK GROUP POLICY#######################");
        CheckBackupPolicy.checkGroupPolicy();
        listOfFolderFromPolicy = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        return listOfFolderFromPolicy;
    }

    public static List<BackupFolderTO> getAllExceptionsToExclusion() {
        List<BackupFolderTO> exceptionsToExclusion = backUpFolderDAOImpl.getAllExceptionsToExclusions();
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedExceptionsToExclusionList((StringBuilder)stringBuilder, exceptionsToExclusion);
        logger.debug("stringBuilder for exceptionsToExclusion......get poilyc string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("exceptionsToExclusions");
        logger.debug("Hash value for policy To" + hashValue + "Hash from save table :" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return exceptionsToExclusion;
        }
        logger.debug("Calling check group policy ........");
        CheckBackupPolicy.checkGroupPolicy();
        exceptionsToExclusion = backUpFolderDAOImpl.getAllExceptionsToExclusions();
        return exceptionsToExclusion;
    }

    public static List<BackupFolderTO> getsqlBackupFolders() {
        List<BackupFolderTO> exceptionsToExclusion = backUpFolderDAOImpl.getAllSqlBackupFolders();
        logger.debug("Calling check group policy ....pvn...." + exceptionsToExclusion.size());
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedExceptionsToExclusionList((StringBuilder)stringBuilder, exceptionsToExclusion);
        logger.debug("stringBuilder for exceptionsToExclusion......get poilyc string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("exceptionsToExclusions");
        logger.debug("Hash value for policy To" + hashValue + "Hash from save table :" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return exceptionsToExclusion;
        }
        logger.debug("Calling check group policy ........");
        CheckBackupPolicy.checkGroupPolicy();
        exceptionsToExclusion = backUpFolderDAOImpl.getAllSqlBackupFolders();
        logger.debug("Calling check group policy ....pvn...." + exceptionsToExclusion.size());
        return exceptionsToExclusion;
    }

    public static List<String> getExcludedFoldersList() {
        List<String> listOfFolderFromPolicy = backupPolicyDAOImpl.getExcludedFoldersList();
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedStringForStringList((StringBuilder)stringBuilder, listOfFolderFromPolicy);
        logger.debug("stringBuilder......get exclusionss string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("policyExcludedFolders");
        logger.debug("Hash value for policyTo" + hashValue + " Hash from saved table:" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return listOfFolderFromPolicy;
        }
        logger.debug("Something's hash not matched so ###PULL POLICY### again..");
        CheckBackupPolicy.checkGroupPolicy();
        listOfFolderFromPolicy = backupPolicyDAOImpl.getExcludedFoldersList();
        return listOfFolderFromPolicy;
    }

    public static List<ScheduleTO> getScheduleList() {
        List<ScheduleTO> listOfSchedulesFromPolicy = backupPolicyDAOImpl.getSchedules();
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedStringForScheduleTOList((StringBuilder)stringBuilder, listOfSchedulesFromPolicy);
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("SCHEDULES");
        logger.debug("Hash value for Schedule" + hashValue + " Hash from saved table:" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            logger.debug("hash is matched so return..." + listOfSchedulesFromPolicy.get(0).getStartTime());
            return listOfSchedulesFromPolicy;
        }
        logger.debug("HAsh is not matched for schedules..........");
        logger.debug("Something's hash not matched so ###PULL POLICY### again..");
        CheckBackupPolicy.checkGroupPolicy();
        listOfSchedulesFromPolicy = backupPolicyDAOImpl.getSchedules();
        return listOfSchedulesFromPolicy;
    }

    public static List<BluVaultTO> getEbmsList() {
        List<BluVaultTO> listOfEbmsFromPolicy = backupPolicyDAOImpl.getBluVaultList();
        StringBuilder stringBuilder = new StringBuilder();
        ParabluStringUtils.createCommaSeparatedStringForBluVaultList((StringBuilder)stringBuilder, listOfEbmsFromPolicy);
        logger.debug("stringBuilder......get ebms string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("EBMS");
        logger.debug("Hash value for policyTo" + hashValue + " Hash from saved table:" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return listOfEbmsFromPolicy;
        }
        logger.debug("Something's hash not matched so ###PULL POLICY### again..");
        CheckBackupPolicy.checkGroupPolicy();
        listOfEbmsFromPolicy = backupPolicyDAOImpl.getBluVaultList();
        return listOfEbmsFromPolicy;
    }

    public static List<GatewayTO> getGatewayList(String policyName) {
        List<GatewayTO> listOfGatewaysFromPolicy = backupPolicyDAOImpl.getGatewayList(policyName);
        StringBuilder stringBuilder = new StringBuilder();
        List<GatewayTO> listOfAllGatewaysFromPolicy = backupPolicyDAOImpl.getGatewayList(null);
        ParabluStringUtils.createCommaSeparatedGatewayTOList((StringBuilder)stringBuilder, listOfAllGatewaysFromPolicy);
        logger.debug("stringBuilder......get gateway string: " + stringBuilder.toString());
        String hashValue = ParabluStringUtils.getHashValue((StringBuilder)stringBuilder, (String)SettingHelper.getDeviceUUId());
        String hashValueFromTable = backUpFolderDAOImpl.getHashValueFoeTable("GATEWAYLIST");
        logger.debug("Hash value for gateway:" + hashValue + " Hash from saved table:" + hashValueFromTable);
        if (StringUtils.isNotEmpty((String)hashValueFromTable) && hashValueFromTable.contentEquals(hashValue)) {
            return listOfGatewaysFromPolicy;
        }
        logger.debug("Something's hash not matched so ###PULL POLICY### again..");
        CheckBackupPolicy.checkGroupPolicy();
        listOfGatewaysFromPolicy = backupPolicyDAOImpl.getGatewayList(policyName);
        return listOfGatewaysFromPolicy;
    }
}

