/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.to.FileTO;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreRestartRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RestoreRestartRunnable.class);
    private AtomicInteger noOfBatches;
    private BlockingQueue<Future<Integer>> finishedBatchesQueue;
    private Thread restoreThread;
    private AtomicBoolean interupted;
    private RestoreElement restoreElement;
    private boolean isSync;
    private CleanupInterface cleanupInterface;

    public RestoreRestartRunnable(AtomicInteger noOfBatches, BlockingQueue<Future<Integer>> finishedBatchesQueue, Thread restoreThread, AtomicBoolean interupted, RestoreElement restoreElement, boolean isSync, CleanupInterface cleanupInterface) {
        this.noOfBatches = noOfBatches;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.restoreThread = restoreThread;
        this.interupted = interupted;
        this.restoreElement = restoreElement;
        this.isSync = isSync;
        this.cleanupInterface = cleanupInterface;
    }

    @Override
    public void run() {
        int batchId = 0;
        while (!Thread.interrupted()) {
            try {
                this.logger.debug("No of batches > i value > : " + batchId + "batch size>" + this.noOfBatches.get());
                int respnse = this.finishedBatchesQueue.take().get();
                if (respnse == -1) {
                    this.logger.debug("After taking BackupTo from finishedBatchesQueue>>>>>no of batches:" + this.noOfBatches.get());
                    break;
                }
                if (respnse != -1) {
                    if (this.isSync) {
                        this.logger.debug("Doing post changes for sync");
                        if (this.restoreElement != null) {
                            Set restoredFiles = this.restoreElement.getRestoredFiles();
                            this.logger.debug("Number of restored files : " + restoredFiles.size() + " batchId : " + batchId);
                            if (restoredFiles != null && !restoredFiles.isEmpty()) {
                                Iterator fileTOIterator = restoredFiles.iterator();
                                while (fileTOIterator.hasNext()) {
                                    FileTO fileTO = (FileTO)fileTOIterator.next();
                                    this.cleanupInterface.runCleanup(fileTO, fileTO.getDownloadStatus());
                                    fileTOIterator.remove();
                                }
                            }
                        }
                    }
                    ++batchId;
                    continue;
                }
                this.logger.debug("Last backup batch file is null so breaking the loop>>>>>>>");
                this.logger.debug("Last backup batch file is null finished que size is:" + this.finishedBatchesQueue.size());
                this.interupted.set(true);
                this.restoreThread.interrupt();
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.trace("" + e);
                this.logger.error("interrupted or execution exception" + e.getMessage());
                this.logger.debug("sdsd");
                this.logger.trace("" + e);
                this.logger.error("Exception :" + e.getMessage());
                this.interupted.set(true);
                this.restoreThread.interrupt();
                Thread.currentThread().interrupt();
            }
        }
        this.logger.error("Thread is been nudged inside Restart Runnable&&&&&&");
    }
}

