/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.registration;

import com.parablu.epa.core.adapter.pcb.CloudAdapter;
import com.parablu.epa.core.element.DeviceRegistrationElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.SymmetricEncryptionUtility;
import com.parablu.epa.core.service.httpserver.HttpRequestHandler;
import com.parablu.epa.core.service.httpserver.SimpleHttpServer;
import com.parablu.epa.core.service.network.CloudIPHelper;
import com.parablu.epa.core.service.registration.ResponseData;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.DeviceRegTo;
import com.parablu.epa.core.to.ResponseTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudRegistrationUtility
extends CloudIPHelper {
    private static final String ERROR_CODE = "Error code is :";
    private static final String EXCEPTION_IN_CLOUDREGISTRATION_SERVICE = "Exception in CloudRegistrationService :";
    private static final String EXCEPTION_THROWN = "Threw Exception???";
    private static final String EXCEPTION_IN_CLOUDREGISTRATION_SERVICE_DUE_TO_BAD_IP = "Exception in CloudRegistrationService :, Mostly due to Bad Ip or request";
    private static final String CONTEXT = "/app";
    private static final int PORT = 8967;
    private Logger logger = LoggerFactory.getLogger(CloudRegistrationUtility.class);
    private final String cloudName;
    private final String deviceName;
    private String userName;
    private final String password;
    private String prefferedIP = null;
    private Integer prefferedPort = null;
    private String devicefinalUUID = null;
    private String token = null;
    public String productVersion = null;
    public boolean retryRegister = false;
    private String keystore;
    private SimpleHttpServer simpleHttpServer = null;

    public CloudRegistrationUtility(String userCloudName, String userDeviceName, String name, String userPassword, InputStream inputStream) {
        super(userCloudName, inputStream);
        this.cloudName = userCloudName;
        this.deviceName = userDeviceName;
        this.userName = name;
        this.password = userPassword;
    }

    public CloudRegistrationUtility(String userCloudName, String userDeviceName, String name, String userPassword, String keyStore) {
        super(userCloudName, keyStore);
        this.cloudName = userCloudName;
        this.deviceName = userDeviceName;
        this.userName = name;
        this.password = userPassword;
        this.keystore = keyStore;
    }

    public CloudRegistrationUtility(String userCloudName, InputStream inputStream) {
        super(userCloudName, inputStream);
        this.cloudName = userCloudName;
        this.deviceName = null;
        this.userName = null;
        this.password = null;
    }

    public CloudRegistrationUtility(String userCloudName, String keyStore) {
        super(userCloudName, keyStore);
        this.cloudName = userCloudName;
        this.deviceName = null;
        this.userName = null;
        this.password = null;
    }

    public CloudRegistrationUtility(String userCloudName, String userDeviceName, String name, String keyStore) {
        super(userCloudName, keyStore);
        this.cloudName = userCloudName;
        this.deviceName = userDeviceName;
        this.userName = name;
        this.password = null;
    }

    public boolean validateData() {
        if (this.cloudName == null || this.userName == null) {
            return false;
        }
        if (this.password == null || this.deviceName == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.cloudName) && !StringUtils.isEmpty((String)this.userName) && !StringUtils.isEmpty((String)this.password) && !StringUtils.isEmpty((String)this.deviceName);
    }

    public DeviceRegTo registerDeviceForCloud(String uuid, String osType, String deviceAlreadyRegistered, String logiType, String osVersion, String forceRegCheck) {
        return this.registerDeviceForCloud(uuid, null, osType, deviceAlreadyRegistered, this.keystore, osVersion, logiType, forceRegCheck);
    }

    public DeviceRegTo registerDeviceForCloud(String uuid, InputStream inputStream, String osType, String deviceAlreadyRegistered, String keyStorePath, String osVersion, String loginType, String forceRegCheck) {
        ResponseTO responseTO;
        int errorCode = 80;
        if (this.cloudName == null) {
            return new DeviceRegTo(80);
        }
        this.prefferedIP = null;
        String deviceUUIDTempUserName = null;
        try {
            deviceUUIDTempUserName = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            this.logger.trace("" + e);
            this.logger.error("Exception while Device registering to Cloud :" + e.getMessage());
        }
        if (StringUtils.isNotBlank((String)uuid) || uuid != null) {
            this.logger.debug("generating DeviceUIID Using Serial Number &&deviceName" + deviceUUIDTempUserName);
            this.devicefinalUUID = this.generateDeviceUIIDUsingSerialNumber(deviceUUIDTempUserName, this.userName.toLowerCase(), uuid);
        } else {
            this.logger.debug("generating DeviceUIID Using MAC address :" + deviceUUIDTempUserName);
            this.devicefinalUUID = this.generateDeviceUIID(deviceUUIDTempUserName);
        }
        this.logger.debug("Registering device for cloud method");
        String req = CreateXmlObject.createXmlStringForDeviceRegistration(this.deviceName, this.devicefinalUUID, osType, osVersion);
        String passwordHash = null;
        String encPwd = null;
        if (this.password != null) {
            passwordHash = MD5Generator.getSHA512hash((String)this.password);
            encPwd = SymmetricEncryptionUtility.encrypt(this.password);
            this.logger.debug("MD5 generated");
        }
        if ((responseTO = this.registerDevice(req, passwordHash, inputStream, deviceAlreadyRegistered, keyStorePath, encPwd, forceRegCheck)) != null && responseTO.getResponseCode() == 1014) {
            this.logger.error("Error code is :1014");
            return new DeviceRegTo(1014);
        }
        if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400 || responseTO.getResponseCode() == 503) {
            this.logger.error("Response is null ,error code is :" + errorCode + " Retry enabled:" + this.retryRegister);
            if (this.retryRegister) {
                this.logger.debug("Inside retry enabled...");
                responseTO = this.retryRegistering(req, passwordHash, inputStream, deviceAlreadyRegistered, keyStorePath, encPwd, forceRegCheck);
                if (responseTO == null || responseTO.getResponseCode() == 404 || responseTO.getResponseCode() == 400 || responseTO.getResponseCode() == 503) {
                    return new DeviceRegTo(80);
                }
            } else {
                this.logger.debug("Inside retry disabled...");
                return new DeviceRegTo(80);
            }
        }
        if (responseTO.getResponseCode() == 416) {
            this.logger.error("Error code is :1005");
            return new DeviceRegTo(1005);
        }
        if (responseTO.getResponseCode() == 426) {
            this.logger.error("Error code is :426");
            return new DeviceRegTo(426);
        }
        if (responseTO.getResponseCode() == 418) {
            this.logger.error("Error code is :1001");
            return new DeviceRegTo(1001);
        }
        if (responseTO.getResponseCode() == 417) {
            this.logger.error("Error code is :1004");
            return new DeviceRegTo(1004);
        }
        if (responseTO.getResponseCode() == 401) {
            this.logger.error("Error code is :8");
            return new DeviceRegTo(8);
        }
        if (responseTO.getResponseCode() == 420) {
            this.logger.error("Error code is :3");
            return new DeviceRegTo(3);
        }
        if (responseTO.getResponseCode() == 425) {
            this.logger.error("Error code is :425");
            return new DeviceRegTo(425);
        }
        if (responseTO.getResponseCode() == 500) {
            this.logger.error("Error code is :20");
            return new DeviceRegTo(20);
        }
        if (responseTO.getResponseCode() == 422) {
            this.logger.error("Error code is :120");
            return new DeviceRegTo(120);
        }
        if (responseTO.getResponseCode() == 409) {
            this.logger.error("Error code is :409");
            return new DeviceRegTo(409);
        }
        if (responseTO.getResponseCode() == 403) {
            this.logger.error("Error code is :403");
            return new DeviceRegTo(403);
        }
        if (responseTO.getResponseCode() == 901) {
            this.logger.error("Error code is :901");
            return new DeviceRegTo(1013);
        }
        if (responseTO.getResponseCode() == 450) {
            this.logger.error("Error code is :450");
            return new DeviceRegTo(1016);
        }
        if (responseTO.getResponseCode() == 444) {
            this.logger.error("Error code is :444");
            return new DeviceRegTo(1019, responseTO.getClientId(), responseTO.getTenantName(), responseTO.getEndPointRedirectUri(), responseTO.getLoginMode(), responseTO.getAccessToken());
        }
        if (responseTO.getResponseCode() == 432) {
            this.logger.error("Error code is :432");
            return new DeviceRegTo(1018, null, null, null, null, responseTO.getAccessToken());
        }
        if (responseTO.getResponseCode() == 431) {
            this.logger.error("Error code is :431");
            return new DeviceRegTo(1015, null, null, null, null, responseTO.getAccessToken());
        }
        if (responseTO.getResponseCode() == 433) {
            this.logger.error("Error code is :433");
            return new DeviceRegTo(1017, null, null, null, null, responseTO.getAccessToken());
        }
        if (responseTO.getResponseCode() == 436) {
            this.logger.error("Error code is :436");
            return new DeviceRegTo(1020);
        }
        this.token = responseTO.getToken();
        DeviceRegistrationElement deviceElement = Xmlparser.parseDeviceRegistrationResponse(responseTO.getResponse());
        if (deviceElement == null) {
            this.logger.error("Device element parsed is null ,error code is :" + errorCode);
            return new DeviceRegTo(20);
        }
        this.userName = deviceElement.getDeviceElement().getUserName();
        errorCode = 30;
        this.logger.debug("Response code for registerCloud is :" + errorCode);
        return new DeviceRegTo(errorCode, deviceElement, responseTO.getSyncEnabled(), responseTO.getBackupEnabled(), responseTO.getIsLDAPEnabled(), deviceElement.getDeviceElement().getDeviceUUID(), responseTO.getRestoreEnabled(), deviceElement.getDeviceElement().getDecoupled(), responseTO.getCloudName(), responseTO.getIsExternalStorageSelected(), responseTO.getUiVersion(), responseTO.getServerBackupEnabled(), deviceElement.getBackupPolicyElement(), deviceElement.getSyncPolicyElement(), responseTO.isUserConsentGiven());
    }

    public void startHttpServer() {
        this.simpleHttpServer = new SimpleHttpServer(8967, CONTEXT, new HttpRequestHandler());
        this.simpleHttpServer.start();
        this.logger.debug("Server is started and listening on port 8967");
    }

    public void stopHttpServer() {
        if (this.simpleHttpServer != null) {
            this.simpleHttpServer.stop();
            this.logger.debug("Server stopped successfully");
        }
    }

    private ResponseTO retryRegistering(String req, String passwordHash, InputStream inputStream, String deviceAlreadyRegistered, String keyStorePath, String encPwd, String forceRegCheck) {
        ResponseTO responseTO;
        boolean retry;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 30000L * (long)sleepMultiplier;
        do {
            this.logger.debug("Inside retry register device");
            retry = false;
            responseTO = this.registerDevice(req, passwordHash, inputStream, deviceAlreadyRegistered, keyStorePath, encPwd, forceRegCheck);
            if (responseTO != null && responseTO.getResponseCode() != 404 && responseTO.getResponseCode() != 400 && responseTO.getResponseCode() != 503) continue;
            this.logger.debug("response is null or empty Inside retry registration");
            retry = true;
            sleepTime = this.sleepForGivenTime(sleepTime, retry);
        } while (retry && ++retryCount < 4);
        return responseTO;
    }

    private long sleepForGivenTime(long sleepTime, boolean retry) {
        long sleepTimeTemp = sleepTime;
        try {
            this.logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            this.logger.error("Sleeper Thread interupted error");
        }
        return sleepTimeTemp;
    }

    private ResponseTO registerDevice(String req, String passwordHash, InputStream input, String deviceAlreadyRegistered, String keyStorePath, String encPwd, String forceRegCheck) {
        ResponseData data = this.useAppropriateIpAndCheckIfDeviceUnique(req, passwordHash, input, deviceAlreadyRegistered, keyStorePath, encPwd, this.productVersion, forceRegCheck);
        return data.response;
    }

    private ResponseData useAppropriateIpAndCheckIfDeviceUnique(String req, String passwordHash, InputStream input, String deviceAlreadyRegistered, String keyStorePath, String encPwd, String productVersion, String forceRegCheck) {
        CloudAdapter pa = input == null ? new CloudAdapter(this.cloudName, keyStorePath) : new CloudAdapter(input, this.cloudName);
        ResponseData data = new ResponseData();
        data = this.registerDeviceValidationWithGAELocal(pa, data, req, passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
        data = this.registerDeviceValidationPublicIP(pa, data, req, passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
        data = this.registerDeviceValidationPublicIPAndUpnpPort(pa, data, req, passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
        if (!data.networkCon || data.response == null || StringUtils.isBlank((String)this.prefferedIP)) {
            data.response = null;
        }
        return data;
    }

    private ResponseData registerDeviceValidationPublicIPAndUpnpPort(CloudAdapter pa, ResponseData data, String req, String passwordHash, String deviceAlreadyRegistered, String encPwd, String productVersion, String forceRegCheck) {
        if (!data.networkCon) {
            try {
                if (StringUtils.isNotBlank((String)this.getCloudPublicIP())) {
                    this.logger.debug("using cloudPublicIP ip address..");
                    ResponseTO responseTO = pa.registerDevice(this.getCloudPublicIP(), Integer.valueOf(this.getHttpsPort()), req, this.getUserName(), passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
                    this.prefferedIP = this.getCloudPublicIP();
                    data.response = responseTO;
                    data.networkCon = true;
                    this.prefferedPort = Integer.valueOf(this.getHttpsPort());
                }
            }
            catch (CrawlAdapterException e) {
                this.logger.error(EXCEPTION_IN_CLOUDREGISTRATION_SERVICE_DUE_TO_BAD_IP + e.getMessage());
                this.logger.trace(EXCEPTION_THROWN + e);
            }
            catch (Exception e) {
                this.logger.error(EXCEPTION_IN_CLOUDREGISTRATION_SERVICE + e);
            }
        }
        return data;
    }

    private ResponseData registerDeviceValidationPublicIP(CloudAdapter pa, ResponseData data, String req, String passwordHash, String deviceAlreadyRegistered, String encPwd, String productVersion, String forceRegCheck) {
        if (!data.networkCon) {
            try {
                if (StringUtils.isNotBlank((String)this.getCloudPublicIP())) {
                    this.logger.debug("using cloudPublicIP ip address..");
                    ResponseTO responseTO = pa.registerDevice(this.getCloudPublicIP(), null, req, this.getUserName(), passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
                    this.prefferedIP = this.getCloudPublicIP();
                    data.response = responseTO;
                    data.networkCon = true;
                }
            }
            catch (CrawlAdapterException e) {
                this.logger.error(EXCEPTION_IN_CLOUDREGISTRATION_SERVICE_DUE_TO_BAD_IP + e.getMessage());
                this.logger.trace(EXCEPTION_THROWN + e);
            }
            catch (Exception e) {
                this.logger.error(EXCEPTION_IN_CLOUDREGISTRATION_SERVICE + e);
            }
        }
        return data;
    }

    private ResponseData registerDeviceValidationWithGAELocal(CloudAdapter pa, ResponseData data, String req, String passwordHash, String deviceAlreadyRegistered, String encPwd, String productVersion, String forceRegCheck) {
        ResponseTO responseTO = null;
        try {
            if (StringUtils.isNotBlank((String)this.getGaeCloudLocalIP())) {
                this.logger.debug("Using GAE local ip address..");
                responseTO = pa.registerDevice(this.getGaeCloudLocalIP(), null, req, this.getUserName(), passwordHash, deviceAlreadyRegistered, encPwd, productVersion, forceRegCheck);
                this.prefferedIP = this.getGaeCloudLocalIP();
                data.response = responseTO;
                data.networkCon = true;
            }
        }
        catch (CrawlAdapterException e) {
            this.logger.error("CrawlAdapterException in CloudRegistrationService :, Mostly due to Bad Ip or request" + e.getMessage());
            this.logger.trace(EXCEPTION_THROWN + e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.trace("Exception" + e);
            this.logger.error(EXCEPTION_IN_CLOUDREGISTRATION_SERVICE + e);
        }
        return data;
    }

    private String generateDeviceUIID(String profileUserName) {
        StringBuilder compleUUID = new StringBuilder();
        compleUUID.append(profileUserName);
        compleUUID.append(this.userName.toLowerCase());
        String completeUUIDString = compleUUID.toString().replace(' ', '_');
        return MD5Generator.generateMD5OfString((String)completeUUIDString);
    }

    private String generateDeviceUIIDUsingSerialNumber(String profileUserName, String userName, String serialNumber) {
        StringBuilder compleUUID = new StringBuilder();
        compleUUID.append(profileUserName);
        compleUUID.append(userName);
        compleUUID.append(serialNumber);
        String completeUUIDString = compleUUID.toString().replace(' ', '_');
        return MD5Generator.generateMD5OfString((String)completeUUIDString);
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public Integer getPrefferedPort() {
        return this.prefferedPort;
    }

    public void setPrefferedPort(Integer prefferedPort) {
        this.prefferedPort = prefferedPort;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefferedIP() {
        return this.prefferedIP;
    }

    public void setPrefferedIP(String prefferedIP) {
        this.prefferedIP = prefferedIP;
    }

    public String getToken() {
        return this.token;
    }

    public boolean validateDataForSilent() {
        if (this.cloudName == null || this.userName == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.cloudName) && !StringUtils.isEmpty((String)this.userName) && !StringUtils.isEmpty((String)this.deviceName);
    }

    public boolean checkDeviceCertAuthentication(String deviceCertName) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String canonicalHostName = inetAddress.getCanonicalHostName();
            this.logger.debug("domain name from AD :" + canonicalHostName);
            String regex = ".*" + deviceCertName + ".*";
            if (!StringUtils.isEmpty((String)canonicalHostName) && canonicalHostName.matches(regex)) {
                this.logger.debug("domain name from AD is matched: " + canonicalHostName);
                return true;
            }
        }
        catch (UnknownHostException e) {
            this.logger.error("Error in finding domain name probably no host found" + e.getMessage());
            this.logger.trace("" + e);
            return false;
        }
        return false;
    }
}

