/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class CertificationRequestInfo
implements DEREncodable {
    DERInteger version = new DERInteger(0);
    X509Name subject;
    SubjectPublicKeyInfo subjectPKInfo;
    DERConstructedSet attributes = null;
    boolean isexplicit = false;

    public static CertificationRequestInfo getInstance(Object object) {
        if (object instanceof CertificationRequestInfo) {
            return (CertificationRequestInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertificationRequestInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertificationRequestInfo(X509Name x509Name, SubjectPublicKeyInfo subjectPublicKeyInfo, DERConstructedSet dERConstructedSet) {
        this.subject = x509Name;
        this.subjectPKInfo = subjectPublicKeyInfo;
        this.attributes = dERConstructedSet;
        if (x509Name == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public CertificationRequestInfo(ASN1Sequence aSN1Sequence) {
        this.version = (DERInteger)aSN1Sequence.getObjectAt(0);
        this.subject = X509Name.getInstance(aSN1Sequence.getObjectAt(1));
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(2));
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(3);
        if (!dERTaggedObject.isEmpty()) {
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERTaggedObject.getObject();
            this.attributes = new DERConstructedSet();
            if (dERConstructedSequence.getObjectAt(0) instanceof ASN1Sequence) {
                int n = 0;
                while (n != dERConstructedSequence.getSize()) {
                    this.attributes.addObject(dERConstructedSequence.getObjectAt(n));
                    ++n;
                }
            } else {
                this.attributes.addObject(dERConstructedSequence);
            }
        }
        this.isexplicit = dERTaggedObject.isExplicit();
        if (this.subject == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPKInfo;
    }

    public DERConstructedSet getAttributes() {
        return this.attributes;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.subject);
        dERConstructedSequence.addObject(this.subjectPKInfo);
        if (this.attributes == null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0));
        } else {
            dERConstructedSequence.addObject(new DERTaggedObject(this.isexplicit, 0, this.attributes));
        }
        return dERConstructedSequence;
    }
}

