/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.Digest;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;

public class DigestedData
implements DEREncodable {
    private CMSVersion version;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private EncapsulatedContentInfo encapContentInfo;
    private Digest digest;

    public DigestedData(CMSVersion cMSVersion, DigestAlgorithmIdentifier digestAlgorithmIdentifier, EncapsulatedContentInfo encapsulatedContentInfo, Digest digest) {
        this.setVersion(cMSVersion);
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setDigest(digest);
    }

    public DigestedData(BERConstructedSequence bERConstructedSequence) {
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(0));
        this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(1));
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(bERConstructedSequence.getObjectAt(2));
        this.digest = Digest.getInstance(bERConstructedSequence.getObjectAt(2));
    }

    public DigestedData(DigestedData digestedData) {
        this.version = digestedData.version;
        this.digestAlgorithm = digestedData.digestAlgorithm;
        this.encapContentInfo = digestedData.encapContentInfo;
        this.digest = digestedData.digest;
    }

    public static DigestedData getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestedData) {
            return (DigestedData)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new DigestedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestedData");
    }

    public static DigestedData newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestedData) {
            return new DigestedData((DigestedData)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new DigestedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestedData");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void setDigest(Digest digest) {
        this.digest = digest;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.digestAlgorithm);
        bERConstructedSequence.addObject(this.encapContentInfo);
        bERConstructedSequence.addObject(this.digest);
        return bERConstructedSequence;
    }
}

