/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;

public class BidiUtil {
    public static final int KEYBOARD_NON_BIDI = 0;
    public static final int KEYBOARD_BIDI = 1;
    static int isBidiPlatform = -1;
    public static final int CLASSIN = 1;
    public static final int LINKBEFORE = 2;
    public static final int LINKAFTER = 4;
    static Map<LONG, Runnable> languageMap = new HashMap<LONG, Runnable>();
    static Map<LONG, LONG> oldProcMap = new HashMap<LONG, LONG>();
    static final String CLASS_NAME = "org.eclipse.swt.internal.BidiUtil";
    static Callback callback;
    static final int GCP_REORDER = 2;
    static final int GCP_GLYPHSHAPE = 16;
    static final int GCP_LIGATE = 32;
    static final int GCP_CLASSIN = 524288;
    static final byte GCPCLASS_ARABIC = 2;
    static final byte GCPCLASS_HEBREW = 2;
    static final byte GCPCLASS_LOCALNUMBER = 4;
    static final byte GCPCLASS_LATINNUMBER = 5;
    static final int GCPGLYPH_LINKBEFORE = 32768;
    static final int GCPGLYPH_LINKAFTER = 16384;
    static final int ETO_CLIPPED = 4;
    static final int ETO_GLYPH_INDEX = 16;
    static final int LANG_ARABIC = 1;
    static final int LANG_HEBREW = 13;
    static final int LANG_FARSI = 41;
    static final String CD_PG_HEBREW = "1255";
    static final String CD_PG_ARABIC = "1256";
    static final int HKL_NEXT = 1;
    static final int HKL_PREV = 0;
    public static final int CLASS_HEBREW = 2;
    public static final int CLASS_ARABIC = 2;
    public static final int CLASS_LOCALNUMBER = 4;
    public static final int CLASS_LATINNUMBER = 5;
    public static final int REORDER = 2;
    public static final int LIGATE = 32;
    public static final int GLYPHSHAPE = 16;

    public static void addLanguageListener(int n, Runnable runnable) {
        languageMap.put(new LONG(n), runnable);
        BidiUtil.subclass(n);
    }

    public static void addLanguageListener(Control control, Runnable runnable) {
        BidiUtil.addLanguageListener(control.handle, runnable);
    }

    static int EnumSystemLanguageGroupsProc(int n, int n2, int n3, int n4, int n5) {
        if (n == 12) {
            isBidiPlatform = 1;
            return 0;
        }
        if (n == 13) {
            isBidiPlatform = 1;
            return 0;
        }
        return 1;
    }

    public static void drawGlyphs(GC gC, char[] cArray, int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.GetLayout(gC.handle) != 0) {
            BidiUtil.reverse(nArray);
            int n4 = n3 - 1;
            nArray[n4] = nArray[n4] - 1;
            BidiUtil.reverse(cArray);
        }
        int n5 = OS.SetBkMode(gC.handle, 1);
        OS.ExtTextOutW(gC.handle, n, n2, 16, null, cArray, cArray.length, nArray);
        OS.SetBkMode(gC.handle, n5);
    }

    public static char[] getRenderInfo(GC gC, String string, int[] nArray, byte[] byArray, int[] nArray2, int n, int[] nArray3) {
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        int n3 = OS.GetProcessHeap();
        int[] nArray4 = new int[8];
        int n4 = OS.GetTextCharset(gC.handle);
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl = OS.GetLayout(gC.handle) != 0;
        }
        OS.TranslateCharsetInfo(n4, nArray4, 1);
        TCHAR tCHAR = new TCHAR(nArray4[1], string, false);
        int n5 = tCHAR.length();
        boolean bl2 = (n & 2) == 2;
        boolean bl3 = (n & 4) == 4;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n5;
        int n6 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n3, 8, n5 * 4);
        int n7 = gCP_RESULTS.lpDx = OS.HeapAlloc(n3, 8, n5 * 4);
        int n8 = gCP_RESULTS.lpClass = OS.HeapAlloc(n3, 8, n5);
        int n9 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(n3, 8, n5 * 2);
        int n10 = 0;
        int n11 = 0;
        n10 |= 2;
        if ((n2 & 0x20) == 32) {
            n10 |= 0x20;
            n11 |= 0;
        }
        if ((n2 & 0x10) == 16) {
            n10 |= 0x10;
            if (bl2) {
                n11 |= 0x8000;
            }
            if (bl3) {
                n11 |= 0x4000;
            }
        }
        byte[] byArray2 = bl2 || bl3 ? new byte[]{(byte)n11, (byte)(n11 >> 8)} : new byte[]{(byte)n11};
        OS.MoveMemory(gCP_RESULTS.lpGlyphs, byArray2, byArray2.length);
        if ((n & 1) == 1) {
            n10 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        char[] cArray = new char[gCP_RESULTS.nGlyphs];
        int n12 = 0;
        for (int i = 0; i < nArray3.length - 1; ++i) {
            Object[] objectArray;
            int n13;
            int n14 = nArray3[i];
            gCP_RESULTS.nGlyphs = n13 = nArray3[i + 1] - nArray3[i];
            TCHAR tCHAR2 = new TCHAR(nArray4[1], string.substring(n14, n14 + n13), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n10);
            if (nArray2 != null) {
                objectArray = new int[gCP_RESULTS.nGlyphs];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpDx, objectArray.length * 4);
                if (bl) {
                    BidiUtil.reverse(objectArray);
                }
                System.arraycopy(objectArray, 0, nArray2, n12, objectArray.length);
            }
            if (nArray != null) {
                objectArray = new int[n13];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n12, bl);
                System.arraycopy(objectArray, 0, nArray, n14, n13);
            }
            if (byArray != null) {
                objectArray = new byte[n13];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n14, n13);
            }
            objectArray = new char[gCP_RESULTS.nGlyphs];
            OS.MoveMemory((char[])objectArray, gCP_RESULTS.lpGlyphs, objectArray.length * 2);
            if (bl) {
                BidiUtil.reverse((char[])objectArray);
            }
            System.arraycopy(objectArray, 0, cArray, n12, objectArray.length);
            n12 += objectArray.length;
            gCP_RESULTS.lpOrder += n13 * 4;
            gCP_RESULTS.lpDx += n13 * 4;
            gCP_RESULTS.lpClass += n13;
            gCP_RESULTS.lpGlyphs += objectArray.length * 2;
        }
        OS.HeapFree(n3, 0, n9);
        OS.HeapFree(n3, 0, n8);
        OS.HeapFree(n3, 0, n7);
        OS.HeapFree(n3, 0, n6);
        return cArray;
    }

    public static void getOrderInfo(GC gC, String string, int[] nArray, byte[] byArray, int n, int[] nArray2) {
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        int n3 = OS.GetProcessHeap();
        int[] nArray3 = new int[8];
        int n4 = OS.GetTextCharset(gC.handle);
        OS.TranslateCharsetInfo(n4, nArray3, 1);
        TCHAR tCHAR = new TCHAR(nArray3[1], string, false);
        int n5 = tCHAR.length();
        boolean bl = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl = OS.GetLayout(gC.handle) != 0;
        }
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n5;
        int n6 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n3, 8, n5 * 4);
        int n7 = gCP_RESULTS.lpClass = OS.HeapAlloc(n3, 8, n5);
        int n8 = 0;
        n8 |= 2;
        if ((n2 & 0x20) == 32) {
            n8 |= 0x20;
        }
        if ((n2 & 0x10) == 16) {
            n8 |= 0x10;
        }
        if ((n & 1) == 1) {
            n8 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        int n9 = 0;
        for (int i = 0; i < nArray2.length - 1; ++i) {
            Object[] objectArray;
            int n10;
            int n11 = nArray2[i];
            gCP_RESULTS.nGlyphs = n10 = nArray2[i + 1] - nArray2[i];
            TCHAR tCHAR2 = new TCHAR(nArray3[1], string.substring(n11, n11 + n10), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n8);
            if (nArray != null) {
                objectArray = new int[n10];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n9, bl);
                System.arraycopy(objectArray, 0, nArray, n11, n10);
            }
            if (byArray != null) {
                objectArray = new byte[n10];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n11, n10);
            }
            n9 += gCP_RESULTS.nGlyphs;
            gCP_RESULTS.lpOrder += n10 * 4;
            gCP_RESULTS.lpClass += n10;
        }
        OS.HeapFree(n3, 0, n7);
        OS.HeapFree(n3, 0, n6);
    }

    public static int getFontBidiAttributes(GC gC) {
        int n = 0;
        int n2 = OS.GetFontLanguageInfo(gC.handle);
        if ((n2 & 2) != 0) {
            n |= 2;
        }
        if ((n2 & 0x20) != 0) {
            n |= 0x20;
        }
        if ((n2 & 0x10) != 0) {
            n |= 0x10;
        }
        return n;
    }

    public static int getKeyboardLanguage() {
        int n = OS.GetKeyboardLayout(0);
        return BidiUtil.isBidiLang(n) ? 1 : 0;
    }

    static int[] getKeyboardLanguageList() {
        int n = 10;
        int[] nArray = new int[n];
        int n2 = OS.GetKeyboardLayoutList(n, nArray);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    static boolean isBidiLang(int n) {
        short s = OS.PRIMARYLANGID(OS.LOWORD(n));
        return s == 1 || s == 13 || s == 41;
    }

    public static boolean isBidiPlatform() {
        if (OS.IsWinCE) {
            return false;
        }
        if (isBidiPlatform != -1) {
            return isBidiPlatform == 1;
        }
        isBidiPlatform = 0;
        if (!BidiUtil.isKeyboardBidi()) {
            return false;
        }
        Callback callback = null;
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "EnumSystemLanguageGroupsProc", 5);
            int n = callback.getAddress();
            if (n == 0) {
                SWT.error(3);
            }
            OS.EnumSystemLanguageGroups(n, 1, 0);
            callback.dispose();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isBidiPlatform == 1) {
            return true;
        }
        String string = String.valueOf(OS.GetACP());
        if (CD_PG_ARABIC.equals(string) || CD_PG_HEBREW.equals(string)) {
            isBidiPlatform = 1;
        }
        return isBidiPlatform == 1;
    }

    public static boolean isKeyboardBidi() {
        int[] nArray = BidiUtil.getKeyboardLanguageList();
        for (int i = 0; i < nArray.length; ++i) {
            if (!BidiUtil.isBidiLang(nArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void removeLanguageListener(int n) {
        languageMap.remove(new LONG(n));
        BidiUtil.unsubclass(n);
    }

    public static void removeLanguageListener(Control control) {
        BidiUtil.removeLanguageListener(control.handle);
    }

    public static int resolveTextDirection(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char[] cArray = new char[]{' ', ' ', '1'};
        char[] cArray2 = new char[]{'\u202b', 'a', ' '};
        char[] cArray3 = new char[]{'\u05d0', ' ', ' '};
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        int n2 = gCP_RESULTS.nGlyphs = cArray2.length;
        int n3 = OS.GetProcessHeap();
        int n4 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n3, 8, n2 * 4);
        int n5 = OS.GetDC(0);
        int[] nArray = new int[1];
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            cArray[0] = c = string.charAt(i);
            OS.GetCharacterPlacementW(n5, cArray, cArray.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
            if (nArray[0] == 2) {
                n6 = 0x4000000;
                break;
            }
            cArray2[2] = c;
            OS.GetCharacterPlacementW(n5, cArray2, cArray2.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder + 4, 4);
            if (nArray[0] != 1) continue;
            cArray3[2] = c;
            OS.GetCharacterPlacementW(n5, cArray3, cArray3.length, 0, gCP_RESULTS, 2);
            OS.MoveMemory(nArray, gCP_RESULTS.lpOrder, 4);
            if (nArray[0] != 0) continue;
            n6 = 0x2000000;
            break;
        }
        OS.ReleaseDC(0, n5);
        OS.HeapFree(n3, 0, n4);
        return n6;
    }

    public static void setKeyboardLanguage(int n) {
        if (n == BidiUtil.getKeyboardLanguage()) {
            return;
        }
        boolean bl = n == 1;
        int[] nArray = BidiUtil.getKeyboardLanguageList();
        for (int i = 0; i < nArray.length; ++i) {
            if (bl != BidiUtil.isBidiLang(nArray[i])) continue;
            OS.ActivateKeyboardLayout(nArray[i], 0);
            return;
        }
    }

    public static boolean setOrientation(int n, int n2) {
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return false;
        }
        int n3 = OS.GetWindowLong(n, -20);
        n3 = (n2 & 0x4000000) != 0 ? (n3 |= 0x400000) : (n3 &= 0xFFBFFFFF);
        OS.SetWindowLong(n, -20, n3);
        return true;
    }

    public static boolean setOrientation(Control control, int n) {
        return BidiUtil.setOrientation(control.handle, n);
    }

    static void subclass(int n) {
        LONG lONG = new LONG(n);
        if (oldProcMap.get(lONG) == null) {
            int n2 = OS.GetWindowLongPtr(n, -4);
            oldProcMap.put(lONG, new LONG(n2));
            OS.SetWindowLongPtr(n, -4, callback.getAddress());
        }
    }

    static void reverse(char[] cArray) {
        int n = cArray.length;
        for (int i = 0; i <= (n - 1) / 2; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n - 1 - i];
            cArray[n - 1 - i] = c;
        }
    }

    static void reverse(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i <= (n - 1) / 2; ++i) {
            int n2 = nArray[i];
            nArray[i] = nArray[n - 1 - i];
            nArray[n - 1 - i] = n2;
        }
    }

    static void translateOrder(int[] nArray, int n, boolean bl) {
        int n2;
        int n3 = 0;
        int n4 = nArray.length;
        if (bl) {
            for (n2 = 0; n2 < n4; ++n2) {
                n3 = Math.max(n3, nArray[n2]);
            }
        }
        n2 = 0;
        while (n2 < n4) {
            if (bl) {
                nArray[n2] = n3 - nArray[n2];
            }
            int n5 = n2++;
            nArray[n5] = nArray[n5] + n;
        }
    }

    static void unsubclass(int n) {
        LONG lONG = new LONG(n);
        if (languageMap.get(lONG) == null) {
            LONG lONG2 = oldProcMap.remove(lONG);
            if (lONG2 == null) {
                return;
            }
            OS.SetWindowLongPtr(n, -4, lONG2.value);
        }
    }

    static int windowProc(int n, int n2, int n3, int n4) {
        Object object;
        LONG lONG = new LONG(n);
        switch (n2) {
            case 81: {
                object = languageMap.get(lONG);
                if (object == null) break;
                object.run();
            }
        }
        object = oldProcMap.get(lONG);
        return OS.CallWindowProc(((LONG)object).value, n, n2, n3, n4);
    }

    static {
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "windowProc", 4);
            if (callback.getAddress() == 0) {
                SWT.error(3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

