/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;

public class RecipientEncryptedKey
implements DEREncodable {
    private KeyAgreeRecipientIdentifier rid;
    private EncryptedKey encryptedKey;

    public RecipientEncryptedKey(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier, EncryptedKey encryptedKey) {
        this.setRid(keyAgreeRecipientIdentifier);
        this.setEncryptedKey(encryptedKey);
    }

    public RecipientEncryptedKey(BERConstructedSequence bERConstructedSequence) {
        this.rid = KeyAgreeRecipientIdentifier.getInstance(bERConstructedSequence.getObjectAt(0));
        this.encryptedKey = EncryptedKey.getInstance(bERConstructedSequence.getObjectAt(1));
    }

    public RecipientEncryptedKey(RecipientEncryptedKey recipientEncryptedKey) {
        this.rid = recipientEncryptedKey.rid;
        this.encryptedKey = recipientEncryptedKey.encryptedKey;
    }

    public static RecipientEncryptedKey getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientEncryptedKey) {
            return (RecipientEncryptedKey)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientEncryptedKey((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientEncryptedKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKey");
    }

    public static RecipientEncryptedKey newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientEncryptedKey) {
            return new RecipientEncryptedKey((RecipientEncryptedKey)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientEncryptedKey((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientEncryptedKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKey");
    }

    public KeyAgreeRecipientIdentifier getRid() {
        return this.rid;
    }

    private void setRid(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier) {
        this.rid = keyAgreeRecipientIdentifier;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.rid);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }
}

