/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.RestoreHelper;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.DisplayTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.SearchDialog;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreBackupold
extends Shell {
    private Logger logger = LoggerFactory.getLogger(RestoreBackupold.class);
    FontsManager fontsManager;
    private BackupAdapter backupAdapter = null;
    private DeviceTo selectedItem;
    private DeviceTo selectedFolder;
    private DeviceTo previousSelectedFolder;
    private String folderPath;
    private TimerTask restoreTimerTask = null;
    private Timer restoreTimer = null;
    private int lengthForFileName = 25;
    private Image shellImage = null;
    private ImageData shellImageData = null;
    Button restoreButton;
    Label restoreStatus;
    Label currentFileBeingRestoredLabel;
    Label currentRestoreStatusLabel;
    private boolean restoreLoadingStatus = true;
    private Integer port;
    private Button closeButton;
    public String deviceuid;
    int restoreFolderorDevice = 0;
    private List<DisplayTo> listDevices = null;
    private List<DisplayTo> listFolders = null;
    private Stack<DisplayTo> listFoldersStack = new Stack();
    String fullPath = null;
    String previousFolderPath = null;
    public int cnt = 1;
    public int restoredCount = 0;
    public int totalnoOfFilesToBeRestored = 0;
    public long totalSizeToBeRestored = 0L;
    public long currentSizeRestored = 0L;
    private Thread restoreThread = null;
    private FileLock fileLock = null;
    Button checkBox;
    Button checkBoxbtn;
    private boolean restoreAllVersionSelected = false;
    private static final String EXCEPTION = "Exception :";
    private static final String RESTORE_DEFAULT = "Restore default Closing shell cause of error";
    RestoreElement restoreElement = new RestoreElement();
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final int WIDTH_HINT = 500;
    Label restoreStatus1;
    private SearchDialog searchDialog;
    private static final String[] columnNames = new String[]{"Device", "Username"};
    Shell searchShell;
    Group restoreFolderGroup = null;
    Group restoreGroup = null;
    Group queryGroup = null;
    Group restorePathGroup = null;
    DeviceElement deviceElement;
    private Image imageBack = null;
    Label showPathLabel;
    Button backLabel = null;
    private static String backImageLocation = "resource\\img\\glyphicons_221_unshare.png";
    String batchId = "";
    String uploadIpForGateway = null;
    private Image imageFolder = null;
    private Image imageFile = null;
    private Image imageWindows = null;
    private Image imageMac = null;
    private Image imageAndroid = null;
    private Image imageUnknown = null;
    private static String folderImageLocation = "resource\\img\\folder_img.png";
    private static String fileImageLocation = "resource\\img\\file_img.png";
    private static String winImageLocation = "resource\\img\\win_img.png";
    private static String macImageLocation = "resource\\img\\mac_img.png";
    private static String androidImageLocation = "resource\\img\\android_img.jpg";
    private static String unknownImageLocation = "resource\\img\\question_img.png";
    private static String calImageLocation = "resource\\img\\calender.png";
    private static String imageOdbLocation = "resource\\img\\onedrive_icon.png";
    private boolean restoreInPlace = false;
    private static Button folderSelectButton;
    private static Text subtext;
    private static String oldfolder;
    private Set<String> selectedDrives = new HashSet<String>();
    private static Button helpButton;
    private static String missingDrive;
    private List<DisplayTo> listOfDrives = null;
    private static Button checkBoxbutton;
    Button inplaceCheckBox;
    private static Button calender;
    private Image imageCalender = null;
    Calendar calendar = null;
    private static Button refresh;
    private static Button pointInTimeCheckBox;
    long restoreTilldate;
    private Date date = null;
    private static Shell dialog;
    private Image imageO365 = null;
    private Text labelForDate;
    private Button PointInTimeCheckBoxBtn;
    private boolean PointInTimeRestoreSelected = false;
    private boolean dialogAlive = false;

    public RestoreBackupold(Shell shell) throws Exception {
        super(shell, 65632);
        this.setLocation(shell.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackupold(Shell parent, int style) throws Exception {
        super(parent, style);
        this.setLocation(parent.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackupold(FileLock uiFileLock) throws Exception {
        super(65760);
        this.searchShell = this.getShell();
        this.fileLock = uiFileLock;
        int xAxisLocation = this.getShell().getDisplay().getClientArea().width / 2 - 270;
        int yAxisLocation = this.getShell().getDisplay().getClientArea().height / 2 - 370;
        this.getShell().setLocation(xAxisLocation, yAxisLocation);
        this.disableEscapeKey();
    }

    private void disableEscapeKey() {
        Listener listener = e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        };
        this.getShell().addListener(31, listener);
    }

    public boolean openShell() throws Exception {
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        NotificationHelper.successfulRestore = 3;
        boolean result = false;
        this.fontsManager = new FontsManager(this.getShell().getDisplay());
        final Shell shell = this.getShell();
        this.shellImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        shell.setText(this.getText());
        shell.setImage(this.shellImage);
        this.searchShell.setImage(this.shellImage);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setLocation(shell.getLocation());
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(20, 20));
        this.imageFolder = new Image((Device)shell.getDisplay(), new ImageData(folderImageLocation).scaledTo(10, 10));
        this.imageFile = new Image((Device)shell.getDisplay(), new ImageData(fileImageLocation).scaledTo(10, 10));
        this.imageWindows = new Image((Device)shell.getDisplay(), new ImageData(winImageLocation).scaledTo(15, 15));
        this.imageMac = new Image((Device)shell.getDisplay(), new ImageData(macImageLocation).scaledTo(15, 15));
        this.imageAndroid = new Image((Device)shell.getDisplay(), new ImageData(androidImageLocation).scaledTo(15, 15));
        this.imageUnknown = new Image((Device)shell.getDisplay(), new ImageData(unknownImageLocation).scaledTo(15, 15));
        this.imageCalender = new Image((Device)shell.getDisplay(), new ImageData(calImageLocation).scaledTo(15, 15));
        this.imageO365 = new Image((Device)shell.getDisplay(), new ImageData(imageOdbLocation).scaledTo(15, 15));
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 5;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        GridData contactGroupGridData = new GridData(768);
        final Table table = this.createDeviceUI(composite, contactGroupGridData);
        final Table foldertable = this.createFolderRestoreInUI(composite);
        foldertable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackupold.this.selectedFolder = (DeviceTo)item.getData();
                    if (RestoreBackupold.this.selectedFolder == null || item.getText().startsWith(" Version")) {
                        RestoreBackupold.this.logger.debug("Selected folder is null:");
                        RestoreBackupold.this.fullPath = RestoreBackupold.this.previousFolderPath;
                        return;
                    }
                    RestoreBackupold.this.logger.debug("Selected folder : " + RestoreBackupold.this.selectedFolder.getFilePath());
                    RestoreBackupold.this.logger.debug("Selected folder/file name: " + RestoreBackupold.this.selectedFolder.getFileName());
                    RestoreBackupold.this.folderPath = RestoreBackupold.this.selectedFolder.getFilePath();
                    RestoreBackupold.this.previousSelectedFolder = RestoreBackupold.this.selectedFolder;
                    if (RestoreBackupold.this.fullPath == null) {
                        RestoreBackupold.this.fullPath = RestoreBackupold.this.folderPath;
                        RestoreBackupold.this.previousFolderPath = RestoreBackupold.this.folderPath;
                    } else {
                        RestoreBackupold.this.previousFolderPath = RestoreBackupold.this.fullPath;
                        RestoreBackupold.this.fullPath = RestoreBackupold.this.fullPath + "/" + RestoreBackupold.this.folderPath;
                        RestoreBackupold.this.logger.debug("fullPath is: " + RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.logger.debug("previousPath: " + RestoreBackupold.this.previousFolderPath);
                    }
                    try {
                        if (!RestoreBackupold.this.selectedFolder.getFolder().equals("true")) {
                            RestoreBackupold.this.logger.debug("Current selected file is a folde:" + RestoreBackupold.this.selectedFolder.getFolder());
                            RestoreBackupold.this.showupRevisions(foldertable, RestoreBackupold.this.selectedFolder.getFilePath(), RestoreBackupold.this.selectedFolder.getFileName());
                        } else {
                            RestoreBackupold.this.getBasePathFromServer(foldertable, RestoreBackupold.this.fullPath);
                        }
                        RestoreBackupold.this.showPathLabel.setText(RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.showPathLabel.setToolTipText(RestoreBackupold.this.fullPath);
                    }
                    catch (Exception e1) {
                        RestoreBackupold.this.logger.trace("" + e1);
                        RestoreBackupold.this.logger.error(RestoreBackupold.EXCEPTION + e1.getMessage());
                    }
                }
            }
        });
        foldertable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++RestoreBackupold.this.cnt;
                RestoreBackupold.this.restoreFolderorDevice = 0;
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackupold.this.selectedFolder = (DeviceTo)item.getData();
                    if (item.getText().startsWith(" Version")) {
                        if (RestoreBackupold.this.checkBoxbtn != null) {
                            RestoreBackupold.this.checkBox.setSelection(false);
                            RestoreBackupold.this.restoreAllVersionSelected = RestoreBackupold.this.checkBoxbtn.getSelection();
                        }
                        String versionFilePath = RestoreBackupold.this.selectedFolder.getFileName() + "/" + RestoreBackupold.this.selectedFolder.getFilePath() + item.getText();
                        RestoreBackupold.this.showPathLabel.setText(versionFilePath);
                        RestoreBackupold.this.showPathLabel.setToolTipText(versionFilePath);
                    }
                    if (RestoreBackupold.this.selectedFolder == null) {
                        RestoreBackupold.this.selectedFolder = RestoreBackupold.this.previousSelectedFolder;
                        RestoreBackupold.this.folderPath = RestoreBackupold.this.selectedFolder.getFilePath();
                        RestoreBackupold.this.logger.debug("Selected restore folder : " + RestoreBackupold.this.fullPath + "/" + RestoreBackupold.this.selectedFolder.getFilePath());
                        return;
                    }
                    if (RestoreBackupold.this.fullPath == null) {
                        RestoreBackupold.this.logger.debug("Selected folder for restore: " + RestoreBackupold.this.selectedFolder.getFilePath());
                    } else {
                        RestoreBackupold.this.logger.debug("Selected folder: " + RestoreBackupold.this.fullPath + "/" + RestoreBackupold.this.selectedFolder.getFilePath());
                        RestoreBackupold.this.logger.debug(" Selected folder backupid: " + RestoreBackupold.this.selectedFolder.getBackupId());
                    }
                }
            }
        });
        this.pullRestoreDeviceListFromServer(table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupold.this.restoreFolderorDevice = 1;
                RestoreBackupold.this.selectedFolder = null;
                if (table.getSelectionIndex() != -1) {
                    NotificationHelper.successfulRestore = 8;
                    RestoreBackupold.this.restoreFolderGroup.setVisible(true);
                    RestoreBackupold.this.restorePathGroup.setVisible(true);
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackupold.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackupold.this.deviceuid = RestoreBackupold.this.selectedItem.getDeviceUid();
                    RestoreBackupold.this.logger.debug("Selected device: " + RestoreBackupold.this.selectedItem.getDeviceName());
                    try {
                        foldertable.clearAll();
                        RestoreBackupold.this.showPathLabel.setText("");
                        RestoreBackupold.this.listFolders.clear();
                    }
                    catch (Exception e1) {
                        RestoreBackupold.this.logger.trace("" + e1);
                        RestoreBackupold.this.logger.error("Exception occured while clearing the folder List" + e1.getMessage());
                    }
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (table.getSelectionIndex() != -1) {
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackupold.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackupold.this.logger.debug("Selected device: " + RestoreBackupold.this.selectedItem.getDeviceName());
                    RestoreBackupold.this.logger.debug("Device ID is:" + RestoreBackupold.this.selectedItem.getDeviceId());
                    RestoreBackupold.this.deviceuid = RestoreBackupold.this.selectedItem.getDeviceUid();
                    try {
                        RestoreBackupold.this.fullPath = null;
                        RestoreBackupold.this.previousFolderPath = null;
                        RestoreBackupold.this.getBasePathFromServer(foldertable, RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.showPathLabel.setText("");
                    }
                    catch (Exception e1) {
                        RestoreBackupold.this.logger.trace("" + e1);
                        RestoreBackupold.this.logger.error(RestoreBackupold.EXCEPTION + e1.getMessage());
                    }
                }
            }
        });
        GridData tableData = new GridData(1808);
        tableData.heightHint = 75;
        tableData.widthHint = 500;
        table.setLayoutData((Object)tableData);
        GridData tableFolderData = new GridData(1808);
        tableFolderData.heightHint = 120;
        tableData.widthHint = 500;
        foldertable.setLayoutData((Object)tableFolderData);
        Composite inPlaceCheckBoxComposite = new Composite(composite, 16384);
        GridLayout inPlaceCheckBoxButtonLayout = new GridLayout();
        inPlaceCheckBoxButtonLayout.numColumns = 9;
        inPlaceCheckBoxButtonLayout.makeColumnsEqualWidth = false;
        inPlaceCheckBoxButtonLayout.horizontalSpacing = 0;
        inPlaceCheckBoxComposite.setLayout((Layout)inPlaceCheckBoxButtonLayout);
        this.inplaceCheckBox = new Button(inPlaceCheckBoxComposite, 32);
        this.inplaceCheckBox.setBounds(330, 225, 75, 20);
        this.inplaceCheckBox.setText("In place restore");
        this.inplaceCheckBox.setFont(this.fontsManager.getMediumNormalFont());
        this.inplaceCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                checkBoxbutton = (Button)event.getSource();
                RestoreBackupold.this.logger.debug(" Restore inplace check box selected:");
                if (checkBoxbutton.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 200);
                    MessageBox message = new MessageBox(shell, 72);
                    msg.setMessage("Selecting this option could result in overwriting of files already present in the folder from where the backup originally occurred. Would you like to continue?");
                    msg.setText("Restore Alert");
                    int result = msg.open();
                    if (result == 64) {
                        if (RestoreBackupold.this.selectedItem == null) {
                            message.setText("No device selected");
                            message.setMessage("No items selected for Restore. Please add and try Restore.");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else if (RestoreBackupold.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("mac")) {
                            message.setText("InplaceRestore Incompatibility ");
                            message.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else if (RestoreBackupold.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("onedrive")) {
                            message.setText("InplaceRestore Incompatibility ");
                            message.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else {
                            checkBoxbutton.setSelection(true);
                            folderSelectButton.setEnabled(false);
                            oldfolder = subtext.getText();
                            subtext.setText("");
                            subtext.setEnabled(false);
                            RestoreBackupold.this.restoreInPlace = checkBoxbutton.getSelection();
                        }
                    } else if (result == 128) {
                        checkBoxbutton.setSelection(false);
                        RestoreBackupold.this.restoreInPlace = checkBoxbutton.getSelection();
                    }
                } else {
                    RestoreBackupold.this.logger.debug(oldfolder);
                    folderSelectButton.setEnabled(true);
                    subtext.setText(oldfolder);
                    subtext.setEnabled(true);
                    RestoreBackupold.this.restoreInPlace = checkBoxbutton.getSelection();
                }
            }
        });
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("dumm");
        helpButton.setVisible(false);
        this.checkBox = new Button(inPlaceCheckBoxComposite, 32);
        this.checkBox.setBounds(330, 225, 75, 20);
        this.checkBox.setText("Restore all versions");
        this.checkBox.setFont(this.fontsManager.getMediumNormalFont());
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackupold.this.checkBoxbtn = (Button)event.getSource();
                RestoreBackupold.this.restoreAllVersionSelected = RestoreBackupold.this.checkBoxbtn.getSelection();
                RestoreBackupold.this.logger.debug("check box selected:" + RestoreBackupold.this.restoreAllVersionSelected);
                if (RestoreBackupold.this.checkBoxbtn.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Restore Alert");
                    msg.setMessage("Selecting all versions may result in a long restore operation and consume a lot of space on your hard drive. \nMake sure there is enough disk space available.");
                    msg.open();
                }
            }
        });
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("dumm");
        helpButton.setVisible(false);
        pointInTimeCheckBox = new Button(inPlaceCheckBoxComposite, 32);
        pointInTimeCheckBox.setBounds(330, 225, 75, 20);
        pointInTimeCheckBox.setText("Restore data before");
        pointInTimeCheckBox.setFont(this.fontsManager.getMediumNormalFont());
        pointInTimeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackupold.this.PointInTimeCheckBoxBtn = (Button)event.getSource();
                RestoreBackupold.this.PointInTimeRestoreSelected = RestoreBackupold.this.PointInTimeCheckBoxBtn.getSelection();
                RestoreBackupold.this.logger.debug(RestoreBackupold.this.PointInTimeCheckBoxBtn.getSelection() + "");
                if (RestoreBackupold.this.PointInTimeCheckBoxBtn.getSelection()) {
                    calender.setEnabled(true);
                    RestoreBackupold.this.labelForDate.setEnabled(true);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
                    Date date = new Date();
                    String currentDate = dateFormat.format(date);
                    RestoreBackupold.this.labelForDate.setText(currentDate);
                    RestoreBackupold.this.logger.debug(date + "Restore Till date " + date.getTime());
                    RestoreBackupold.this.restoreTilldate = date.getTime();
                    refresh.setEnabled(true);
                } else {
                    calender.setEnabled(false);
                    calender.setText("");
                    RestoreBackupold.this.labelForDate.setEnabled(false);
                    RestoreBackupold.this.labelForDate.setText("Select Date..");
                    RestoreBackupold.this.restoreTilldate = 0L;
                    refresh.setEnabled(false);
                }
            }
        });
        calender = new Button(inPlaceCheckBoxComposite, 0);
        calender.setImage(this.imageCalender);
        calender.setFont(this.fontsManager.getMediumNormalFont());
        calender.setEnabled(false);
        calender.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestoreBackupold.this.dialogAlive) {
                    calender.setFocus();
                    return;
                }
                dialog = new Shell(shell, 2144);
                dialog.setLayout((Layout)new GridLayout(3, false));
                dialog.setText("Select Date..");
                dialog.setImage(RestoreBackupold.this.shellImage);
                if (!RestoreBackupold.this.dialogAlive) {
                    RestoreBackupold.this.dialogAlive = true;
                    final DateTime calendar = new DateTime((Composite)dialog, 1024);
                    final DateTime time = new DateTime((Composite)dialog, 32896);
                    new Label((Composite)dialog, 0);
                    new Label((Composite)dialog, 0);
                    Button ok = new Button((Composite)dialog, 8);
                    ok.setText("OK");
                    ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                    ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                            String dateValue = calendar.getDay() + "/" + (calendar.getMonth() + 1) + "/" + calendar.getYear() + " " + time.getHours() + ":" + time.getMinutes();
                            try {
                                RestoreBackupold.this.date = formatter.parse(dateValue);
                            }
                            catch (ParseException e1) {
                                RestoreBackupold.this.logger.error("unable to prase the date format" + e1.getMessage());
                            }
                            if (RestoreBackupold.this.date != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
                                        String dateText = dateFormat.format(RestoreBackupold.this.date);
                                        RestoreBackupold.this.labelForDate.setText(dateText);
                                        RestoreBackupold.this.restoreTilldate = RestoreBackupold.this.date.getTime();
                                        RestoreBackupold.this.logger.debug(dateFormat.format(RestoreBackupold.this.date) + "Restore Till Date......." + RestoreBackupold.this.restoreTilldate);
                                    }
                                });
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RestoreBackupold.this.labelForDate.setText("Select Date..");
                                    }
                                });
                            }
                            dialog.close();
                            RestoreBackupold.this.dialogAlive = false;
                        }
                    });
                    Listener listener = arg0 -> {
                        RestoreBackupold.this.logger.debug("closing calender");
                        RestoreBackupold.this.dialogAlive = false;
                    };
                    dialog.addListener(21, listener);
                    dialog.setDefaultButton(ok);
                    dialog.pack();
                    dialog.open();
                }
            }
        });
        this.labelForDate = new Text(inPlaceCheckBoxComposite, 0x1000800);
        this.labelForDate.setText("Select Date..");
        GridData textData = new GridData(0x1000000, 0x1000000, true, true);
        textData.widthHint = 105;
        this.labelForDate.setLayoutData((Object)textData);
        this.labelForDate.setFont(this.fontsManager.smallNormalFont);
        this.labelForDate.setEditable(false);
        this.labelForDate.setEnabled(false);
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("du");
        helpButton.setVisible(false);
        refresh = new Button(inPlaceCheckBoxComposite, 1024);
        refresh.setText("Refresh");
        refresh.setEnabled(false);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    foldertable.removeAll();
                    RestoreBackupold.this.showPathLabel.setText("");
                    if (RestoreBackupold.this.listFolders != null) {
                        RestoreBackupold.this.listFolders.clear();
                    }
                    if (RestoreBackupold.this.selectedFolder != null) {
                        RestoreBackupold.this.selectedFolder = null;
                    }
                    if (RestoreBackupold.this.selectedItem != null) {
                        RestoreBackupold.this.selectedItem = null;
                    }
                }
                catch (Exception e) {
                    RestoreBackupold.this.logger.debug("Exception to clear the folder list .." + e.getMessage());
                }
            }
        });
        this.queryGroup = new Group(composite, 0x1000000);
        GridLayout queryGroupGridLayout = new GridLayout();
        queryGroupGridLayout.numColumns = 2;
        queryGroupGridLayout.makeColumnsEqualWidth = false;
        this.queryGroup.setLayout((Layout)queryGroupGridLayout);
        GridData queryGroupGridData = new GridData(768);
        queryGroupGridData.horizontalSpan = 2;
        this.queryGroup.setLayoutData((Object)queryGroupGridData);
        this.queryGroup.setText("Select the destination folder");
        this.queryGroup.setFont(this.fontsManager.getSmallNormalFont());
        subtext = new Text((Composite)this.queryGroup, 2052);
        GridData subGridData = new GridData(768);
        subGridData.widthHint = 170;
        subtext.setLayoutData((Object)subGridData);
        folderSelectButton = new Button((Composite)this.queryGroup, 8);
        folderSelectButton.setText("Select Folder");
        folderSelectButton.setFont(this.fontsManager.getMediumNormalFont());
        Label showDestinationFolderHelpLabel = new Label((Composite)this.queryGroup, 0);
        showDestinationFolderHelpLabel.setLayoutData((Object)queryGroupGridData);
        showDestinationFolderHelpLabel.setText("Restored data will be downloaded to this folder");
        showDestinationFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        folderSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(subtext.getText());
                dlg.setText("Parablu");
                dlg.setMessage("Select the directory you want to restore to");
                String dir = dlg.open();
                if (dir != null) {
                    subtext.setText(dir);
                }
            }
        });
        Composite restoreStartGroup = new Composite(composite, 0x1000000);
        GridLayout restoreStartGroupGridLayout = new GridLayout();
        restoreStartGroupGridLayout.numColumns = 1;
        restoreStartGroupGridLayout.makeColumnsEqualWidth = false;
        restoreStartGroup.setLayout((Layout)restoreStartGroupGridLayout);
        GridData restoreStartGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        restoreStartGroup.setLayoutData((Object)restoreStartGroupGridData);
        this.restoreStatus = new Label(restoreStartGroup, 16384);
        GridData restoreGridData = new GridData(768);
        this.restoreStatus.setLayoutData((Object)restoreGridData);
        this.restoreStatus.setText("Loading information");
        this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
        this.restoreStatus1 = new Label(restoreStartGroup, 16384);
        this.restoreStatus1.setLayoutData((Object)restoreGridData);
        this.restoreStatus1.setFont(this.fontsManager.getSmallNormalFont());
        Composite currentFileGroup = new Composite(composite, 0x1000000);
        GridLayout currentFileLayout = new GridLayout();
        currentFileLayout.numColumns = 1;
        currentFileLayout.makeColumnsEqualWidth = false;
        currentFileGroup.setLayout((Layout)currentFileLayout);
        GridData currentFileGridData = new GridData(768);
        currentFileGridData.horizontalSpan = 2;
        currentFileGroup.setLayoutData((Object)currentFileGridData);
        this.currentFileBeingRestoredLabel = new Label(currentFileGroup, 16384);
        this.currentFileBeingRestoredLabel.setLayoutData((Object)new GridData(768));
        this.currentRestoreStatusLabel = new Label(currentFileGroup, 16384);
        this.currentRestoreStatusLabel.setLayoutData((Object)new GridData(768));
        Composite restoreButtonComposite = new Composite(composite, 0x1000000);
        GridLayout restoreButtonLayout = new GridLayout();
        restoreButtonLayout.numColumns = 4;
        restoreButtonLayout.makeColumnsEqualWidth = false;
        restoreButtonLayout.horizontalSpacing = 70;
        restoreButtonComposite.setLayout((Layout)restoreButtonLayout);
        GridData restoreButtonGridData = new GridData(768);
        restoreButtonGridData.horizontalSpan = 2;
        restoreButtonComposite.setLayoutData((Object)restoreButtonGridData);
        this.restoreButton = new Button(restoreButtonComposite, 8);
        GridData buttonGridData = new GridData();
        this.restoreButton.setLayoutData((Object)buttonGridData);
        this.restoreButton.setEnabled(false);
        this.restoreButton.setText("Restore");
        this.restoreButton.setFont(this.fontsManager.getMediumNormalFont());
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackupold.this.logger.debug("The selected item is:(file-1/folder-0):" + RestoreBackupold.this.restoreFolderorDevice);
                RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
                RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                NotificationHelper.setShowFileBeingRestored((boolean)false);
                RestoreBackupold.this.totalnoOfFilesToBeRestored = 0;
                RestoreBackupold.this.restoredCount = 0;
                if (NotificationHelper.restoreStarted) {
                    return;
                }
                MessageBox msg = new MessageBox(shell, 34);
                String destinationFolder = subtext.getText();
                File file = new File(destinationFolder);
                if (RestoreBackupold.this.selectedItem == null) {
                    msg.setText("No device selected");
                    msg.setMessage("No items selected for Restore. Please add and try Restore.");
                    msg.open();
                } else if (RestoreBackupold.this.restoreInPlace && RestoreBackupold.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("mac")) {
                    msg.setText("InplaceRestore Incompatibility ");
                    msg.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                    msg.open();
                } else if (RestoreBackupold.this.restoreInPlace && RestoreBackupold.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("onedrive")) {
                    msg.setText("InplaceRestore Incompatibility ");
                    msg.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                    msg.open();
                } else if (!RestoreBackupold.this.restoreInPlace && destinationFolder == "") {
                    msg.setText("No folder selected");
                    msg.setMessage("Please select a folder to restore to");
                    msg.open();
                } else if (!RestoreBackupold.this.restoreInPlace && !file.isDirectory()) {
                    msg.setText("Error");
                    msg.setMessage("The selected path is not a valid folder");
                    msg.open();
                } else if (RestoreBackupold.this.restoreInPlace && !RestoreBackupold.this.isAllDrivesPresnt()) {
                    msg.setMessage("A required folder path ( " + missingDrive + " )couldn\u2019t be created");
                    msg.setText("Restore Alert");
                    msg.open();
                    missingDrive = "";
                } else if (RestoreBackupold.this.PointInTimeRestoreSelected && RestoreBackupold.this.restoreTilldate == 0L) {
                    msg.setMessage("Restore tilldate  shouldn't be empty, please select date");
                    msg.setText("Restore Alert");
                    msg.open();
                } else {
                    if (!RestoreBackupold.this.restoreInPlace && file.list().length > 0) {
                        msg.setText("Folder not empty");
                        msg.setMessage("The destination folder is not empty. Please note that any file with the same name will be overwritten.");
                        msg.open();
                    }
                    NotificationHelper.successfulRestore = 1;
                    if (RestoreBackupold.this.restoreFolderorDevice == 0 || RestoreBackupold.this.restoreFolderorDevice == 1) {
                        if (RestoreBackupold.this.restoreFolderorDevice == 1 || RestoreBackupold.this.selectedFolder.getFilePath().length() <= 3 && RestoreBackupold.this.selectedFolder.getFilePath().contains(":")) {
                            RestoreBackupold.this.showInfoMessage();
                        }
                        RestoreBackupold.this.logger.debug("Folder RESTORE");
                        RestoreBackupold.this.restoreButton.setEnabled(false);
                        RestoreBackupold.this.closeButton.setEnabled(false);
                        NotificationHelper.setRestoreStarted((boolean)true);
                        NotificationHelper.restoreFinished = false;
                        Runnable runnable = () -> {
                            try {
                                RestoreBackupold.this.restoredCount = 0;
                                String status = BackupLifeCycle.STARTED.toString();
                                RestoreBackupold.this.logger.debug("Status" + status);
                                RestoreBackupold.this.batchId = RestoreBackupold.this.restoreBatchInitiated(status, "", "0/0", 0L);
                                RestoreBackupold.this.restoreElement = new RestoreElement();
                                String selectedPathForRestore = destinationFolder;
                                NotificationHelper.setShowFileBeingRestored((boolean)true);
                                if (RestoreBackupold.this.PointInTimeRestoreSelected) {
                                    RestoreBackupold.this.restoreElement.setRestoreTillDate(String.valueOf(RestoreBackupold.this.restoreTilldate));
                                }
                                if (!RestoreBackupold.this.batchId.equals("") && !"-1".equals(RestoreBackupold.this.batchId)) {
                                    RestoreBackupold.this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
                                    RestoreBackupold.this.logger.debug("Inserting into restore table");
                                    restoreActivityTo.setRestoreBatchStatus(status);
                                    restoreActivityTo.setRestoreBatchId(RestoreBackupold.this.batchId);
                                    restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
                                }
                                FileElement fileElement = null;
                                FileListElement listFolderFiles = new FileListElement();
                                if (RestoreBackupold.this.restoreFolderorDevice == 0) {
                                    if (RestoreBackupold.this.selectedFolder.getFolder().equalsIgnoreCase("true")) {
                                        selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + RestoreBackupold.this.selectedFolder.getFilePath().replace(":", "_DRIVE");
                                        fileElement = ObjectUtils.convertToFileElement((DeviceTo)RestoreBackupold.this.selectedFolder);
                                        fileElement.setFileName("");
                                        RestoreBackupold.this.restoreElement.setSelectedDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackupold.this.restoreElement.setDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackupold.this.restoreElement.setFileUserOwner(RestoreBackupold.this.selectedFolder.getFileUserOwner());
                                        listFolderFiles.getFileElementList().add(fileElement);
                                    } else if (RestoreBackupold.this.selectedFolder.getFolder().equalsIgnoreCase("false")) {
                                        RestoreBackupold.this.restoreElement.setSelectedDevicePath(RestoreBackupold.this.selectedFolder.getFileName());
                                        RestoreBackupold.this.restoreElement.setDevicePath(RestoreBackupold.this.selectedFolder.getFileName());
                                        RestoreBackupold.this.restoreElement.setFileName(RestoreBackupold.this.selectedFolder.getFilePath());
                                        RestoreBackupold.this.restoreElement.setFileUserOwner(RestoreBackupold.this.selectedFolder.getFileUserOwner());
                                        if (!RestoreBackupold.this.restoreAllVersionSelected) {
                                            RestoreBackupold.this.logger.debug("all versions not selected so set backup id>>>>>>" + RestoreBackupold.this.selectedFolder.getFileUserOwner());
                                            RestoreBackupold.this.restoreElement.setFileBackupId(RestoreBackupold.this.selectedFolder.getBackupId());
                                        }
                                    }
                                } else if (RestoreBackupold.this.restoreFolderorDevice == 1) {
                                    RestoreBackupold.this.restoreElement.setFileUserOwner(SettingHelper.getUserName());
                                    fileElement = new FileElement();
                                }
                                RestoreBackupold.this.restoreElement.setCloudName(SettingHelper.getCloudName());
                                RestoreBackupold.this.restoreElement.setRestoreBatchId(RestoreBackupold.this.batchId);
                                if (RestoreBackupold.this.restoreInPlace) {
                                    RestoreBackupold.this.restoreElement.setDestinationPath(null);
                                } else {
                                    RestoreBackupold.this.restoreElement.setDestinationPath(selectedPathForRestore);
                                }
                                RestoreBackupold.this.restoreElement.setDeviceUUid(RestoreBackupold.this.deviceuid);
                                RestoreBackupold.this.restoreElement.setRestoreAllVersions(RestoreBackupold.this.restoreAllVersionSelected);
                                this.getUploadIPForGateway();
                                if (fileElement != null) {
                                    String fileElementXml = CreateXmlObject.createXmlForFileElement((FileElement)fileElement);
                                    FileListElement listFolderFilesFromServer = RestoreBackupold.this.backupAdapter.getAllFoldersForDevicePathToFileElement(SettingHelper.getCurrentCloudIpAddress(), RestoreBackupold.this.port, RestoreBackupold.this.deviceuid, SettingHelper.readTokenFromFile(), fileElementXml, RestoreBackupold.this.restoreTilldate);
                                    listFolderFiles.getFileElementList().addAll(listFolderFilesFromServer.getFileElementList());
                                    List listFileElement = listFolderFiles.getFileElementList();
                                    RestoreBackupold.this.logger.debug("filelist elements:" + listFolderFiles.getFileElementList().size());
                                    int count = 1;
                                    if (CollectionUtils.isEmpty((Collection)listFileElement)) {
                                        NotificationHelper.successfulRestore = 2;
                                    }
                                    for (FileElement element : listFileElement) {
                                        if (element.getFileName() != null && element.getFileCompletePath() != null) {
                                            RestoreBackupold.this.logger.debug(count + " FolderName:" + element.getFileName() + " devicePath:" + element.getFileCompletePath());
                                        } else if (element.getFileName() == null && element.getFileCompletePath() != null) {
                                            RestoreBackupold.this.logger.debug(count + " Folder Name is null device Path:" + element.getFileCompletePath());
                                        } else {
                                            RestoreBackupold.this.logger.debug(count + " Device Path is null folderName:" + element.getFileName());
                                        }
                                        ++count;
                                    }
                                    count = 1;
                                    for (FileElement element : listFileElement) {
                                        if (RestoreBackupold.this.restoreThread.isInterrupted()) {
                                            RestoreBackupold.this.logger.debug("Restore thread is interrupted...");
                                            return;
                                        }
                                        ++count;
                                        NotificationHelper.setRestoreStarted((boolean)true);
                                        NotificationHelper.restoreFinished = false;
                                        RestoreBackupold.this.logger.debug("element devicepath:" + element.getFileCompletePath() + " filename:" + element.getFileName());
                                        String devicePath = element.getFileCompletePath();
                                        if (!StringUtils.isEmpty((String)element.getFileCompletePath()) && !StringUtils.isEmpty((String)element.getFileName())) {
                                            devicePath = element.getFileCompletePath() + "/" + element.getFileName();
                                        }
                                        if (StringUtils.isEmpty((String)element.getFileCompletePath())) {
                                            devicePath = element.getFileName();
                                        }
                                        RestoreBackupold.this.restoreElement.setDevicePath(devicePath.replace("\\", "/"));
                                        RestoreBackupold.this.logger.debug("restore element devicepath>" + RestoreBackupold.this.restoreElement.getDevicePath());
                                        NotificationHelper.successfulRestore = 1;
                                        this.downloadFile();
                                        restoreActivityTo.setTotalRestoreCount(RestoreBackupold.this.restoreElement.getRestoreCount());
                                        restoreActivityTo.setTotalRestoredSize(RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                        RestoreBackupold.this.logger.debug("Resore count:" + RestoreBackupold.this.restoreElement.getRestoreCount() + "Resore size:" + RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                    }
                                } else {
                                    this.downloadFile();
                                }
                                return;
                            }
                            catch (Exception e1) {
                                NotificationHelper.successfulRestore = 0;
                                RestoreBackupold.this.logger.trace("" + e1);
                                RestoreBackupold.this.logger.error("unsuccessfulRestore, Exception e1: ", (Object)e1.getMessage());
                            }
                            finally {
                                String restoreCount;
                                if (NotificationHelper.successfulRestore == 1 || NotificationHelper.successfulRestore == 2) {
                                    RestoreBackupold.this.logger.debug("inside finally ********************8");
                                    String status = BackupLifeCycle.COMPLETED.toString();
                                    restoreCount = RestoreBackupold.this.restoreElement.getRestoreCount();
                                    RestoreBackupold.this.batchId = RestoreBackupold.this.restoreBatchInitiated(status, RestoreBackupold.this.batchId, restoreCount, RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                    if (RestoreBackupold.this.batchId != null && RestoreBackupold.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityTo.setTotalRestoreCount(restoreCount);
                                        restoreActivityTo.setTotalRestoredSize(RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                } else {
                                    String status = BackupLifeCycle.FAILED.toString();
                                    restoreCount = RestoreBackupold.this.restoreElement.getRestoreCount();
                                    RestoreBackupold.this.batchId = RestoreBackupold.this.restoreBatchInitiated(status, RestoreBackupold.this.batchId, restoreCount, RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                    if (RestoreBackupold.this.batchId != null && RestoreBackupold.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityTo.setTotalRestoreCount(restoreCount);
                                        restoreActivityTo.setTotalRestoredSize(RestoreBackupold.this.restoreElement.getTotalRestoredSize());
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                }
                                NotificationHelper.setRestoreStarted((boolean)false);
                                NotificationHelper.restoreFinished = true;
                            }
                        };
                        RestoreBackupold.this.restoreThread = new Thread(runnable);
                        RestoreBackupold.this.restoreThread.start();
                    }
                }
            }

            private void downloadFile() {
                boolean retry;
                AtomicInteger skipValue = new AtomicInteger(0);
                int retryCount = 0;
                int sleepMultiplier = 1;
                long sleepTime = 60000L * (long)sleepMultiplier;
                do {
                    retry = false;
                    try {
                        if ((SettingHelper.getBackupLicenced().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase("true") && !StringUtils.isEmpty((String)RestoreBackupold.this.uploadIpForGateway)) {
                            int response1 = RestoreBackupold.this.backupAdapter.downloadFileViaGateway1(RestoreBackupold.this.uploadIpForGateway, RestoreBackupold.this.port, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), RestoreBackupold.this.restoreElement, skipValue, SettingHelper.getDeviceUUId(), SettingHelper.getKeystorePath());
                            if (response1 == 204) {
                                NotificationHelper.successfulRestore = 5;
                            }
                            if (response1 != 4) {
                                NotificationHelper.successfulRestore = 0;
                            }
                            if (response1 != 4 || !"0".equalsIgnoreCase(RestoreBackupold.this.restoreElement.getRestoreCount())) continue;
                            NotificationHelper.successfulRestore = 2;
                            continue;
                        }
                        NotificationHelper.successfulRestore = 0;
                        RestoreBackupold.this.logger.debug("Restore Failed");
                    }
                    catch (CrawlAdapterException e) {
                        RestoreBackupold.this.logger.debug("Exception : " + (Object)((Object)e));
                        RestoreBackupold.this.logger.error("Crawl Adapter Exception:" + e.getMessage());
                        RestoreBackupold.this.logger.debug("retry after time interval>>>" + sleepTime);
                        retry = true;
                        ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                        sleepTime = 60000L * (long)sleepMultiplier;
                    }
                    catch (Exception e) {
                        NotificationHelper.successfulRestore = 0;
                        RestoreBackupold.this.logger.error("unsuccessfulRestore, Exception: ", (Throwable)e);
                    }
                } while (retry && retryCount < 6);
            }

            private void getUploadIPForGateway() {
                if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    try {
                        GatewayTO uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP((String)"ANY", (String)"RESTORE");
                        if (uploadGatewayTo != null) {
                            RestoreBackupold.this.uploadIpForGateway = uploadGatewayTo.getGatewayName();
                        }
                    }
                    catch (Exception e) {
                        RestoreBackupold.this.logger.trace("" + e);
                        RestoreBackupold.this.logger.debug("Error in get privacy gateway ip" + e.getMessage());
                    }
                    RestoreBackupold.this.logger.debug("Restore Privacy Gateway IP:" + RestoreBackupold.this.uploadIpForGateway);
                }
            }
        });
        this.closeButton = new Button(restoreButtonComposite, 8);
        GridData buttonGridDatax = new GridData();
        this.closeButton.setLayoutData((Object)buttonGridDatax);
        this.closeButton.setText("Close");
        this.closeButton.setFont(this.fontsManager.getMediumNormalFont());
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        Listener listener = arg0 -> {
            this.logger.debug("Closing the restore Window");
            try {
                this.restoreTimer.cancel();
                NotificationHelper.restoreFinished = false;
                if (NotificationHelper.isRestoreStarted() && this.restoreThread != null && this.restoreThread.isAlive()) {
                    this.restoreThread.stop();
                    this.restoreElement.setRestoreInterrupted(true);
                    NotificationHelper.setRestoreStarted((boolean)false);
                    this.restoreBatchUpdateBeforeExit();
                    this.logger.debug("Stopping thread for restore....");
                }
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Restore Timer not cancelled" + e.getMessage());
            }
        };
        shell.addListener(21, listener);
        shell.pack();
        shell.open();
        shell.forceActive();
        return result;
    }

    public void restoreBatchUpdateBeforeExit() {
        String status = BackupLifeCycle.FAILED.toString();
        String restoreCount = this.restoreElement.getRestoreCount();
        long totalSizeRestored = this.restoreElement.getTotalRestoredSize();
        RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        this.batchId = this.restoreBatchInitiated(status, this.batchId, restoreCount, totalSizeRestored);
        if (this.batchId != null && this.batchId != "-1") {
            restoreActivityTo.setRestoreBatchId(this.batchId);
            restoreActivityTo.setRestoreBatchStatus(status);
            restoreActivityTo.setTotalRestoreCount(restoreCount);
            restoreActivityTo.setTotalRestoredSize(this.restoreElement.getTotalRestoredSize());
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
        }
    }

    private Table createDeviceUI(Composite composite, GridData contactGroupGridData) {
        this.restoreGroup = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        this.restoreGroup.setLayout((Layout)groupGridLayout);
        contactGroupGridData.horizontalSpan = 2;
        this.restoreGroup.setLayoutData((Object)contactGroupGridData);
        this.restoreGroup.setText("Select the device to restore");
        this.restoreGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table table = new Table((Composite)this.restoreGroup, 68356);
        table.setLayoutData((Object)contactGroupGridData);
        table.setHeaderVisible(true);
        TableColumn deviceColumn = new TableColumn(table, 16);
        deviceColumn.setText("Device");
        deviceColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                if (1024 == table.getSortDirection() || 0 == table.getSortDirection()) {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listDevices, "Device", true);
                    table.setSortDirection(128);
                } else {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listDevices, "Device", false);
                    table.setSortDirection(1024);
                }
                RestoreBackupold.this.addDevicesToTable(RestoreBackupold.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        TableColumn deviceUserColumn = new TableColumn(table, 16);
        deviceUserColumn.setText("Username");
        deviceUserColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                if (1024 == table.getSortDirection() || 0 == table.getSortDirection()) {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listDevices, "Username", true);
                    table.setSortDirection(128);
                } else {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listDevices, "Username", false);
                    table.setSortDirection(1024);
                }
                RestoreBackupold.this.addDevicesToTable(RestoreBackupold.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        Label showHelpLabel = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel.setLayoutData((Object)contactGroupGridData);
        showHelpLabel.setText("Click a device to select all data on the device for restoration");
        showHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        Label showHelpLabel1 = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel1.setText("Double click a device to drill down and select a specific folder or a file in it.");
        showHelpLabel1.setFont(this.fontsManager.getSmallNormalFont());
        Button button = new Button((Composite)this.restoreGroup, 8);
        button.setText("Search");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupold.this.searchDialog.setMatchCase(false);
                RestoreBackupold.this.searchDialog.setMatchWord(false);
                RestoreBackupold.this.searchDialog.setSearchDown(true);
                RestoreBackupold.this.searchDialog.setSearchString("");
                RestoreBackupold.this.searchDialog.setSelectedSearchArea(0);
                RestoreBackupold.this.searchDialog.open();
            }
        });
        this.searchDialog = new SearchDialog(this.searchShell);
        this.searchDialog.setSearchAreaNames(columnNames);
        this.searchDialog.setSearchAreaLabel("Column");
        this.searchDialog.addFindListener(new SearchDialog.FindListener(){

            @Override
            public boolean find() {
                return RestoreBackupold.this.findEntry(table);
            }
        });
        return table;
    }

    private boolean findEntry(Table table) {
        Cursor waitCursor = new Cursor((Device)this.searchShell.getDisplay(), 1);
        this.searchShell.setCursor(waitCursor);
        boolean matchCase = this.searchDialog.getMatchCase();
        boolean matchWord = this.searchDialog.getMatchWord();
        String searchString = this.searchDialog.getSearchString();
        int column = this.searchDialog.getSelectedSearchArea();
        searchString = matchCase ? searchString : searchString.toLowerCase();
        boolean found = false;
        if (this.searchDialog.getSearchDown()) {
            for (int i = table.getSelectionIndex() + 1; i < table.getItemCount(); ++i) {
                found = this.findMatch(searchString, table.getItem(i), column, matchWord, matchCase);
                if (!found) continue;
                table.setSelection(i);
                break;
            }
        } else {
            for (int i = table.getSelectionIndex() - 1; i > -1; --i) {
                found = this.findMatch(searchString, table.getItem(i), column, matchWord, matchCase);
                if (!found) continue;
                table.setSelection(i);
                break;
            }
        }
        this.searchShell.setCursor(null);
        if (waitCursor != null) {
            waitCursor.dispose();
        }
        return found;
    }

    private boolean findMatch(String searchString, TableItem item, int column, boolean matchWord, boolean matchCase) {
        String tableText;
        String string = tableText = matchCase ? item.getText(column) : item.getText(column).toLowerCase();
        return matchWord ? tableText != null && tableText.equals(searchString) : tableText != null && tableText.indexOf(searchString) != -1;
    }

    private Table createFolderRestoreInUI(Composite composite) {
        this.restorePathGroup = new Group(composite, 0x1000000);
        this.restorePathGroup.setVisible(false);
        GridLayout groupRestorePathGridLayout = new GridLayout();
        groupRestorePathGridLayout.numColumns = 2;
        groupRestorePathGridLayout.makeColumnsEqualWidth = false;
        groupRestorePathGridLayout.horizontalSpacing = 10;
        this.restorePathGroup.setLayout((Layout)groupRestorePathGridLayout);
        this.restoreFolderGroup = new Group(composite, 0x1000000);
        this.restoreFolderGroup.setVisible(false);
        GridLayout groupFolderGridLayout = new GridLayout();
        groupFolderGridLayout.numColumns = 1;
        groupFolderGridLayout.makeColumnsEqualWidth = false;
        this.restoreFolderGroup.setLayout((Layout)groupFolderGridLayout);
        GridData contactGroupFolderGridData = new GridData(768);
        contactGroupFolderGridData.horizontalSpan = 2;
        contactGroupFolderGridData.grabExcessHorizontalSpace = true;
        GridData gdBtnNewButton3 = new GridData(4, 4, true, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 24;
        this.backLabel = new Button((Composite)this.restorePathGroup, 16384);
        this.backLabel.setLayoutData((Object)gdBtnNewButton3);
        this.backLabel.setText("");
        this.backLabel.setImage(this.imageBack);
        GridData gdBtnNewButton4 = new GridData(4, 4, true, false, 1, 1);
        gdBtnNewButton4.heightHint = 10;
        gdBtnNewButton4.widthHint = 500;
        this.showPathLabel = new Label((Composite)this.restorePathGroup, 0);
        this.showPathLabel.setLayoutData((Object)gdBtnNewButton4);
        this.showPathLabel.setText("");
        this.restoreFolderGroup.setLayoutData((Object)contactGroupFolderGridData);
        this.restoreFolderGroup.setText("Select a folder or a file to restore");
        this.restoreFolderGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table foldertable = new Table((Composite)this.restoreFolderGroup, 68356);
        foldertable.setHeaderVisible(true);
        TableColumn fileColumn = new TableColumn(foldertable, 16);
        fileColumn.setText("Folders/Files");
        fileColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Folders/Files", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Folders/Files", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupold.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn timestampColumn = new TableColumn(foldertable, 16);
        timestampColumn.setText("Modified Time");
        timestampColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Modified Time", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Modified Time", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupold.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn sizeColumn = new TableColumn(foldertable, 16);
        sizeColumn.setText("Size(KB)");
        sizeColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Size(KB)", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupold.this.sortListForRestore(RestoreBackupold.this.listFolders, "Size(KB)", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupold.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        this.backLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (RestoreBackupold.this.fullPath == null) {
                        return;
                    }
                    if (RestoreBackupold.this.fullPath.contains("/")) {
                        String tmpPath;
                        RestoreBackupold.this.fullPath = tmpPath = RestoreBackupold.this.getPreviousPathforBackButton();
                        RestoreBackupold.this.logger.debug("Temp Path in back function is:" + tmpPath);
                        RestoreBackupold.this.showPathLabel.setText(RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.showPathLabel.setToolTipText(RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.getBasePathFromServer(foldertable, RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.backLabel.setEnabled(false);
                    } else {
                        RestoreBackupold.this.fullPath = null;
                        RestoreBackupold.this.getBasePathFromServer(foldertable, RestoreBackupold.this.fullPath);
                        RestoreBackupold.this.showPathLabel.setText("");
                        RestoreBackupold.this.backLabel.setEnabled(false);
                    }
                }
                catch (Exception e1) {
                    RestoreBackupold.this.logger.trace("" + e1);
                    RestoreBackupold.this.logger.error(RestoreBackupold.EXCEPTION + e1.getMessage());
                }
            }
        });
        Label showFolderHelpLabel = new Label((Composite)this.restoreFolderGroup, 0);
        showFolderHelpLabel.setLayoutData((Object)contactGroupFolderGridData);
        showFolderHelpLabel.setText("Selecting a folder will result in restoring all sub-folders and files under it.");
        showFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        return foldertable;
    }

    String getPreviousPathforBackButton() {
        String delimiter = "\\/";
        String[] tmpArray = this.fullPath.split(delimiter);
        StringBuilder tmpPath = null;
        for (int i = 0; i < tmpArray.length - 1; ++i) {
            tmpPath = tmpPath == null ? new StringBuilder(tmpArray[i]) : tmpPath.append("/").append(tmpArray[i]);
        }
        if (tmpPath != null) {
            return tmpPath.toString();
        }
        return null;
    }

    public void getBasePathFromServer(Table foldertable, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listFolders = this.getListOfFolders(folderPath);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runbl = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runbl);
                return;
            }
            if (RestoreHelper.serviceUnavailable) {
                RestoreHelper.serviceUnavailable = false;
                Runnable runbl = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runbl);
                return;
            }
            Runnable runn = () -> {
                if (!this.listFolders.isEmpty()) {
                    this.listFoldersStack.removeAllElements();
                    this.listFoldersStack.addAll(this.listFolders);
                }
                this.logger.debug("addinggg:" + this.listFoldersStack.size());
                this.addFolderDevicesToTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runn);
        };
        new Thread(runnable).start();
    }

    public void showupRevisions(Table foldertable, String fileName, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        foldertable.getColumn(0).setText("Versions");
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runable1 = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllRevisionsForAFile(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, fileName, this.restoreTilldate);
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION, (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runnable = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnable);
                return;
            }
            Runnable runbl = () -> {
                this.showRevisionsInTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runbl);
        };
        new Thread(runable1).start();
    }

    private void pullRestoreDeviceListFromServer(Table table) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        NotificationHelper.restoreFinished = false;
        NotificationHelper.successfulRestore = 3;
        Runnable runnable = () -> {
            this.listDevices = null;
            try {
                this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
                if (this.listDevices == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, SettingHelper.readTokenFromFile());
                }
            }
            catch (Exception e) {
                this.logger.debug(EXCEPTION, (Throwable)e);
            }
            if (this.isDisposed() || this.getDisplay() == null) {
                Runnable runbl = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runbl);
                return;
            }
            if (this.listDevices == null || this.listDevices.isEmpty()) {
                this.logger.debug(RESTORE_DEFAULT);
                Runnable runn = () -> {
                    this.showErrorMessageForDeviceListEmpty();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runn);
                return;
            }
            Runnable runnable1 = () -> {
                this.logger.debug("Displaing list of devices");
                this.addDevicesToTable(this.listDevices, table);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 4;
            };
            this.getDisplay().asyncExec(runnable1);
        };
        new Thread(runnable).start();
    }

    private void addDevicesToTable(List<DisplayTo> listDevices, Table table) {
        for (DisplayTo deviceTo : listDevices) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, deviceTo.getDeviceName());
            if (!StringUtils.isEmpty((String)deviceTo.getUserName())) {
                item.setText(1, deviceTo.getUserName());
            } else {
                item.setText(1, "");
            }
            item.setData((Object)deviceTo);
            if (!StringUtils.isEmpty((String)deviceTo.getDeviceOsType())) {
                if (deviceTo.getDeviceOsType().toLowerCase().contains("win")) {
                    item.setImage(0, this.imageWindows);
                    continue;
                }
                if (deviceTo.getDeviceOsType().toLowerCase().contains("ios") || deviceTo.getDeviceOsType().toLowerCase().contains("mac")) {
                    item.setImage(0, this.imageMac);
                    continue;
                }
                if (deviceTo.getDeviceOsType().toLowerCase().contains("android")) {
                    item.setImage(0, this.imageAndroid);
                    continue;
                }
                if (!deviceTo.getDeviceOsType().toLowerCase().contains("onedrive")) continue;
                item.setImage(0, this.imageO365);
                continue;
            }
            item.setImage(0, this.imageUnknown);
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).pack();
        }
        table.getColumn(0).setWidth((int)((double)table.getClientArea().width * 0.5));
        table.getColumn(1).setWidth((int)((double)table.getClientArea().width * 0.5));
    }

    private void addFolderDevicesToTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        foldertable.getColumn(0).setText("Folders/Files");
        for (DisplayTo displayTo : this.listFolders) {
            if (displayTo != null && displayTo.getFilePath() != null) continue;
        }
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + this.listFolders.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("listFoldersStack:" + this.listFoldersStack.size());
                this.listFoldersStack.forEach(p -> this.listFolders.add((DisplayTo)p));
                this.logger.debug("Full Path is:" + this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
        this.setDataToFolderTable(foldertable, 1);
    }

    private void showRevisionsInTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        ArrayList<DisplayTo> vesionsList = new ArrayList<DisplayTo>();
        int count = this.listFolders.size();
        for (DisplayTo displayTo : this.listFolders) {
            if (displayTo.getFilePath() == null || !displayTo.isExists()) {
                --count;
                continue;
            }
            displayTo.setDisplayName(" Version " + count);
            vesionsList.add(displayTo);
            --count;
        }
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + this.listFolders.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("Full Path is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        } else {
            this.listFolders.clear();
            this.listFolders.addAll(vesionsList);
            this.setDataToFolderTable(foldertable, count);
        }
    }

    protected void showInfoMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Warning!");
        msg.setMessage("This operation may take some time, depending on the amount of data being restored.\nPlease ensure that the system is connected to a power source and doesn\u2019t sleep or hibernate during this time.  \nTo get critical data back faster, you may consider doing multiple restores of smaller file sets.");
        msg.open();
    }

    private void showErrorMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Server unreachable");
        msg.setMessage("Cannot connect to the server. Please check the network connection and try again. If the problem persists, please contact your Administrator.");
        msg.open();
    }

    protected void createTempFile(File oldTempFile) throws IOException, InterruptedException {
        if (!oldTempFile.getParentFile().exists()) {
            oldTempFile.getParentFile().mkdirs();
        }
        if (oldTempFile.exists()) {
            oldTempFile.delete();
        }
        oldTempFile.createNewFile();
        oldTempFile.deleteOnExit();
    }

    public void cancelRestoreDisplayTimer() {
        this.logger.debug("canceling the update timemr.....");
        if (this.restoreTimerTask != null) {
            this.restoreTimerTask.cancel();
        }
        if (this.restoreTimer != null) {
            this.restoreTimer.cancel();
        }
    }

    public void startRestoreBackup() {
        if (this.restoreTimer == null) {
            this.restoreTimer = new Timer();
        }
        if (this.restoreTimerTask == null) {
            this.restoreTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        RestoreBackupold.this.updateRestoreDisplay();
                    }
                    catch (Exception e) {
                        RestoreBackupold.this.logger.error("Error in updateRestoreDisplay", (Throwable)e);
                    }
                }
            };
            this.restoreTimer.schedule(this.restoreTimerTask, 1000L, 1000L);
        }
    }

    protected void updateRestoreDisplay() {
        if (this.getDisplay() == null || this.getDisplay().isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            if (this.restoreButton == null || this.restoreButton.isDisposed()) {
                return;
            }
            try {
                if (NotificationHelper.isRestoreStarted()) {
                    String fileBeingRestored;
                    this.restoreButton.setEnabled(false);
                    this.closeButton.setEnabled(false);
                    this.restoreStatus.setText("Restore in progress");
                    this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    this.restoreStatus1.setText("");
                    this.restoreFolderGroup.setEnabled(false);
                    this.restorePathGroup.setEnabled(false);
                    this.restoreGroup.setEnabled(false);
                    this.inplaceCheckBox.setEnabled(false);
                    calender.setEnabled(false);
                    refresh.setEnabled(false);
                    pointInTimeCheckBox.setEnabled(false);
                    this.checkBox.setEnabled(false);
                    if (!StringUtils.isEmpty((String)this.restoreElement.getFileBeingRestored())) {
                        NotificationHelper.setFileBeingRestored((String)this.restoreElement.getFileBeingRestored());
                    }
                    if ((fileBeingRestored = this.restoreElement.getFileBeingRestored()) != null && NotificationHelper.isShowFileBeingRestored()) {
                        this.currentFileBeingRestoredLabel.setVisible(true);
                        this.currentRestoreStatusLabel.setVisible(true);
                        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
                        this.currentFileBeingRestoredLabel.setToolTipText(NotificationHelper.getFileBeingRestored());
                        this.currentRestoreStatusLabel.setFont(this.fontsManager.getMediumNormalFont());
                        String filesCount = this.restoreElement.getRestoreCount();
                        this.currentRestoreStatusLabel.setToolTipText(" " + filesCount + "files completed.");
                        this.currentRestoreStatusLabel.setText(" " + filesCount + "files completed.");
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                    }
                } else {
                    this.closeButton.setEnabled(true);
                    this.inplaceCheckBox.setEnabled(true);
                    if (this.PointInTimeRestoreSelected) {
                        calender.setEnabled(true);
                        refresh.setEnabled(true);
                    }
                    pointInTimeCheckBox.setEnabled(true);
                    this.checkBox.setEnabled(true);
                    if (NotificationHelper.successfulRestore != 3) {
                        this.restoreButton.setEnabled(true);
                    }
                    this.currentFileBeingRestoredLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setText("");
                    if (NotificationHelper.restoreFinished) {
                        this.restoreFolderGroup.setEnabled(true);
                        this.restorePathGroup.setEnabled(true);
                        this.restoreGroup.setEnabled(true);
                        this.inplaceCheckBox.setEnabled(true);
                        if (this.PointInTimeRestoreSelected) {
                            calender.setEnabled(true);
                            refresh.setEnabled(true);
                        }
                        pointInTimeCheckBox.setEnabled(true);
                        this.checkBox.setEnabled(true);
                        if (NotificationHelper.successfulRestore == 1) {
                            this.restoreStatus.setText("Restored successfully");
                            this.restoreStatus1.setText("");
                        } else if (NotificationHelper.successfulRestore == 2) {
                            this.restoreStatus.setText("No files restored.");
                            this.restoreStatus1.setText("");
                        } else if (NotificationHelper.successfulRestore == 0) {
                            if ("0".equalsIgnoreCase(this.restoreElement.getRestoreCount())) {
                                this.restoreStatus.setText("Unable to connect to the server.");
                                this.restoreStatus1.setText("");
                            } else {
                                this.restoreStatus.setText("Restore completed - " + this.restoreElement.getRestoreCount() + " files restored.");
                                this.restoreStatus1.setText("");
                            }
                        } else if (NotificationHelper.successfulRestore == 5) {
                            this.restoreStatus.setText("Error during restore. Token expired");
                            this.restoreStatus1.setText("");
                        } else if (NotificationHelper.successfulRestore == 6) {
                            this.restoreStatus.setText("Restore aborted.  Please check your network connection and try again.");
                            this.restoreStatus1.setText("If the problem persists, please contact your Administrator.");
                        }
                    } else {
                        if (NotificationHelper.successfulRestore == 3) {
                            this.restoreGroup.setEnabled(false);
                            this.restoreFolderGroup.setEnabled(false);
                            this.restorePathGroup.setEnabled(false);
                            this.queryGroup.setEnabled(false);
                            this.inplaceCheckBox.setEnabled(false);
                            calender.setEnabled(false);
                            refresh.setEnabled(false);
                            pointInTimeCheckBox.setEnabled(false);
                            this.checkBox.setEnabled(false);
                            if (this.restoreLoadingStatus) {
                                this.restoreStatus.setText("Loading information..");
                            } else {
                                this.restoreStatus.setText("Loading information...");
                            }
                            this.restoreLoadingStatus = !this.restoreLoadingStatus;
                        } else {
                            this.restoreGroup.setEnabled(true);
                            this.restoreFolderGroup.setEnabled(true);
                            this.restorePathGroup.setEnabled(true);
                            this.queryGroup.setEnabled(true);
                            this.inplaceCheckBox.setEnabled(true);
                            if (this.PointInTimeRestoreSelected) {
                                calender.setEnabled(true);
                                refresh.setEnabled(true);
                            }
                            pointInTimeCheckBox.setEnabled(true);
                            this.checkBox.setEnabled(true);
                            this.restoreStatus.setText("Click Restore to start restoration");
                            this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                        }
                        if (NotificationHelper.successfulRestore == 4) {
                            this.restoreStatus.setText("Select Device/Folder to restore");
                            this.restoreStatus1.setText("");
                            this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("error in restoreStatus toggle", (Throwable)e);
            }
        };
        this.getDisplay().asyncExec(runnable);
    }

    protected void checkSubclass() {
    }

    public void validatePreviousBatchStatus(RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        RestoreActivityTO activityTO = restoreActivityHistoryDAOImpl.getCurrentStatusFromRestoreActivityHistoryTable(true);
        if (activityTO != null && activityTO.getRestoreBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            this.logger.debug("**********************************" + activityTO.getRestoreBatchId());
            this.logger.debug("User exit the app or network connection failed. so failed status to be sent");
            activityTO.setRestoreBatchStatus(BackupLifeCycle.FAILED.toString());
            String currentBatchId = activityTO.getRestoreBatchId();
            this.logger.debug("Batchid is" + currentBatchId);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(activityTO);
            this.restoreBatchInitiated(activityTO.getRestoreBatchStatus(), currentBatchId, activityTO.getTotalRestoreCount(), activityTO.getTotalRestoredSize());
        }
    }

    public String restoreBatchInitiated(String batchStatus, String batchId, String restoreCount, long totalSizeRestored) {
        String restoreBatchId;
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        String jobType = "RESTORE";
        try {
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(batchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(this.restoredCount);
            backupOrRestoreStatusTo.setErrorCode(909);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(0L);
            backupOrRestoreStatusTo.setTotalUploadedCount(restoreCount);
            backupOrRestoreStatusTo.setCrawlCount(0);
            backupOrRestoreStatusTo.setCrawlTimeStamp("0");
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            backupOrRestoreStatusTo.setPolicyConfiguredFolders("");
            backupOrRestoreStatusTo.setRestoreDeviceUUID(this.deviceuid);
            backupOrRestoreStatusTo.setTotalSizeRestored(totalSizeRestored);
            this.setRestoreFolder(backupOrRestoreStatusTo);
            restoreBatchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            restoreBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.debug(" Exception inside send email notification  " + e.getMessage());
        }
        return restoreBatchId;
    }

    private void setRestoreFolder(BackupOrRestoreStatusTo backupOrRestoreStatusTo) {
        if (this.selectedFolder != null) {
            if (this.selectedFolder.getFileName() == null) {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFilePath());
            } else {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFileName() + "/" + this.selectedFolder.getFilePath());
            }
        } else {
            backupOrRestoreStatusTo.setRestoreFolder("All drives");
        }
    }

    private void showErrorMessageForDeviceListEmpty() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        if (RestoreHelper.licenseExpired) {
            msg.setText("License has Expired.  Please contact your Administrator.");
            msg.setMessage("License has Expired.  Please contact your Administrator.");
        } else if (RestoreHelper.deviceBlocked) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.sessionExpired) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.serviceUnavailable) {
            msg.setText("Service Unavailable");
            msg.setMessage("Service unavailable, please try again later");
            RestoreHelper.serviceUnavailable = false;
        } else {
            msg.setText("Device List is Empty");
            msg.setMessage("There is no device backed up for the user " + SettingHelper.getUserName());
        }
        msg.open();
    }

    private void sortListForRestore(List<DisplayTo> list, String sortBy, boolean forwardSort) {
        Comparator comparator;
        switch (sortBy) {
            case "Folders/Files": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d1.getDisplayName(), (Object)d2.getDisplayName()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d2.getDisplayName(), (Object)d1.getDisplayName()).toComparison();
                };
                break;
            }
            case "Size(KB)": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getSize(), d2.getSize()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getSize(), d1.getSize()).toComparison();
                };
                break;
            }
            case "Modified Time": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getModifiedTime(), d2.getModifiedTime()).toComparison();
                    }
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getModifiedTime(), d1.getModifiedTime()).toComparison();
                };
                break;
            }
            case "Username": {
                comparator = (d1, d2) -> {
                    if (!StringUtils.isEmpty((String)d1.getUserName()) && !StringUtils.isEmpty((String)d2.getUserName())) {
                        if (forwardSort) {
                            return d1.getUserName().compareTo(d2.getUserName());
                        }
                        return d2.getUserName().compareTo(d1.getUserName());
                    }
                    return 0;
                };
                break;
            }
            case "Versions": {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return d1.getDisplayName().compareTo(d2.getDisplayName());
                    }
                    return d2.getDisplayName().compareTo(d1.getDisplayName());
                };
                break;
            }
            default: {
                comparator = (d1, d2) -> {
                    if (forwardSort) {
                        return d1.getDeviceName().compareTo(d2.getDeviceName());
                    }
                    return d2.getDeviceName().compareTo(d1.getDeviceName());
                };
            }
        }
        Collections.sort(list, comparator);
    }

    private int setDataToFolderTable(Table foldertable, int counter) {
        int tempCounter = counter;
        int columnCount = foldertable.getColumnCount();
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        for (DisplayTo displayTo : this.listFolders) {
            TableItem item1 = new TableItem(foldertable, 0);
            Date date = new Date(displayTo.getModifiedTime());
            if (displayTo.getDisplayName() == null) {
                displayTo.setDisplayName(displayTo.getFilePath());
            }
            item1.setText(0, displayTo.getDisplayName());
            if (Boolean.parseBoolean(displayTo.getFolder())) {
                item1.setImage(0, this.imageFolder);
                item1.setText(1, "");
                item1.setText(2, "");
            } else {
                item1.setImage(0, this.imageFile);
                item1.setText(1, this.sdf.format(date));
                item1.setText(2, String.valueOf(displayTo.getSize()));
            }
            item1.setData((Object)displayTo);
            ++tempCounter;
        }
        for (int i = 0; i < columnCount; ++i) {
            foldertable.getColumn(i).pack();
        }
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        return tempCounter;
    }

    public boolean isAllDrivesPresnt() {
        boolean result = false;
        Set rootFilesList = PolicyManagementServerHelper.storeSystemRoots();
        if (this.restoreFolderorDevice == 1) {
            this.listOfDrives = this.getListOfFolders(null);
            for (DisplayTo list : this.listOfDrives) {
                this.selectedDrives.add((list.getFilePath() + StringLiterals.FILE_SEPARATOR).toLowerCase());
            }
        } else if (StringUtils.isEmpty((String)this.selectedFolder.getFileName())) {
            this.selectedDrives.add((this.selectedFolder.getFilePath().substring(0, 2) + StringLiterals.FILE_SEPARATOR).toLowerCase());
        } else if (StringUtils.isNotEmpty((String)this.selectedFolder.getFileName()) && StringUtils.isNotEmpty((String)this.selectedFolder.getFilePath())) {
            this.selectedDrives.add((this.selectedFolder.getFileName().substring(0, 2) + StringLiterals.FILE_SEPARATOR).toLowerCase());
        }
        this.selectedDrives.removeAll(rootFilesList);
        if (this.selectedDrives.size() == 0) {
            result = true;
        }
        missingDrive = StringUtils.join(this.selectedDrives, (String)" ,");
        this.selectedDrives.clear();
        return result;
    }

    private List<DisplayTo> getListOfFolders(String folderPath) {
        try {
            this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, this.restoreTilldate);
            if (this.listFolders == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, this.restoreTilldate);
            }
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION, (Throwable)e);
        }
        return this.listFolders;
    }

    static {
        subtext = null;
        missingDrive = "";
    }
}

