/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.catnapgames.winfolders.WinFoldersJava;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.RegistrationLiterals;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.element.SyncPolicyElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.registration.CloudRegistrationUtility;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.DeviceRegTo;
import com.parablu.epa.core.to.MediaFolderTO;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.helper.constant.GeneralHelperConstant;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import com.parablu.epa.service.settings.ShortcutHelper;
import com.parablu.epa.view.BackupManagerView;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RegistrationView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrationProgressView
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RegistrationProgressView.class);
    FontsManager fontsManager;
    private ImageData tickImageData = null;
    private Image tickImage = null;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PARABLU_SEARCHING_GIF = "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "ParaBluSearch.gif";
    public static final String DEVICE_ALREADY_REGISTERED = "false";
    private Composite compositeForGif = null;
    private Composite compositeForFolderLocation = null;
    private Label chooseFolderDescriptionLabel = null;
    private Label chooseFolderImage = null;
    private Group currentFolderSelectPanel = null;
    private Composite helpTextPanel = null;
    private Label chooseFolderDefaultLabel = null;
    private Label helpTextLabel = null;
    private Text currentFolderSelectedText = null;
    private Button browseButton = null;
    private Display display = null;
    private Display display1 = null;
    private String userCloudName = null;
    private String userDeviceName = null;
    private String name = null;
    private String userPassword = null;
    private StackLayout parentStackLayout = null;
    private Composite parentComposite = null;
    private Composite registrationPanelForInputTexts = null;
    private ImageLoader loader = null;
    private Image image = null;
    private int imageNumber = 0;
    private Thread gifUpdaterThread = null;
    private Canvas canvas = null;
    private Label connectingLabel;
    private boolean continueSearchDisplay = true;
    private final Button registerButton;
    private final Label pageDescription;
    private final RegistrationView.RegisterSelectionAdapter registerSelectionAdapter;
    private static final String DEFAULT_FOLDER_NAME = SettingHelper.getUserHome();
    private static final String DEFAULT_PARABLU_NAME = StringLiterals.FILE_SEPARATOR + "ParaBlu";
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    String folderPath = DEFAULT_FOLDER_NAME;
    private static final int SEARCHING_CLOUD = 0;
    private static final int VALIDATING_USER = 1;
    private static final int ERROR = -5000;
    private int result = -5000;
    private static final String SILENT = "silent";
    private boolean retryRegister = false;
    public static final String FORCE_REGISTRATION = "true";
    protected static Shell shell = null;
    protected static Shell silentShell;
    public static int deviceRegistryResponse;
    public static String loginType;

    public RegistrationProgressView(Composite stackPanel, String cloudName, String deviceName, String userName, String password, Button parentRegButton, Label pageDescription, StackLayout stackLayout, Composite defaultComposite, RegistrationView.RegisterSelectionAdapter registerSelectionAdapter) {
        this.userCloudName = cloudName;
        this.userDeviceName = deviceName;
        this.name = userName;
        this.userPassword = password;
        this.parentComposite = stackPanel;
        this.registerButton = parentRegButton;
        this.parentStackLayout = stackLayout;
        this.registrationPanelForInputTexts = defaultComposite;
        this.pageDescription = pageDescription;
        this.registerSelectionAdapter = registerSelectionAdapter;
    }

    @Override
    public void run() {
        try {
            if (!SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                this.loadUI();
            } else if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                this.retryRegister = true;
            }
            this.logger.debug("Starting cloud registration ");
            CloudRegistrationUtility rs = new CloudRegistrationUtility(this.userCloudName, this.userDeviceName, this.name, this.userPassword, SettingHelper.getKeystorePath());
            this.logger.debug("Searching for cloud ");
            this.update(0);
            boolean isIPFound = rs.searchForPublicIpOfCloud();
            if (!isIPFound) {
                if (!StringUtils.isEmpty((String)PropertyHelper.MAIN_EBMS_DOMAIN)) {
                    this.logger.debug("Inside hash check needed....");
                    rs.setGaeCloudLocalIP(PropertyHelper.MAIN_EBMS_DOMAIN.trim());
                    rs.setCloudPublicIP(PropertyHelper.MAIN_EBMS_DOMAIN.trim());
                } else {
                    this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, " Cloud name is not mapped to your Account");
                    this.closeShell();
                    return;
                }
            }
            this.update(1);
            this.logger.debug("Registering Cloud");
            String computerSerialNumberWindows = null;
            rs.retryRegister = this.retryRegister;
            rs.productVersion = SettingHelper.getProductVersion();
            this.logger.debug("Product version in registry " + rs.productVersion + " Setting helper " + SettingHelper.getProductVersion());
            DeviceRegTo response = rs.registerDeviceForCloud(computerSerialNumberWindows, SettingHelper.getOsName(), DEVICE_ALREADY_REGISTERED, loginType, SettingHelper.getOsVersion(), FORCE_REGISTRATION);
            this.continueSearchDisplay = false;
            this.logger.debug("Registering device");
            int rslt = this.decipherResponseTo(response, rs);
            if (rslt == 64) {
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), FORCE_REGISTRATION, loginType, SettingHelper.getOsVersion(), FORCE_REGISTRATION);
                rslt = this.decipherResponseTo(response, rs);
            }
            if (rslt == 68) {
                int retryCount = 0;
                int sleepTime = 1000;
                int exitVal = -1;
                int sleepTimeFromRegieditInMin = this.getSleepTimeFromRegedit();
                int sleepTimeFromRegiedit = sleepTimeFromRegieditInMin * 60 * 1000;
                int timeSlept = 0;
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                rs.startHttpServer();
                String clientId = response.getClientId();
                String redirectUri = response.getEndPointRedirectUri();
                String tenantName = response.getTenantName();
                String loginMode = response.getLoginMode();
                this.logger.debug("clientId:" + clientId);
                this.logger.debug("redirectUri:" + redirectUri);
                String url = "https://login.microsoftonline.com/" + tenantName + "/oauth2/v2.0/authorize?client_id=" + clientId + "^&response_type=code^&redirect_uri=" + redirectUri + "^&response_mode=query^&scope=offline_access%20user.read";
                String urlAlt = "https://login.microsoftonline.com/" + tenantName + "/oauth2/v2.0/authorize?\nclient_id=" + clientId + "\n&response_type=code\n&redirect_uri=" + redirectUri + "\n&response_mode=query\n&scope=offline_access%20user.read";
                if (loginMode.equalsIgnoreCase("okta")) {
                    url = "https://" + tenantName + "/oauth2/v1/authorize?client_id=" + clientId + "^&response_type=code^&redirect_uri=" + redirectUri + "^&response_mode=query^&scope=openid%20profile%20email^&state=state-pvn";
                    urlAlt = "https://" + tenantName + "/oauth2/v1/authorize?\nclient_id=" + clientId + "\n&response_type=code\n&redirect_uri=" + redirectUri + "\n&response_mode=query\n&scope=openid%20profile%20email\n&state=state-pvn";
                }
                String forceCheck = PropertyHelper.SSO_BROWSER_PREFERENCE;
                List<String> preferences = Arrays.asList(forceCheck.split(","));
                for (String browserPreference : preferences) {
                    boolean contains = Arrays.stream(GeneralHelperConstant.BROWSER_PREF_LIST).anyMatch(browserPreference::equals);
                    if (!contains) {
                        this.logger.debug(browserPreference + " is not available so move on");
                        continue;
                    }
                    browserPreference = !browserPreference.equalsIgnoreCase("edge") ? browserPreference + " " : "microsoft-edge:";
                    String command = "start " + browserPreference + url;
                    builder.command("cmd", "/c", command);
                    Process process = builder.start();
                    exitVal = process.waitFor();
                    this.logger.debug("url to launch:" + url);
                    if (exitVal == 0) {
                        this.logger.debug("tried opening " + browserPreference + " it succeeded." + exitVal);
                        break;
                    }
                    this.logger.error("tried opening " + browserPreference + " but failed." + exitVal);
                }
                this.logger.debug("process..." + exitVal);
                if (exitVal != 0) {
                    Program.launch((String)urlAlt);
                }
                while (StringUtils.isEmpty((String)ParabluFileSystemUtils.getAADAuthCode())) {
                    this.logger.debug("Sleep and Wait for Auth code.. ");
                    Thread.sleep(sleepTime);
                    ++retryCount;
                    if ((timeSlept += sleepTime) <= sleepTimeFromRegiedit) {
                        if (retryCount <= 30) continue;
                        sleepTime = 10000;
                        continue;
                    }
                    this.logger.debug("couldn't get the auth code in a given time so quit the application");
                    System.exit(0);
                }
                rs.stopHttpServer();
                this.logger.debug("AAD auth code:" + ParabluFileSystemUtils.getAADAuthCode());
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), FORCE_REGISTRATION, loginType, SettingHelper.getOsVersion(), FORCE_REGISTRATION);
                this.logger.debug("access token:" + response.getAccessToken());
                if (StringUtils.isNotEmpty((String)response.getAccessToken())) {
                    ParabluFileSystemUtils.setAADAccessToken((String)response.getAccessToken());
                }
                rslt = this.decipherResponseTo(response, rs);
            }
            if (rslt == 65) {
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), DEVICE_ALREADY_REGISTERED, SettingHelper.getKeystorePath(), SettingHelper.getOsVersion(), DEVICE_ALREADY_REGISTERED);
                rslt = this.decipherResponseTo(response, rs);
            }
            if (rslt == 0 || rslt == 128) {
                this.closeShell();
                return;
            }
            if (rslt == 1) {
                this.logger.debug("Registering device successful");
                SettingHelper.setSyncLicenced((String)response.getSyncEnabled());
                SettingHelper.setBackupLicenced((String)response.getBackupEnabled());
                SettingHelper.setDeviceUUId((String)response.getDeviceUUId());
                SettingHelper.setRestoreEnabled((String)response.getRestoreEnabled());
                SettingHelper.setIsExternalStorageSelected((String)response.getIsExternalStorageSelected());
                SettingHelper.setUiVersion((int)response.getUiVersion());
                SettingHelper.setServerBackupLicensed((String)response.getServerBackupEnabled());
                if (SettingHelper.getServerBackupLicensed().contentEquals(FORCE_REGISTRATION)) {
                    SettingHelper.setBackupLicenced((String)FORCE_REGISTRATION);
                }
                if (SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION) && response.getBackupPolicyElement() == null || SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION) && response.getSyncPolicyElement() == null) {
                    this.logger.debug("Backup Policy : " + response.getBackupPolicyElement());
                    this.logger.debug("Sync Policy : " + response.getSyncPolicyElement());
                    this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, "No policy mapped to user.\nPlease contact administrator");
                    this.closeShell();
                    return;
                }
                BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
                if (SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION)) {
                    this.logger.debug("Before creating databases..");
                    backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
                    backUpFolderDAOImpl.createBackUpTable();
                    backupPolicyDAOImpl.createBackupPolicyTable();
                    backupPolicyDAOImpl.createDeviceBackupLicenseTable();
                    backupPolicyDAOImpl.createNetworkThrottlingTable();
                    backupPolicyDAOImpl.createSchedulesTable();
                    backupPolicyDAOImpl.createInclusionsTable();
                    backupPolicyDAOImpl.createPrivacyGatewayTable();
                    backupPolicyDAOImpl.createBackupPolicyDefaultFoldersTable();
                    backupPolicyDAOImpl.createEBMSTable();
                    backupPolicyDAOImpl.createPolicyExcludedFolderTable();
                    backupPolicyDAOImpl.creatContainerTable();
                    backupPolicyDAOImpl.createPolicyExceptionsTOExclusionTable();
                    backUpFolderDAOImpl.createHashTable();
                    GroupPolicyElementList groupPolicyElementList = new GroupPolicyElementList();
                    ArrayList<GroupPolicyElement> groupPolicyElements = new ArrayList<GroupPolicyElement>();
                    groupPolicyElements.add(response.getBackupPolicyElement());
                    groupPolicyElementList.setGroupPolicyElement(groupPolicyElements);
                    PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)new BackupPolicyTO(), (GroupPolicyElementList)groupPolicyElementList);
                    if (SettingHelper.isDCMEnabled()) {
                        if (BluSyncLauncher.certName != null && !BluSyncLauncher.certName.isEmpty()) {
                            this.logger.debug("Checking device certificate authentication");
                            boolean isDeviceCertValid = rs.checkDeviceCertAuthentication(BluSyncLauncher.certName);
                            if (!isDeviceCertValid) {
                                this.logger.error("certAuthentication Error");
                                this.showFailedToRegisterMessageBox("DCM Authentication Error", "Device authentication failed for your machine.\nPlease contact administrator");
                                this.closeShell();
                                return;
                            }
                        } else {
                            this.logger.error("certAuthentication Error and cert name is empty");
                            this.showFailedToRegisterMessageBox("DCM Authentication Error", "Device authentication failed for your machine.\nPlease contact administrator");
                            this.closeShell();
                            return;
                        }
                    }
                }
                if (SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION)) {
                    SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
                    syncPolicyDAOImpl.createSyncPolicyTable();
                    syncPolicyDAOImpl.createInclusionsTable();
                    syncPolicyDAOImpl.createShareTable();
                    backupPolicyDAOImpl.createEBMSTable();
                    backupPolicyDAOImpl.createPrivacyGatewayTable();
                    PolicyManagementServerHelper.createSyncPolicyAndChildDetails((SyncPolicyDAOImpl)syncPolicyDAOImpl, (SyncPolicyTo)new SyncPolicyTo(), (SyncPolicyElement)response.getSyncPolicyElement());
                }
                if (!SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                    this.showFolderSelectionPage();
                } else {
                    SettingHelper.setParabluSyncFolder((String)this.folderPath);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                }
                PropertyHelper.changeConfigProperty((String)"login-type", (String)"", (int)1);
                this.logger.debug("Closed registration UI");
            }
        }
        catch (Exception e) {
            this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            this.closeShell();
            this.logger.error("Exception occurred during connection to cloud ", (Throwable)e);
            this.logger.trace("" + e);
            return;
        }
    }

    private int getSleepTimeFromRegedit() {
        int sleepTimeFromRegieditInMin = 2;
        String platformNo = SettingHelper.getOsVersion();
        String timerdelayinString = "";
        try {
            timerdelayinString = platformNo.contains("64 bit") ? RegistryUtils.getRegistryValue((String)"HKLM", (String)"SOFTWARE\\WOW6432Node\\ParaBlu\\BluSync\\Params", (String)"sleepTimeToWaitAndgetAuthcode") : RegistryUtils.getRegistryValue((String)"HKLM", (String)"SOFTWARE\\ParaBlu\\BluSync\\Params", (String)"sleepTimeToWaitAndgetAuthcode");
            if (StringUtils.isNotEmpty((String)timerdelayinString)) {
                sleepTimeFromRegieditInMin = Integer.parseInt(timerdelayinString);
            }
        }
        catch (Exception e) {
            this.logger.debug("exception getting sleeptime from reg edit:" + e);
        }
        return sleepTimeFromRegieditInMin;
    }

    private int decipherResponseTo(DeviceRegTo response, CloudRegistrationUtility rs) {
        if (response.getStatus() != 30 && response.getStatus() != 409 && response.getStatus() != 1019) {
            if (response.getStatus() == 1014) {
                this.logger.debug("Registering device failed due to NO_NETWORK");
                this.showFailedToRegisterMessageBox("Network Error", "Device seems to be offline.Please check your internet connection and try again.");
            } else if (response.getStatus() == 8) {
                if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent) && !"noui".equalsIgnoreCase(BluSyncLauncher.isNoUi)) {
                    this.startUIAfterDecoupledAndIfSilent();
                } else {
                    this.logger.debug("registering device failed due to USERNAME_PASSWORD_AUTHENTHICATION_FAILED");
                    this.showFailedToRegisterMessageBox("Authentication Error: Invalid credentials", "Please check your login credentials and try again.");
                }
            } else if (response.getStatus() == 1001) {
                this.logger.debug("Registering device failed due to DEVICE_LIMIT_EXCEEDED");
                this.showFailedToRegisterMessageBox("Device Limit Reached", RegistrationLiterals.DEVICE_LIMIT_EXCEEDED_ERROR_MESSAGE);
            } else if (response.getStatus() == 1005) {
                this.logger.debug("Registering device failed due to LICENSE_EXPIRED");
                this.showFailedToRegisterMessageBox("License Expired", "The license for this Parablu Installation has expired.");
            } else if (response.getStatus() == 426) {
                this.logger.debug("Registering device failed due to HTTP_CONFLICTING_DEVICE");
                this.showFailedToRegisterMessageBox("Registration Failed", "A device with the same name already exists.\n Please enter a different name");
            } else if (response.getStatus() == 425) {
                this.logger.debug("registering device failed due to HTTP_AUTO_SYNC_BACKUP_DISABLED");
                this.showFailedToRegisterMessageBox("Registration Failed", PropertyHelper.USER_SYNC_BACK_DISABLED_ERROR_MESSAGE);
            } else if (response.getStatus() == 3) {
                this.logger.debug("registering device failed due to DEVICE_UNAUTHORIZED_CONNECTION");
                this.showFailedToRegisterMessageBox("Device Blocked", RegistrationLiterals.DEVICE_BLOCKED_ERROR_MESSAGE);
            } else if (response.getStatus() == 120) {
                this.logger.debug("Registering device failed due to USER_NO_CLOUDS_ATTACHED");
                this.showFailedToRegisterMessageBox("Error:Login Failed", RegistrationLiterals.NO_CLOUDS_ATTACHED_ERROR_MESSAGE);
            } else if (response.getStatus() == 1004) {
                this.logger.debug("Registering device failed due to USER_LIMIT_EXCEEDED_ERROR_MESSAGE");
                this.showFailedToRegisterMessageBox("User Limit Reached", "The maximum user limit has been reached.");
            } else if (response.getStatus() == 403) {
                this.logger.debug("Registering device failed due to USER_ACCOUNT_NOT_ACTIVE");
                this.showFailedToRegisterMessageBox("Access Error", "Account is not active.");
            } else if (response.getStatus() == 1012) {
                this.logger.debug("Registering device failed due to SERVICE_UNAVAILABLE");
                this.showFailedToRegisterMessageBox("Server Error", "Service is unavailable.\nPlease contact administrator");
            } else if (response.getStatus() == 1013) {
                this.logger.debug("Registering device failed due to USER_POLICY_NOT_AVAILABLE");
                this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            } else if (response.getStatus() == 1015) {
                int res = this.checkForconfirmation("Parablu Device Registration", "This device is already registered with at least one other user.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    return 65;
                }
                this.logger.debug("Registering device failed due to HTTP_DEVICE_WITH_MULTIPLE_USER");
                System.exit(0);
            } else if (response.getStatus() == 1017) {
                int res = this.checkForconfirmation("Parablu Device Registration", "This device is already registered with at least one other user.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    int res1 = this.checkForconfirmation("Parablu Device Registration", "Your user name is already registered with at least one other device.\nAre you sure you wish to continue?");
                    deviceRegistryResponse = 0;
                    if (res1 == 1) {
                        return 65;
                    }
                    this.logger.debug("Registering device failed due to Multiple user and Device registration");
                    System.exit(0);
                } else {
                    this.logger.debug("Registering device failed due to Multiple user and Device registration");
                    System.exit(0);
                }
            } else if (response.getStatus() == 1018) {
                int res = this.checkForconfirmation("Parablu Device Registration", "Your user name is already registered with at least one other device.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    return 65;
                }
                this.logger.debug("Registering device failed due to Multiple Device registration");
                System.exit(0);
            } else if (response.getStatus() == 1016) {
                this.logger.debug("Registering device failed due to AAD_CREDENTIALS_NOT_FOUND");
                this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            } else if (response.getStatus() == 1020) {
                this.logger.debug("Registering device failed due to CREDENTIALS_NOT_FOUND");
                this.showFailedToRegisterMessageBox("Access Error", "This username/password combination is not recognized.\n Please contact your Administrator");
            } else {
                this.logger.debug("Registering device failed due to undefined exception ");
                this.showFailedToRegisterMessageBox(PropertyHelper.DEVICE_REGISTRATION_ERROR_TITLE, PropertyHelper.DEVICE_REGISTRATION_ERROR_MESSAGE);
            }
            return 0;
        }
        if (response.getStatus() == 409) {
            this.logger.debug("Another device is already registered");
            return 64;
        }
        if (response.getStatus() == 1019) {
            this.logger.debug("Bad login type login..");
            loginType = "AAD";
            return 68;
        }
        try {
            SettingHelper.createTokenFile((CloudRegistrationUtility)rs);
        }
        catch (Exception exception) {
            this.logger.trace("" + exception);
            this.logger.error("Exception in create token file" + exception.getMessage());
            this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, " Cloud name is not mapped to your Account");
            return 0;
        }
        SettingHelper.refresh();
        SettingHelper.setLocalIpAddress((String)rs.getCloudLocalIP());
        SettingHelper.setPublicIpAddress((String)rs.getCloudPublicIP());
        SettingHelper.setCloudName((String)response.getCloudName());
        SettingHelper.setUserName((String)rs.getUserName());
        SettingHelper.setGaeLocalIpAddress((String)rs.getGaeCloudLocalIP());
        if (rs.getCloudLocalIP() != null) {
            SettingHelper.setCurrentCloudIpAddress((String)rs.getCloudLocalIP());
            ProxyElement.setIp((String)rs.getCloudLocalIP());
        } else {
            SettingHelper.setCurrentCloudIpAddress((String)rs.getPrefferedIP());
            ProxyElement.setIp((String)rs.getCloudLocalIP());
        }
        SettingHelper.setCurrentHttpsPort(rs.getPrefferedPort() == null ? null : String.valueOf(rs.getPrefferedPort()));
        SettingHelper.setDeviceName((String)response.getDeviceRegistrationElement().getDeviceElement().getDeviceName());
        return 1;
    }

    private void disposeRegistrationView() {
        this.parentComposite.getShell().dispose();
    }

    private void showFolderSelectionPage() {
        if (this.display == null) {
            this.logger.debug("Display is null while showing Folder Selection Page");
            return;
        }
        Runnable runnable = () -> this.showCustomiseParabluFolderShell();
        this.display.asyncExec(runnable);
    }

    public void hideShell() {
        this.logger.debug("Trying to close shell ");
        if (this.display == null) {
            this.logger.debug(" Display is null hiding Shell;");
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null && !this.compositeForGif.isDisposed()) {
                this.compositeForGif.setVisible(false);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void closeShell() {
        this.logger.debug("Trying to close shell ");
        if (this.display == null) {
            this.logger.debug(" Display is null while closing Shell;");
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null) {
                this.disposeProgressBUIAndChangeTopControl();
                this.registrationPanelForInputTexts.setParent(this.parentComposite);
                this.parentStackLayout.topControl = this.registrationPanelForInputTexts;
                this.parentComposite.layout();
            }
        };
        this.display.asyncExec(runnable);
    }

    private int showFailedToRegisterMessageBox(String value, String messgae) {
        if (this.display == null) {
            this.logger.debug("Display is null in show Failed To Register Message Box; ");
            return -5000;
        }
        this.result = -5000;
        Runnable runnable = () -> {
            MessageBox dialog = new MessageBox(this.parentComposite.getShell(), 40);
            dialog.setText(value);
            dialog.setMessage(messgae);
            this.result = dialog.open();
            this.setLoginButtonEnableOrDisable(true);
        };
        this.display.asyncExec(runnable);
        return this.result;
    }

    protected void launchParaBluButton() {
        this.pageDescription.setText("");
        this.registerButton.setEnabled(true);
        this.registerButton.setText("Launch Client");
        this.registerButton.setFont(this.fontsManager.getLargeNormalFont());
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingHelper.setParabluSyncFolder((String)RegistrationProgressView.this.folderPath);
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
                RegistrationProgressView.this.disposeAllFontsAndImages();
                RegistrationProgressView.this.disposeRegistrationView();
            }
        });
        this.registerButton.getParent().layout();
    }

    protected void showFinishButton() {
        this.pageDescription.setText("");
        this.pageDescription.setFont(this.fontsManager.getLargeNormalFont());
        this.registerButton.setEnabled(true);
        this.registerButton.setText("Launch Client");
        this.registerButton.setFont(this.fontsManager.getMediumNormalFont());
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingHelper.initiateAndCreateDatabases();
                SettingHelper.setParabluSyncFolder((String)RegistrationProgressView.this.folderPath);
                File baseParabluFolder = new File(RegistrationProgressView.this.folderPath + DEFAULT_PARABLU_NAME);
                if (!baseParabluFolder.mkdirs() && !baseParabluFolder.isDirectory()) {
                    MessageBox messageBox = new MessageBox(RegistrationProgressView.this.parentComposite.getShell());
                    messageBox.setText("Folder creation failed");
                    messageBox.setMessage("Failed to create folder, choose a different path");
                    messageBox.open();
                    return;
                }
                String currentOperatingSystem = SettingHelper.getOsName();
                if (currentOperatingSystem != null && currentOperatingSystem.toLowerCase().contains("win")) {
                    ShortcutHelper.createDesktopShortCut(RegistrationProgressView.this.folderPath + DEFAULT_PARABLU_NAME, null);
                    ShortcutHelper.createFavouritesShortcut(RegistrationProgressView.this.folderPath + DEFAULT_PARABLU_NAME, null);
                    RegistrationProgressView.this.logger.debug("Created shortcut.");
                }
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
                RegistrationProgressView.this.disposeAllFontsAndImages();
                RegistrationProgressView.this.disposeRegistrationView();
            }
        });
        this.registerButton.getParent().layout();
    }

    protected void prepopulateMediaDBWithDefaultFolders() {
        this.logger.debug("Entering prepopulateMediaDBWithDefaultFolders");
        MediaFolderDAOImpl mediaFolderDAOImpl = new MediaFolderDAOImpl(SettingHelper.getMediaDbUrl());
        if (!mediaFolderDAOImpl.checkIfTableIsEmpty()) {
            this.logger.debug("Returning from prepopulateMediaDBWithDefaultFolders");
            return;
        }
        String platform = System.getProperty("sun.arch.data.model").contains("64") ? "_x64" : "";
        this.logger.debug("Platform: " + platform);
        this.logger.debug(platform);
        String currentOperatingSystem = SettingHelper.getOsName();
        this.logger.debug(currentOperatingSystem);
        if (currentOperatingSystem.toLowerCase().contains("win")) {
            System.load(new File("").getAbsolutePath() + "\\DefaultFoldersFinder.dll");
            System.load(new File("").getAbsolutePath() + "\\sigar-x86-winnt.dll");
            this.logger.debug("Loaded");
        }
        String[] mediaTypes = new String[]{"Music", "Picture", "Video"};
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put("Music", WinFoldersJava.getSpecialFolderPath((int)13));
        aMap.put("Picture", WinFoldersJava.getSpecialFolderPath((int)39));
        aMap.put("Video", WinFoldersJava.getSpecialFolderPath((int)14));
        this.logger.debug("default music folder: " + WinFoldersJava.getSpecialFolderPath((int)13));
        this.logger.debug("default pictures folder: " + WinFoldersJava.getSpecialFolderPath((int)39));
        this.logger.debug("default videos folder: " + WinFoldersJava.getSpecialFolderPath((int)14));
        for (String mediaType : mediaTypes) {
            MediaFolderTO mediaFolderTO = new MediaFolderTO();
            mediaFolderTO.setFolderPath((String)aMap.get(mediaType));
            mediaFolderTO.setLastSyncTime(0L);
            mediaFolderTO.setMediaType(mediaType);
            mediaFolderDAOImpl.removeAParentFolder(mediaFolderTO);
            mediaFolderDAOImpl.insertAParentFolder(mediaFolderTO);
        }
    }

    protected void setLoginButtonEnableOrDisable(boolean value) {
        this.registerButton.setEnabled(value);
        if (value) {
            this.pageDescription.setText("");
            this.pageDescription.setText("        " + PropertyHelper.REGVIEW_CONNECT_TO_LABEL);
        } else {
            this.pageDescription.setText("");
            this.pageDescription.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
        }
        this.registerButton.getParent().layout();
    }

    public void loadUI() {
        try {
            if (this.parentComposite.getDisplay() == null) {
                this.logger.debug("loadUI; Dispay was null");
                this.display = new Display();
            } else {
                this.display = !this.parentComposite.getDisplay().isDisposed() ? this.parentComposite.getDisplay() : new Display();
            }
            Runnable runnable = () -> this.initiateRegistrationProgShell();
            this.display.asyncExec(runnable);
        }
        catch (Exception e) {
            this.logger.error("Exception in loading UI: ", (Throwable)e);
        }
    }

    private void initiateRegistrationProgShell() {
        try {
            this.startRegistrationProgressShell();
        }
        catch (Exception e) {
            this.logger.error("Exception occured in start Registration Progress Shell: " + e);
        }
    }

    private void startRegistrationProgressShell() {
        this.fontsManager = new FontsManager(this.display);
        this.compositeForGif = new Composite(this.parentComposite, 0);
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginTop = 30;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginLeft = 0;
        shellGridLayout.marginWidth = 0;
        shellGridLayout.verticalSpacing = 20;
        this.compositeForGif.setBackgroundMode(1);
        this.compositeForGif.setLayout((Layout)shellGridLayout);
        this.compositeForGif.setLayoutData((Object)new GridData());
        this.generateGif();
        this.parentStackLayout.topControl = this.compositeForGif;
        this.parentComposite.layout();
    }

    private void showCustomiseParabluFolderShell() {
        if (this.tickImage == null) {
            this.tickImageData = new ImageData(SyncConstants.CONSTANTS_TICK_IMAGE_URL);
            this.tickImage = new Image((Device)this.display, this.tickImageData);
        }
        this.compositeForFolderLocation = new Composite(this.parentComposite, 0x1000000);
        GridLayout compositeForFolderLocationGridLayout = new GridLayout();
        compositeForFolderLocationGridLayout.marginTop = 18;
        compositeForFolderLocationGridLayout.marginHeight = 0;
        compositeForFolderLocationGridLayout.marginWidth = 0;
        compositeForFolderLocationGridLayout.verticalSpacing = 4;
        compositeForFolderLocationGridLayout.marginLeft = 10;
        compositeForFolderLocationGridLayout.numColumns = 2;
        compositeForFolderLocationGridLayout.makeColumnsEqualWidth = false;
        this.compositeForFolderLocation.setBackgroundMode(1);
        this.compositeForFolderLocation.setLayout((Layout)compositeForFolderLocationGridLayout);
        this.compositeForFolderLocation.setLayoutData((Object)new GridData(1808));
        this.chooseFolderImage = new Label(this.compositeForFolderLocation, 256);
        this.chooseFolderImage.setImage(this.tickImage);
        this.chooseFolderImage.setLayoutData((Object)new GridData());
        this.chooseFolderDescriptionLabel = new Label(this.compositeForFolderLocation, 320);
        this.chooseFolderDescriptionLabel.setLayoutData((Object)new GridData(768));
        this.chooseFolderDescriptionLabel.setText(PropertyHelper.REGVIEWPROGRESS_SUCCESSFULL_LABEL);
        this.chooseFolderDescriptionLabel.setFont(this.fontsManager.getLargeNormalFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 20;
        gridLayout.verticalSpacing = 10;
        GridData currentFolderSelectPanelData = new GridData(768);
        currentFolderSelectPanelData.horizontalSpan = 2;
        this.currentFolderSelectPanel = new Group(this.compositeForFolderLocation, 0x1000000);
        if (SettingHelper.getSyncLicenced().contentEquals(DEVICE_ALREADY_REGISTERED)) {
            this.currentFolderSelectPanel.setVisible(false);
        }
        this.currentFolderSelectPanel.setLayout((Layout)gridLayout);
        this.currentFolderSelectPanel.setLayoutData((Object)currentFolderSelectPanelData);
        Composite chooseFolderDefaultComposite = new Composite((Composite)this.currentFolderSelectPanel, 0);
        GridLayout chooseFolderDefaultCompositeGridLayout = new GridLayout();
        chooseFolderDefaultCompositeGridLayout.marginLeft = 0;
        chooseFolderDefaultComposite.setLayout((Layout)chooseFolderDefaultCompositeGridLayout);
        GridData chooseFolderDefaultLabelGridDatax = new GridData();
        chooseFolderDefaultLabelGridDatax.horizontalSpan = 2;
        chooseFolderDefaultComposite.setLayoutData((Object)chooseFolderDefaultLabelGridDatax);
        this.chooseFolderDefaultLabel = new Label(chooseFolderDefaultComposite, 320);
        GridData chooseFolderDefaultLabelGridData = new GridData();
        this.chooseFolderDefaultLabel.setLayoutData((Object)chooseFolderDefaultLabelGridData);
        this.chooseFolderDefaultLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONFIGURE_FOLDER_LABEL);
        this.chooseFolderDefaultLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentFolderSelectedText = new Text((Composite)this.currentFolderSelectPanel, 2048);
        GridData currentFolderSelectedTextGridData = new GridData();
        currentFolderSelectedTextGridData.widthHint = this.parentComposite.getSize().x / 3 * 2;
        this.currentFolderSelectedText.setLayoutData((Object)currentFolderSelectedTextGridData);
        this.currentFolderSelectedText.setText(this.folderPath + DEFAULT_PARABLU_NAME);
        this.currentFolderSelectedText.setEditable(false);
        this.browseButton = new Button((Composite)this.currentFolderSelectPanel, 8);
        this.browseButton.setText("Browse");
        this.browseButton.setFocus();
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(RegistrationProgressView.this.compositeForFolderLocation.getShell());
                directoryDialog.setFilterPath(SettingHelper.getUserHome());
                directoryDialog.setMessage("Please select a folder");
                directoryDialog.setText("Folder Selection");
                RegistrationProgressView.this.folderPath = directoryDialog.open();
                if (RegistrationProgressView.this.folderPath == null) {
                    RegistrationProgressView.this.folderPath = DEFAULT_FOLDER_NAME;
                }
                RegistrationProgressView.this.currentFolderSelectedText.setText(new File(RegistrationProgressView.this.folderPath + DEFAULT_PARABLU_NAME).getAbsolutePath());
                RegistrationProgressView.this.parentComposite.getShell().layout();
            }
        });
        this.helpTextPanel = new Composite((Composite)this.currentFolderSelectPanel, 0x1000000);
        GridLayout helpTextPanelGridLayout = new GridLayout();
        helpTextPanelGridLayout.marginTop = 0;
        this.helpTextPanel.setLayout((Layout)helpTextPanelGridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.helpTextPanel.setLayoutData((Object)gridData);
        this.helpTextLabel = new Label(this.helpTextPanel, 320);
        GridData helpTextLabelGridData = new GridData(512);
        this.helpTextLabel.setLayoutData((Object)helpTextLabelGridData);
        this.helpTextLabel.setText("Please choose the folder to store the synchronized files. The current location of the folder is shown above.  We recommend that you choose a different location.");
        this.helpTextLabel.setFont(this.fontsManager.getSmallNormalFont());
        if (SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION)) {
            this.showFinishButton();
        } else if (SettingHelper.getSyncLicenced().contentEquals(DEVICE_ALREADY_REGISTERED) && SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION)) {
            this.launchParaBluButton();
        } else if (SettingHelper.getSyncLicenced().contentEquals(DEVICE_ALREADY_REGISTERED) && SettingHelper.getBackupLicenced().contentEquals(DEVICE_ALREADY_REGISTERED)) {
            this.showInactiveButton();
        }
        this.parentStackLayout.topControl = this.compositeForFolderLocation;
        this.parentComposite.layout();
    }

    public void renderPreconfiguredBackupGroup() {
        Group preconfiguredBackupGroup = new Group(this.compositeForFolderLocation, 0);
        GridLayout preconfiguredBackupGridLayout = new GridLayout();
        preconfiguredBackupGridLayout.marginTop = 0;
        preconfiguredBackupGridLayout.marginLeft = 2;
        preconfiguredBackupGridLayout.marginWidth = 3;
        preconfiguredBackupGridLayout.marginHeight = 0;
        preconfiguredBackupGridLayout.marginBottom = 0;
        preconfiguredBackupGridLayout.numColumns = 1;
        preconfiguredBackupGridLayout.horizontalSpacing = 20;
        preconfiguredBackupGridLayout.verticalSpacing = 10;
        GridData preconfiguredBackupData = new GridData(768);
        preconfiguredBackupData.horizontalSpan = 2;
        preconfiguredBackupGroup.setLayout((Layout)preconfiguredBackupGridLayout);
        preconfiguredBackupGroup.setLayoutData((Object)preconfiguredBackupData);
        Label preconfiguredBackupLabel = new Label((Composite)preconfiguredBackupGroup, 320);
        GridData preconfiguredBackupLabelGrid = new GridData(768);
        preconfiguredBackupLabelGrid.widthHint = this.parentComposite.getSize().x / 3 * 2;
        preconfiguredBackupLabel.setLayoutData((Object)preconfiguredBackupLabelGrid);
        preconfiguredBackupLabel.setText("You have previously configured folders for backup. These folders have been added to your backup list. If you wish to edit them, then please click on the link provided.");
        Link preconfiguredBackupLink = new Link((Composite)preconfiguredBackupGroup, 0);
        preconfiguredBackupLink.setLayoutData((Object)new GridData());
        preconfiguredBackupLink.setText("<a>Pre-Configured Folders</a>");
        preconfiguredBackupLink.setFont(this.fontsManager.getSmallNormalFont());
        Listener listener = event -> {
            try {
                SettingHelper.initiateAndCreateDatabases();
                BackupManagerView backupManagerView = new BackupManagerView(this.parentComposite.getShell());
                backupManagerView.open();
            }
            catch (Exception e) {
                this.logger.debug("Exception in initiate and create database", (Throwable)e);
            }
        };
        preconfiguredBackupLink.addListener(13, listener);
    }

    private void showInactiveButton() {
        this.pageDescription.setText(RegistrationLiterals.SUCCESSFULLY_REGISTERED);
        this.registerButton.setEnabled(false);
        this.registerButton.setText("No Licenses");
        this.registerButton.setFont(this.fontsManager.getMediumNormalFont());
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.getParent().layout();
    }

    protected void disposeProgressBUIAndChangeTopControl() {
        if (this.compositeForGif == null) {
            return;
        }
        this.disposeAllFontsAndImages();
        this.registrationPanelForInputTexts.setParent(this.parentComposite);
        this.parentStackLayout.topControl = this.registrationPanelForInputTexts;
        this.parentComposite.layout();
    }

    private void disposeAllFontsAndImages() {
        this.fontsManager.disposeFonts();
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        if (this.tickImage != null && !this.tickImage.isDisposed()) {
            this.tickImage.dispose();
        }
    }

    private void generateGif() {
        this.loader = new ImageLoader();
        try {
            this.loader.load((InputStream)new FileInputStream(PARABLU_SEARCHING_GIF));
            Label connectingToCloudLabel = new Label(this.compositeForGif, 0);
            GridData connectingGridLayout = new GridData();
            connectingGridLayout.horizontalIndent = 87;
            connectingToCloudLabel.setLayoutData((Object)connectingGridLayout);
            connectingToCloudLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
            connectingToCloudLabel.setFont(this.fontsManager.getLargeNormalFont());
            this.canvas = new Canvas(this.compositeForGif, 0);
            GridData gd = new GridData();
            gd.heightHint = 180;
            gd.widthHint = 400;
            this.canvas.setLayoutData((Object)gd);
            this.canvas.setBackgroundMode(1);
            this.image = new Image((Device)this.display, this.loader.data[0]);
            PaintListener paintListener = event -> {
                if (!this.image.isDisposed()) {
                    event.gc.drawImage(this.image, 0, 0);
                }
            };
            this.canvas.addPaintListener(paintListener);
            this.gifUpdaterThread = new Thread(new GIFRunnable());
            this.connectingLabel = new Label(this.compositeForGif, 0x1000000);
            this.connectingLabel.setText(" Connecting ...");
            GridData data = new GridData(1808);
            this.connectingLabel.setLayoutData((Object)data);
            this.connectingLabel.setFont(this.fontsManager.getLargeNormalFont());
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException for PARABLU_SEARCHING_GIF: ", (Throwable)e);
        }
    }

    public synchronized void update(int value) {
        switch (value) {
            case 0: {
                this.logger.debug(">>>>>>>>>>>>>>>>>> SEARCHING_CLOUD");
                this.showSearchingGif();
                break;
            }
            case 1: {
                this.logger.debug(">>>>>>>>>>>>>>>>>> VALIDATING_USER");
                this.continueSearchDisplay = false;
                this.showValidatingUserImage();
                break;
            }
        }
    }

    private void showSearchingGif() {
        if (this.display == null) {
            return;
        }
        Runnable runnable = () -> {
            this.connectingLabel.setText("");
            this.connectingLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
            this.connectingLabel.setFont(this.fontsManager.getMediumNormalFont());
            if (this.gifUpdaterThread != null) {
                this.gifUpdaterThread.start();
            } else {
                this.logger.debug("The thread is :" + this.gifUpdaterThread);
            }
        };
        this.display.asyncExec(runnable);
    }

    private void showValidatingUserImage() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            this.connectingLabel.setText("");
            this.connectingLabel.setText("Validating credentials...");
            this.connectingLabel.setFont(this.fontsManager.getMediumNormalFont());
            if (!this.display.isDisposed()) {
                this.image.dispose();
                this.image = new Image((Device)this.display, SyncConstants.VALIDATE_IMAGE);
            }
            if (this.compositeForGif != null && !this.compositeForGif.isDisposed() && !this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        };
        this.display.asyncExec(runnable);
    }

    private void startUIAfterDecoupledAndIfSilent() {
        BluSyncLauncher.isSilent = DEVICE_ALREADY_REGISTERED;
        RegistrationView regview = new RegistrationView();
        regview.loadRegistrationUI();
        this.logger.debug("Registration complete");
        try {
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                this.logger.debug("inside RegView part");
                BluSyncLauncher.startUI();
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception in startUI" + e.getMessage());
        }
    }

    public int checkForconfirmation(final String value, final String messgae) {
        try {
            if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                if (this.display1 == null) {
                    this.display1 = new Display();
                }
                silentShell = new Shell(this.display1, 278536);
                ImageData registrationImageData = new ImageData(SyncConstants.PARABLU_NAMED_IMAGE);
                Image registrationImage = new Image((Device)this.display, registrationImageData.scaledTo(72, 72));
                silentShell.setImage(registrationImage);
                silentShell.setFocus();
            }
        }
        catch (Exception e1) {
            this.logger.error("......" + e1.getMessage());
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox dialog;
                if (!RegistrationProgressView.SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                    dialog = new MessageBox(RegistrationProgressView.this.parentComposite.getShell(), 196);
                } else {
                    silentShell.pack();
                    silentShell.open();
                    dialog = new MessageBox(silentShell, 196);
                }
                try {
                    dialog.setText(value);
                    dialog.setMessage(messgae);
                    RegistrationProgressView.this.result = dialog.open();
                    if (RegistrationProgressView.SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                        silentShell.dispose();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RegistrationProgressView.this.logger.debug(RegistrationProgressView.this.result + "result");
                if (RegistrationProgressView.this.result == 64) {
                    deviceRegistryResponse = 1;
                } else if (!RegistrationProgressView.SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                    RegistrationProgressView.this.setLoginButtonEnableOrDisable(true);
                }
            }
        });
        return deviceRegistryResponse;
    }

    static {
        deviceRegistryResponse = 0;
        loginType = "PB";
    }

    class GIFRunnable
    implements Runnable {
        GIFRunnable() {
        }

        @Override
        public void run() {
            if (RegistrationProgressView.this.display == null) {
                RegistrationProgressView.this.logger.debug("Display is null");
                return;
            }
            while (RegistrationProgressView.this.continueSearchDisplay && !RegistrationProgressView.this.display.isDisposed()) {
                int delayTime = ((RegistrationProgressView)RegistrationProgressView.this).loader.data[((RegistrationProgressView)RegistrationProgressView.this).imageNumber].delayTime;
                try {
                    Thread.sleep((long)delayTime * 10L);
                }
                catch (InterruptedException e1) {
                    RegistrationProgressView.this.logger.trace("" + e1);
                    RegistrationProgressView.this.logger.error("Thread Interrupted " + e1.getMessage());
                }
                Runnable runnable = () -> {
                    try {
                        RegistrationProgressView.this.imageNumber = RegistrationProgressView.this.imageNumber == ((RegistrationProgressView)RegistrationProgressView.this).loader.data.length - 1 ? 0 : RegistrationProgressView.this.imageNumber + 1;
                        if (!RegistrationProgressView.this.display.isDisposed()) {
                            RegistrationProgressView.this.image.dispose();
                            RegistrationProgressView.this.image = new Image((Device)RegistrationProgressView.this.display, ((RegistrationProgressView)RegistrationProgressView.this).loader.data[RegistrationProgressView.this.imageNumber]);
                        }
                        if (RegistrationProgressView.this.compositeForGif != null && !RegistrationProgressView.this.compositeForGif.isDisposed() && !RegistrationProgressView.this.canvas.isDisposed()) {
                            RegistrationProgressView.this.canvas.redraw();
                        }
                    }
                    catch (Exception e) {
                        RegistrationProgressView.this.logger.error("Exception in canvas/compositeForGif: ", (Throwable)e);
                    }
                };
                RegistrationProgressView.this.display.asyncExec(runnable);
            }
        }
    }
}

